/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Transliterator;
import java.lang.invoke.CallSite;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRTransforms;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.With;

public class FixTransformNames {
    CLDRConfig testInfo = ToolConfig.getToolInstance();
    Map<String, String> fieldToCode = new HashMap<String, String>();
    Map<String, String> oldToNewVariant = new HashMap<String, String>();
    Map<String, String> fieldToVariant = new HashMap<String, String>();
    Map<String, String> targetToCode = new HashMap<String, String>();
    Set<String> languageCodes = new HashSet<String>();
    LanguageTagParser ltp = new LanguageTagParser();
    CLDRFile english = this.testInfo.getEnglish();

    public static void main(String[] args) {
        new FixTransformNames().run(args);
    }

    private void run(String[] args) {
        CLDRFile file = this.testInfo.getEnglish();
        for (String lang : StandardCodes.make().getAvailableCodes(StandardCodes.CodeType.language)) {
            String name = file.getName(lang);
            if (name.equals(lang)) continue;
            this.fieldToCode.put(name, lang);
            this.languageCodes.add(lang);
        }
        this.fieldToCode.put("Maldivian", "dv");
        this.fieldToCode.put("JapaneseKana", "und_Kana");
        this.fieldToCode.put("Kirghiz", "ky");
        this.fieldToCode.put("ASCII", "und-Qaaa");
        this.fieldToCode.put("zh_Latn_PINYIN", "zh_Latn");
        this.fieldToCode.put("zh_Latn_PINYIN", "zh_Latn");
        this.fieldToCode.put("IPA", "und-fonipa");
        this.fieldToCode.put("XSampa", "und-fonxsamp");
        this.fieldToCode.put("Simplified", "und-Hans");
        this.fieldToCode.put("Traditional", "und-Hant");
        this.fieldToCode.put("ConjoiningJamo", "und-Qaaj");
        this.oldToNewVariant.put("UNGEGN", "-m0-ungegn");
        this.oldToNewVariant.put("BGN", "-m0-bgn");
        this.addX(this.oldToNewVariant, "-x0-", "hex", "C Java Perl, Plain Unicode XML XML10");
        this.addX(this.fieldToVariant, "-x0-", "", "CaseFold Lower Title Upper");
        this.addX(this.fieldToVariant, "-x0-", "", "NFC NFD NFKC NFKD FCC FCD FullWidth Halfwidth");
        this.addX(this.fieldToVariant, "-x0-", "", "Null Remove");
        this.addX(this.fieldToVariant, "-x0-", "", "Accents Publishing Name");
        Relation<Object, String> missing = Relation.of(new TreeMap(), TreeSet.class);
        TreeSet<CallSite> found = new TreeSet<CallSite>();
        TreeMap<String, String> allFields = new TreeMap<String, String>();
        TreeMap<CallSite, String> specialFields = new TreeMap<CallSite, String>();
        TreeMap<String, String> allVariants = new TreeMap<String, String>();
        TreeSet<String> internal = new TreeSet<String>();
        Set<String> cldrIds = this.getCldrIds(internal);
        for (String id : CLDRTransforms.getAvailableIds()) {
            int n;
            int second;
            String id2;
            if (id.endsWith(".xml")) {
                id = id.substring(0, id.length() - 4);
            }
            String string = id2 = (second = id.indexOf(45, (n = id.indexOf(45)) + 1)) < 0 ? id : id.substring(0, second) + "/" + id.substring(second + 1);
            if (internal.contains(id2)) {
                System.out.println("*Internal:\t" + id);
                continue;
            }
            if (cldrIds.contains(id2)) continue;
            System.out.println("*Missing:\t" + id);
        }
        TreeSet<String> icuOnlyIds = new TreeSet<String>();
        Enumeration<String> x = Transliterator.getAvailableIDs();
        while (x.hasMoreElements()) {
            String string = x.nextElement();
            if (cldrIds.contains(string)) continue;
            icuOnlyIds.add(string);
        }
        Iterator<Object> iterator = With.in(new Iterable[]{cldrIds, icuOnlyIds}).iterator();
        while (iterator.hasNext()) {
            String string;
            String original = string = (String)iterator.next();
            CLDRTransforms.ParsedTransformID ptd = new CLDRTransforms.ParsedTransformID().set(string);
            if (!string.equals(ptd.toString())) {
                missing.put("ERROR\t" + string, ptd.toString());
                continue;
            }
            String variantSource = ptd.variant;
            String variant = this.getFixedVariant(variantSource);
            if (variant.contains("?")) {
                missing.put(variantSource, string);
            } else {
                allVariants.put(variant, variantSource);
            }
            String source = this.getFixedName(ptd.source);
            if (source.contains("?")) {
                if (variantSource == null) {
                    String temp = this.fieldToVariant.get(ptd.source);
                    if (temp != null) {
                        source = "";
                        variant = temp;
                        specialFields.put((CallSite)((Object)(source + "/" + variant)), ptd.source);
                    } else {
                        missing.put(ptd.source, string);
                    }
                } else {
                    missing.put(ptd.source, string);
                }
            } else {
                allFields.put(source, ptd.source);
            }
            String target = this.getFixedName(ptd.target);
            if (target.contains("?")) {
                if (variantSource == null) {
                    String temp = this.fieldToVariant.get(ptd.target);
                    if (temp != null) {
                        target = "und";
                        variant = temp;
                        specialFields.put((CallSite)((Object)(target + "/" + variant)), ptd.target);
                    } else {
                        missing.put(ptd.target, string);
                    }
                } else {
                    missing.put(ptd.target, string);
                }
            } else {
                allFields.put(target, ptd.target);
            }
            String bcp47 = target + "-t" + (String)(source.isEmpty() ? "" : "-" + source) + variant;
            if (bcp47.contains("?")) continue;
            found.add((CallSite)((Object)(bcp47 + "\t" + this.getName(target) + "\t" + this.getName(source) + "\t" + variant + "\t" + original)));
        }
        System.out.println("\nAll Fields");
        for (Map.Entry entry : allFields.entrySet()) {
            System.out.println((String)entry.getKey() + "\t" + this.getName((String)entry.getKey()) + "\t" + (String)entry.getValue());
        }
        System.out.println("\nSpecial Fields");
        for (Map.Entry entry : specialFields.entrySet()) {
            System.out.println((String)entry.getKey() + "\t" + (String)entry.getValue());
        }
        System.out.println("\nAll Variants");
        for (Map.Entry entry : allVariants.entrySet()) {
            System.out.println((String)entry.getKey() + "\t" + (String)entry.getValue());
        }
        System.out.println("\nFound IDs");
        for (String string : found) {
            System.out.println(string);
        }
        System.out.println("\nUnconverted");
        for (Map.Entry entry : missing.keyValuesSet()) {
            System.out.println((String)entry.getKey() + "\t" + entry.getValue());
        }
    }

    private void addX(Map<String, String> oldToNewVariant2, String type, String prefix, String items) {
        for (String part : items.split("\\s+")) {
            Object target = prefix + part.toLowerCase(Locale.ENGLISH);
            if (((String)target).length() > 8) {
                target = ((String)target).substring(0, 8);
            }
            oldToNewVariant2.put(part, type + (String)target);
        }
    }

    private String getName(String target) {
        if (target.equals("und")) {
            return "Any";
        }
        this.ltp.set(target);
        if (this.ltp.getLanguage().equals("und")) {
            String result = "";
            result = this.add(result, 1, this.ltp.getScript());
            result = this.add(result, 2, this.ltp.getRegion());
            for (String v : this.ltp.getVariants()) {
                result = this.add(result, 3, v);
            }
            return result;
        }
        return this.english.getName(target.replace('-', '_'));
    }

    private String add(String result, int type, String code) {
        if (code.isEmpty()) {
            return result;
        }
        if (((String)result).length() != 0) {
            result = (String)result + ", ";
        }
        Object temp = this.english.getName(type, code);
        if (type == 1 && this.fieldToCode.containsKey(temp)) {
            temp = (String)temp + "*";
        }
        return (String)result + (String)(temp == null ? code : temp);
    }

    private String getFixedVariant(String variant) {
        if (variant == null || variant.isEmpty()) {
            return "";
        }
        String fixedVariant = this.oldToNewVariant.get(variant);
        if (fixedVariant != null) {
            return fixedVariant;
        }
        return "??" + variant;
    }

    private Set<String> getCldrIds(Set<String> internal) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String s2 : CLDRTransforms.getAvailableIds()) {
            Set<String> store;
            CLDRTransforms.ParsedTransformID directionInfo = new CLDRTransforms.ParsedTransformID();
            Set<String> set = store = directionInfo.getVisibility() == CLDRTransforms.Visibility.external ? result : internal;
            if (directionInfo.getDirection() != CLDRTransforms.Direction.backward) {
                store.add(directionInfo.getId());
            }
            if (directionInfo.getDirection() == CLDRTransforms.Direction.forward) continue;
            store.add(directionInfo.getBackwardId());
        }
        return result;
    }

    private String getFixedName(String field) {
        String variant = "";
        if (field.equals("Any")) {
            return "und";
        }
        if (field.contains("_FONIPA")) {
            field = field.replace("_FONIPA", "");
            variant = "-fonipa";
        }
        if (field.equals("es_419") || field.equals("ja_Latn") || field.equals("zh_Latn") || field.equals("und-Latn")) {
            return field.replace("_", "-");
        }
        int source = UScript.getCodeFromName(field);
        if (this.languageCodes.contains(field)) {
            return field + variant;
        }
        try {
            String name = UScript.getShortName(source);
            return "und-" + name + variant;
        }
        catch (Exception e) {
            String name = this.fieldToCode.get(field);
            if (name != null) {
                return name + variant;
            }
            return "??" + field;
        }
    }
}

