/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.unicode.cldr.tool.GenerateMaximalLocales;
import org.unicode.cldr.tool.LikelySubtags;

public class GenerateLikelySubtagTests {
    private static final String SEPARATOR = "\n";
    private static final GenerateMaximalLocales.OutputStyle OUTPUT_STYLE = GenerateMaximalLocales.OutputStyle.XML;
    private static PrintWriter out;
    private static final String VERSION = "44";

    public static void main(String[] args) throws IOException {
        throw new IllegalArgumentException("This tool should not be used in its current state.");
    }

    private static String writeTestLine(String from, Map<String, String> likelySubtags) {
        String maxFrom = LikelySubtags.maximize(from, likelySubtags);
        String minFrom = LikelySubtags.minimize(from, likelySubtags, true);
        GenerateLikelySubtagTests.writeTestLine2(from, maxFrom, minFrom);
        return maxFrom;
    }

    private static void writeTestLine2(String from, String maxFrom, String minFrom) {
        if (OUTPUT_STYLE == GenerateMaximalLocales.OutputStyle.C) {
            out.print("  {\n    " + GenerateLikelySubtagTests.getItem(from) + ",\n    " + GenerateLikelySubtagTests.getItem(maxFrom) + ",\n    " + GenerateLikelySubtagTests.getItem(minFrom) + "\n  },");
        } else {
            out.println("    <!-- " + GenerateLikelySubtagTests.printNameOrError(from) + " \u2192 " + GenerateLikelySubtagTests.printNameOrError(maxFrom) + " \u2192 " + GenerateLikelySubtagTests.printNameOrError(minFrom) + " -->");
            out.println("    <result input='" + GenerateLikelySubtagTests.getNameOrError(from) + "' add='" + GenerateLikelySubtagTests.getNameOrError(maxFrom) + "' remove='" + GenerateLikelySubtagTests.getNameOrError(minFrom) + "'/>");
        }
    }

    private static String printNameOrError(String maxFrom) {
        String result = GenerateMaximalLocales.printingName(maxFrom, "");
        if (result == null) {
            return "ERROR";
        }
        return result;
    }

    private static String getNameOrError(String from) {
        String result = GenerateMaximalLocales.toAlt(from, true);
        if (result == null) {
            return "ERROR";
        }
        return result;
    }

    private static String getItem(String from) {
        String toAlt = GenerateLikelySubtagTests.getNameOrError(from);
        if (toAlt == null) {
            return null;
        }
        return "\"" + toAlt + "\"";
    }
}

