/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.RuleBasedTransliterator;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeFilter;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DiscreteComparator;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class CLDRTransforms {
    public static final String TRANSFORM_DIR = CLDRPaths.COMMON_DIRECTORY + "transforms/";
    static final CLDRTransforms SINGLETON = new CLDRTransforms();
    private static final boolean PARANOID = true;
    final Set<String> overridden = new HashSet<String>();
    static Transliterator fixup = Transliterator.getInstance("[:Mn:]any-hex/java");
    public static Pattern TRANSFORM_ID_PATTERN = PatternCache.get("(.+)-([^/]+)(/(.*))?");
    private BiMap<String, String> displayNameToId = HashBiMap.create();
    Appendable showProgress;
    Map<String, RuleDirection> idToRules = new TreeMap<String, RuleDirection>();
    static boolean ALREADY_REGISTERED = false;
    private static final ImmutableSet<String> noSkip = ImmutableSet.of();
    private static final boolean SHOW = false;
    private static final boolean SHOW_FAILED_MATCHES = false;
    static final Pattern TRANSLIT_FINDER = Pattern.compile("\\s*::\\s*(?:\\[[^\\]]+\\]\\s*)?([A-Za-z0-9////_//-]*)?(?:\\s*\\((?:\\[[^\\]]+\\]\\s*)?([A-Za-z0-9////_//-]*)?\\s*\\))?\\s*;\\s*(#.*)?");

    public static CLDRTransforms getInstance() {
        return SINGLETON;
    }

    public Appendable getShowProgress() {
        return this.showProgress;
    }

    public CLDRTransforms setShowProgress(Appendable showProgress) {
        this.showProgress = showProgress;
        return this;
    }

    public static void registerCldrTransforms(String dir, String namesMatchingRegex, Appendable showProgress, boolean keepDashTIds) {
        CLDRTransforms r = CLDRTransforms.getInstance();
        if (dir == null) {
            dir = TRANSFORM_DIR;
        }
        r.showProgress = showProgress;
        Set ordered = CLDRTransforms.getFileRegistrationOrder(dir);
        if (namesMatchingRegex != null) {
            Matcher filter = PatternCache.get(namesMatchingRegex).matcher("");
            ordered = ordered.stream().filter(x -> filter.reset((CharSequence)x).matches()).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        for (String cldrFileName : ordered) {
            r.registerTransliteratorsFromXML(dir, cldrFileName, Collections.emptySet(), keepDashTIds);
        }
        Transliterator.registerAny();
    }

    public static List<String> getAvailableIds() {
        return Arrays.asList(new File(TRANSFORM_DIR).list());
    }

    public Set<String> getOverriddenTransliterators() {
        return Collections.unmodifiableSet(this.overridden);
    }

    public Transliterator getInstance(String id) {
        if (!this.overridden.contains(id)) {
            throw new IllegalArgumentException("No overriden transform for " + id);
        }
        return Transliterator.getInstance(id);
    }

    public Transliterator getReverseInstance(String id) {
        Matcher matcher = TRANSFORM_ID_PATTERN.matcher(id);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("**No transform for " + id);
        }
        return this.getInstance(matcher.group(2) + "-" + matcher.group(1) + (String)(matcher.group(4) == null ? "" : "/" + matcher.group(4)));
    }

    public BiMap<String, String> getDisplayNameToId() {
        return this.displayNameToId;
    }

    private void addDisplayNameToId(Map<String, String> ids2, ParsedTransformID directionInfo) {
        this.displayNameToId.put(directionInfo.getDisplayId(), directionInfo.toString());
    }

    public String registerTransliteratorsFromXML(String dir, String cldrFileName, Set<String> cantSkip, boolean keepDashTIds) {
        ParsedTransformID directionInfo = new ParsedTransformID();
        String ruleString = CLDRTransforms.getIcuRulesFromXmlFile(dir, cldrFileName, directionInfo);
        String id = directionInfo.getId();
        this.addDisplayNameToId(this.displayNameToId, directionInfo);
        if (directionInfo.getDirection() == Direction.both || directionInfo.getDirection() == Direction.forward) {
            for (String alias : directionInfo.getAliases()) {
                if (!keepDashTIds && alias.contains("-t-")) continue;
                Transliterator.unregister(alias);
                Transliterator.registerAlias(alias, id);
            }
            this.internalRegister(id, ruleString, 0);
        }
        if (directionInfo.getDirection() == Direction.both || directionInfo.getDirection() == Direction.backward) {
            for (String alias : directionInfo.getBackwardAliases()) {
                if (!keepDashTIds && alias.contains("-t-")) continue;
                Transliterator.unregister(alias);
                Transliterator.registerAlias(alias, directionInfo.getBackwardId());
            }
            this.internalRegister(id, ruleString, 1);
        }
        return id;
    }

    public static String getIcuRulesFromXmlFile(String dir, String cldrFileName, ParsedTransformID directionInfo) {
        MyHandler myHandler = new MyHandler(cldrFileName, directionInfo);
        XMLFileReader xfr = new XMLFileReader().setHandler(myHandler);
        xfr.read(dir + cldrFileName, XMLFileReader.CONTENT_HANDLER | XMLFileReader.ERROR_HANDLER, true);
        return myHandler.getRules();
    }

    private void internalRegister(String id, String ruleString, int direction) {
        if (direction == 1) {
            id = ParsedTransformID.reverse(id);
        }
        this.internalRegisterNoReverseId(id, ruleString, direction);
    }

    private void internalRegisterNoReverseId(String id, String ruleString, int direction) {
        try {
            Transliterator t2 = Transliterator.createFromRules(id, ruleString, direction);
            this.overridden.add(id);
            Transliterator oldTranslit = null;
            if (this.showProgress != null) {
                try {
                    oldTranslit = Transliterator.getInstance(id);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Transliterator.unregister(id);
            Transliterator.registerInstance(t2);
            String r1 = CLDRTransforms.showTransliterator("", t2, 9999, new StringBuilder()).toString();
            Transliterator t22 = Transliterator.getInstance(id);
            String r2 = CLDRTransforms.showTransliterator("", t22, 9999, new StringBuilder()).toString();
            if (!r1.equals(r2)) {
                throw new IllegalArgumentException("Rules unequal\n" + ruleString + "$$$\n$$$" + r2);
            }
            if (this.showProgress != null) {
                this.append("Registered new Transliterator: " + id + (String)(oldTranslit == null ? "" : "\told:\t" + oldTranslit.getID()) + "\n");
                if (id.startsWith("el-")) {
                    CLDRTransforms.showTransliterator("", t2, 999);
                    Transliterator t23 = Transliterator.getInstance(id);
                    CLDRTransforms.showTransliterator("", t23, 999);
                }
            }
        }
        catch (RuntimeException e) {
            if (this.showProgress != null) {
                e.printStackTrace();
                this.append("Couldn't register new Transliterator: " + id + "\t" + e.getMessage() + "\n");
            }
            throw (IllegalArgumentException)new IllegalArgumentException("Couldn't register new Transliterator: " + id).initCause(e);
        }
    }

    private void append(String string) {
        try {
            if (this.showProgress == null) {
                return;
            }
            this.showProgress.append(string);
            if (this.showProgress instanceof Writer) {
                ((Writer)this.showProgress).flush();
            }
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    private void appendln(String s2) {
        this.append(s2 + "\n");
    }

    private void registerFromIcuFile(String id, String directory, String filename, int direction) {
        if (filename == null) {
            filename = id.replace("-", "_").replace("/", "_") + ".txt";
        }
        String ruleString = CldrUtility.getText(directory, (String)filename);
        this.idToRules.put(id, new RuleDirection(ruleString, direction));
    }

    public void checkIdFix(String id, Map<String, String> fixedIDs, Set<String> oddIDs, Matcher translitID) {
        if (fixedIDs.containsKey(id)) {
            return;
        }
        if (!translitID.reset(id).matches()) {
            this.appendln("Can't fix: " + id);
            fixedIDs.put(id, "?" + id);
            return;
        }
        String source1 = translitID.group(1);
        String target1 = translitID.group(2);
        String variant = translitID.group(3);
        String source = CLDRTransforms.fixID(source1);
        String target = CLDRTransforms.fixID(target1);
        if (!source1.equals(source)) {
            fixedIDs.put(source1, source);
        }
        if (!target1.equals(target)) {
            fixedIDs.put(target1, target);
        }
        if (variant != null) {
            oddIDs.add("variant: " + variant);
        }
    }

    static String fixID(String source) {
        return source;
    }

    public static void verifyNullFilter(String id) {
        Transliterator widen;
        try {
            widen = Transliterator.getInstance(id);
        }
        catch (Exception e) {
            return;
        }
        UnicodeFilter filter = widen.getFilter();
        if (filter != null) {
            throw new IllegalArgumentException(id + " has non-empty filter: " + filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerModified() {
        Class<CLDRTransforms> clazz = CLDRTransforms.class;
        synchronized (CLDRTransforms.class) {
            if (ALREADY_REGISTERED) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.registerTranslit("Lao-Latin", "\u0e9a", "b");
            this.registerTranslit("Khmer-Latin", "\u17a5", "\u0115");
            this.registerTranslit("Sinhala-Latin", "\u0d9a", "ka");
            this.registerTranslit("Japn-Latn", "\u8b46", "aa");
            this.registerTranslit("Han-SpacedHan", "\u300a", "\u00ab");
            this.registerTranslit("Greek-Latin", "\u0384", "\u00b4");
            this.registerTranslit("Hebrew-Latin", "\u05be", "-");
            this.registerTranslit("Cyrillic-Latin", "\u04e9", "\u00f6");
            this.registerTranslit("Myanmar-Latin", "\u103f", "s");
            this.registerTranslit("Latin-Armenian", "\u2019", "\u055a");
            this.registerTranslit("Interindic-Latin", "\ue070", ".", "\ue03c", "\u0323", "\ue04d", "");
            this.registerTranslit("Malayalam-Interindic", "\u0d7a", "\ue023\ue04d");
            this.registerTranslit("Interindic-Malayalam", "\ue023\ue04d", "\u0d23\u0d4d");
            this.registerTranslit("Malayalam-Latin", "\u0d7a", "\u1e47");
            this.registerTranslit("Devanagari-Interindic", "\u0972", "\ue084");
            this.registerTranslit("Devanagari-Latin", "\u0972", "\u00e6");
            this.registerTranslit("Arabic-Latin", "\u0609", "\u2030");
            ALREADY_REGISTERED = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void registerTranslit(String ID, String ... sourcePairs) {
        String internalId = this.registerTransliteratorsFromXML(TRANSFORM_DIR, ID, noSkip, true);
        Transliterator.registerAny();
        Transliterator t2 = null;
        try {
            t2 = Transliterator.getInstance(internalId);
        }
        catch (Exception e) {
            System.out.println("For " + ID + " (" + internalId + ")");
            e.printStackTrace();
            return;
        }
        CLDRTransforms.testSourceTarget(t2, sourcePairs);
    }

    public static void showTransliterator(String prefix, Transliterator t2, int limit) {
        CLDRTransforms.showTransliterator(prefix, t2, limit, System.out);
        System.out.flush();
    }

    public static <T extends Appendable> T showTransliterator(String prefix, Transliterator t2, int limit, T output) {
        if (!((String)prefix).isEmpty()) {
            prefix = (String)prefix + " ";
        }
        try {
            output.append((String)prefix + "ID:\t" + t2.getID() + "\n");
            output.append((String)prefix + "Class:\t" + t2.getClass().getName() + "\n");
            if (t2.getFilter() != null) {
                output.append((String)prefix + "Filter:\t" + t2.getFilter().toPattern(false) + "\n");
            }
            if (t2 instanceof RuleBasedTransliterator) {
                RuleBasedTransliterator rbt = (RuleBasedTransliterator)t2;
                String[] rules = rbt.toRules(true).split("\n");
                int length = rules.length;
                if (limit >= 0 && limit < length) {
                    length = limit;
                }
                output.append((String)prefix + "Rules:\n");
                prefix = (String)prefix + "\t";
                for (int i = 0; i < length; ++i) {
                    output.append((String)prefix + rules[i] + "\n");
                }
            } else {
                Transliterator[] elements = t2.getElements();
                if (elements[0] == t2) {
                    output.append((String)prefix + "\tNonRuleBased\n");
                    return output;
                }
                prefix = (String)prefix + "\t";
                for (int i = 0; i < elements.length; ++i) {
                    CLDRTransforms.showTransliterator((String)prefix, elements[i], limit, output);
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return output;
    }

    public static void testSourceTarget(Transliterator t2, String ... sourcePairs) {
        for (int i = 0; i < sourcePairs.length; i += 2) {
            String sourceTest = sourcePairs[i];
            String targetTest = sourcePairs[i + 1];
            String target = t2.transform(sourceTest);
            if (target.equals(targetTest)) continue;
            throw new IllegalArgumentException(t2.getID() + " For " + sourceTest + ", expected " + targetTest + ", got " + target);
        }
    }

    public static Transliterator getTestingLatinScriptTransform(String script) {
        Object id;
        switch (script) {
            case "Latn": {
                return null;
            }
            case "Khmr": {
                id = "Khmr-Latn/UNGEGN";
                break;
            }
            case "Laoo": {
                id = "Laoo-Latn/UNGEGN";
                break;
            }
            case "Sinh": {
                id = "Sinh-Latn/UNGEGN";
                break;
            }
            case "Japn": {
                id = "Jpan-Latn";
                break;
            }
            case "Kore": {
                id = "Hangul-Latn";
                break;
            }
            case "Hant": 
            case "Hans": {
                id = "Han-Latn";
                break;
            }
            case "Olck": {
                id = "sat_Olck-sat_FONIPA";
                break;
            }
            case "Cher": {
                id = "chr-chr_FONIPA";
                break;
            }
            default: {
                id = script + "-Latn";
            }
        }
        return Transliterator.getInstance((String)id);
    }

    public static Set<String> getFileRegistrationOrder(String dir) {
        if (dir == null) {
            dir = TRANSFORM_DIR;
        }
        List<String> files = CLDRTransforms.getAvailableIds();
        HashMultimap<String, String> fileToAliases = HashMultimap.create();
        TreeMultimap fileToDependencies = TreeMultimap.create();
        for (String file : files) {
            ParsedTransformID directionInfo = new ParsedTransformID();
            String string = CLDRTransforms.getIcuRulesFromXmlFile(dir, file, directionInfo);
            LinkedHashSet others = new LinkedHashSet();
            Set order = string.lines().map(x -> x.trim()).filter(x -> x.contains("::") && !x.trim().startsWith("#")).map(x -> CLDRTransforms.parseDoubleColon(x, others)).collect(Collectors.toCollection(LinkedHashSet::new));
            order.addAll(others);
            if (!order.isEmpty()) {
                fileToDependencies.putAll(file, order);
            }
            if (directionInfo.direction != Direction.backward) {
                fileToAliases.put(file, directionInfo.getId());
                fileToAliases.putAll(file, Arrays.asList(directionInfo.getAliases()));
            }
            if (directionInfo.direction == Direction.forward) continue;
            fileToAliases.put(file, directionInfo.getBackwardId());
            fileToAliases.putAll(file, Arrays.asList(directionInfo.getBackwardAliases()));
        }
        TreeMultimap aliasesToFile = Multimaps.invertFrom(fileToAliases, TreeMultimap.create());
        TreeMultimap<String, Object> fileToDependentFiles = TreeMultimap.create();
        for (Map.Entry entry : fileToDependencies.asMap().entrySet()) {
            Set v = ((Collection)entry.getValue()).stream().filter(x -> aliasesToFile.containsKey(x)).map(y -> (String)aliasesToFile.get(y).first()).collect(Collectors.toSet());
            fileToDependentFiles.putAll((String)entry.getKey(), v);
        }
        DiscreteComparator.Builder comp = new DiscreteComparator.Builder(null);
        fileToDependentFiles.forEach((x, y) -> comp.add(y, x));
        DiscreteComparator discreteComparator = comp.get();
        LinkedHashSet orderedDependents = new LinkedHashSet(discreteComparator.getOrdering());
        orderedDependents.retainAll(fileToDependentFiles.values());
        TreeSet<String> remainingFiles = new TreeSet<String>(files);
        remainingFiles.removeAll(orderedDependents);
        orderedDependents.addAll(remainingFiles);
        return ImmutableSet.copyOf(orderedDependents);
    }

    static String parseDoubleColon(String x, Set<String> others) {
        Matcher matcher = TRANSLIT_FINDER.matcher(x);
        if (matcher.matches()) {
            String first = matcher.group(1);
            String second = matcher.group(2);
            if (second != null && !second.isBlank()) {
                others.add(second);
            }
            return first == null || first.isBlank() ? "" : first;
        }
        return "";
    }

    public static class MyHandler
    extends XMLFileReader.SimpleHandler {
        boolean first = true;
        ParsedTransformID directionInfo;
        String cldrFileName;
        StringBuilder rules = new StringBuilder();

        public String getRules() {
            return this.rules.toString();
        }

        public MyHandler(String cldrFileName, ParsedTransformID directionInfo) {
            this.cldrFileName = cldrFileName;
            this.directionInfo = directionInfo;
        }

        @Override
        public void handlePathValue(String path, String value) {
            if (this.first) {
                String backwardAlias;
                if (path.startsWith("//supplementalData/version")) {
                    return;
                }
                if (path.startsWith("//supplementalData/generation")) {
                    return;
                }
                XPathParts parts = XPathParts.getFrozenInstance(path);
                Map<String, String> attributes = parts.findAttributes("transform");
                if (attributes == null) {
                    throw new IllegalArgumentException("Not an XML transform file: " + this.cldrFileName + "\t" + path);
                }
                this.directionInfo.setSource(attributes.get("source"));
                this.directionInfo.setTarget(attributes.get("target"));
                this.directionInfo.setVariant(attributes.get("variant"));
                this.directionInfo.setDirection(Direction.valueOf(attributes.get("direction").toLowerCase(Locale.ENGLISH)));
                String alias = attributes.get("alias");
                if (alias != null) {
                    this.directionInfo.setAliases(alias.trim().split("\\s+"));
                }
                if ((backwardAlias = attributes.get("backwardAlias")) != null) {
                    this.directionInfo.setBackwardAliases(backwardAlias.trim().split("\\s+"));
                }
                this.directionInfo.setVisibility(attributes.get("visibility"));
                this.first = false;
            }
            if (path.indexOf("/comment") < 0) {
                if (path.indexOf("/tRule") >= 0) {
                    value = fixup.transliterate(value);
                    this.rules.append(value).append("\n");
                } else {
                    throw new IllegalArgumentException("Unknown element: " + path + "\t " + value);
                }
            }
        }
    }

    public static class ParsedTransformID {
        public String source = "Any";
        public String target = "Any";
        public String variant;
        protected String[] aliases = new String[0];
        protected String[] backwardAliases = new String[0];
        protected Direction direction = null;
        protected Visibility visibility;
        static final LikelySubtags likely = new LikelySubtags();

        public String getId() {
            return this.getSource() + "-" + this.getTarget() + (String)(this.getVariant() == null ? "" : "/" + this.getVariant());
        }

        public String getDisplayId() {
            return this.getDisplaySource() + "-" + this.getDisplayTarget() + (String)(this.getVariant() == null ? "" : "/" + this.getDisplayVariant());
        }

        private String getDisplayVariant() {
            return this.getVariant();
        }

        private String getDisplayTarget() {
            return this.getDisplaySourceOrTarget(this.getTarget());
        }

        private String getDisplaySource() {
            return this.getDisplaySourceOrTarget(this.getSource());
        }

        private String getDisplaySourceOrTarget(String sourceOrTarget) {
            int uscript = UScript.getCodeFromName(sourceOrTarget);
            if (uscript >= 0) {
                return UScript.getName(uscript);
            }
            if (sourceOrTarget.contains("FONIPA")) {
                return "IPA";
            }
            if (sourceOrTarget.equals("InterIndic")) {
                return "Indic";
            }
            try {
                String name = CLDRConfig.getInstance().getEnglish().getName(sourceOrTarget);
                return name;
            }
            catch (Exception e) {
                return sourceOrTarget;
            }
        }

        public static String getScriptCode(String sourceOrTarget) {
            int uscript = UScript.getCodeFromName(sourceOrTarget);
            if (uscript >= 0) {
                return UScript.getShortName(uscript);
            }
            if (sourceOrTarget.contains("FONIPA")) {
                return "Ipa0";
            }
            if (sourceOrTarget.equals("InterIndic")) {
                return "Ind0";
            }
            try {
                String max = likely.maximize(sourceOrTarget);
                return max == null ? null : new LanguageTagParser().set(max).getScript();
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getBackwardId() {
            return this.getTarget() + "-" + this.getSource() + (String)(this.getVariant() == null ? "" : "/" + this.getVariant());
        }

        public ParsedTransformID set(String source, String target, String variant, Direction direction) {
            this.source = source;
            this.target = target;
            this.variant = variant;
            this.direction = direction;
            return this;
        }

        public ParsedTransformID set(String id) {
            this.variant = null;
            int pos = id.indexOf(45);
            if (pos < 0) {
                this.source = "Any";
                this.target = id;
                return this;
            }
            this.source = id.substring(0, pos);
            int pos2 = id.indexOf(47, pos);
            if (pos2 < 0) {
                this.target = id.substring(pos + 1);
                return this;
            }
            this.target = id.substring(pos + 1, pos2);
            this.variant = id.substring(pos2 + 1);
            return this;
        }

        public ParsedTransformID reverse() {
            String temp = this.source;
            this.source = this.target;
            this.target = temp;
            return this;
        }

        public String getTargetVariant() {
            return this.target + (String)(this.variant == null ? "" : "/" + this.variant);
        }

        public String getSourceVariant() {
            return this.source + (String)(this.variant == null ? "" : "/" + this.variant);
        }

        protected void setDirection(Direction direction) {
            this.direction = direction;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public void setVariant(String variant) {
            this.variant = variant;
        }

        protected String getVariant() {
            return this.variant;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public String getTarget() {
            return this.target;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getSource() {
            return this.source;
        }

        public String toString() {
            return this.source + "-" + this.getTargetVariant();
        }

        public static String getId(String source, String target, String variant) {
            String id = source + "-" + target;
            if (variant != null) {
                id = id + "/" + variant;
            }
            return id;
        }

        public static String reverse(String id) {
            return new ParsedTransformID().set(id).getBackwardId();
        }

        public void setAliases(String[] aliases) {
            this.aliases = aliases;
        }

        public String[] getAliases() {
            return this.aliases;
        }

        public void setBackwardAliases(String[] backwardAliases) {
            this.backwardAliases = backwardAliases;
        }

        public String[] getBackwardAliases() {
            return this.backwardAliases;
        }

        protected void setVisibility(String string) {
            this.visibility = Visibility.valueOf(string);
        }

        public Visibility getVisibility() {
            return this.visibility;
        }
    }

    public static enum Visibility {
        external,
        internal;

    }

    public static enum Direction {
        backward,
        both,
        forward;

    }

    private class RuleDirection {
        String ruleString;
        int direction;

        public RuleDirection(String ruleString, int direction) {
            this.ruleString = ruleString;
            this.direction = direction;
        }
    }
}

