/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Splitter;
import com.ibm.icu.lang.CharSequences;
import com.ibm.icu.text.Normalizer2;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.function.Function;
import org.unicode.cldr.util.CodePointEscaper;
import org.unicode.cldr.util.ComparatorUtilities;
import org.unicode.cldr.util.FormatterParser;
import org.unicode.cldr.util.With;

public class SimpleUnicodeSetFormatter
implements FormatterParser<UnicodeSet> {
    public static Normalizer2 nfc = Normalizer2.getNFCInstance();
    public static final Comparator<String> BASIC_COLLATOR = ComparatorUtilities.getIcuCollator(ULocale.ROOT, 15);
    private static final int DEFAULT_MAX_DISALLOW_RANGES = 199;
    private final Comparator<String> comparator;
    private final UnicodeSet forceHex;
    private final int maxDisallowRanges;
    private final UTF16.StringComparator codepointComparator = new UTF16.StringComparator(true, false, 0);
    static final int DEFAULT_MAX = 1024;
    static final Splitter SPACE_SPLITTER = Splitter.on(' ').omitEmptyStrings();

    public SimpleUnicodeSetFormatter(Comparator<String> col, UnicodeSet forceHex, int maxDisallowRanges) {
        this.comparator = ComparatorUtilities.wrapForCodePoints(col);
        this.forceHex = forceHex == null ? CodePointEscaper.FORCE_ESCAPE : forceHex.freeze();
        this.maxDisallowRanges = maxDisallowRanges;
    }

    public static SimpleUnicodeSetFormatter fromIcuLocale(String localeId) {
        return new SimpleUnicodeSetFormatter(ComparatorUtilities.getIcuCollator(localeId, 15), null, 1024);
    }

    public SimpleUnicodeSetFormatter(Comparator<String> col, UnicodeSet forceHex) {
        this(col, forceHex, 199);
    }

    public SimpleUnicodeSetFormatter(Comparator<String> col) {
        this(col, null, 1024);
    }

    public SimpleUnicodeSetFormatter() {
        this(ComparatorUtilities.getIcuCollator(ULocale.ROOT, 15), null, 1024);
    }

    public static SimpleUnicodeSetFormatter getDefault() {
        return Lazy.getSingleton();
    }

    public static UnicodeSet parseLenient(String source) {
        if (source.startsWith("[") && source.endsWith("]")) {
            return new UnicodeSet(source);
        }
        return SimpleUnicodeSetFormatter.getDefault().parse(source);
    }

    @Override
    public String format(UnicodeSet input) {
        boolean allowRanges = input.size() > this.maxDisallowRanges;
        StringBuilder result = new StringBuilder();
        ArrayList sorted = input.addAllTo(allowRanges ? new ArrayList() : new TreeSet<String>(this.comparator));
        int firstOfRange = -2;
        int lastOfRange = -2;
        for (String item : sorted) {
            int cp = CharSequences.getSingleCodePoint(item);
            if (cp == Integer.MAX_VALUE) {
                if (lastOfRange >= 0) {
                    if (firstOfRange != lastOfRange) {
                        result.append(firstOfRange + 1 != lastOfRange ? CodePointEscaper.RANGE_SYNTAX : (char)' ');
                        SimpleUnicodeSetFormatter.appendWithHex(result, lastOfRange, this.forceHex);
                    }
                    lastOfRange = -2;
                    firstOfRange = -2;
                }
                if (result.length() > 0) {
                    result.append(' ');
                }
                SimpleUnicodeSetFormatter.appendWithHex(result, item, this.forceHex);
                continue;
            }
            if (allowRanges && lastOfRange == cp - 1) {
                ++lastOfRange;
                continue;
            }
            if (firstOfRange != lastOfRange) {
                result.append(firstOfRange + 1 != lastOfRange ? CodePointEscaper.RANGE_SYNTAX : (char)' ');
                SimpleUnicodeSetFormatter.appendWithHex(result, lastOfRange, this.forceHex);
            }
            if (result.length() > 0) {
                result.append(' ');
            }
            SimpleUnicodeSetFormatter.appendWithHex(result, cp, this.forceHex);
            firstOfRange = lastOfRange = cp;
        }
        if (firstOfRange != lastOfRange) {
            result.append(firstOfRange + 1 != lastOfRange ? CodePointEscaper.RANGE_SYNTAX : (char)' ');
            SimpleUnicodeSetFormatter.appendWithHex(result, lastOfRange, this.forceHex);
        }
        return result.toString();
    }

    public static final StringBuilder appendWithHex(StringBuilder ap, CharSequence s2, UnicodeSet forceHex) {
        for (int cp : With.codePointArray(s2)) {
            SimpleUnicodeSetFormatter.appendWithHex(ap, cp, forceHex);
        }
        return ap;
    }

    public static StringBuilder appendWithHex(StringBuilder ap, int cp, UnicodeSet forceHex) {
        if (!forceHex.contains(cp)) {
            ap.appendCodePoint(cp);
        } else {
            ap.append(CodePointEscaper.codePointToEscaped(cp));
        }
        return ap;
    }

    @Override
    public UnicodeSet parse(String input) {
        UnicodeSet result = new UnicodeSet();
        for (String word : SPACE_SPLITTER.split(input)) {
            int rangePos = word.indexOf(CodePointEscaper.RANGE_SYNTAX);
            if (rangePos < 0) {
                result.add(SimpleUnicodeSetFormatter.unescape(word));
                continue;
            }
            int range2Pos = word.indexOf(CodePointEscaper.RANGE_SYNTAX, rangePos + 1);
            String before = word.substring(0, rangePos);
            String after = word.substring(rangePos + 1);
            if (rangePos == 0) {
                throw new IllegalArgumentException("Must have exactly one character before '\u2796': " + before + "\u274c\u2796" + after);
            }
            if (rangePos == word.length() - 1) {
                throw new IllegalArgumentException("Must have exactly one character after '\u2796': " + before + "\u2796\u274c" + after);
            }
            if (range2Pos >= 0) {
                throw new IllegalArgumentException("Must not have two '\u2796' characters: " + before + "\u2796\u274c" + after);
            }
            int first = CharSequences.getSingleCodePoint(SimpleUnicodeSetFormatter.unescape(before));
            int second = CharSequences.getSingleCodePoint(SimpleUnicodeSetFormatter.unescape(after));
            if (first == Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Must have exactly one character before '\u2796': " + before + "\u274c\u2796" + after);
            }
            if (second == Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Must have exactly one character after '\u2796': " + before + "\u2796\u274c" + after);
            }
            result.add(first, second);
        }
        return result;
    }

    public static CharSequence unescape(String word) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < word.length()) {
            int endStart;
            String toAppend;
            int escapeStart = word.indexOf(CodePointEscaper.ESCAPE_START, i);
            if (escapeStart < 0) {
                toAppend = i == 0 ? word : word.substring(i);
                endStart = toAppend.indexOf(CodePointEscaper.ESCAPE_END);
                if (endStart >= 0) {
                    throw new IllegalArgumentException("Missing start escape " + CodePointEscaper.ESCAPE_START + ": " + word.substring(0, endStart) + "\u274c" + word.substring(endStart));
                }
                result.append(toAppend);
                break;
            }
            toAppend = word.substring(i, escapeStart);
            endStart = toAppend.indexOf(CodePointEscaper.ESCAPE_END);
            if (endStart >= 0) {
                throw new IllegalArgumentException("Missing start escape " + CodePointEscaper.ESCAPE_START + ": " + toAppend.substring(0, endStart) + "\u274c" + toAppend.substring(endStart));
            }
            result.append(toAppend);
            int interiorStart = escapeStart + 1;
            int escapeEnd = word.indexOf(CodePointEscaper.ESCAPE_END, interiorStart);
            if (escapeEnd < 0) {
                throw new IllegalArgumentException("Missing end escape " + CodePointEscaper.ESCAPE_END + ": " + word + "\u274c");
            }
            result.appendCodePoint(CodePointEscaper.rawEscapedToCodePoint(word.substring(interiorStart, escapeEnd)));
            i = escapeEnd + 1;
        }
        return result;
    }

    public static UnicodeSet transform(UnicodeSet expected, Function<String, String> function) {
        UnicodeSet result = new UnicodeSet();
        for (String s2 : expected) {
            String t2 = function.apply(s2);
            result.add(t2);
        }
        return result;
    }

    public static <T extends Collection<String>> T transformAndAddAllTo(UnicodeSet expected, Function<String, String> function, T target) {
        for (String s2 : expected) {
            String t2 = function == null ? s2 : function.apply(s2);
            target.add((String)t2);
        }
        return target;
    }

    static class Lazy {
        static SimpleUnicodeSetFormatter SINGLETON = new SimpleUnicodeSetFormatter();

        Lazy() {
        }

        static SimpleUnicodeSetFormatter getSingleton() {
            return SINGLETON;
        }
    }
}

