/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Output;
import java.io.BufferedReader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.ScriptMetadata;
import org.unicode.cldr.util.CalculatedCoverageLevels;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.Iso639Data;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.LocalesTxtReader;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.ZoneParser;

public class StandardCodes {
    private static final Set<CodeType> TypeSet = Collections.unmodifiableSet(EnumSet.allOf(CodeType.class));
    private static final Set<String> TypeStringSet;
    public static final String DESCRIPTION_SEPARATOR = "\u25aa";
    public static final String NO_COUNTRY = "001";
    private EnumMap<CodeType, Map<String, List<String>>> type_code_data = new EnumMap(CodeType.class);
    private EnumMap<CodeType, Map<String, List<String>>> type_name_codes = new EnumMap(CodeType.class);
    private EnumMap<CodeType, Map<String, String>> type_code_preferred = new EnumMap(CodeType.class);
    private Map<String, Set<String>> country_modernCurrency = new TreeMap<String, Set<String>>();
    private Map<CodeType, Set<String>> goodCodes = new TreeMap<CodeType, Set<String>>();
    private static final boolean DEBUG = false;
    private static Set<String> GOOD_COUNTRIES;
    static Comparator caseless;
    public static final String ALL_LOCALES = "*";
    private Map<String, List<String>> WorldBankInfo;
    Set<String> moribundLanguages;
    static String[][] extras;
    static final String registryName;
    static Map<String, Map<String, Map<String, String>>> LSTREG;
    static Map<LstrType, Map<String, Map<LstrField, String>>> LSTREG_ENUM;
    static Map<LstrType, Map<String, Map<LstrField, String>>> LSTREG_RAW;
    static Counter<LstrType> languageCount;
    ZoneParser zoneParser = new ZoneParser();
    static final Pattern whitespace;
    static Set<String> filteredCurrencies;
    static UnicodeSet COUNTRY;

    public static boolean isLocaleAtLeastBasic(String locale) {
        return CalculatedCoverageLevels.getInstance().isLocaleAtLeastBasic(locale);
    }

    public static synchronized StandardCodes make() {
        return StandardCodesHelper.SINGLETON;
    }

    public String getData(String type, String code) {
        Map<String, List<String>> code_data = this.getCodeData(type);
        if (code_data == null) {
            return null;
        }
        List<String> list = code_data.get(code);
        if (list == null) {
            return null;
        }
        return list.get(0);
    }

    public List<String> getFullData(String type, String code) {
        Map<String, List<String>> code_data = this.getCodeData(type);
        if (code_data == null) {
            return null;
        }
        return code_data.get(code);
    }

    public List<String> getFullData(CodeType type, String code) {
        Map<String, List<String>> code_data = this.type_code_data.get((Object)type);
        if (code_data == null) {
            return null;
        }
        return code_data.get(code);
    }

    private Map<String, List<String>> getCodeData(String type) {
        return this.getCodeData(CodeType.from(type));
    }

    private Map<String, List<String>> getCodeData(CodeType type) {
        return this.type_code_data.get((Object)type);
    }

    public Map<String, String> getLangData(String type, String code) {
        try {
            if (type.equals("territory")) {
                type = "region";
            } else if (type.equals("variant")) {
                code = code.toLowerCase(Locale.ENGLISH);
            }
            return StandardCodes.getLStreg().get(type).get(code);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public String getReplacement(String type, String code) {
        if (type.equals("currency")) {
            return null;
        }
        List<String> data = this.getFullData(type, code);
        if (data == null) {
            return null;
        }
        if (data.size() < 3) {
            return null;
        }
        String replacement = data.get(2);
        if (!replacement.equals("") && !replacement.equals("--")) {
            return replacement;
        }
        return null;
    }

    @Deprecated
    public List<String> getCodes(String type, String data) {
        return this.getCodes(CodeType.from(type), data);
    }

    public List<String> getCodes(CodeType type, String data) {
        Map<String, List<String>> data_codes = this.type_name_codes.get((Object)type);
        if (data_codes == null) {
            return null;
        }
        return Collections.unmodifiableList(data_codes.get(data));
    }

    @Deprecated
    public String getPreferred(String type, String code) {
        return this.getPreferred(CodeType.from(type), code);
    }

    public String getPreferred(CodeType type, String code) {
        Map<String, String> code_preferred = this.type_code_preferred.get((Object)type);
        if (code_preferred == null) {
            return code;
        }
        String newCode = code_preferred.get(code);
        if (newCode == null) {
            return code;
        }
        return newCode;
    }

    public Set<String> getAvailableTypes() {
        return TypeStringSet;
    }

    public Set<CodeType> getAvailableTypesEnum() {
        return TypeSet;
    }

    public Set<String> getAvailableCodes(String type) {
        return this.getAvailableCodes(CodeType.from(type));
    }

    public Set<String> getAvailableCodes(CodeType type) {
        Map<String, List<String>> code_name = this.type_code_data.get((Object)type);
        return Collections.unmodifiableSet(code_name.keySet());
    }

    public Set<String> getGoodAvailableCodes(String stringType) {
        return this.getGoodAvailableCodes(CodeType.from(stringType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getGoodAvailableCodes(CodeType type) {
        Set<String> result = this.goodCodes.get((Object)type);
        if (result == null) {
            Map<CodeType, Set<String>> map = this.goodCodes;
            synchronized (map) {
                Map<String, List<String>> code_name = this.getCodeData(type);
                SupplementalDataInfo sd = SupplementalDataInfo.getInstance();
                if (code_name == null) {
                    return null;
                }
                result = new TreeSet<String>(code_name.keySet());
                switch (type) {
                    case currency: {
                        break;
                    }
                    case language: {
                        return sd.getCLDRLanguageCodes();
                    }
                    case script: {
                        return sd.getCLDRScriptCodes();
                    }
                    case tzid: {
                        break;
                    }
                    default: {
                        Iterator<String> it = result.iterator();
                        while (it.hasNext()) {
                            String code = it.next();
                            if (code.equals("root") || code.equals("QO")) continue;
                            List<String> data = this.getFullData(type, code);
                            if (data.size() < 3) {
                                // empty if block
                            }
                            if (!"PRIVATE USE".equalsIgnoreCase(data.get(0)) && (data.get(2).equals("") || data.get(2).equals("--"))) continue;
                            it.remove();
                        }
                        break block2;
                    }
                }
                result = Collections.unmodifiableSet(result);
                this.goodCodes.put(type, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getGoodCountries() {
        Map<CodeType, Set<String>> map = this.goodCodes;
        synchronized (map) {
            if (GOOD_COUNTRIES == null) {
                LinkedHashSet<String> temp = new LinkedHashSet<String>();
                for (String s2 : this.getGoodAvailableCodes(CodeType.territory)) {
                    if (!StandardCodes.isCountry(s2)) continue;
                    temp.add(s2);
                }
                GOOD_COUNTRIES = Collections.unmodifiableSet(temp);
            }
        }
        return GOOD_COUNTRIES;
    }

    public Set<String> getMainCurrencies(String countryCode) {
        return this.country_modernCurrency.get(countryCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Map<Organization, Map<String, Level>> getLocaleTypes() {
        Class<StandardCodes> clazz = StandardCodes.class;
        synchronized (StandardCodes.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.loadPlatformLocaleStatus().platform_locale_level;
        }
    }

    public Map<String, Level> getLocaleToLevel(Organization org) {
        return this.getLocaleTypes().get((Object)org);
    }

    public Level getHighestLocaleCoverageLevel(String organization, String locale) {
        String parentId = LocaleIDParser.getParent(locale);
        Level parentLevel = Level.UNDETERMINED;
        if (parentId != null && !parentId.equals("root")) {
            parentLevel = this.getHighestLocaleCoverageLevel(organization, parentId);
        }
        Level ourLevel = this.getLocaleCoverageLevel(organization, locale);
        if (parentLevel.getLevel() > ourLevel.getLevel()) {
            return parentLevel;
        }
        return ourLevel;
    }

    public Level getLocaleCoverageLevel(String organization, String desiredLocale) {
        return this.getLocaleCoverageLevel(Organization.fromString(organization), desiredLocale);
    }

    public Level getLocaleCoverageLevel(Organization organization, String desiredLocale) {
        return this.getLocaleCoverageLevel(organization, desiredLocale, new Output<LocaleCoverageType>());
    }

    public Level getLocaleCoverageLevel(Organization organization, String desiredLocale, Output<LocaleCoverageType> coverageType) {
        Level status;
        coverageType.value = LocaleCoverageType.undetermined;
        if (organization == null) {
            return Level.UNDETERMINED;
        }
        Map<String, Level> locale_status = this.loadPlatformLocaleStatus().platform_locale_level.get((Object)organization);
        if (locale_status == null) {
            return Level.UNDETERMINED;
        }
        String originalLocale = desiredLocale;
        while (desiredLocale != null) {
            status = locale_status.get(desiredLocale);
            if (status != null && status != Level.UNDETERMINED) {
                coverageType.value = originalLocale == desiredLocale ? LocaleCoverageType.explicit : LocaleCoverageType.parent;
                return status;
            }
            desiredLocale = LocaleIDParser.getParent(desiredLocale);
        }
        status = locale_status.get(ALL_LOCALES);
        if (status != null && status != Level.UNDETERMINED) {
            coverageType.value = LocaleCoverageType.star;
            return status;
        }
        return Level.UNDETERMINED;
    }

    public Level getDefaultLocaleCoverageLevel(Organization organization) {
        return this.getLocaleCoverageLevel(organization, ALL_LOCALES);
    }

    public Set<Organization> getLocaleCoverageOrganizations() {
        return this.loadPlatformLocaleStatus().platform_locale_level.keySet();
    }

    public Set<String> getLocaleCoverageOrganizationStrings() {
        return this.loadPlatformLocaleStatus().platform_locale_levelString.keySet();
    }

    public Set<String> getLocaleCoverageLocales(String organization) {
        return this.getLocaleCoverageLocales(Organization.fromString(organization));
    }

    public Set<String> getLocaleCoverageLocales(Organization organization) {
        return this.loadPlatformLocaleStatus().platform_locale_level.get((Object)organization).keySet();
    }

    public Map<String, Level> getLocalesToLevelsFor(Organization organization) {
        return this.loadPlatformLocaleStatus().platform_locale_level.get((Object)organization);
    }

    public Relation<Level, String> getLevelsToLocalesFor(Organization organization) {
        return this.loadPlatformLocaleStatus().platform_level_locale.get((Object)organization);
    }

    public Set<String> getLocaleCoverageLocales(Organization organization, Set<Level> choice) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String locale : this.getLocaleCoverageLocales(organization)) {
            if (!choice.contains((Object)this.getLocaleCoverageLevel(organization, locale))) continue;
            result.add(locale);
        }
        return result;
    }

    public Level getTargetCoverageLevel(String localeId) {
        Level level = this.getLocaleCoverageLevel(Organization.cldr, localeId);
        if (level != Level.UNDETERMINED) {
            return level;
        }
        for (Organization o : Organization.values()) {
            if (o == Organization.cldr || o == Organization.unaffiliated || o == Organization.surveytool) continue;
            Output<LocaleCoverageType> outputType = new Output<LocaleCoverageType>();
            Level orgLevel = this.getLocaleCoverageLevel(o, localeId, outputType);
            if (outputType.value == LocaleCoverageType.undetermined || outputType.value == LocaleCoverageType.star) continue;
            Level pinnedOrgLevel = Level.min(Level.MODERN, orgLevel);
            level = Level.max(level, pinnedOrgLevel);
        }
        if (level != Level.UNDETERMINED) {
            return level;
        }
        level = Level.BASIC;
        return level;
    }

    private LocalesTxtReader loadPlatformLocaleStatus() {
        return LocalesTxtHelper.SINGLETON.reader;
    }

    String validate(LocaleIDParser parser) {
        String territory;
        Object message = "";
        String lang = parser.getLanguage();
        if (lang.length() == 0) {
            message = (String)message + ", Missing language";
        } else if (!this.getAvailableCodes("language").contains(lang)) {
            message = (String)message + ", Invalid language code: " + lang;
        }
        String script = parser.getScript();
        if (script.length() != 0 && !this.getAvailableCodes("script").contains(script)) {
            message = (String)message + ", Invalid script code: " + script;
        }
        if ((territory = parser.getRegion()).length() != 0 && !this.getAvailableCodes("territory").contains(territory)) {
            message = (String)message + ", Invalid territory code: " + lang;
        }
        return ((String)message).length() == 0 ? message : ((String)message).substring(2);
    }

    public boolean isLocaleInGroup(String locale, String group, Organization org) {
        return group.equals(this.getGroup(locale, org));
    }

    public boolean isLocaleInGroup(String locale, String group, String org) {
        return this.isLocaleInGroup(locale, group, Organization.fromString(org));
    }

    public String getGroup(String locale, String org) {
        return this.getGroup(locale, Organization.fromString(org));
    }

    private String getGroup(String locale, Organization org) {
        Level l = this.getLocaleCoverageLevel(org, locale);
        if (l.equals((Object)Level.UNDETERMINED)) {
            return null;
        }
        return l.toString();
    }

    private StandardCodes() {
        String[] files = new String[]{"ISO4217.txt"};
        this.type_code_preferred.put(CodeType.tzid, new TreeMap());
        this.add(CodeType.language, "root", "Root");
        String originalLine = null;
        for (int fileIndex = 0; fileIndex < files.length; ++fileIndex) {
            try {
                String line;
                BufferedReader lstreg = CldrUtility.getUTF8Data(files[fileIndex]);
                while ((line = (originalLine = lstreg.readLine())) != null) {
                    if (line.startsWith("\ufeff")) {
                        line = line.substring(1);
                    }
                    line = line.trim();
                    int commentPos = line.indexOf(35);
                    String comment = "";
                    if (commentPos >= 0) {
                        comment = line.substring(commentPos + 1).trim();
                        line = line.substring(0, commentPos);
                    }
                    if (line.length() == 0) continue;
                    List<String> pieces = CldrUtility.splitList(line, '|', true, new ArrayList<String>());
                    CodeType type = CodeType.from(pieces.get(0));
                    pieces.remove(0);
                    String code = pieces.get(0);
                    pieces.remove(0);
                    if (type.equals("date")) continue;
                    String oldName = pieces.get(0);
                    int pos = oldName.indexOf(59);
                    if (pos >= 0) {
                        oldName = oldName.substring(0, pos).trim();
                        pieces.set(0, oldName);
                    }
                    List<String> data = pieces;
                    if (comment.indexOf("deprecated") >= 0 && data.get(2).toString().length() == 0) {
                        data.set(2, "--");
                    }
                    if (oldName.equalsIgnoreCase("PRIVATE USE")) {
                        int separatorPos = code.indexOf("..");
                        if (separatorPos < 0) {
                            this.add(type, code, data);
                            continue;
                        }
                        String current = code.substring(0, separatorPos);
                        String end = code.substring(separatorPos + 2);
                        while (current.compareTo(end) <= 0) {
                            this.add(type, current, data);
                            current = StandardCodes.nextAlpha(current);
                        }
                        continue;
                    }
                    if (!type.equals("tzid")) {
                        this.add(type, code, data);
                        if (!type.equals("currency") || !data.get(3).equals("C")) continue;
                        String country = data.get(1);
                        Set<String> codes = this.country_modernCurrency.get(country);
                        if (codes == null) {
                            codes = new TreeSet<String>();
                            this.country_modernCurrency.put(country, codes);
                        }
                        codes.add(code);
                        continue;
                    }
                    String preferred = null;
                    for (int i = 0; i < pieces.size(); ++i) {
                        code = pieces.get(i);
                        this.add(type, code, data);
                        if (preferred == null) {
                            preferred = code;
                            continue;
                        }
                        Map<String, String> code_preferred = this.type_code_preferred.get((Object)type);
                        code_preferred.put(code, preferred);
                    }
                }
                lstreg.close();
            }
            catch (Exception e) {
                System.err.println("WARNING: " + files[fileIndex] + " may be a corrupted UTF-8 file. Please check.");
                throw (IllegalArgumentException)new IllegalArgumentException("Can't read " + files[fileIndex] + "\t" + originalLine).initCause(e);
            }
            this.country_modernCurrency = CldrUtility.protectCollection(this.country_modernCurrency);
        }
        Map<String, Map<String, Map<String, String>>> languageRegistry = StandardCodes.getLStreg();
        for (String type : languageRegistry.keySet()) {
            CodeType type2 = CodeType.from(type);
            Map<String, Map<String, String>> m4 = languageRegistry.get(type);
            for (String code : m4.keySet()) {
                Map<String, String> mm4 = m4.get(code);
                ArrayList<String> data = new ArrayList<String>(0);
                data.add(mm4.get("Description"));
                data.add(mm4.get("Added"));
                String pref = mm4.get("Preferred-Value");
                if (pref == null) {
                    pref = mm4.get("Deprecated");
                    pref = pref == null ? "" : "deprecated";
                }
                data.add(pref);
                if (type.equals("variant")) {
                    code = code.toUpperCase();
                }
                this.add(type2, code, data);
            }
        }
        Map<String, List<String>> m5 = this.getZoneData();
        for (String code : m5.keySet()) {
            this.add(CodeType.tzid, code, m5.get(code).toString());
        }
    }

    private static String nextAlpha(String current) {
        int value = 0;
        for (int i = 0; i < current.length(); ++i) {
            char c;
            c = (char)(c - ((c = current.charAt(i)) < 'a' ? 65 : 97));
            value = value * 26 + c;
        }
        ++value;
        Object result = "";
        for (int i = 0; i < current.length(); ++i) {
            result = (char)(value % 26 + 65) + (String)result;
            value /= 26;
        }
        if (UCharacter.toLowerCase(current).equals(current)) {
            result = UCharacter.toLowerCase((String)result);
        } else if (!UCharacter.toUpperCase(current).equals(current)) {
            result = UCharacter.toTitleCase((String)result, null);
        }
        return result;
    }

    private void add(CodeType type, String string2, String string3) {
        ArrayList<String> l = new ArrayList<String>();
        l.add(string3);
        this.add(type, string2, l);
    }

    private void add(CodeType type, String code, List<String> otherData) {
        List<String> codes;
        List<String> lastData;
        if (type == CodeType.script) {
            if (code.equals("Qaai")) {
                otherData = new ArrayList<String>(otherData);
                otherData.set(0, "Inherited");
            } else if (code.equals("Zyyy")) {
                otherData = new ArrayList<String>(otherData);
                otherData.set(0, "Common");
            }
        }
        String name = otherData.get(0);
        Map<String, List<String>> code_data = this.getCodeData(type);
        if (code_data == null) {
            code_data = new TreeMap<String, List<String>>();
            this.type_code_data.put(type, code_data);
        }
        if ((lastData = code_data.get(code)) != null) {
            lastData.addAll(otherData);
        } else {
            code_data.put(code, otherData);
        }
        Map<String, List<String>> name_codes = this.type_name_codes.get((Object)type);
        if (name_codes == null) {
            name_codes = new TreeMap<String, List<String>>();
            this.type_name_codes.put(type, name_codes);
        }
        if ((codes = name_codes.get(name)) == null) {
            codes = new ArrayList<String>();
            name_codes.put(name, codes);
        }
        codes.add(code);
    }

    public Map<String, List<String>> getWorldBankInfo() {
        if (this.WorldBankInfo == null) {
            List<String> temp = this.fillFromCommaFile("WorldBankInfo.txt", false);
            this.WorldBankInfo = new HashMap<String, List<String>>();
            for (String line : temp) {
                List<String> row = CldrUtility.splitList(line, ';', true);
                String key = row.get(0);
                row.remove(0);
                this.WorldBankInfo.put(key, row);
            }
            this.WorldBankInfo = CldrUtility.protectCollection(this.WorldBankInfo);
        }
        return this.WorldBankInfo;
    }

    public Set<String> getMoribundLanguages() {
        if (this.moribundLanguages == null) {
            List<String> temp = this.fillFromCommaFile("moribund_languages.txt", true);
            this.moribundLanguages = new TreeSet<String>();
            this.moribundLanguages.addAll(temp);
            this.moribundLanguages = CldrUtility.protectCollection(this.moribundLanguages);
        }
        return this.moribundLanguages;
    }

    private List<String> fillFromCommaFile(String filename, boolean trim) {
        try {
            String line;
            ArrayList<String> result = new ArrayList<String>();
            BufferedReader lstreg = CldrUtility.getUTF8Data(filename);
            while ((line = lstreg.readLine()) != null) {
                int commentPos = line.indexOf(35);
                if (commentPos >= 0) {
                    line = line.substring(0, commentPos);
                }
                if (trim) {
                    line = line.trim();
                }
                if (line.length() == 0) continue;
                result.add(line);
            }
            return result;
        }
        catch (Exception e) {
            throw (RuntimeException)new IllegalArgumentException("Can't process file: data/" + filename).initCause(e);
        }
    }

    public static Map<String, Map<String, Map<String, String>>> getLStreg() {
        if (LSTREG == null) {
            StandardCodes.initLstr();
        }
        return LSTREG;
    }

    public static Map<LstrType, Map<String, Map<LstrField, String>>> getEnumLstreg() {
        if (LSTREG_ENUM == null) {
            StandardCodes.initLstr();
        }
        return LSTREG_ENUM;
    }

    public static Map<LstrType, Map<String, Map<LstrField, String>>> getLstregEnumRaw() {
        if (LSTREG_ENUM == null) {
            StandardCodes.initLstr();
        }
        return LSTREG_RAW;
    }

    private static void initLstr() {
        TreeMap result2 = new TreeMap();
        int lineNumber = 1;
        TreeSet funnyTags = new TreeSet();
        try {
            String line;
            BufferedReader lstreg = CldrUtility.getUTF8Data(registryName);
            Object lastType = null;
            String lastTag = null;
            TreeMap subtagData = null;
            TreeMap<LstrField, CallSite> currentData = null;
            LstrField lastLabel = null;
            Object lastRest = null;
            boolean inRealContent = false;
            while ((line = lstreg.readLine()) != null) {
                if (line.length() != 0) {
                    if (line.startsWith("File-Date: ")) {
                        inRealContent = true;
                    } else if (inRealContent && !line.startsWith("Internet-Draft") && !line.startsWith("Ewell") && !line.startsWith("\f")) {
                        if (line.startsWith("4.  Security Considerations")) {
                            break;
                        }
                        if (!line.startsWith("%%")) {
                            if (line.startsWith(" ")) {
                                currentData.put(lastLabel, (CallSite)((Object)(lastRest + " " + line.trim())));
                            } else {
                                int pos2 = line.indexOf(58);
                                LstrField label = LstrField.from(line.substring(0, pos2));
                                String rest = line.substring(pos2 + 1).trim();
                                if (label == LstrField.Type) {
                                    lastType = rest.equals("grandfathered") ? LstrType.legacy : LstrType.fromString(rest);
                                    subtagData = (TreeMap)CldrUtility.get(result2, lastType);
                                    if (subtagData == null) {
                                        subtagData = new TreeMap();
                                        result2.put(lastType, subtagData);
                                    }
                                } else if (label == LstrField.Subtag || label == LstrField.Tag) {
                                    lastTag = rest;
                                    String endTag = null;
                                    int pos = lastTag.indexOf("..");
                                    if (pos >= 0) {
                                        endTag = lastTag.substring(pos + 2);
                                        lastTag = lastTag.substring(0, pos);
                                    }
                                    currentData = new TreeMap<LstrField, CallSite>();
                                    if (endTag == null) {
                                        StandardCodes.putSubtagData(lastTag, subtagData, currentData);
                                        languageCount.add((LstrType)((Object)lastType), 1L);
                                    } else {
                                        while (lastTag.compareTo(endTag) <= 0) {
                                            StandardCodes.putSubtagData(lastTag, subtagData, currentData);
                                            languageCount.add((LstrType)((Object)lastType), 1L);
                                            lastTag = StandardCodes.nextAlpha(lastTag);
                                        }
                                    }
                                } else {
                                    lastLabel = label;
                                    lastRest = rest;
                                    String oldValue = (String)CldrUtility.get(currentData, lastLabel);
                                    if (oldValue != null) {
                                        lastRest = oldValue + DESCRIPTION_SEPARATOR + (String)lastRest;
                                    }
                                    currentData.put(lastLabel, (CallSite)lastRest);
                                }
                            }
                        }
                    }
                }
                ++lineNumber;
            }
        }
        catch (Exception e) {
            throw (RuntimeException)new IllegalArgumentException("Can't process file: data/" + registryName + ";\t at line " + lineNumber).initCause(e);
        }
        finally {
            if (!funnyTags.isEmpty()) {
                // empty if block
            }
        }
        TreeMap rawLstreg = new TreeMap();
        for (Map.Entry entry1 : result2.entrySet()) {
            LstrType key1 = (LstrType)((Object)entry1.getKey());
            TreeMap raw1 = new TreeMap();
            rawLstreg.put(key1, raw1);
            for (Map.Entry entry2 : ((Map)entry1.getValue()).entrySet()) {
                String key2 = (String)entry2.getKey();
                Map value2 = (Map)entry2.getValue();
                TreeMap raw2 = new TreeMap();
                raw2.putAll(value2);
                raw1.put(key2, raw2);
            }
        }
        LSTREG_RAW = CldrUtility.protectCollection(rawLstreg);
        for (int i = 0; i < extras.length; ++i) {
            TreeMap<String, TreeMap<LstrField, String>> subtagData = (TreeMap<String, TreeMap<LstrField, String>>)CldrUtility.get(result2, LstrType.fromString(extras[i][0]));
            if (subtagData == null) {
                subtagData = new TreeMap<String, TreeMap<LstrField, String>>();
                result2.put((Object)((Object)LstrType.fromString(extras[i][0])), subtagData);
            }
            TreeMap<LstrField, String> labelData = new TreeMap<LstrField, String>();
            for (int j = 2; j < extras[i].length; j += 2) {
                labelData.put(LstrField.from(extras[i][j]), extras[i][j + 1]);
            }
            Map old = (Map)CldrUtility.get(subtagData, extras[i][1]);
            if (old != null && !"Private use".equals(CldrUtility.get(old, LstrField.Description))) {
                throw new IllegalArgumentException("REPLACING data for " + extras[i][1] + "\t" + old + "\twith" + labelData);
            }
            subtagData.put(extras[i][1], labelData);
        }
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : result2.entrySet()) {
            LinkedHashMap copy2 = new LinkedHashMap();
            result.put(((LstrType)((Object)entry.getKey())).toString(), copy2);
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                LinkedHashMap<String, String> copy3 = new LinkedHashMap<String, String>();
                copy2.put((String)entry2.getKey(), copy3);
                for (Map.Entry entry3 : ((Map)entry2.getValue()).entrySet()) {
                    copy3.put(((LstrField)((Object)entry3.getKey())).toString(), (String)entry3.getValue());
                }
            }
        }
        LSTREG = CldrUtility.protectCollection(result);
        LSTREG_ENUM = CldrUtility.protectCollection(result2);
    }

    private static <K, K2, V> Map<K2, V> putSubtagData(K lastTag, Map<K, Map<K2, V>> subtagData, Map<K2, V> currentData) {
        Map<K2, V> oldData = subtagData.get(lastTag);
        if (oldData != null) {
            if (oldData.get("CLDR") != null) {
                System.out.println("overriding: " + lastTag + ", " + oldData);
            } else {
                throw new IllegalArgumentException("Duplicate tag: " + lastTag);
            }
        }
        return subtagData.put(lastTag, currentData);
    }

    public static Counter<LstrType> getLanguageCount() {
        return languageCount;
    }

    @Deprecated
    public Map<String, List<ZoneParser.ZoneLine>> getZone_rules() {
        return this.zoneParser.getZone_rules();
    }

    @Deprecated
    public Map<String, List<String>> getZoneData() {
        return this.zoneParser.getZoneData();
    }

    @Deprecated
    public Set<String> getCanonicalTimeZones() {
        return this.zoneParser.getZoneData().keySet();
    }

    @Deprecated
    public Map<String, Set<String>> getCountryToZoneSet() {
        return this.zoneParser.getCountryToZoneSet();
    }

    @Deprecated
    public List<String> getDeprecatedZoneIDs() {
        return this.zoneParser.getDeprecatedZoneIDs();
    }

    @Deprecated
    public Comparator<String> getTZIDComparator() {
        return this.zoneParser.getTZIDComparator();
    }

    @Deprecated
    public Map<String, Set<String>> getZoneLinkNew_OldSet() {
        return this.zoneParser.getZoneLinkNew_OldSet();
    }

    @Deprecated
    public Map<String, String> getZoneLinkold_new() {
        return this.zoneParser.getZoneLinkold_new();
    }

    @Deprecated
    public Map getZoneRuleID_rules() {
        return this.zoneParser.getZoneRuleID_rules();
    }

    @Deprecated
    public Map<String, String> getZoneToCounty() {
        return this.zoneParser.getZoneToCounty();
    }

    @Deprecated
    public String getZoneVersion() {
        return this.zoneParser.getVersion();
    }

    public static String fixLanguageTag(String languageSubtag) {
        if (languageSubtag.equals("mo")) {
            return "ro";
        }
        return languageSubtag;
    }

    public boolean isModernLanguage(String languageCode) {
        if (this.getMoribundLanguages().contains(languageCode)) {
            return false;
        }
        Iso639Data.Type type = Iso639Data.getType(languageCode);
        if (type == Iso639Data.Type.Living) {
            return true;
        }
        return languageCode.equals("eo");
    }

    public static boolean isScriptModern(String script) {
        ScriptMetadata.Info info = ScriptMetadata.getInfo(script);
        if (info == null) {
            return false;
        }
        ScriptMetadata.IdUsage idUsage = info.idUsage;
        return idUsage != ScriptMetadata.IdUsage.EXCLUSION && idUsage != ScriptMetadata.IdUsage.UNKNOWN;
    }

    public Set<String> getSurveyToolDisplayCodes(String type) {
        return this.getGoodAvailableCodes(type);
    }

    public static boolean isCountry(String territory) {
        switch (territory) {
            case "ZZ": 
            case "QO": 
            case "EU": 
            case "UN": 
            case "EZ": {
                return false;
            }
        }
        return territory.length() == 2 && COUNTRY.containsAll(territory);
    }

    public boolean isLstregPrivateUse(String type, String code) {
        Map<String, String> lStregData = StandardCodes.getLStreg().get(type).get(code);
        return lStregData.get("Description").equalsIgnoreCase("private use");
    }

    public boolean isLstregDeprecated(String type, String code) {
        Map<String, String> lStregData = StandardCodes.getLStreg().get(type).get(code);
        return lStregData.get("Deprecated") != null;
    }

    static {
        LinkedHashSet<String> foo = new LinkedHashSet<String>();
        for (CodeType x : CodeType.values()) {
            foo.add(x.toString());
        }
        TypeStringSet = Collections.unmodifiableSet(foo);
        caseless = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String s1 = (String)arg0;
                String s2 = (String)arg1;
                return s1.compareToIgnoreCase(s2);
            }
        };
        extras = new String[][]{{"language", "root", "Description", "Root", "CLDR", "True"}, {"variant", "REVISED", "Description", "Revised Orthography", "CLDR", "True"}, {"variant", "SAAHO", "Description", "Dialect", "CLDR", "True"}, {"variant", "POSIX", "Description", "Computer-Style", "CLDR", "True"}, {"region", "ZZ", "Description", "Unknown or Invalid Region", "CLDR", "True"}, {"region", "QO", "Description", "Outlying Oceania", "CLDR", "True"}, {"region", "XK", "Description", "Kosovo", "CLDR", "True"}, {"script", "Qaai", "Description", "Inherited", "CLDR", "True"}};
        registryName = CldrUtility.getProperty("registry", "language-subtag-registry");
        languageCount = new Counter();
        whitespace = PatternCache.get("\\s+");
        filteredCurrencies = null;
        COUNTRY = new UnicodeSet("[a-zA-Z]").freeze();
    }

    public static enum LstrField {
        Type,
        Subtag,
        Description,
        Added,
        Scope,
        Tag,
        Suppress_Script,
        Macrolanguage,
        Deprecated,
        Preferred_Value,
        Comments,
        Prefix,
        CLDR;


        public static LstrField from(String s2) {
            return LstrField.valueOf(s2.trim().replace("-", "_"));
        }
    }

    public static enum LstrType {
        language("und", "zxx", "mul", "mis", "root"),
        script("Zzzz", "Zsym", "Zxxx", "Zmth"),
        region("ZZ"),
        variant(new String[0]),
        extension(new String[0]),
        extlang(true, false, new String[0]),
        legacy(true, false, new String[0]),
        redundant(true, false, new String[0]),
        currency(false, true, "XXX"),
        subdivision(false, true, new String[0]),
        unit(false, true, new String[0]),
        usage(false, true, new String[0]),
        zone(false, true, new String[0]);

        public final Set<String> specials;
        public final String unknown;
        public final boolean isLstr;
        public final boolean isUnicode;
        static final Pattern WELLFORMED;

        private LstrType(String ... unknownValue) {
            this(true, true, unknownValue);
        }

        private LstrType(boolean lstr, boolean unicode, String ... unknownValue) {
            this.unknown = unknownValue.length == 0 ? null : unknownValue[0];
            LinkedHashSet<String> set = new LinkedHashSet<String>(Arrays.asList(unknownValue));
            if (this.unknown != null) {
                set.remove(this.unknown);
            }
            this.specials = Collections.unmodifiableSet(set);
            this.isLstr = lstr;
            this.isUnicode = unicode;
        }

        boolean isWellFormed(String candidate) {
            switch (this) {
                case subdivision: {
                    return WELLFORMED.matcher(candidate).matches();
                }
            }
            throw new UnsupportedOperationException();
        }

        public String toCompatString() {
            switch (this) {
                case region: {
                    return "territory";
                }
                case legacy: {
                    return "language";
                }
                case redundant: {
                    return "language";
                }
            }
            return this.toString();
        }

        public static LstrType fromString(String rawType) {
            try {
                return LstrType.valueOf(rawType);
            }
            catch (IllegalArgumentException e) {
                if ("territory".equals(rawType)) {
                    return region;
                }
                throw e;
            }
        }

        static {
            WELLFORMED = Pattern.compile("([0-9]{3}|[a-zA-Z]{2})[a-zA-Z0-9]{1,4}");
        }
    }

    private static final class LocalesTxtHelper {
        static LocalesTxtHelper SINGLETON = new LocalesTxtHelper();
        public LocalesTxtReader reader = new LocalesTxtReader().read(StandardCodes.make());

        LocalesTxtHelper() {
        }
    }

    public static enum LocaleCoverageType {
        explicit,
        parent,
        star,
        undetermined;

    }

    private static final class StandardCodesHelper {
        static final StandardCodes SINGLETON = new StandardCodes();

        private StandardCodesHelper() {
        }
    }

    public static enum CodeType {
        language,
        script,
        territory,
        extlang,
        legacy,
        redundant,
        variant,
        currency,
        tzid;


        public static CodeType from(String name) {
            if ("region".equals(name)) {
                return territory;
            }
            return CodeType.valueOf(name);
        }
    }
}

