/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.json;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.ibm.icu.number.IntegerWidth;
import com.ibm.icu.number.LocalizedNumberFormatter;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.number.Precision;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.NoUnit;
import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.draft.ScriptMetadata;
import org.unicode.cldr.json.CldrItem;
import org.unicode.cldr.json.CldrNode;
import org.unicode.cldr.json.LdmlConfigFileReader;
import org.unicode.cldr.json.LdmlConvertRules;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.Annotations;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.CalculatedCoverageLevels;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.CoverageInfo;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.FileCopier;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.Timer;
import org.unicode.cldr.util.XPathParts;

@CLDRTool(alias="ldml2json", description="Convert CLDR data to JSON")
public class Ldml2JsonConverter {
    private static final String DONE_ICON = "\u2705";
    private static final String GEAR_ICON = "\u2699\ufe0f";
    private static final String NONE_ICON = "\u2205";
    private static final String PACKAGE_ICON = "\ud83d\udce6";
    private static final String SECTION_ICON = "\ud83d\udccd";
    private static final String TYPE_ICON = "\ud83d\udcc2";
    private static final String WARN_ICON = "\u26a0\ufe0f";
    private static final String CLDR_PKG_PREFIX = "cldr-";
    private static final String FULL_TIER_SUFFIX = "-full";
    private static final String MODERN_TIER_SUFFIX = "-modern";
    private static Logger logger = Logger.getLogger(Ldml2JsonConverter.class.getName());
    private static final StandardCodes sc = StandardCodes.make();
    private Set<String> defaultContentLocales = SupplementalDataInfo.getInstance().getDefaultContentLocales();
    private Set<String> skippedDefaultContentLocales = new TreeSet<String>();
    private AvailableLocales avl = new AvailableLocales();
    private Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Option.Options options = new Option.Options("Usage: LDML2JsonConverter [OPTIONS] [FILES]\nThis program converts CLDR data to the JSON format.\nPlease refer to the following options. \n\texample: org.unicode.cldr.json.Ldml2JsonConverter -c xxx -d yyy").add("bcp47", Character.valueOf('B'), "(true|false)", "true", "Whether to strictly use BCP47 tags in filenames and data. Defaults to true.").add("bcp47-no-subtags", Character.valueOf('T'), "(true|false)", "true", "In BCP47 mode, ignore locales with subtags such as en-US-u-va-posix. Defaults to true.").add("commondir", Character.valueOf('c'), ".*", CLDRPaths.COMMON_DIRECTORY, "Common directory for CLDR files, defaults to CldrUtility.COMMON_DIRECTORY").add("destdir", Character.valueOf('d'), ".*", CLDRPaths.GEN_DIRECTORY, "Destination directory for output files, defaults to CldrUtility.GEN_DIRECTORY").add("match", Character.valueOf('m'), ".*", ".*", "Regular expression to define only specific locales or files to be generated").add("type", Character.valueOf('t'), "(" + RunType.valueList() + ")", "all", "Type of CLDR data being generated, such as main, supplemental, or segments. All gets all.").add("resolved", Character.valueOf('r'), "(true|false)", "false", "Whether the output JSON for the main directory should be based on resolved or unresolved data").add("Redundant", Character.valueOf('R'), "(true|false)", "false", "Include redundant data from code-fallback and constructed").add("draftstatus", Character.valueOf('s'), "(approved|contributed|provisional|unconfirmed)", "unconfirmed", "The minimum draft status of the output data").add("coverage", Character.valueOf('l'), "(minimal|basic|moderate|modern|comprehensive|optional)", "optional", "The maximum coverage level of the output data").add("packagelist", Character.valueOf('P'), "(true|false)", "true", "Whether to output PACKAGES.md and cldr-core/cldr-packages.json (during supplemental/cldr-core)").add("fullnumbers", Character.valueOf('n'), "(true|false)", "false", "Whether the output JSON should output data for all numbering systems, even those not used in the locale").add("other", Character.valueOf('o'), "(true|false)", "false", "Whether to write out the 'other' section, which contains any unmatched paths").add("packages", Character.valueOf('p'), "(true|false)", "false", "Whether to group data files into installable packages").add("identity", Character.valueOf('i'), "(true|false)", "true", "Whether to copy the identity info into all sections containing data").add("konfig", Character.valueOf('k'), ".*", null, "LDML to JSON configuration file").add("pkgversion", Character.valueOf('V'), ".*", Ldml2JsonConverter.getDefaultVersion(), "Version to be used in writing package files").add("Modern", Character.valueOf('M'), "(true|false)", "true", "Whether to include the -modern tier").add("license-file", Character.valueOf('L'), ".*", "", "Override the license file included in the bundle");
    private String cldrCommonDir;
    private String outputDir;
    private boolean fullNumbers;
    private boolean resolve;
    private String match;
    private int coverageValue;
    private boolean writePackages;
    private final RunType type;
    private boolean includeRedundant;
    private Map<String, String> dependencies;
    private List<JSONSection> sections;
    private Set<String> packages;
    private final String pkgVersion;
    private final boolean strictBcp47;
    private final boolean writeModernPackage;
    private final Optional<String> licenseFile;
    private final boolean skipBcp47LocalesWithSubtags;
    private LdmlConfigFileReader configFileReader;
    static final Pattern ANNOTATION_CP_REMAP = PatternCache.get("^(.*)\\[@cp=\"(\\[|\\]|'|\"|@|/|=)\"\\](.*)$");
    static final Pattern VERSION_INFO_PATTERN = PatternCache.get(".*/(identity|version).*");
    static final Pattern HAS_SUBTAG = PatternCache.get(".*-[a-z]-.*");
    Pattern IS_REGION_CODE = PatternCache.get("([A-Z][A-Z])|([0-9][0-9][0-9])");
    final LocalizedNumberFormatter percentFormatter = (LocalizedNumberFormatter)((LocalizedNumberFormatter)((LocalizedNumberFormatter)NumberFormatter.withLocale(Locale.ENGLISH).unit(NoUnit.PERCENT)).integerWidth(IntegerWidth.zeroFillTo(3))).precision(Precision.integer());
    private static final Pattern escapePattern = PatternCache.get("\\\\(?!u)");

    public static void main(String[] args) throws Exception {
        System.out.println("\u2699\ufe0f " + Ldml2JsonConverter.class.getName() + " options:");
        options.parse(args, true);
        Timer overallTimer = new Timer();
        overallTimer.start();
        String rawType = options.get("type").getValue();
        if (RunType.all.name().equals(rawType)) {
            for (RunType t2 : RunType.values()) {
                if (t2 == RunType.all) continue;
                System.out.println();
                System.out.println("\ud83d\udcc2#######################  " + t2 + " #######################");
                Timer subTimer = new Timer();
                subTimer.start();
                Ldml2JsonConverter.processType(t2.name());
                System.out.println("\ud83d\udcc2 " + t2 + "\tFinished in " + subTimer.toMeasureString());
                System.out.println();
            }
        } else {
            Ldml2JsonConverter.processType(rawType);
        }
        System.out.println("\n\n###\n\n\u2705 Finished everything in " + overallTimer.toMeasureString());
    }

    static void processType(String runType) throws Exception {
        Ldml2JsonConverter l2jc = new Ldml2JsonConverter(options.get("commondir").getValue(), options.get("destdir").getValue(), runType, Boolean.parseBoolean(options.get("fullnumbers").getValue()), Boolean.parseBoolean(options.get("resolved").getValue()), options.get("coverage").getValue(), options.get("match").getValue(), Boolean.parseBoolean(options.get("packages").getValue()), options.get("konfig").getValue(), options.get("pkgversion").getValue(), Boolean.parseBoolean(options.get("bcp47").getValue()), Boolean.parseBoolean(options.get("bcp47-no-subtags").getValue()), Boolean.parseBoolean(options.get("Modern").getValue()), Boolean.parseBoolean(options.get("Redundant").getValue()), Optional.ofNullable(options.get("license-file").getValue()).filter(s2 -> !s2.isEmpty()));
        CLDRFile.DraftStatus status = CLDRFile.DraftStatus.valueOf(options.get("draftstatus").getValue());
        l2jc.processDirectory(runType, status);
    }

    public Ldml2JsonConverter(String cldrDir, String outputDir, String runType, boolean fullNumbers, boolean resolve, String coverage, String match, boolean writePackages, String configFile, String pkgVersion, boolean strictBcp47, boolean skipBcp47LocalesWithSubtags, boolean writeModernPackage, boolean includeRedundant, Optional<String> licenseFile) {
        this.writeModernPackage = writeModernPackage;
        this.strictBcp47 = strictBcp47;
        this.skipBcp47LocalesWithSubtags = strictBcp47 && skipBcp47LocalesWithSubtags;
        this.cldrCommonDir = cldrDir;
        this.outputDir = outputDir;
        try {
            this.type = RunType.valueOf(runType);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new RuntimeException("runType (-t) invalid: " + runType + " must be one of " + RunType.valueList(), e);
        }
        this.fullNumbers = fullNumbers;
        this.resolve = resolve;
        this.match = match;
        this.writePackages = writePackages;
        this.coverageValue = Level.get(coverage).getLevel();
        this.pkgVersion = pkgVersion;
        LdmlConvertRules.addVersionHandler(pkgVersion.split("\\.")[0]);
        this.configFileReader = new LdmlConfigFileReader();
        this.configFileReader.read(configFile, this.type);
        this.dependencies = this.configFileReader.getDependencies();
        this.sections = this.configFileReader.getSections();
        this.packages = new TreeSet<String>();
        this.includeRedundant = includeRedundant;
        this.licenseFile = licenseFile;
    }

    private String transformPath(String pathStr, String pathPrefix) {
        String result = pathStr;
        Matcher cpm = ANNOTATION_CP_REMAP.matcher(result);
        if (cpm.matches()) {
            String badCodepointRange = cpm.group(2);
            StringBuilder sb = new StringBuilder(cpm.group(1)).append("[@cp=\"");
            if (badCodepointRange.codePointCount(0, badCodepointRange.length()) != 1) {
                throw new IllegalArgumentException("Need exactly one codepoint in the @cp string, but got " + badCodepointRange + " in xpath " + pathStr);
            }
            badCodepointRange.codePoints().forEach(cp -> sb.append("U+").append(Integer.toHexString(cp).toUpperCase()));
            sb.append("\"]").append(cpm.group(3));
            result = sb.toString();
        }
        logger.finest(" IN pathStr : " + result);
        result = LdmlConvertRules.PathTransformSpec.applyAll(result);
        result = result.replaceFirst("/ldml/", pathPrefix);
        result = result.replaceFirst("/supplementalData/", pathPrefix);
        if (!result.startsWith("//cldr/supplemental/references/reference")) {
            if (this.strictBcp47) {
                String oldResult;
                if (result.contains("localeDisplayNames/languages/language")) {
                    if (result.contains("type=\"root\"")) {
                        return "";
                    }
                    result = this.fixXpathBcp47(result, "language", "type");
                } else if (result.contains("likelySubtags/likelySubtag")) {
                    if (!(result.contains("\"iw\"") || result.contains("\"in\"") || result.contains("\"ji\""))) {
                        result = this.fixXpathBcp47(result, "likelySubtag", "from", "to");
                    } else {
                        result = this.underscoreToHypen(result);
                        logger.warning("Including aliased likelySubtags: " + result);
                    }
                } else if (result.startsWith("//cldr/supplemental/weekData/weekOfPreference")) {
                    result = this.fixXpathBcp47(result, "weekOfPreference", "locales");
                } else if (result.startsWith("//cldr/supplemental/metadata/defaultContent")) {
                    result = this.fixXpathBcp47(result, "defaultContent", "locales");
                } else if (result.startsWith("//cldr/supplemental/grammatical") && result.contains("Data/grammaticalFeatures")) {
                    result = this.fixXpathBcp47(result, "grammaticalFeatures", "locales");
                } else if (result.startsWith("//cldr/supplemental/grammatical") && result.contains("Data/grammaticalDerivations")) {
                    result = this.fixXpathBcp47(result, "grammaticalDerivations", "locales");
                } else if (result.startsWith("//cldr/supplemental/dayPeriodRuleSet")) {
                    result = this.fixXpathBcp47(result, "dayPeriodRules", "locales");
                } else if (result.startsWith("//cldr/supplemental/plurals")) {
                    result = this.fixXpathBcp47(result, "pluralRules", "locales");
                } else if (result.startsWith("//cldr/supplemental/timeData/hours")) {
                    result = this.fixXpathBcp47MishMash(result, "hours", "regions");
                } else if (result.startsWith("//cldr/supplemental/parentLocales/parentLocale")) {
                    result = this.fixXpathBcp47(result, "parentLocale", "parent", "locales");
                } else if (result.startsWith("//cldr/supplemental/territoryInfo/territory/languagePopulation")) {
                    result = this.fixXpathBcp47(result, "languagePopulation", "type");
                } else if ((result.contains("languages") || result.contains("languageAlias") || result.contains("languageMatches") || result.contains("likelySubtags") || result.contains("parentLocale") || result.contains("locales=")) && !(oldResult = result).equals(result = this.underscoreToHypen(result))) {
                    logger.fine(oldResult + " => " + result);
                }
            } else if (result.contains("languages") || result.contains("languageAlias") || result.contains("languageMatches") || result.contains("likelySubtags") || result.contains("parentLocale") || result.contains("locales=")) {
                result = this.underscoreToHypen(result);
            }
        }
        logger.finest("OUT pathStr : " + result);
        logger.finest("result: " + result);
        return result;
    }

    private Map<JSONSection, List<CldrItem>> mapPathsToSections(AtomicInteger readCount, int totalCount, CLDRFile file, String pathPrefix, SupplementalDataInfo sdi) throws IOException, ParseException {
        TreeMap<JSONSection, List<CldrItem>> sectionItems = new TreeMap<JSONSection, List<CldrItem>>();
        String locID = file.getLocaleID();
        Matcher noNumberingSystemMatcher = LdmlConvertRules.NO_NUMBERING_SYSTEM_PATTERN.matcher("");
        Matcher numberingSystemMatcher = LdmlConvertRules.NUMBERING_SYSTEM_PATTERN.matcher("");
        Matcher rootIdentityMatcher = LdmlConvertRules.ROOT_IDENTITY_PATTERN.matcher("");
        TreeSet<String> activeNumberingSystems = new TreeSet<String>();
        activeNumberingSystems.add("latn");
        for (String np : LdmlConvertRules.ACTIVE_NUMBERING_SYSTEM_XPATHS) {
            String ns = file.getWinningValue(np);
            if (ns == null || ns.length() <= 0) continue;
            activeNumberingSystems.add(ns);
        }
        DtdType fileDtdType = file.getDtdType();
        CoverageInfo covInfo = CLDRConfig.getInstance().getCoverageInfo();
        CLDRFile.Status status = new CLDRFile.Status();
        Iterator<String> it = file.iterator("", DtdData.getInstance(fileDtdType).getDtdComparator(null));
        block1: while (it.hasNext()) {
            XPathParts xpp;
            String currentNS;
            int cv = Level.UNDETERMINED.getLevel();
            String path = it.next();
            String localeWhereFound = file.getSourceLocaleID(path, status);
            if (!this.includeRedundant && (localeWhereFound.equals("code-fallback") || status.pathWhereFound.equals("constructed"))) continue;
            String fullPath = file.getFullXPath(path);
            String value = file.getWinningValue(path);
            if (fullPath == null) {
                fullPath = path;
            }
            if (!CLDRFile.isSupplementalName(locID) && path.startsWith("//ldml/") && !path.contains("/identity")) {
                cv = covInfo.getCoverageValue(path, locID);
            }
            if (cv > this.coverageValue) continue;
            rootIdentityMatcher.reset(fullPath);
            if (rootIdentityMatcher.matches() && !"root".equals(locID)) continue;
            noNumberingSystemMatcher.reset(fullPath);
            if (noNumberingSystemMatcher.matches()) continue;
            numberingSystemMatcher.reset(fullPath);
            if (numberingSystemMatcher.matches() && !this.fullNumbers && (currentNS = (xpp = XPathParts.getFrozenInstance(fullPath)).getAttributeValue(2, "numberSystem")) != null && !activeNumberingSystems.contains(currentNS) || this.resolve && CldrUtility.NO_INHERITANCE_MARKER.equals(value)) continue;
            String pathNoDraft = CLDRFile.DRAFT_PATTERN.matcher(path).replaceAll("");
            String fullPathNoDraft = CLDRFile.DRAFT_PATTERN.matcher(fullPath).replaceAll("");
            String pathNoXmlSpace = CLDRFile.XML_SPACE_PATTERN.matcher(pathNoDraft).replaceAll("");
            String fullPathNoXmlSpace = CLDRFile.XML_SPACE_PATTERN.matcher(fullPathNoDraft).replaceAll("");
            String transformedPath = this.transformPath(pathNoXmlSpace, pathPrefix);
            String transformedFullPath = this.transformPath(fullPathNoXmlSpace, pathPrefix);
            if (transformedPath.isEmpty()) continue;
            for (JSONSection js : this.sections) {
                if (!js.pattern.matcher(transformedPath).matches()) continue;
                CldrItem item = new CldrItem(transformedPath, transformedFullPath, path, fullPath, value);
                ArrayList<CldrItem> cldrItems = (ArrayList<CldrItem>)sectionItems.get(js);
                if (cldrItems == null) {
                    cldrItems = new ArrayList<CldrItem>();
                }
                cldrItems.add(item);
                sectionItems.put(js, cldrItems);
                continue block1;
            }
        }
        Matcher versionInfoMatcher = VERSION_INFO_PATTERN.matcher("");
        JSONSection otherSection = this.sections.get(this.sections.size() - 1);
        List others = (List)sectionItems.get(otherSection);
        if (others == null) {
            return sectionItems;
        }
        ArrayList otherSectionItems = new ArrayList(others);
        int addedItemCount = 0;
        boolean copyIdentityInfo = Boolean.parseBoolean(options.get("identity").getValue());
        for (CldrItem item : otherSectionItems) {
            String thisPath = item.getPath();
            versionInfoMatcher.reset(thisPath);
            if (!versionInfoMatcher.matches()) continue;
            for (JSONSection js : this.sections) {
                List hit;
                if (sectionItems.get(js) != null && !js.section.equals("other") && copyIdentityInfo) {
                    hit = (List)sectionItems.get(js);
                    hit.add(addedItemCount, item);
                    sectionItems.put(js, hit);
                }
                if (!js.section.equals("other")) continue;
                hit = (List)sectionItems.get(js);
                hit.remove(item);
                sectionItems.put(js, hit);
            }
            ++addedItemCount;
        }
        return sectionItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private int convertCldrItems(AtomicInteger readCount, int totalCount, String dirName, String filename, String pathPrefix, Map<JSONSection, List<CldrItem>> sectionItems) throws IOException, ParseException {
        String filenameAsLangTag = this.unicodeLocaleToString(filename);
        if (this.skipBcp47LocalesWithSubtags && this.type.locales() && HAS_SUBTAG.matcher(filenameAsLangTag).matches()) {
            return 0;
        }
        int totalItemsInFile = 0;
        LinkedList<Pair<String, Integer>> outputProgress = new LinkedList<Pair<String, Integer>>();
        for (JSONSection js : this.sections) {
            if (js.section.equals("IGNORE")) continue;
            if (this.type == RunType.rbnf) {
                String string = filenameAsLangTag + ".json";
            } else if (this.type == RunType.bcp47) {
                String string = filename + ".json";
            } else if (js.section.equals("other")) {
                String string = js.section + "-" + filename + ".json";
            } else {
                String string = js.section + ".json";
            }
            String tier = "";
            boolean writeOther = Boolean.parseBoolean(options.get("other").getValue());
            if (js.section.equals("other") && !writeOther) continue;
            StringBuilder outputDirname = new StringBuilder(this.outputDir);
            if (this.writePackages) {
                if (this.type.tiered()) {
                    LocaleIDParser lp = new LocaleIDParser();
                    lp.set(filename);
                    if (this.defaultContentLocales.contains(filename) && lp.getRegion().length() > 0) {
                        if (this.type != RunType.main) continue;
                        this.skippedDefaultContentLocales.add(filenameAsLangTag);
                        continue;
                    }
                    boolean isModernTier = this.localeIsModernTier(filename);
                    if (isModernTier && this.writeModernPackage) {
                        tier = MODERN_TIER_SUFFIX;
                        if (this.type == RunType.main) {
                            this.avl.modern.add(filenameAsLangTag);
                        }
                    } else {
                        tier = FULL_TIER_SUFFIX;
                    }
                    if (this.type == RunType.main) {
                        this.avl.full.add(filenameAsLangTag);
                    }
                } else if (this.type == RunType.rbnf) {
                    js.packageName = "rbnf";
                    tier = "";
                } else if (this.type == RunType.bcp47) {
                    js.packageName = "bcp47";
                    tier = "";
                }
                if (js.packageName != null) {
                    String packageName = CLDR_PKG_PREFIX + js.packageName + tier;
                    outputDirname.append("/" + packageName);
                    this.packages.add(packageName);
                }
                outputDirname.append("/" + dirName + "/");
                if (this.type.tiered()) {
                    outputDirname.append(filenameAsLangTag);
                }
                logger.fine("outDir: " + outputDirname);
                logger.fine("pack: " + js.packageName);
                logger.fine("dir: " + dirName);
            } else {
                outputDirname.append("/" + filename);
            }
            assert (tier.isEmpty() == !this.type.tiered());
            ArrayList<String> outputDirs = new ArrayList<String>();
            outputDirs.add(outputDirname.toString());
            if (this.writePackages && tier.equals(MODERN_TIER_SUFFIX) && js.packageName != null) {
                outputDirs.add(outputDirname.toString().replaceFirst(MODERN_TIER_SUFFIX, FULL_TIER_SUFFIX));
                this.packages.add(CLDR_PKG_PREFIX + js.packageName + FULL_TIER_SUFFIX);
            }
            for (String outputDir : outputDirs) {
                void var12_12;
                List<CldrItem> theItems = sectionItems.get(js);
                if (theItems == null || theItems.size() == 0) {
                    logger.fine(() -> ">" + this.progressPrefix(readCount, totalCount) + outputDir + " - no items to write in " + js.section);
                    continue;
                }
                logger.fine(() -> "?" + this.progressPrefix(readCount, totalCount, filename, js.section) + " - " + theItems.size() + " item(s)\r");
                File dir = new File(outputDir.toString());
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                JsonObject out = new JsonObject();
                ArrayList<CldrItem> sortingItems = new ArrayList<CldrItem>();
                ArrayList<CldrItem> arrayItems = new ArrayList<CldrItem>();
                ArrayList<CldrNode> nodesForLastItem = new ArrayList<CldrNode>();
                String lastLeadingArrayItemPath = null;
                String leadingArrayItemPath = "";
                int valueCount = 0;
                String previousIdentityPath = null;
                for (CldrItem item : theItems) {
                    CldrItem[] items;
                    if (item.getPath().isEmpty()) {
                        throw new IllegalArgumentException("empty xpath in " + filename + " section " + js.packageName + "/" + js.section);
                    }
                    if (this.type == RunType.rbnf) {
                        item.adjustRbnfPath();
                    }
                    if (item.getPath().contains("/identity/")) {
                        String[] parts = item.getPath().split("\\[");
                        if (parts[0].equals(previousIdentityPath)) continue;
                        XPathParts xpp = XPathParts.getFrozenInstance(item.getPath());
                        String territory = xpp.findAttributeValue("territory", "type");
                        LocaleIDParser lp = new LocaleIDParser().set(filename);
                        if (territory != null && territory.length() > 0 && !territory.equals(lp.getRegion())) continue;
                        previousIdentityPath = parts[0];
                    }
                    if ((items = item.split()) == null) {
                        items = new CldrItem[]{item};
                    }
                    valueCount += items.length;
                    if (item.getUntransformedPath().contains("unitPreference")) continue;
                    for (CldrItem newItem : items) {
                        if (newItem.isAliasItem()) {
                            --valueCount;
                        }
                        if (newItem.needsSort()) {
                            this.resolveArrayItems(out, nodesForLastItem, arrayItems);
                            sortingItems.add(newItem);
                            continue;
                        }
                        Matcher matcher = LdmlConvertRules.ARRAY_ITEM_PATTERN.matcher(newItem.getPath());
                        if (matcher.matches()) {
                            this.resolveSortingItems(out, nodesForLastItem, sortingItems);
                            leadingArrayItemPath = matcher.group(1);
                            if (lastLeadingArrayItemPath != null && !lastLeadingArrayItemPath.equals(leadingArrayItemPath)) {
                                this.resolveArrayItems(out, nodesForLastItem, arrayItems);
                            }
                            lastLeadingArrayItemPath = leadingArrayItemPath;
                            arrayItems.add(newItem);
                            continue;
                        }
                        this.resolveSortingItems(out, nodesForLastItem, sortingItems);
                        this.resolveArrayItems(out, nodesForLastItem, arrayItems);
                        this.outputCldrItem(out, nodesForLastItem, newItem);
                        lastLeadingArrayItemPath = "";
                    }
                }
                this.resolveSortingItems(out, nodesForLastItem, sortingItems);
                this.resolveArrayItems(out, nodesForLastItem, arrayItems);
                if (js.section.contains("unitPreferenceData")) {
                    this.outputUnitPreferenceData(js, theItems, out, nodesForLastItem);
                }
                try (PrintWriter outf = FileUtilities.openUTF8Writer(outputDir, (String)var12_12);){
                    outf.println(this.gson.toJson(out));
                }
                String outPath = new File(outputDir.substring(this.outputDir.length()), (String)var12_12).getPath();
                outputProgress.add(Pair.of(String.format("%20s %s", js.section, outPath), valueCount));
                logger.fine(">" + this.progressPrefix(readCount, totalCount, filename, js.section) + String.format("\u2026%s (%d values)", outPath, valueCount));
                totalItemsInFile += valueCount;
            }
        }
        StringBuilder outStr = new StringBuilder();
        if (!outputProgress.isEmpty()) {
            for (Pair pair : outputProgress) {
                outStr.append(String.format("\t%6d %s\n", pair.getSecond(), pair.getFirst()));
            }
            outStr.append(String.format("%s%-12s\t  %s\n", this.progressPrefix(readCount, totalCount), filename, Ldml2JsonConverter.valueSectionsFormat(totalItemsInFile, outputProgress.size())));
        } else {
            outStr.append(String.format("%s%-12s\t\u2205 (no output)\n", this.progressPrefix(readCount, totalCount), filename));
        }
        AtomicInteger atomicInteger = readCount;
        synchronized (atomicInteger) {
            System.out.print(outStr);
        }
        return totalItemsInFile;
    }

    private static String valueSectionsFormat(int values, int sections) {
        return MessageFormat.format("({0, plural,  one {# value} other {# values}} in {1, plural, one {# section} other {# sections}})", values, sections);
    }

    private boolean localeIsModernTier(String filename) {
        Level lev = CalculatedCoverageLevels.getInstance().getEffectiveCoverageLevel(filename);
        if (lev == null) {
            return false;
        }
        return lev.isAtLeast(Level.MODERN);
    }

    private boolean localeIsBasicTier(String filename) {
        Level lev = CalculatedCoverageLevels.getInstance().getEffectiveCoverageLevel(filename);
        if (lev == null) {
            return false;
        }
        return lev.isAtLeast(Level.BASIC);
    }

    private String underscoreToHypen(String filename) {
        return filename.replaceAll("_", "-");
    }

    private final String unicodeLocaleToString(String locale) {
        if (this.strictBcp47) {
            return CLDRLocale.toLanguageTag(locale);
        }
        return this.underscoreToHypen(locale);
    }

    private final String unicodeLocaleMishMashToString(String locale) {
        if (this.strictBcp47) {
            if (this.IS_REGION_CODE.matcher(locale).matches()) {
                return locale;
            }
            return CLDRLocale.toLanguageTag(locale);
        }
        return this.underscoreToHypen(locale);
    }

    final String fixXpathBcp47(String path, String elementName, String ... attributeNames) {
        XPathParts xpp = XPathParts.getFrozenInstance(path).cloneAsThawed();
        for (String attributeName : attributeNames) {
            String[] oldValues;
            String newValue;
            String oldValue = xpp.findAttributeValue(elementName, attributeName);
            if (oldValue == null || oldValue.equals(newValue = Arrays.stream(oldValues = oldValue.split(" ")).map(s2 -> this.unicodeLocaleToString((String)s2)).collect(Collectors.joining(" ")))) continue;
            xpp.setAttribute(elementName, attributeName, newValue);
            logger.finest(attributeName + " = " + oldValue + " -> " + newValue);
        }
        return xpp.toString();
    }

    final String fixXpathBcp47MishMash(String path, String elementName, String ... attributeNames) {
        XPathParts xpp = XPathParts.getFrozenInstance(path).cloneAsThawed();
        for (String attributeName : attributeNames) {
            String[] oldValues;
            String newValue;
            String oldValue = xpp.findAttributeValue(elementName, attributeName);
            if (oldValue == null || oldValue.equals(newValue = Arrays.stream(oldValues = oldValue.split(" ")).map(s2 -> this.unicodeLocaleMishMashToString((String)s2)).collect(Collectors.joining(" ")))) continue;
            xpp.setAttribute(elementName, attributeName, newValue);
            logger.finest(attributeName + " = " + oldValue + " -> " + newValue);
        }
        return xpp.toString();
    }

    private void outputUnitPreferenceData(JSONSection js, List<CldrItem> theItems, JsonObject out, ArrayList<CldrNode> nodesForLastItem) throws ParseException, IOException {
        CldrNode supplementalNode = CldrNode.createNode("cldr", "supplemental", "supplemental");
        JsonElement supplementalObject = this.startNonleafNode(out, supplementalNode);
        CldrNode unitPrefNode = CldrNode.createNode("supplemental", js.section, js.section);
        JsonElement o = this.startNonleafNode(supplementalObject, unitPrefNode);
        TreeMap<Pair, Map> catUsagetoRegionItems = new TreeMap<Pair, Map>();
        for (CldrItem item : theItems) {
            if (!item.getUntransformedPath().contains("unitPref")) continue;
            CldrItem[] items = item.split();
            if (items == null) {
                throw new IllegalArgumentException("expected unit pref to split: " + item);
            }
            for (CldrItem subItem : items) {
                XPathParts xpp = XPathParts.getFrozenInstance(subItem.getPath());
                String category2 = xpp.findFirstAttributeValue("category");
                String usage = xpp.findFirstAttributeValue("usage");
                String region = xpp.findFirstAttributeValue("regions");
                Pair<String, String> key = Pair.of(category2, usage);
                Map regionMap = catUsagetoRegionItems.computeIfAbsent(key, ignored -> new TreeMap());
                List perRegion = regionMap.computeIfAbsent(region, ignored -> new ArrayList());
                perRegion.add(subItem);
            }
        }
        catUsagetoRegionItems.keySet().stream().map(p -> (String)p.getFirst()).distinct().forEach(category -> {
            JsonObject oo = new JsonObject();
            o.getAsJsonObject().add((String)category, oo);
            catUsagetoRegionItems.entrySet().stream().filter(p -> ((String)((Pair)p.getKey()).getFirst()).equals(category)).forEach(ent -> {
                String usage = (String)((Pair)ent.getKey()).getSecond();
                JsonObject ooo = new JsonObject();
                oo.getAsJsonObject().add(usage, ooo);
                ((Map)ent.getValue()).forEach((region, list) -> {
                    JsonArray array = new JsonArray();
                    ooo.getAsJsonObject().add((String)region, array);
                    list.forEach(item -> {
                        XPathParts xpp = XPathParts.getFrozenInstance(item.getPath());
                        JsonObject u = new JsonObject();
                        array.add(u);
                        u.addProperty("unit", item.getValue());
                        if (xpp.containsAttribute("geq")) {
                            u.addProperty("geq", Double.parseDouble(xpp.findFirstAttributeValue("geq")));
                        }
                    });
                });
            });
        });
        nodesForLastItem.add(unitPrefNode);
    }

    public void writePackagingFiles(String outputDir, String packageName) throws IOException {
        File dir = new File(outputDir.toString());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.writePackageJson(outputDir, packageName);
        this.writeBowerJson(outputDir, packageName);
        this.writeReadme(outputDir, packageName);
    }

    public void writeCopyrightSection(PrintWriter out) {
        out.println(CldrUtility.getCopyrightMarkdown() + "\nA copy of the license is included as [LICENSE](./LICENSE).");
    }

    private void writeReadmeSection(PrintWriter outf) throws IOException {
        FileCopier.copy(CldrUtility.getUTF8Data("cldr-json-readme.md"), outf);
        outf.println();
        this.writeCopyrightSection(outf);
    }

    public void writeReadme(String outputDir, String packageName) throws IOException {
        block23: {
            String basePackageName = this.getBasePackageName(packageName);
            try (PrintWriter outf = FileUtilities.openUTF8Writer(outputDir + "/" + packageName, "README.md");){
                outf.println("# " + packageName);
                outf.println();
                outf.println(this.configFileReader.getPackageDescriptions().get(basePackageName));
                outf.println();
                if (packageName.endsWith(FULL_TIER_SUFFIX)) {
                    outf.println("This package contains all locales.");
                    outf.println();
                } else if (packageName.endsWith(MODERN_TIER_SUFFIX)) {
                    outf.println("**Deprecated** This package contains only the set of locales listed as modern coverage. Use `cldr-" + basePackageName + "-full` and locale coverage data instead. The -modern packages are scheduled to be removed in v46, see [CLDR-16465](https://unicode-org.atlassian.net/browse/CLDR-16465).");
                    outf.println();
                }
                outf.println();
                outf.println(this.getNpmBadge(packageName));
                outf.println();
                this.writeReadmeSection(outf);
            }
            outf = FileUtilities.openUTF8Writer(outputDir + "/" + packageName, "LICENSE");
            try {
                if (this.licenseFile.isPresent()) {
                    try (BufferedReader br = FileUtilities.openUTF8Reader("", this.licenseFile.get());){
                        FileCopier.copy(br, outf);
                        break block23;
                    }
                }
                FileCopier.copy(CldrUtility.getUTF8Data("LICENSE"), outf);
            }
            finally {
                if (outf != null) {
                    outf.close();
                }
            }
        }
    }

    String getBasePackageName(String packageName) {
        String basePackageName = packageName;
        if (basePackageName.startsWith(CLDR_PKG_PREFIX)) {
            basePackageName = basePackageName.substring(CLDR_PKG_PREFIX.length());
        }
        if (basePackageName.endsWith(FULL_TIER_SUFFIX)) {
            basePackageName = basePackageName.substring(0, basePackageName.length() - FULL_TIER_SUFFIX.length());
        } else if (basePackageName.endsWith(MODERN_TIER_SUFFIX)) {
            basePackageName = basePackageName.substring(0, basePackageName.length() - MODERN_TIER_SUFFIX.length());
        }
        return basePackageName;
    }

    public void writeBasicInfo(JsonObject obj, String packageName, boolean isNPM) {
        obj.addProperty("name", packageName);
        obj.addProperty("version", this.pkgVersion);
        String[] packageNameParts = packageName.split("-");
        String dependency = this.dependencies.get(packageNameParts[1]);
        if (dependency != null) {
            String[] dependentPackageNames = new String[1];
            String tier = packageNameParts[packageNameParts.length - 1];
            dependentPackageNames[0] = dependency.equals("core") || dependency.equals("bcp47") ? CLDR_PKG_PREFIX + dependency : CLDR_PKG_PREFIX + dependency + "-" + tier;
            JsonObject dependencies = new JsonObject();
            for (String dependentPackageName : dependentPackageNames) {
                if (dependentPackageName == null) continue;
                dependencies.addProperty(dependentPackageName, this.pkgVersion);
            }
            obj.add(isNPM ? "peerDependencies" : "dependencies", dependencies);
        }
    }

    private static String getDefaultVersion() {
        Object versionString = "45";
        while (((String)versionString).split("\\.").length < 3) {
            versionString = (String)versionString + ".0";
        }
        return versionString;
    }

    public void writePackageJson(String outputDir, String packageName) throws IOException {
        PrintWriter outf = FileUtilities.openUTF8Writer(outputDir + "/" + packageName, "package.json");
        logger.fine("\ud83d\udce6 Creating packaging file => " + outputDir + File.separator + packageName + File.separator + "package.json");
        JsonObject obj = new JsonObject();
        this.writeBasicInfo(obj, packageName, true);
        JsonArray maintainers = new JsonArray();
        JsonObject primaryMaintainer = new JsonObject();
        JsonObject secondaryMaintainer = new JsonObject();
        String basePackageName = this.getBasePackageName(packageName);
        Object description = this.configFileReader.getPackageDescriptions().get(basePackageName);
        if (packageName.endsWith(MODERN_TIER_SUFFIX)) {
            description = (String)description + " (modern only: deprecated)";
        }
        obj.addProperty("description", (String)description);
        obj.addProperty("homepage", "https://cldr.unicode.org");
        obj.addProperty("author", "The Unicode Consortium");
        primaryMaintainer.addProperty("name", "Steven R. Loomis");
        primaryMaintainer.addProperty("email", "srloomis@unicode.org");
        maintainers.add(primaryMaintainer);
        secondaryMaintainer.addProperty("name", "John Emmons");
        secondaryMaintainer.addProperty("email", "emmo@us.ibm.com");
        secondaryMaintainer.addProperty("url", "https://github.com/JCEmmons");
        maintainers.add(secondaryMaintainer);
        obj.add("maintainers", maintainers);
        JsonObject repository = new JsonObject();
        repository.addProperty("type", "git");
        repository.addProperty("url", "git://github.com/unicode-cldr/cldr-json.git");
        obj.add("repository", repository);
        obj.addProperty("license", "Unicode-3.0");
        obj.addProperty("bugs", "https://cldr.unicode.org/index/bug-reports#TOC-Filing-a-Ticket");
        SupplementalDataInfo sdi = CLDRConfig.getInstance().getSupplementalDataInfo();
        obj.addProperty("cldrVersion", sdi.getCldrVersionString());
        obj.addProperty("unicodeVersion", sdi.getUnicodeVersionString());
        outf.println(this.gson.toJson(obj));
        outf.close();
    }

    public void writeBowerJson(String outputDir, String packageName) throws IOException {
        PrintWriter outf = FileUtilities.openUTF8Writer(outputDir + "/" + packageName, "bower.json");
        logger.fine("\ud83d\udce6 Creating packaging file => " + outputDir + File.separator + packageName + File.separator + "bower.json");
        JsonObject obj = new JsonObject();
        this.writeBasicInfo(obj, packageName, false);
        if (this.type == RunType.supplemental) {
            JsonArray mainPaths = new JsonArray();
            mainPaths.add(new JsonPrimitive("availableLocales.json"));
            mainPaths.add(new JsonPrimitive("defaultContent.json"));
            mainPaths.add(new JsonPrimitive("scriptMetadata.json"));
            mainPaths.add(new JsonPrimitive(this.type.toString() + "/*.json"));
            obj.add("main", mainPaths);
        } else if (this.type == RunType.rbnf) {
            obj.addProperty("main", this.type.toString() + "/*.json");
        } else {
            obj.addProperty("main", this.type.toString() + "/**/*.json");
        }
        JsonArray ignorePaths = new JsonArray();
        ignorePaths.add(new JsonPrimitive(".gitattributes"));
        ignorePaths.add(new JsonPrimitive("README.md"));
        obj.add("ignore", ignorePaths);
        obj.addProperty("license", "Unicode-3.0");
        outf.println(this.gson.toJson(obj));
        outf.close();
    }

    public void writeDefaultContent(String outputDir) throws IOException {
        PrintWriter outf = FileUtilities.openUTF8Writer(outputDir + "/cldr-core", "defaultContent.json");
        System.out.println("\ud83d\udce6 Creating packaging file => " + outputDir + "/cldr-core" + File.separator + "defaultContent.json");
        JsonObject obj = new JsonObject();
        obj.add("defaultContent", this.gson.toJsonTree(this.skippedDefaultContentLocales));
        outf.println(this.gson.toJson(obj));
        outf.close();
    }

    public void writeCoverageLevels(String outputDir) throws IOException {
        try (PrintWriter outf = FileUtilities.openUTF8Writer(outputDir + "/cldr-core", "coverageLevels.json");){
            TreeMap<String, String> covlocs = new TreeMap<String, String>();
            System.out.println("\ud83d\udce6 Creating packaging file => " + outputDir + "/cldr-core" + File.separator + "coverageLevels.json from coverageLevels.txt");
            CalculatedCoverageLevels ccl = CalculatedCoverageLevels.getInstance();
            for (Map.Entry<String, Level> e : ccl.getLevels().entrySet()) {
                String uloc = e.getKey();
                String level = e.getValue().name().toLowerCase();
                String bcp47loc = this.unicodeLocaleToString(uloc);
                if (covlocs.put(bcp47loc, level) == null) continue;
                throw new IllegalArgumentException("coverageLevels.txt: duplicate locale " + bcp47loc);
            }
            TreeMap effectiveCovlocs = new TreeMap();
            this.avl.full.forEach(loc -> {
                String uloc = ULocale.forLanguageTag(loc).toString();
                Level lev = ccl.getEffectiveCoverageLevel(uloc);
                if (lev != null) {
                    effectiveCovlocs.put(loc, lev.name().toLowerCase());
                }
            });
            JsonObject obj = new JsonObject();
            obj.add("coverageLevels", this.gson.toJsonTree(covlocs));
            obj.add("effectiveCoverageLevels", this.gson.toJsonTree(effectiveCovlocs));
            outf.println(this.gson.toJson(obj));
        }
    }

    public void writeAvailableLocales(String outputDir) throws IOException {
        PrintWriter outf = FileUtilities.openUTF8Writer(outputDir + "/cldr-core", "availableLocales.json");
        System.out.println("\ud83d\udce6 Creating packaging file => " + outputDir + "/cldr-core" + File.separator + "availableLocales.json");
        JsonObject obj = new JsonObject();
        obj.add("availableLocales", this.gson.toJsonTree(this.avl));
        outf.println(this.gson.toJson(obj));
        outf.close();
    }

    public void writeScriptMetadata(String outputDir) throws IOException {
        PrintWriter outf = FileUtilities.openUTF8Writer(outputDir + "/cldr-core", "scriptMetadata.json");
        System.out.println("Creating script metadata file => " + outputDir + File.separator + "cldr-core" + File.separator + "scriptMetadata.json");
        TreeMap<String, ScriptMetadata.Info> scriptInfo = new TreeMap<String, ScriptMetadata.Info>();
        for (String script : ScriptMetadata.getScripts()) {
            ScriptMetadata.Info i = ScriptMetadata.getInfo(script);
            scriptInfo.put(script, i);
        }
        if (ScriptMetadata.errors.size() > 0) {
            System.err.println(Joiner.on("\n\t").join(ScriptMetadata.errors));
        }
        JsonObject obj = new JsonObject();
        obj.add("scriptMetadata", this.gson.toJsonTree(scriptInfo));
        outf.println(this.gson.toJson(obj));
        outf.close();
    }

    public void writePackageList(String outputDir) throws IOException {
        PrintWriter outf = FileUtilities.openUTF8Writer(outputDir + "/cldr-core", "cldr-packages.json");
        System.out.println("\ud83d\udce6 Creating packaging metadata file => " + outputDir + File.separator + "cldr-core" + File.separator + "cldr-packages.json and PACKAGES.md");
        PrintWriter pkgs = FileUtilities.openUTF8Writer(outputDir + "/..", "PACKAGES.md");
        pkgs.println("# CLDR JSON Packages");
        pkgs.println();
        LdmlConfigFileReader uberReader = new LdmlConfigFileReader();
        for (RunType r : RunType.values()) {
            if (r == RunType.all) continue;
            uberReader.read(null, r);
        }
        TreeMap<String, String> pkgsToDesc = new TreeMap<String, String>();
        JsonObject obj = new JsonObject();
        obj.addProperty("license", "Unicode-3.0");
        obj.addProperty("bugs", "https://cldr.unicode.org/index/bug-reports#TOC-Filing-a-Ticket");
        obj.addProperty("homepage", "https://cldr.unicode.org");
        obj.addProperty("version", this.pkgVersion);
        JsonArray packages = new JsonArray();
        for (Map.Entry<String, String> entry : uberReader.getPackageDescriptions().entrySet()) {
            JsonObject packageEntry;
            String baseName = entry.getKey();
            if (baseName.equals("IGNORE") || baseName.equals("cal")) continue;
            if (baseName.equals("core") || baseName.equals("rbnf") || baseName.equals("bcp47")) {
                packageEntry = new JsonObject();
                packageEntry.addProperty("description", entry.getValue());
                packageEntry.addProperty("name", CLDR_PKG_PREFIX + baseName);
                packages.add(packageEntry);
                pkgsToDesc.put(packageEntry.get("name").getAsString(), packageEntry.get("description").getAsString());
                continue;
            }
            packageEntry = new JsonObject();
            packageEntry.addProperty("description", entry.getValue());
            packageEntry.addProperty("tier", "full");
            packageEntry.addProperty("name", CLDR_PKG_PREFIX + baseName + FULL_TIER_SUFFIX);
            packages.add(packageEntry);
            pkgsToDesc.put(packageEntry.get("name").getAsString(), packageEntry.get("description").getAsString());
            packageEntry = new JsonObject();
            packageEntry.addProperty("description", entry.getValue() + " modern (deprecated)");
            packageEntry.addProperty("tier", "modern");
            packageEntry.addProperty("name", CLDR_PKG_PREFIX + baseName + MODERN_TIER_SUFFIX);
            packages.add(packageEntry);
            pkgsToDesc.put(packageEntry.get("name").getAsString(), packageEntry.get("description").getAsString());
        }
        pkgs.println();
        for (Map.Entry<String, String> entry : pkgsToDesc.entrySet()) {
            pkgs.println("### [" + entry.getKey() + "](./cldr-json/" + entry.getKey() + "/)");
            pkgs.println();
            if (entry.getKey().contains(MODERN_TIER_SUFFIX)) {
                pkgs.println(" - **Note: Deprecated** see [CLDR-16465](https://unicode-org.atlassian.net/browse/CLDR-16465).");
            }
            pkgs.println(" - " + entry.getValue());
            pkgs.println(" - " + this.getNpmBadge(entry.getKey()));
            pkgs.println();
        }
        obj.add("packages", packages);
        outf.println(this.gson.toJson(obj));
        outf.close();
        pkgs.println("## JSON Metadata");
        pkgs.println();
        pkgs.println("Package metadata is available at [`cldr-core`/cldr-packages.json](./cldr-json/cldr-core/cldr-packages.json)");
        pkgs.println();
        this.writeReadmeSection(pkgs);
        pkgs.close();
    }

    private String getNpmBadge(String packageName) {
        return String.format("[![NPM version](https://img.shields.io/npm/v/%s.svg?style=flat)](https://www.npmjs.org/package/%s)", packageName, packageName);
    }

    private void resolveSortingItems(JsonObject out, ArrayList<CldrNode> nodesForLastItem, ArrayList<CldrItem> sortingItems) throws IOException, ParseException {
        ArrayList<CldrItem> arrayItems = new ArrayList<CldrItem>();
        String lastLeadingArrayItemPath = null;
        if (!sortingItems.isEmpty()) {
            Collections.sort(sortingItems);
            for (CldrItem item : sortingItems) {
                Matcher matcher = LdmlConvertRules.ARRAY_ITEM_PATTERN.matcher(item.getPath());
                if (matcher.matches()) {
                    String leadingArrayItemPath = matcher.group(1);
                    if (lastLeadingArrayItemPath != null && !lastLeadingArrayItemPath.equals(leadingArrayItemPath)) {
                        this.resolveArrayItems(out, nodesForLastItem, arrayItems);
                    }
                    lastLeadingArrayItemPath = leadingArrayItemPath;
                    arrayItems.add(item);
                    continue;
                }
                this.outputCldrItem(out, nodesForLastItem, item);
            }
            sortingItems.clear();
            this.resolveArrayItems(out, nodesForLastItem, arrayItems);
        }
    }

    private void resolveArrayItems(JsonObject out, ArrayList<CldrNode> nodesForLastItem, ArrayList<CldrItem> arrayItems) throws IOException, ParseException {
        if (!arrayItems.isEmpty()) {
            CldrItem firstItem = arrayItems.get(0);
            if (firstItem.needsSort()) {
                Collections.sort(arrayItems);
                firstItem = arrayItems.get(0);
            }
            int arrayLevel = this.getArrayIndentLevel(firstItem);
            JsonArray array = this.outputStartArray(out, nodesForLastItem, firstItem, arrayLevel);
            for (int len = nodesForLastItem.size(); len > arrayLevel; --len) {
                nodesForLastItem.remove(len - 1);
            }
            for (CldrItem insideItem : arrayItems) {
                this.outputArrayItem(array, insideItem, nodesForLastItem, arrayLevel);
            }
            arrayItems.clear();
            int lastLevel = nodesForLastItem.size() - 1;
            for (int i = arrayLevel - 1; i < lastLevel; ++i) {
                nodesForLastItem.remove(i);
            }
        }
    }

    private int getArrayIndentLevel(CldrItem item) throws ParseException {
        Matcher matcher = LdmlConvertRules.ARRAY_ITEM_PATTERN.matcher(item.getPath());
        if (!matcher.matches()) {
            System.out.println("No match found for " + item.getPath() + ", this shouldn't happen.");
            return 0;
        }
        String leadingPath = matcher.group(1);
        CldrItem fakeItem = new CldrItem(leadingPath, leadingPath, leadingPath, leadingPath, "");
        return fakeItem.getNodesInPath().size() - 1;
    }

    private JsonArray outputStartArray(JsonObject out, ArrayList<CldrNode> nodesForLastItem, CldrItem item, int arrayLevel) throws IOException, ParseException {
        ArrayList<CldrNode> nodesInPath = item.getNodesInPath();
        JsonElement o = out;
        for (int i = 1; i < arrayLevel - 1; ++i) {
            CldrNode node = nodesInPath.get(i);
            o = this.startNonleafNode(o, node);
        }
        String objName = nodesInPath.get(arrayLevel - 1).getNodeKeyName();
        JsonArray array = new JsonArray();
        o.getAsJsonObject().add(objName, array);
        return array;
    }

    private void outputCldrItem(JsonObject out, ArrayList<CldrNode> nodesForLastItem, CldrItem item) throws IOException, ParseException {
        if (item.isAliasItem()) {
            return;
        }
        ArrayList<CldrNode> nodesInPath = item.getNodesInPath();
        int arraySize = nodesInPath.size();
        int i = 0;
        if (i == nodesInPath.size() && this.type != RunType.rbnf) {
            System.err.println("This nodes and last nodes has identical path. (" + item.getPath() + ") Some distinguishing attributes wrongly removed?");
            return;
        }
        JsonElement o = out;
        while (i < nodesInPath.size() - 1) {
            o = this.startNonleafNode(o, nodesInPath.get(i));
            ++i;
        }
        this.writeLeafNode(o, nodesInPath.get(i), item.getValue());
        nodesForLastItem.clear();
        nodesForLastItem.addAll(nodesInPath);
    }

    private JsonElement startNonleafNode(JsonElement out, CldrNode node) throws IOException {
        String objName = node.getNodeKeyName();
        logger.finest(() -> "objName= " + objName + " for path " + node.getUntransformedPath());
        if (objName == null || objName.equals("cldr") || objName.equals("ldmlBCP47")) {
            return out;
        }
        Map<String, String> attrAsValueMap = node.getAttrAsValueMap();
        String name = this.type == RunType.annotations || this.type == RunType.annotationsDerived ? (objName.startsWith("U+") ? UTF16.valueOf(Integer.parseInt(objName.substring(2), 16)) : objName) : objName;
        JsonElement o = out.getAsJsonObject().get(name);
        if (o == null) {
            o = new JsonObject();
            out.getAsJsonObject().add(name, o);
        }
        for (String key : attrAsValueMap.keySet()) {
            logger.finest(() -> "Non-Leaf Node: " + node.getUntransformedPath() + " ." + key);
            String rawAttrValue = attrAsValueMap.get(key);
            String value = this.escapeValue(rawAttrValue);
            String attrAsKey = "_" + key;
            if (LdmlConvertRules.attrIsBooleanOmitFalse(node.getUntransformedPath(), node.getName(), node.getParent(), key)) {
                Boolean v = Boolean.parseBoolean(rawAttrValue);
                if (!v.booleanValue()) continue;
                o.getAsJsonObject().addProperty(attrAsKey, v);
                continue;
            }
            if (attrAsKey.equals("_localeRules")) {
                JsonElement sibling;
                JsonElement localeRules = out.getAsJsonObject().get(attrAsKey);
                if (localeRules == null) {
                    localeRules = new JsonObject();
                    out.getAsJsonObject().add(attrAsKey, localeRules);
                }
                if ((sibling = localeRules.getAsJsonObject().get(name)) == null) {
                    sibling = new JsonObject();
                    localeRules.getAsJsonObject().add(name, sibling);
                }
                String parent = XPathParts.getFrozenInstance(node.getUntransformedPath()).getAttributeValue(-1, "parent");
                sibling.getAsJsonObject().addProperty(value, parent);
                continue;
            }
            o.getAsJsonObject().addProperty(attrAsKey, value);
        }
        return o;
    }

    private void outputArrayItem(JsonArray out, CldrItem item, ArrayList<CldrNode> nodesForLastItem, int arrayLevel) throws IOException, ParseException {
        ArrayList<CldrNode> nodesInPath = item.getNodesInPath();
        String value = this.escapeValue(item.getValue());
        int nodesNum = nodesInPath.size();
        CldrNode cldrNode = nodesInPath.get(nodesNum - 1);
        if (arrayLevel == nodesNum - 1) {
            Map<String, String> attrAsValueMap;
            String objName = cldrNode.getNodeKeyName();
            int pos = objName.indexOf(45);
            if (pos > 0) {
                objName = objName.substring(0, pos);
            }
            if ((attrAsValueMap = cldrNode.getAttrAsValueMap()).isEmpty()) {
                JsonObject o = new JsonObject();
                out.add(o);
                o.addProperty(objName, value);
            } else if (objName.equals("rbnfrule")) {
                this.writeRbnfLeafNode(out, item, attrAsValueMap);
            } else {
                JsonObject o = new JsonObject();
                this.writeLeafNode(o, objName, attrAsValueMap, value, cldrNode.getName(), cldrNode.getParent(), cldrNode);
                out.add(o);
            }
            nodesInPath.remove(nodesNum - 1);
        } else {
            JsonObject o = new JsonObject();
            out.add(o);
            CldrNode node = nodesInPath.get(arrayLevel);
            String objName = node.getNodeKeyName();
            int pos = objName.indexOf(45);
            if (pos > 0) {
                objName = objName.substring(0, pos);
            }
            Map<String, String> attrAsValueMap = node.getAttrAsValueMap();
            JsonObject oo = new JsonObject();
            o.add(objName, oo);
            for (String key : attrAsValueMap.keySet()) {
                oo.addProperty("_" + key, this.escapeValue(attrAsValueMap.get(key)));
            }
            JsonElement o2 = out;
            System.err.println("PROBLEM at " + cldrNode.getUntransformedPath());
            for (int i = arrayLevel + 1; i < nodesInPath.size() - 1; ++i) {
                o2 = this.startNonleafNode(o2, nodesInPath.get(i));
            }
            this.writeLeafNode(o2, cldrNode, value);
        }
        nodesForLastItem.clear();
        nodesForLastItem.addAll(nodesInPath);
    }

    private void writeRbnfLeafNode(JsonElement out, CldrItem item, Map<String, String> attrAsValueMap) throws IOException {
        if (attrAsValueMap.size() != 1) {
            throw new IllegalArgumentException("Error, attributes seem wrong for RBNF " + item.getUntransformedPath());
        }
        Map.Entry<String, String> entry = attrAsValueMap.entrySet().iterator().next();
        JsonArray arr = new JsonArray();
        arr.add(entry.getKey());
        arr.add(entry.getValue());
        out.getAsJsonArray().add(arr);
    }

    private String progressPrefix(AtomicInteger readCount, int totalCount, String filename, String section) {
        return this.progressPrefix(readCount.get(), totalCount, filename, section);
    }

    private String progressPrefix(int readCount, int totalCount, String filename, String section) {
        return this.progressPrefix(readCount, totalCount) + filename + "\t" + section + "\t";
    }

    private final String progressPrefix(AtomicInteger readCount, int totalCount) {
        return this.progressPrefix(readCount.get(), totalCount);
    }

    private final String progressPrefix(int readCount, int totalCount) {
        double asPercent = (double)readCount / (double)totalCount * 100.0;
        return String.format("\ud83d\udccd %s (step %d/%d)\t[%s]:\t", new Object[]{this.type, this.type.ordinal(), RunType.values().length - 1, this.percentFormatter.format(asPercent)});
    }

    public void processDirectory(String dirName, CLDRFile.DraftStatus minimalDraftStatus) throws IOException, ParseException {
        SupplementalDataInfo sdi = SupplementalDataInfo.getInstance(this.cldrCommonDir + "supplemental");
        Factory cldrFactory = Factory.make(this.cldrCommonDir + dirName + "/", ".*");
        Set files = cldrFactory.getAvailable().stream().filter(filename -> filename.matches(this.match) && !LdmlConvertRules.IGNORE_FILE_SET.contains(filename)).collect(Collectors.toSet());
        int total = files.size();
        AtomicInteger readCount = new AtomicInteger(0);
        TreeMap errs = new TreeMap();
        System.out.println(this.progressPrefix(0, total) + " " + MessageFormat.format("\u2699\ufe0f Beginning parallel process of {0, plural, one {# file} other {# files}}", total));
        Object[] noOutputFiles = ((Stream)files.parallelStream().unordered()).map(filename -> {
            CLDRFile file = cldrFactory.make((String)filename, this.resolve && this.type == RunType.main, minimalDraftStatus);
            readCount.incrementAndGet();
            logger.fine(() -> "<" + this.progressPrefix(readCount, total, dirName, (String)filename) + "\r");
            String pathPrefix = this.type == RunType.main ? "/cldr/" + dirName + "/" + this.unicodeLocaleToString((String)filename) + "/" : "/cldr/" + dirName + "/";
            int totalForThisFile = 0;
            try {
                totalForThisFile = this.convertCldrItems(readCount, total, dirName, (String)filename, pathPrefix, this.mapPathsToSections(readCount, total, file, pathPrefix, sdi));
            }
            catch (IOException | ParseException t2) {
                t2.printStackTrace();
                System.err.println("!" + this.progressPrefix(readCount, total) + filename + " - err - " + t2);
                errs.put(filename, t2);
            }
            finally {
                logger.fine(() -> "." + this.progressPrefix(readCount, total) + "Completing " + dirName + "/" + filename);
            }
            return new Pair<CallSite, Integer>((CallSite)((Object)(dirName + "/" + filename)), totalForThisFile);
        }).filter(p -> (Integer)p.getSecond() == 0).map(p -> (String)p.getFirst()).toArray();
        System.out.println(this.progressPrefix(total, total) + " \u2705" + MessageFormat.format("Completed parallel process of {0, plural, one {# file} other {# files}}", total));
        if (noOutputFiles.length > 0) {
            System.err.println(WARN_ICON + MessageFormat.format(" Warning: {0, plural, one {# file} other {# files}} did not produce any output (check JSON config):", noOutputFiles.length));
            for (Iterator<Object> iterator : noOutputFiles) {
                String loc = iterator.toString();
                String uloc = this.unicodeLocaleToString(iterator.toString());
                if (this.skipBcp47LocalesWithSubtags && this.type.locales() && HAS_SUBTAG.matcher(uloc).matches()) {
                    System.err.println("\t- " + loc + " \u274e (Skipped due to '-T true': " + uloc + ")");
                    continue;
                }
                System.err.println("\t- " + loc);
            }
        }
        if (!errs.isEmpty()) {
            System.err.println("Errors in these files:");
            for (Map.Entry entry : errs.entrySet()) {
                System.err.println((String)entry.getKey() + " - " + entry.getValue());
            }
            Iterator<Object> iterator = errs.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (entry.getValue() instanceof IOException) {
                    throw (IOException)entry.getValue();
                }
                if (entry.getValue() instanceof ParseException) {
                    throw (ParseException)entry.getValue();
                }
                throw new RuntimeException("Other exception thrown: " + entry.getValue());
            }
        }
        if (this.writePackages) {
            for (String string : this.packages) {
                this.writePackagingFiles(this.outputDir, string);
            }
            if (this.type == RunType.main) {
                this.writeDefaultContent(this.outputDir);
                this.writeAvailableLocales(this.outputDir);
                this.writeCoverageLevels(this.outputDir);
            } else if (this.type == RunType.supplemental) {
                this.writeScriptMetadata(this.outputDir);
                if (Boolean.parseBoolean(options.get("packagelist").getValue())) {
                    this.writePackageList(this.outputDir);
                }
            }
        }
    }

    private String escapeValue(String value) {
        Matcher match = escapePattern.matcher(value);
        String ret = match.replaceAll("\\\\");
        return ret.replace("\n", " ").replace("\t", " ");
    }

    private void writeLeafNode(JsonElement out, CldrNode node, String value) throws IOException {
        String objName = node.getNodeKeyName();
        Map<String, String> attrAsValueMaps = node.getAttrAsValueMap();
        this.writeLeafNode(out, objName, attrAsValueMaps, value, node.getName(), node.getParent(), node);
    }

    private void writeLeafNode(JsonElement out, String objName, Map<String, String> attrAsValueMap, String value, String nodeName, String parent, CldrNode node) throws IOException {
        if (objName == null) {
            return;
        }
        value = this.escapeValue(value);
        boolean valueIsSpacesepArray = LdmlConvertRules.valueIsSpacesepArray(nodeName, parent);
        if (attrAsValueMap.isEmpty()) {
            if (value.isEmpty()) {
                if (valueIsSpacesepArray) {
                    out.getAsJsonObject().add(objName, new JsonArray());
                } else if (objName.endsWith("SpaceReplacement")) {
                    out.getAsJsonObject().addProperty(objName, "");
                } else {
                    out.getAsJsonObject().add(objName, new JsonObject());
                }
            } else if (this.type == RunType.annotations || this.type == RunType.annotationsDerived) {
                JsonArray a = new JsonArray();
                for (String s2 : Annotations.splitter.split(value.trim())) {
                    a.add(s2);
                }
                out.getAsJsonObject().add(objName, a);
            } else if (valueIsSpacesepArray) {
                this.outputSpaceSepArray(out, objName, value);
            } else {
                out.getAsJsonObject().addProperty(objName, value);
            }
            return;
        }
        if (value.isEmpty() && attrAsValueMap.containsKey("_")) {
            String v = attrAsValueMap.get("_");
            if (valueIsSpacesepArray) {
                this.outputSpaceSepArray(out, objName, v);
            } else {
                out.getAsJsonObject().addProperty(objName, v);
            }
            return;
        }
        JsonObject o = new JsonObject();
        out.getAsJsonObject().add(objName, o);
        if (!value.isEmpty()) {
            o.addProperty("_value", value);
        }
        for (String key : attrAsValueMap.keySet()) {
            String rawAttrValue = attrAsValueMap.get(key);
            String attrValue = this.escapeValue(rawAttrValue);
            String attrAsKey = "_" + key;
            if (node != null) {
                logger.finest(() -> "Leaf Node: " + node.getUntransformedPath() + " ." + key);
            }
            if (LdmlConvertRules.ATTRVALUE_AS_ARRAY_SET.contains(key)) {
                String[] strings = attrValue.trim().split("\\s+");
                JsonArray a = new JsonArray();
                o.add(attrAsKey, a);
                for (String s3 : strings) {
                    a.add(s3);
                }
                continue;
            }
            if (node != null && LdmlConvertRules.attrIsBooleanOmitFalse(node.getUntransformedPath(), nodeName, parent, key)) {
                Boolean v = Boolean.parseBoolean(rawAttrValue);
                if (!v.booleanValue()) continue;
                o.addProperty(attrAsKey, v);
                continue;
            }
            o.addProperty(attrAsKey, attrValue);
        }
    }

    private void outputSpaceSepArray(JsonElement out, String objName, String v) throws IOException {
        JsonArray a = new JsonArray();
        out.getAsJsonObject().add(objName, a);
        for (String s2 : v.trim().split(" ")) {
            if (s2.isEmpty()) continue;
            a.add(s2);
        }
    }

    static class JSONSection
    implements Comparable<JSONSection> {
        public String section;
        public Pattern pattern;
        public String packageName;

        JSONSection() {
        }

        @Override
        public int compareTo(JSONSection other) {
            return this.section.compareTo(other.section);
        }
    }

    private class AvailableLocales {
        Set<String> modern = new TreeSet<String>();
        Set<String> full = new TreeSet<String>();

        private AvailableLocales() {
        }
    }

    static enum RunType {
        all,
        main,
        supplemental(false, false),
        segments,
        rbnf(false, true),
        annotations,
        annotationsDerived,
        bcp47(false, false);

        private final boolean isTiered;
        private final boolean hasLocales;

        private RunType() {
            this.isTiered = true;
            this.hasLocales = true;
        }

        private RunType(boolean isTiered, boolean hasLocales) {
            this.isTiered = isTiered;
            this.hasLocales = hasLocales;
        }

        public boolean tiered() {
            return this.isTiered;
        }

        public boolean locales() {
            return this.hasLocales;
        }

        public static String valueList() {
            return String.join((CharSequence)"|", (CharSequence[])Lists.newArrayList(RunType.values()).stream().map(t2 -> t2.name()).toArray(String[]::new));
        }
    }
}

