/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.ULocale;
import java.util.BitSet;
import java.util.List;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.FactoryCheckCLDR;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.ComparatorUtilities;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.SimpleUnicodeSetFormatter;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.UnicodeSetPrettyPrinter;
import org.unicode.cldr.util.XPathParts;

public class CheckExemplars
extends FactoryCheckCLDR {
    public static final boolean USE_PUNCTUATION = false;
    private static final boolean SUPPRESS_AUX_EMPTY_CHECK = true;
    private static final String[] QUOTE_ELEMENTS = new String[]{"quotationStart", "quotationEnd", "alternateQuotationStart", "alternateQuotationEnd"};
    static final SupplementalDataInfo SUP = CLDRConfig.getInstance().getSupplementalDataInfo();
    Collator col;
    boolean isRoot;
    SimpleUnicodeSetFormatter displayFormatter;
    UnicodeSetPrettyPrinter rawFormatter;
    static final UnicodeSet HangulSyllables = new UnicodeSet("[[:Hangul_Syllable_Type=LVT:][:Hangul_Syllable_Type=LV:]]").freeze();
    public static final UnicodeSet AlwaysOK = new UnicodeSet("[[[:Nd:][:script=common:][:script=inherited:]-[:Default_Ignorable_Code_Point:]-[:C:] - [_]] [\u05be \u05f3 \u066a-\u066c][[\u0609][\u0f0b \u0f0d\u0f0c][\u0f71]\u200e\u200e{\u09af\u09bc}\u09df]-[\u276e\u276f]]");
    private static final UnicodeSet SPECIAL_ALLOW;
    public static final UnicodeSet UAllowedInExemplars;
    public static final UnicodeSet UAllowedInNumbers;
    public static final UnicodeSet AllowedInExemplars;
    public static final UnicodeSet ALLOWED_IN_PUNCTUATION;
    public static final UnicodeSet ALLOWED_IN_AUX;
    static final BitSet Japn;
    static final BitSet Kore;

    public CheckExemplars(Factory factory) {
        super(factory);
    }

    @Override
    public CheckCLDR handleSetCldrFileToCheck(CLDRFile cldrFileToCheck, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        if (cldrFileToCheck == null) {
            return this;
        }
        super.handleSetCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        String locale = cldrFileToCheck.getLocaleID();
        this.isRoot = cldrFileToCheck.getLocaleID().equals("root");
        this.col = ComparatorUtilities.getIcuCollator(new ULocale(locale), 15);
        Collator spaceCol = ComparatorUtilities.getIcuCollator(new ULocale(locale), 0);
        this.displayFormatter = new SimpleUnicodeSetFormatter(this.col);
        this.rawFormatter = UnicodeSetPrettyPrinter.from(this.col, spaceCol);
        return this;
    }

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (fullPath == null) {
            return this;
        }
        if (path.indexOf("/exemplarCharacters") < 0) {
            if (path.contains("parseLenient")) {
                this.checkParse(path, fullPath, value, options, result);
            }
            return this;
        }
        if (!this.accept(result)) {
            return this;
        }
        XPathParts oparts = XPathParts.getFrozenInstance(path);
        String exemplarString = oparts.findAttributeValue("exemplarCharacters", "type");
        ExemplarType type = exemplarString == null ? ExemplarType.main : ExemplarType.valueOf(exemplarString);
        this.checkExemplar(value, result, type);
        try {
            UnicodeSet auxiliarySet;
            UnicodeSet mainSet = this.getResolvedCldrFileToCheck().getExemplarSet("", CLDRFile.WinningChoice.WINNING);
            if (type == ExemplarType.auxiliary) {
                Object overlap;
                auxiliarySet = SimpleUnicodeSetFormatter.parseLenient(value);
                UnicodeSet combined = new UnicodeSet(mainSet).addAll(auxiliarySet);
                this.checkMixedScripts("main+auxiliary", combined, result);
                if (auxiliarySet.containsSome(mainSet) && ((UnicodeSet)(overlap = new UnicodeSet(mainSet).retainAll(auxiliarySet).removeAll(HangulSyllables))).size() != 0) {
                    String fixedExemplar1 = this.rawFormatter.format((UnicodeSet)overlap);
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.auxiliaryExemplarsOverlap).setMessage("Auxiliary characters also exist in main: \u200e{0}\u200e", fixedExemplar1));
                }
            } else if (type == ExemplarType.punctuation) {
                UnicodeSet punctuationSet = SimpleUnicodeSetFormatter.parseLenient(value);
                UnicodeSet quoteSet = new UnicodeSet();
                for (String element : QUOTE_ELEMENTS) {
                    quoteSet.add(this.getResolvedCldrFileToCheck().getWinningValue("//ldml/delimiters/" + element));
                }
                if (!punctuationSet.containsAll(quoteSet)) {
                    quoteSet.removeAll(punctuationSet);
                    StringBuilder characters = new StringBuilder();
                    for (String item : quoteSet) {
                        if (characters.length() != 0) {
                            characters.append(" ");
                        }
                        characters.append(item);
                    }
                    CheckCLDR.CheckStatus message = new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.missingPunctuationCharacters).setMessage("Punctuation exemplar characters are missing quotation marks for this locale: {0}", characters);
                    result.add(message);
                }
            } else if (type == ExemplarType.index) {
                auxiliarySet = this.getResolvedCldrFileToCheck().getExemplarSet("auxiliary", CLDRFile.WinningChoice.WINNING);
                if (auxiliarySet == null) {
                    auxiliarySet = new UnicodeSet();
                }
                UnicodeSet mainAndAuxAllCase = new UnicodeSet(mainSet).addAll(auxiliarySet).closeOver(4);
                UnicodeSet indexBadChars = SimpleUnicodeSetFormatter.parseLenient(value).removeAll(mainAndAuxAllCase);
                if (!indexBadChars.isEmpty()) {
                    CheckCLDR.CheckStatus message = new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.charactersNotInMainOrAuxiliaryExemplars).setMessage("Index exemplars include characters not in main or auxiliary exemplars: {0}", indexBadChars.toPattern(false));
                    result.add(message);
                }
            }
            Boolean localeIsRTL = false;
            String charOrientation = this.getResolvedCldrFileToCheck().getStringValue("//ldml/layout/orientation/characterOrder");
            if (charOrientation.equals("right-to-left")) {
                localeIsRTL = true;
            }
            UnicodeSetIterator mi = new UnicodeSetIterator(mainSet);
            while (mi.next()) {
                if (mi.codepoint == -1 || UCharacter.getDirection(mi.codepoint) != 1 && UCharacter.getDirection(mi.codepoint) != 13 || localeIsRTL.booleanValue()) continue;
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.orientationDisagreesWithExemplars).setMessage("Main exemplar set contains RTL characters, but orientation of this locale is not RTL."));
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    private void checkParse(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        try {
            XPathParts oparts = XPathParts.getFrozenInstance(path);
            UnicodeSet us = SimpleUnicodeSetFormatter.parseLenient(value);
            String sampleValue = oparts.getAttributeValue(-1, "sample");
            if (!us.contains(sampleValue)) {
                CheckCLDR.CheckStatus message = new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.badParseLenient).setMessage("ParseLenient sample not in value: {0} \u220c {1}", us, sampleValue);
                result.add(message);
            }
        }
        catch (IllegalArgumentException e) {
            CheckCLDR.CheckStatus message = new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.badParseLenient).setMessage(e.toString() + (String)(e.getMessage() == null ? "" : ": " + e.getMessage()));
            result.add(message);
        }
    }

    private void checkMixedScripts(String title, UnicodeSet set, List<CheckCLDR.CheckStatus> result) {
        BitSet s2 = new BitSet();
        for (String item : set) {
            int script = UScript.getScript(item.codePointAt(0));
            if (script == 0 || script == 1) continue;
            s2.set(script);
        }
        int cardinality = s2.cardinality();
        if (cardinality < 2) {
            return;
        }
        if (cardinality == 2 && title.equals("currencySymbol") && s2.get(25)) {
            return;
        }
        if (s2.equals(Japn) || s2.equals(Kore)) {
            return;
        }
        StringBuilder scripts = new StringBuilder();
        int i = s2.nextSetBit(0);
        while (i >= 0) {
            if (scripts.length() != 0) {
                scripts.append(", ");
            }
            scripts.append(UScript.getName(i));
            UnicodeSet inSet = new UnicodeSet().applyIntPropertyValue(4106, i).retainAll(set);
            int count = 0;
            scripts.append(" (");
            for (String cp : inSet) {
                if (count != 0) {
                    scripts.append(",");
                }
                scripts.append(cp);
                if (++count <= 3) continue;
                scripts.append('\u2026');
                break;
            }
            scripts.append(")");
            i = s2.nextSetBit(i + 1);
        }
        result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalExemplarSet).setMessage("{0} exemplars contain multiple scripts: {1}", title, scripts));
    }

    private void checkExemplar(String v, List<CheckCLDR.CheckStatus> result, ExemplarType exemplarType) {
        UnicodeSet exemplar1;
        if (v == null) {
            return;
        }
        try {
            exemplar1 = SimpleUnicodeSetFormatter.parseLenient(v).freeze();
        }
        catch (Exception e) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalExemplarSet).setMessage(e.getMessage()));
            return;
        }
        this.checkMixedScripts(exemplarType.toString(), exemplar1, result);
        String fixedExemplar1 = this.rawFormatter.format(exemplar1);
        UnicodeSet doubleCheck = new UnicodeSet(fixedExemplar1);
        if (!doubleCheck.equals(exemplar1)) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.internalUnicodeSetFormattingError).setMessage("Internal Error: formatting not working for {0}", exemplar1));
        }
        if (!exemplarType.allowed.containsAll(exemplar1)) {
            UnicodeSet remainder0 = new UnicodeSet(exemplar1).removeAll(exemplarType.allowed);
            UnicodeSet remainder = new UnicodeSet();
            for (String s2 : remainder0) {
                if (Character.codePointCount(s2, 0, s2.length()) != 1) continue;
                remainder.add(s2);
            }
            if (remainder.size() != 0) {
                fixedExemplar1 = this.displayFormatter.format(exemplar1);
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalCharactersInExemplars).setMessage("Should be limited to " + exemplarType.message + "; thus not contain: \u200e{0}\u200e", remainder));
            }
        }
        if (!this.isRoot && exemplar1.size() == 0) {
            switch (exemplarType) {
                case auxiliary: {
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.missingAuxiliaryExemplars).setMessage("Most languages allow <i>some<i> auxiliary characters, so review this."));
                    break;
                }
                case index: 
                case punctuation: 
                case main: {
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.missingMainExemplars).setMessage("Exemplar set (" + exemplarType + ") must not be empty -- that would imply that this language uses no " + (exemplarType == ExemplarType.punctuation ? "punctuation" : "letters") + "!"));
                }
            }
        }
    }

    static {
        AlwaysOK.freeze();
        SPECIAL_ALLOW = new UnicodeSet("[\u061c\\u200E\\u200F\\u200c\\u200d\u200e\u200e\u200e[\u064b\u064e-\u0651\u0670]\u200e[:Nd:]\u200e[\u0951\u0952]\u200e[\u064b-\u0652\u0654-\u0657\u0670]\u200e[\u0a66-\u0a6f][\u0ed0-\u0ed9][\u064b-\u0652]\u200e[\\u02BB\\u02BC][\u0ce6-\u0cef]\u200e\u200e[\u0966-\u096f]\u200e\u200e\u200e[:word_break=Katakana:][:word_break=ALetter:][:word_break=MidLetter:] ]").freeze();
        UAllowedInExemplars = new UnicodeSet("[[:assigned:]-[:Z:]]").removeAll(AlwaysOK).addAll(SPECIAL_ALLOW).freeze();
        UAllowedInNumbers = new UnicodeSet("[\u00a0\u202f[:N:][:P:][:Sm:][:Letter_Number:][:Numeric_Type=Numeric:]]").addAll(SPECIAL_ALLOW).freeze();
        AllowedInExemplars = new UnicodeSet(UAllowedInExemplars).removeAll(new UnicodeSet("[[:Uppercase:]-[\u0130]]")).freeze();
        ALLOWED_IN_PUNCTUATION = new UnicodeSet("[[:P:][:S:]-[:Sc:]]").freeze();
        ALLOWED_IN_AUX = new UnicodeSet(AllowedInExemplars).addAll(ALLOWED_IN_PUNCTUATION).removeAll(AlwaysOK).addAll(SPECIAL_ALLOW).freeze();
        Japn = new BitSet();
        Kore = new BitSet();
        Japn.set(17);
        Japn.set(20);
        Japn.set(22);
        Kore.set(17);
        Kore.set(18);
    }

    public static enum ExemplarType {
        main(AllowedInExemplars, "(specific-script - uppercase - invisibles + \u0130)", true),
        punctuation(ALLOWED_IN_PUNCTUATION, "punctuation", false),
        auxiliary(ALLOWED_IN_AUX, "(specific-script - uppercase - invisibles + \u0130)", true),
        index(UAllowedInExemplars, "(specific-script - invisibles)", false),
        numbers(UAllowedInNumbers, "(specific-script - invisibles)", false);

        public final UnicodeSet allowed;
        public final UnicodeSet toRemove;
        public final String message;
        public final boolean convertUppercase;

        private ExemplarType(UnicodeSet allowed, String message, boolean convertUppercase) {
            if (!allowed.isFrozen()) {
                throw new IllegalArgumentException("Internal Error");
            }
            this.allowed = allowed;
            this.message = message;
            this.toRemove = new UnicodeSet(allowed).complement().freeze();
            this.convertUppercase = convertUppercase;
        }
    }
}

