/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.text.Normalizer2;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.VersionInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.XMLSource;
import org.unicode.cldr.util.XPathParts;

public class SimpleXMLSource
extends XMLSource {
    private Map<String, String> xpath_value = CldrUtility.newConcurrentHashMap();
    private Map<String, String> xpath_fullXPath = CldrUtility.newConcurrentHashMap();
    private XPathParts.Comments xpath_comments = new XPathParts.Comments();
    private Relation<String, String> VALUE_TO_PATH = null;
    private Object VALUE_TO_PATH_MUTEX = new Object();
    private VersionInfo dtdVersionInfo;
    static final Normalizer2 NFKCCF = Normalizer2.getNFKCCasefoldInstance();
    static final Normalizer2 NFKC = Normalizer2.getNFKCInstance();
    static final UnicodeSet NON_ALPHANUM = new UnicodeSet("[^[:L:][:M:][:N:][:Sc:][\\u202F\uffff _ \u00a1 \u00ab ( ) \\- \\[ \\] \\{ \\} \u00a7 / \\\\ % \u066a \u2030 \u0609 \u2031-\u2033 ` \\^ \u00af \u00a8 \u00b0 + \u00ac | \u00a6 ~ \u2212 \u2295 \u2370 \u2609 \u00a9 \u00ae]]").freeze();
    static final Pattern PLACEHOLDER = PatternCache.get("\\{\\d\\}");
    private Map<String, XMLSource.SourceLocation> locationHash = new HashMap<String, XMLSource.SourceLocation>();

    public SimpleXMLSource(String localeID) {
        this.setLocaleID(localeID);
    }

    protected SimpleXMLSource(SimpleXMLSource copyAsLockedFrom) {
        this.xpath_value = copyAsLockedFrom.xpath_value;
        this.xpath_fullXPath = copyAsLockedFrom.xpath_fullXPath;
        this.xpath_comments = copyAsLockedFrom.xpath_comments;
        this.setLocaleID(copyAsLockedFrom.getLocaleID());
        this.locationHash = Collections.unmodifiableMap(copyAsLockedFrom.locationHash);
        this.locked = true;
    }

    @Override
    public String getValueAtDPath(String xpath) {
        return this.xpath_value.get(xpath);
    }

    public String getValueAtDPathSkippingInheritanceMarker(String xpath) {
        String result = this.xpath_value.get(xpath);
        return CldrUtility.INHERITANCE_MARKER.equals(result) ? null : result;
    }

    @Override
    public String getFullPathAtDPath(String xpath) {
        String result = this.xpath_fullXPath.get(xpath);
        if (result != null) {
            return result;
        }
        if (this.xpath_value.get(xpath) != null) {
            return xpath;
        }
        return null;
    }

    @Override
    public XPathParts.Comments getXpathComments() {
        return this.xpath_comments;
    }

    @Override
    public void setXpathComments(XPathParts.Comments xpath_comments) {
        this.xpath_comments = xpath_comments;
    }

    @Override
    public void removeValueAtDPath(String distinguishingXPath) {
        String oldValue = this.xpath_value.get(distinguishingXPath);
        this.xpath_value.remove(distinguishingXPath);
        this.xpath_fullXPath.remove(distinguishingXPath);
        this.updateValuePathMapping(distinguishingXPath, oldValue, null);
    }

    @Override
    public Iterator<String> iterator() {
        return Collections.unmodifiableSet(this.xpath_value.keySet()).iterator();
    }

    @Override
    public XMLSource freeze() {
        this.locked = true;
        return this;
    }

    @Override
    public XMLSource cloneAsThawed() {
        SimpleXMLSource result = (SimpleXMLSource)super.cloneAsThawed();
        result.xpath_comments = (XPathParts.Comments)result.xpath_comments.clone();
        result.xpath_fullXPath = CldrUtility.newConcurrentHashMap(result.xpath_fullXPath);
        result.xpath_value = CldrUtility.newConcurrentHashMap(result.xpath_value);
        result.locationHash.putAll(result.locationHash);
        return result;
    }

    @Override
    public void putFullPathAtDPath(String distinguishingXPath, String fullxpath) {
        this.xpath_fullXPath.put(distinguishingXPath.intern(), fullxpath.intern());
    }

    @Override
    public void putValueAtDPath(String distinguishingXPath, String value) {
        distinguishingXPath = distinguishingXPath.intern();
        String oldValue = this.xpath_value.get(distinguishingXPath);
        this.xpath_value.put(distinguishingXPath, value);
        this.updateValuePathMapping(distinguishingXPath, oldValue, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValuePathMapping(String distinguishingXPath, String oldValue, String newValue) {
        Object object = this.VALUE_TO_PATH_MUTEX;
        synchronized (object) {
            if (this.VALUE_TO_PATH != null) {
                if (oldValue != null) {
                    this.VALUE_TO_PATH.remove(SimpleXMLSource.normalize(oldValue), distinguishingXPath);
                }
                if (newValue != null) {
                    this.VALUE_TO_PATH.put(SimpleXMLSource.normalize(newValue), distinguishingXPath);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getPathsWithValue(String valueToMatch, String pathPrefix, Set<String> result) {
        Object object = this.VALUE_TO_PATH_MUTEX;
        synchronized (object) {
            Set<String> paths;
            if (this.VALUE_TO_PATH == null) {
                this.VALUE_TO_PATH = Relation.of(new HashMap(), HashSet.class);
                for (String path : this) {
                    String value1 = this.getValueAtDPathSkippingInheritanceMarker(path);
                    if (value1 == null) continue;
                    String value = SimpleXMLSource.normalize(value1);
                    this.VALUE_TO_PATH.put(value, path);
                }
            }
            if ((paths = this.VALUE_TO_PATH.getAll(SimpleXMLSource.normalize(valueToMatch))) == null) {
                return;
            }
            if (pathPrefix == null || pathPrefix.length() == 0) {
                result.addAll(paths);
                return;
            }
            for (String path : paths) {
                if (!path.startsWith(pathPrefix)) continue;
                result.add(path);
            }
        }
    }

    public static String normalize(String valueToMatch) {
        return SimpleXMLSource.normalize2(valueToMatch, NFKCCF);
    }

    public static String normalizeCaseSensitive(String valueToMatch) {
        return SimpleXMLSource.normalize2(valueToMatch, NFKC);
    }

    public static String normalize2(String valueToMatch, Normalizer2 normalizer2) {
        if (valueToMatch.indexOf(8239) >= 0) {
            String temp = valueToMatch.replace('\u202f', '\uffff');
            String result = SimpleXMLSource.replace(NON_ALPHANUM, normalizer2.normalize(temp), "");
            return result.replace('\uffff', '\u202f');
        }
        return SimpleXMLSource.replace(NON_ALPHANUM, normalizer2.normalize(valueToMatch), "");
    }

    public static String replace(UnicodeSet unicodeSet, String valueToMatch, String substitute) {
        if (valueToMatch.contains("{")) {
            valueToMatch = PLACEHOLDER.matcher(valueToMatch).replaceAll("\u2370").trim();
        }
        StringBuilder b = null;
        for (int i = 0; i < valueToMatch.length(); ++i) {
            int cp = valueToMatch.codePointAt(i);
            if (unicodeSet.contains(cp)) {
                if (b == null) {
                    b = new StringBuilder();
                    b.append(valueToMatch.substring(0, i));
                }
                if (substitute.length() != 0) {
                    b.append(substitute);
                }
            } else if (b != null) {
                b.appendCodePoint(cp);
            }
            if (cp <= 65535) continue;
            ++i;
        }
        if (b != null) {
            valueToMatch = b.toString();
        }
        return valueToMatch;
    }

    public void setDtdVersionInfo(VersionInfo dtdVersionInfo) {
        this.dtdVersionInfo = dtdVersionInfo;
    }

    @Override
    public VersionInfo getDtdVersionInfo() {
        return this.dtdVersionInfo;
    }

    @Override
    public XMLSource addSourceLocation(String currentFullXPath, XMLSource.SourceLocation location) {
        if (!this.isFrozen()) {
            this.locationHash.put(currentFullXPath.intern(), location);
        } else {
            System.err.println("SimpleXMLSource::addSourceLocationAttempt to modify frozen source location");
        }
        return this;
    }

    @Override
    public XMLSource.SourceLocation getSourceLocation(String fullXPath) {
        return this.locationHash.get(fullXPath);
    }
}

