/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util.props;

import com.google.common.base.Joiner;
import com.ibm.icu.dev.util.UnicodeMap;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.VersionInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.props.UnicodeProperty;

public class ICUPropertyFactory
extends UnicodeProperty.Factory {
    static final Names Binary_Extras = new Names(75, new String[]{"isNFC", "isNFD", "isNFKC", "isNFKD", "isLowercase", "isUppercase", "isTitlecase", "isCasefolded", "isCased"});
    static final int isNFC = 75;
    static final int isNFD = 76;
    static final int isNFKC = 77;
    static final int isNFKD = 78;
    static final int isLowercase = 79;
    static final int isUppercase = 80;
    static final int isTitlecase = 81;
    static final int isCasefolded = 82;
    static final int isCased = 83;
    static final int BINARY_LIMIT = 84;
    static BitSet BITSET = new BitSet();
    private static ICUPropertyFactory singleton = null;

    protected ICUPropertyFactory() {
        List c = this.getInternalAvailablePropertyAliases(new ArrayList());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(this.getInternalProperty((String)it.next()));
        }
    }

    public static synchronized String getStringScriptExtensions(int codePoint) {
        int result = UScript.getScriptExtensions(codePoint, BITSET);
        if (result >= 0) {
            return UScript.getName(result);
        }
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        int scriptCode = BITSET.nextSetBit(0);
        while (scriptCode >= 0) {
            sorted.put(UScript.getShortName(scriptCode), UScript.getName(scriptCode));
            scriptCode = BITSET.nextSetBit(scriptCode + 1);
        }
        return Joiner.on(" ").join(sorted.values());
    }

    public static synchronized ICUPropertyFactory make() {
        if (singleton != null) {
            return singleton;
        }
        singleton = new ICUPropertyFactory();
        return singleton;
    }

    public List getInternalAvailablePropertyAliases(List result) {
        int[][] ranges = new int[][]{{0, 75}, {4096, 4122}, {12288, 12289}, {16384, 16398}, {28672, 28674}};
        for (int i = 0; i < ranges.length; ++i) {
            for (int j = ranges[i][0]; j < ranges[i][1]; ++j) {
                String alias = UCharacter.getPropertyName(j, 1);
                UnicodeProperty.addUnique(alias, result);
                if (result.contains(alias)) continue;
                result.add(alias);
            }
        }
        result.addAll(Binary_Extras.getNames());
        return result;
    }

    public UnicodeProperty getInternalProperty(String propertyAlias) {
        int possibleItem = Binary_Extras.get(propertyAlias);
        int propEnum = possibleItem >= 0 ? possibleItem : UCharacter.getPropertyEnum(propertyAlias);
        return new ICUProperty(propertyAlias, propEnum);
    }

    public static class Names {
        private String[] names;
        private int base;

        public Names(int base, String[] names) {
            this.base = base;
            this.names = names;
        }

        public int get(String name) {
            for (int i = 0; i < this.names.length; ++i) {
                if (!name.equalsIgnoreCase(this.names[i])) continue;
                return this.base + i;
            }
            return -1;
        }

        public String get(int number) {
            if ((number -= this.base) < 0 || this.names.length <= number) {
                return null;
            }
            return this.names[number];
        }

        public boolean isInRange(int number) {
            return 0 <= (number -= this.base) && number < this.names.length;
        }

        public List getNames() {
            return Arrays.asList(this.names);
        }
    }

    static class ICUProperty
    extends UnicodeProperty {
        protected int propEnum = Integer.MIN_VALUE;
        boolean shownException = false;
        static Map fixSkeleton = new HashMap();
        private static Map cccHack = new HashMap();
        private static Set cccExtras = new HashSet();
        static String[] AGES;

        protected ICUProperty(String propName, int propEnum) {
            this.setName(propName);
            this.propEnum = propEnum;
            this.setType(this.internalGetPropertyType(propEnum));
            if (propEnum == 5 || propEnum == 4096 || propEnum == 4101) {
                this.setUniformUnassigned(false);
            } else {
                this.setUniformUnassigned(true);
            }
        }

        @Override
        public String _getValue(int codePoint) {
            switch (this.propEnum) {
                case 16384: {
                    return this.getAge(codePoint);
                }
                case 16385: {
                    return UTF16.valueOf(UCharacter.getMirror(codePoint));
                }
                case 16386: {
                    return UCharacter.foldCase(UTF16.valueOf(codePoint), true);
                }
                case 16387: {
                    return UCharacter.getISOComment(codePoint);
                }
                case 16388: {
                    return UCharacter.toLowerCase(Locale.ENGLISH, UTF16.valueOf(codePoint));
                }
                case 16389: {
                    return UCharacter.getName(codePoint);
                }
                case 16390: {
                    return UTF16.valueOf(UCharacter.foldCase(codePoint, true));
                }
                case 16391: {
                    return UTF16.valueOf(UCharacter.toLowerCase(codePoint));
                }
                case 16392: {
                    return UTF16.valueOf(UCharacter.toTitleCase(codePoint));
                }
                case 16393: {
                    return UTF16.valueOf(UCharacter.toUpperCase(codePoint));
                }
                case 16394: {
                    return UCharacter.toTitleCase(Locale.ENGLISH, UTF16.valueOf(codePoint), null);
                }
                case 16395: {
                    return UCharacter.getName1_0(codePoint);
                }
                case 16396: {
                    return UCharacter.toUpperCase(Locale.ENGLISH, UTF16.valueOf(codePoint));
                }
                case 75: {
                    return String.valueOf(Normalizer.normalize(codePoint, Normalizer.NFC).equals(UTF16.valueOf(codePoint)));
                }
                case 76: {
                    return String.valueOf(Normalizer.normalize(codePoint, Normalizer.NFD).equals(UTF16.valueOf(codePoint)));
                }
                case 77: {
                    return String.valueOf(Normalizer.normalize(codePoint, Normalizer.NFKC).equals(UTF16.valueOf(codePoint)));
                }
                case 78: {
                    return String.valueOf(Normalizer.normalize(codePoint, Normalizer.NFKD).equals(UTF16.valueOf(codePoint)));
                }
                case 79: {
                    return String.valueOf(UCharacter.toLowerCase(Locale.ENGLISH, UTF16.valueOf(codePoint)).equals(UTF16.valueOf(codePoint)));
                }
                case 80: {
                    return String.valueOf(UCharacter.toUpperCase(Locale.ENGLISH, UTF16.valueOf(codePoint)).equals(UTF16.valueOf(codePoint)));
                }
                case 81: {
                    return String.valueOf(UCharacter.toTitleCase(Locale.ENGLISH, UTF16.valueOf(codePoint), null).equals(UTF16.valueOf(codePoint)));
                }
                case 82: {
                    return String.valueOf(UCharacter.foldCase(UTF16.valueOf(codePoint), true).equals(UTF16.valueOf(codePoint)));
                }
                case 83: {
                    return String.valueOf(UCharacter.toLowerCase(Locale.ENGLISH, UTF16.valueOf(codePoint)).equals(UTF16.valueOf(codePoint)));
                }
                case 28672: {
                    return ICUPropertyFactory.getStringScriptExtensions(codePoint);
                }
            }
            if (this.propEnum < 4122) {
                String value;
                int enumValue;
                block31: {
                    enumValue = -1;
                    value = null;
                    try {
                        enumValue = UCharacter.getIntPropertyValue(codePoint, this.propEnum);
                        if (enumValue >= 0) {
                            value = ICUProperty.fixedGetPropertyValueName(this.propEnum, enumValue, 1);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        if (this.shownException) break block31;
                        System.out.println("Fail: " + this.getName() + ", " + Integer.toHexString(codePoint));
                        this.shownException = true;
                    }
                }
                return value != null ? value : String.valueOf(enumValue);
            }
            if (this.propEnum < 12289) {
                double num = UCharacter.getUnicodeNumericValue(codePoint);
                if (num == -1.23456789E8) {
                    return null;
                }
                return Double.toString(num);
            }
            return null;
        }

        private String getAge(int codePoint) {
            String temp = UCharacter.getAge(codePoint).toString();
            if (temp.equals("0.0.0.0")) {
                return "unassigned";
            }
            if (temp.endsWith(".0.0")) {
                return temp.substring(0, temp.length() - 4);
            }
            return temp;
        }

        private String getFixedValueAlias(String valueAlias, int valueEnum, int nameChoice) {
            String result;
            if (this.propEnum >= 16384) {
                if (nameChoice > 1) {
                    throw new IllegalArgumentException();
                }
                if (nameChoice != 1) {
                    return null;
                }
                return "<string>";
            }
            if (this.propEnum >= 12288) {
                if (nameChoice > 1) {
                    throw new IllegalArgumentException();
                }
                if (nameChoice != 1) {
                    return null;
                }
                return "<number>";
            }
            if (valueAlias != null && !valueAlias.equals("<integer>")) {
                valueEnum = ICUProperty.fixedGetPropertyValueEnum(this.propEnum, valueAlias);
            }
            if ((result = ICUProperty.fixedGetPropertyValueName(this.propEnum, valueEnum, nameChoice)) != null) {
                return result;
            }
            if (nameChoice == 1) {
                result = ICUProperty.fixedGetPropertyValueName(this.propEnum, valueEnum, 0);
                if (result != null) {
                    return result;
                }
                if (this.isCombiningClassProperty()) {
                    return null;
                }
                return "<integer>";
            }
            return null;
        }

        public boolean isCombiningClassProperty() {
            return this.propEnum == 4098 || this.propEnum == 4112 || this.propEnum == 4113;
        }

        private static int fixedGetPropertyValueEnum(int propEnum, String valueAlias) {
            try {
                if (propEnum < 84) {
                    propEnum = 0;
                }
                return UCharacter.getPropertyValueEnum(propEnum, valueAlias);
            }
            catch (Exception e) {
                return Integer.parseInt(valueAlias);
            }
        }

        private static String fixedGetPropertyValueName(int propEnum, int valueEnum, int nameChoice) {
            String value = UCharacter.getPropertyValueName(propEnum, valueEnum, nameChoice);
            String newValue = (String)fixSkeleton.get(value);
            if (newValue == null) {
                newValue = value;
                if (propEnum == 4102) {
                    newValue = newValue == null ? null : newValue.toLowerCase(Locale.ENGLISH);
                }
                newValue = ICUProperty.regularize(newValue, true);
                fixSkeleton.put(value, newValue);
            }
            return newValue;
        }

        public List _getNameAliases(List result) {
            String alias;
            if (result == null) {
                result = new ArrayList();
            }
            if ((alias = Binary_Extras.get(this.propEnum)) != null) {
                ICUProperty.addUnique(alias, result);
            } else {
                ICUProperty.addUnique(this.getFixedPropertyName(this.propEnum, 0), result);
                ICUProperty.addUnique(this.getFixedPropertyName(this.propEnum, 1), result);
            }
            return result;
        }

        public String getFixedPropertyName(int propName, int nameChoice) {
            try {
                return UCharacter.getPropertyName(this.propEnum, nameChoice);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public List _getAvailableValues(List result) {
            if (result == null) {
                result = new ArrayList();
            }
            if (this.propEnum == 16384) {
                ICUProperty.addAllUnique(this.getAges(), result);
                return result;
            }
            if (this.propEnum < 4122) {
                if (Binary_Extras.isInRange(this.propEnum)) {
                    this.propEnum = 0;
                }
                int start = UCharacter.getIntPropertyMinValue(this.propEnum);
                int end = UCharacter.getIntPropertyMaxValue(this.propEnum);
                for (int i = start; i <= end; ++i) {
                    String alias = this.getFixedValueAlias(null, i, 1);
                    String alias2 = this.getFixedValueAlias(null, i, 0);
                    if (alias == null && (alias = alias2) == null && this.isCombiningClassProperty()) {
                        alias = String.valueOf(i);
                    }
                    ICUProperty.addUnique(alias, result);
                }
            } else if (this.propEnum >= 12288 && this.propEnum < 12289) {
                UnicodeMap map = this.getUnicodeMap();
                Set values = map.values();
                ICUProperty.addAllUnique(values, result);
            } else {
                String alias = this.getFixedValueAlias(null, -1, 1);
                ICUProperty.addUnique(alias, result);
            }
            return result;
        }

        private String[] getAges() {
            if (AGES == null) {
                TreeSet<String> ages = new TreeSet<String>();
                for (int i = 0; i < 0x10FFFF; ++i) {
                    ages.add(this.getAge(i));
                }
                AGES = ages.toArray(new String[ages.size()]);
            }
            return AGES;
        }

        public List _getValueAliases(String valueAlias, List result) {
            int type;
            if (result == null) {
                result = new ArrayList();
            }
            if (this.propEnum == 16384) {
                ICUProperty.addUnique(valueAlias, result);
                return result;
            }
            if (this.isCombiningClassProperty()) {
                ICUProperty.addUnique(cccHack.get(valueAlias), result);
            }
            if ((type = this.getType()) == 12 || type == 13) {
                ICUProperty.addUnique(valueAlias, result);
                if (valueAlias.endsWith(".0")) {
                    ICUProperty.addUnique(valueAlias.substring(0, valueAlias.length() - 2), result);
                }
            } else {
                int nameChoice = 0;
                while (true) {
                    try {
                        ICUProperty.addUnique(this.getFixedValueAlias(valueAlias, -1, nameChoice), result);
                    }
                    catch (Exception e) {
                        break;
                    }
                    ++nameChoice;
                }
            }
            return result;
        }

        private int internalGetPropertyType(int prop) {
            switch (prop) {
                case 4097: 
                case 4106: 
                case 16384: {
                    return 6;
                }
                case 16387: 
                case 16389: 
                case 16395: 
                case 28672: {
                    return 8;
                }
                case 16385: 
                case 16386: 
                case 16388: 
                case 16390: 
                case 16391: 
                case 16392: 
                case 16393: 
                case 16394: 
                case 16396: {
                    return 11;
                }
            }
            if (prop < 0) {
                return 0;
            }
            if (prop < 75) {
                return 2;
            }
            if (prop < 4096) {
                return 3;
            }
            if (prop < 4122) {
                return 4;
            }
            if (prop < 12288) {
                return 5;
            }
            if (prop < 12289) {
                return 12;
            }
            if (prop < 16384) {
                return 13;
            }
            if (prop < 16398) {
                return 10;
            }
            return 11;
        }

        @Override
        public String _getVersion() {
            return VersionInfo.ICU_VERSION.toString();
        }

        static {
            for (int i = 0; i <= 255; ++i) {
                String alias = UCharacter.getPropertyValueName(4098, i, 1);
                String numStr = String.valueOf(i);
                if (alias != null) {
                    cccHack.put(alias, numStr);
                    continue;
                }
                cccHack.put(numStr, numStr);
                cccExtras.add(numStr);
            }
            AGES = null;
        }
    }
}

