/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.ibm.icu.impl.locale.XCldrStub;
import com.ibm.icu.util.VersionInfo;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.CLDRPaths;

public enum CldrVersion {
    unknown,
    v1_1,
    v1_1_1,
    v1_2,
    v1_3,
    v1_4,
    v1_4_1,
    v1_5_0_1,
    v1_5_1,
    v1_6_1,
    v1_7_2,
    v1_8_1,
    v1_9_1,
    v2_0_1,
    v21_0,
    v22_1,
    v23_1,
    v24_0,
    v25_0,
    v26_0,
    v27_0,
    v28_0,
    v29_0,
    v30_0,
    v31_0,
    v32_0,
    v33_0,
    v33_1,
    v34_0,
    v35_0,
    v35_1,
    v36_0,
    v36_1,
    v37_0,
    v38_0,
    v38_1,
    v39_0,
    v40_0,
    v41_0,
    v42_0,
    v43_0,
    v44_0,
    v44_1,
    baseline;

    private final String baseDirectory;
    private final String dotName;
    private final VersionInfo versionInfo;
    public static final CldrVersion LAST_RELEASE_VERSION;
    public static final List<CldrVersion> CLDR_VERSIONS_ASCENDING;
    public static final List<CldrVersion> CLDR_VERSIONS_DESCENDING;
    private static final Map<VersionInfo, CldrVersion> versionInfoToCldrVersion;

    public static CldrVersion from(VersionInfo versionInfo) {
        if (versionInfo == null) {
            return unknown;
        }
        CldrVersion result;
        while ((result = versionInfoToCldrVersion.get(versionInfo)) == null) {
            versionInfo = versionInfo.getMilli() != 0 ? VersionInfo.getInstance(versionInfo.getMajor(), versionInfo.getMinor()) : (versionInfo.getMinor() != 0 ? VersionInfo.getInstance(versionInfo.getMajor()) : CldrVersion.unknown.versionInfo);
        }
        return result;
    }

    public static CldrVersion from(String versionString) {
        if (versionString.equals("45") || versionString.equals("45.0")) {
            return baseline;
        }
        return CldrVersion.valueOf((String)(versionString.charAt(0) < 'A' ? "v" + versionString.replace('.', '_') : versionString));
    }

    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public String toString() {
        return this.dotName;
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public boolean isOlderThan(CldrVersion other) {
        return this.compareTo(other) < 0;
    }

    private CldrVersion() {
        String oldName = this.name();
        if (oldName.charAt(0) == 'v') {
            this.dotName = oldName.substring(1).replace('_', '.');
            this.versionInfo = VersionInfo.getInstance(this.dotName);
            this.baseDirectory = CLDRPaths.ARCHIVE_DIRECTORY + "cldr-" + this.toString() + "/";
        } else {
            this.dotName = oldName;
            this.baseDirectory = CLDRPaths.BASE_DIRECTORY;
            VersionInfo cldrVersion = VersionInfo.getInstance("45");
            this.versionInfo = "baseline".equals(oldName) ? cldrVersion : VersionInfo.getInstance(0);
        }
    }

    public List<File> getPathsForFactory() {
        File[] fileArray;
        if (this.versionInfo != null && this.versionInfo.getMajor() < 27) {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = new File(this.getBaseDirectory() + "common/main/");
        } else {
            File[] fileArray3 = new File[2];
            fileArray3[0] = new File(this.getBaseDirectory() + "common/main/");
            fileArray = fileArray3;
            fileArray3[1] = new File(this.getBaseDirectory() + "common/annotations/");
        }
        return ImmutableList.copyOf(fileArray);
    }

    public static void checkVersions() {
        TreeSet<VersionInfo> allFileVersions = new TreeSet<VersionInfo>();
        TreeSet<VersionInfo> allTc = new TreeSet<VersionInfo>();
        TreeSet<VersionInfo> missingEnums = new TreeSet<VersionInfo>();
        EnumSet<CldrVersion> extraEnums = EnumSet.copyOf(CLDR_VERSIONS_ASCENDING);
        extraEnums.remove((Object)baseline);
        extraEnums.remove((Object)unknown);
        for (String subdir : new File(CLDRPaths.ARCHIVE_DIRECTORY).list()) {
            if (!subdir.startsWith("cldr-")) continue;
            String versionString = subdir.substring("cldr-".length());
            VersionInfo versionInfo = VersionInfo.getInstance(versionString);
            allFileVersions.add(versionInfo);
            try {
                CldrVersion found = CldrVersion.from(versionString);
                extraEnums.remove((Object)found);
            }
            catch (Exception e) {
                missingEnums.add(versionInfo);
            }
        }
        LinkedHashSet<CallSite> errorMessages = new LinkedHashSet<CallSite>();
        for (String tc : ToolConstants.CLDR_VERSIONS) {
            VersionInfo versionInfo = VersionInfo.getInstance(tc);
            allTc.add(versionInfo);
        }
        if (!allTc.equals(allFileVersions)) {
            LinkedHashSet tcMFile = new LinkedHashSet(allTc);
            tcMFile.removeAll(allFileVersions);
            if (!tcMFile.isEmpty()) {
                errorMessages.add((CallSite)((Object)("Extra ToolConstants.CLDR_VERSIONS compared to " + CLDRPaths.ARCHIVE_DIRECTORY + ": " + tcMFile)));
            }
            LinkedHashSet fileMTc = new LinkedHashSet(allFileVersions);
            fileMTc.removeAll(allTc);
            if (!fileMTc.isEmpty()) {
                errorMessages.add((CallSite)((Object)("Extra folders in " + CLDRPaths.ARCHIVE_DIRECTORY + " compared to ToolConstants.CLDR_VERSIONS: " + fileMTc)));
            }
        }
        if (!extraEnums.isEmpty()) {
            errorMessages.add((CallSite)((Object)("Extra enums compared to " + CLDRPaths.ARCHIVE_DIRECTORY + ": " + extraEnums)));
        }
        if (!missingEnums.isEmpty()) {
            StringBuilder temp = new StringBuilder();
            allFileVersions.forEach(v -> temp.append(", v" + v.getVersionString(2, 4).replace('.', '_')));
            errorMessages.add((CallSite)((Object)("Missing enums " + missingEnums + ", should be:\ntrunk" + temp + ", unknown")));
        }
        if (!errorMessages.isEmpty()) {
            throw new IllegalArgumentException(((Object)errorMessages).toString());
        }
    }

    static {
        LAST_RELEASE_VERSION = CldrVersion.values()[CldrVersion.values().length - 2];
        EnumSet<CldrVersion> temp = EnumSet.allOf(CldrVersion.class);
        CLDR_VERSIONS_ASCENDING = ImmutableList.copyOf(temp);
        CLDR_VERSIONS_DESCENDING = ImmutableList.copyOf(Lists.reverse(CLDR_VERSIONS_ASCENDING));
        LinkedHashMap<VersionInfo, CldrVersion> temp2 = new LinkedHashMap<VersionInfo, CldrVersion>();
        for (CldrVersion item : CLDR_VERSIONS_ASCENDING) {
            VersionInfo version2 = item.versionInfo;
            temp2.put(version2, item);
            if (version2.getMilli() != 0 && !temp2.containsKey(version2 = VersionInfo.getInstance(version2.getMajor(), version2.getMinor()))) {
                temp2.put(version2, item);
            }
            if (version2.getMinor() == 0 || temp2.containsKey(version2 = VersionInfo.getInstance(version2.getMajor()))) continue;
            temp2.put(version2, item);
        }
        versionInfoToCldrVersion = XCldrStub.ImmutableMap.copyOf(temp2);
    }
}

