/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.ibm.icu.util.Freezable;
import com.ibm.icu.util.Output;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.EnumComparator;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.UnitConverter;
import org.unicode.cldr.util.UnitPathType;
import org.unicode.cldr.util.With;
import org.unicode.cldr.util.XPathParts;

public class GrammarInfo
implements Freezable<GrammarInfo> {
    private Map<GrammaticalTarget, Map<GrammaticalFeature, Map<GrammaticalScope, Set<String>>>> targetToFeatureToUsageToValues = new TreeMap<GrammaticalTarget, Map<GrammaticalFeature, Map<GrammaticalScope, Set<String>>>>();
    private boolean frozen = false;
    private static final Set<String> CORE_UNITS_NEEDING_GRAMMAR = ImmutableSet.of("mass-grain", "volume-dessert-spoon", "volume-dessert-spoon-imperial", "volume-drop", "volume-dram", "volume-jigger", new String[]{"volume-pinch", "volume-quart-imperial", "acceleration-meter-per-square-second", "area-acre", "area-hectare", "area-square-centimeter", "area-square-foot", "area-square-kilometer", "area-square-mile", "concentr-percent", "consumption-mile-per-gallon", "consumption-mile-per-gallon-imperial", "duration-day", "duration-hour", "duration-minute", "duration-month", "duration-second", "duration-week", "duration-year", "energy-foodcalorie", "energy-kilocalorie", "length-centimeter", "length-foot", "length-inch", "length-kilometer", "length-meter", "length-mile", "length-millimeter", "length-parsec", "length-picometer", "length-solar-radius", "length-yard", "light-solar-luminosity", "mass-dalton", "mass-earth-mass", "mass-milligram", "mass-solar-mass", "pressure-kilopascal", "speed-kilometer-per-hour", "speed-meter-per-second", "speed-mile-per-hour", "temperature-celsius", "temperature-fahrenheit", "temperature-generic", "temperature-kelvin", "acceleration-g-force", "consumption-liter-per-100-kilometer", "mass-gram", "mass-kilogram", "mass-ounce", "mass-pound", "volume-centiliter", "volume-cubic-centimeter", "volume-cubic-foot", "volume-cubic-mile", "volume-cup", "volume-deciliter", "volume-fluid-ounce", "volume-fluid-ounce-imperial", "volume-gallon", "volume-gallon", "volume-gallon-imperial", "volume-liter", "volume-milliliter", "volume-pint", "volume-quart", "volume-tablespoon", "volume-teaspoon"});
    static final Set<String> INCLUDE_OTHER = ImmutableSet.of("g-force", "arc-minute", "arc-second", "degree", "revolution", "bit", new String[]{"byte", "week", "calorie", "pixel", "generic", "karat", "percent", "permille", "permillion", "permyriad", "atmosphere", "em", "century", "decade", "month", "year"});
    static final Set<String> EXCLUDE_GRAMMAR = Set.of("point", "dunam", "dot", "astronomical-unit", "nautical-mile", "knot", "dalton", "kilocalorie", "electronvolt", "dot-per-centimeter", "millimeter-ofhg", "milligram-ofglucose-per-deciliter");
    public static final boolean DEBUG = false;

    @Deprecated
    public void add(GrammaticalTarget target, GrammaticalFeature feature, GrammaticalScope usage, String value) {
        Map<GrammaticalFeature, Map<GrammaticalScope, Set<String>>> featureToUsageToValues = this.targetToFeatureToUsageToValues.get((Object)target);
        if (featureToUsageToValues == null) {
            featureToUsageToValues = new TreeMap<GrammaticalFeature, Map<GrammaticalScope, Set<String>>>();
            this.targetToFeatureToUsageToValues.put(target, featureToUsageToValues);
        }
        if (feature != null) {
            Set<String> values;
            Map<GrammaticalScope, Set<String>> usageToValues = featureToUsageToValues.get((Object)feature);
            if (usageToValues == null) {
                usageToValues = new TreeMap<GrammaticalScope, Set<String>>();
                featureToUsageToValues.put(feature, usageToValues);
            }
            if ((values = usageToValues.get((Object)usage)) == null) {
                values = new TreeSet<String>();
                usageToValues.put(usage, values);
            }
            if (value != null) {
                values.add(value);
            } else {
                boolean bl = false;
            }
        }
    }

    @Deprecated
    public void add(GrammaticalTarget target, GrammaticalFeature feature, GrammaticalScope usage, Collection<String> valueSet) {
        Map<GrammaticalFeature, Map<GrammaticalScope, Set<String>>> featureToUsageToValues = this.targetToFeatureToUsageToValues.get((Object)target);
        if (featureToUsageToValues == null) {
            featureToUsageToValues = new TreeMap<GrammaticalFeature, Map<GrammaticalScope, Set<String>>>();
            this.targetToFeatureToUsageToValues.put(target, featureToUsageToValues);
        }
        if (feature != null) {
            Set<String> values;
            Map<GrammaticalScope, Set<String>> usageToValues = featureToUsageToValues.get((Object)feature);
            if (usageToValues == null) {
                usageToValues = new TreeMap<GrammaticalScope, Set<String>>();
                featureToUsageToValues.put(feature, usageToValues);
            }
            if ((values = usageToValues.get((Object)usage)) == null) {
                values = new TreeSet<String>();
                usageToValues.put(usage, values);
            }
            this.validate(feature, valueSet);
            values.addAll(valueSet);
        }
    }

    private void validate(GrammaticalFeature feature, Collection<String> valueSet) {
        for (String value : valueSet) {
            this.validate(feature, value);
        }
    }

    private void validate(GrammaticalFeature feature, String value) {
        switch (feature) {
            case grammaticalCase: {
                CaseValues.valueOf(value);
                break;
            }
            case grammaticalDefiniteness: {
                DefinitenessValues.valueOf(value);
                break;
            }
            case grammaticalGender: {
                GenderValues.valueOf(value);
                break;
            }
            case grammaticalNumber: {
                PluralValues.valueOf(value);
            }
        }
    }

    @Deprecated
    public void add(String targetsRaw, String featureRaw, String usagesRaw, String valuesRaw) {
        for (String targetString : SupplementalDataInfo.split_space.split(targetsRaw)) {
            GrammaticalTarget target = GrammaticalTarget.valueOf(targetString);
            if (featureRaw == null) {
                this.add(target, null, null, (String)null);
                continue;
            }
            GrammaticalFeature feature = GrammaticalFeature.valueOf(featureRaw);
            List<String> usages = usagesRaw == null ? Collections.singletonList(GrammaticalScope.general.toString()) : SupplementalDataInfo.split_space.splitToList(usagesRaw);
            List<String> values = valuesRaw == null ? Collections.emptyList() : SupplementalDataInfo.split_space.splitToList(valuesRaw);
            for (String usageRaw : usages) {
                GrammaticalScope usage = GrammaticalScope.valueOf(usageRaw);
                this.add(target, feature, usage, values);
            }
        }
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public GrammarInfo freeze() {
        if (!this.frozen) {
            Map<GrammaticalTarget, Map<GrammaticalFeature, Map<GrammaticalScope, Set<String>>>> temp = CldrUtility.protectCollection(this.targetToFeatureToUsageToValues);
            if (!temp.equals(this.targetToFeatureToUsageToValues)) {
                throw new IllegalArgumentException();
            }
            this.targetToFeatureToUsageToValues = temp;
            this.frozen = true;
        }
        return this;
    }

    @Override
    public GrammarInfo cloneAsThawed() {
        GrammarInfo result = new GrammarInfo();
        this.forEach3((t2, f, u, v) -> result.add((GrammaticalTarget)((Object)t2), (GrammaticalFeature)((Object)f), (GrammaticalScope)((Object)u), (Collection<String>)v));
        return result;
    }

    public void forEach(Handler4<GrammaticalTarget, GrammaticalFeature, GrammaticalScope, String> handler) {
        for (Map.Entry<GrammaticalTarget, Map<GrammaticalFeature, Map<GrammaticalScope, Set<String>>>> entry1 : this.targetToFeatureToUsageToValues.entrySet()) {
            GrammaticalTarget target = entry1.getKey();
            Map<GrammaticalFeature, Map<GrammaticalScope, Set<String>>> featureToUsageToValues = entry1.getValue();
            if (featureToUsageToValues.isEmpty()) {
                handler.apply(target, null, null, null);
                continue;
            }
            for (Map.Entry<GrammaticalFeature, Map<GrammaticalScope, Set<String>>> entry2 : featureToUsageToValues.entrySet()) {
                GrammaticalFeature feature = entry2.getKey();
                for (Map.Entry<GrammaticalScope, Set<String>> entry3 : entry2.getValue().entrySet()) {
                    GrammaticalScope usage = entry3.getKey();
                    for (String value : entry3.getValue()) {
                        handler.apply(target, feature, usage, value);
                    }
                }
            }
        }
    }

    public void forEach3(Handler3<GrammaticalTarget, GrammaticalFeature, GrammaticalScope, Collection<String>> handler) {
        for (Map.Entry<GrammaticalTarget, Map<GrammaticalFeature, Map<GrammaticalScope, Set<String>>>> entry1 : this.targetToFeatureToUsageToValues.entrySet()) {
            GrammaticalTarget target = entry1.getKey();
            Map<GrammaticalFeature, Map<GrammaticalScope, Set<String>>> featureToUsageToValues = entry1.getValue();
            if (featureToUsageToValues.isEmpty()) {
                handler.apply(target, null, null, null);
                continue;
            }
            for (Map.Entry<GrammaticalFeature, Map<GrammaticalScope, Set<String>>> entry2 : featureToUsageToValues.entrySet()) {
                GrammaticalFeature feature = entry2.getKey();
                for (Map.Entry<GrammaticalScope, Set<String>> entry3 : entry2.getValue().entrySet()) {
                    GrammaticalScope usage = entry3.getKey();
                    Collection values = entry3.getValue();
                    handler.apply(target, feature, usage, values);
                }
            }
        }
    }

    public Collection<String> get(GrammaticalTarget target, GrammaticalFeature feature, GrammaticalScope usage) {
        Map<GrammaticalFeature, Map<GrammaticalScope, Set<String>>> featureToUsageToValues = this.targetToFeatureToUsageToValues.get((Object)target);
        if (featureToUsageToValues == null) {
            return Collections.emptySet();
        }
        Map<GrammaticalScope, Set<String>> usageToValues = featureToUsageToValues.get((Object)feature);
        if (usageToValues == null) {
            return Collections.emptySet();
        }
        Collection result = usageToValues.get((Object)usage);
        return result == null ? (Collection)usageToValues.get((Object)GrammaticalScope.general) : result;
    }

    public Map<GrammaticalScope, Set<String>> get(GrammaticalTarget target, GrammaticalFeature feature) {
        Map<GrammaticalFeature, Map<GrammaticalScope, Set<String>>> featureToUsageToValues = this.targetToFeatureToUsageToValues.get((Object)target);
        if (featureToUsageToValues == null) {
            return Collections.emptyMap();
        }
        Map<GrammaticalScope, Set<String>> usageToValues = featureToUsageToValues.get((Object)feature);
        if (usageToValues == null) {
            return Collections.emptyMap();
        }
        return usageToValues;
    }

    public boolean hasInfo(GrammaticalTarget target) {
        return this.targetToFeatureToUsageToValues.containsKey((Object)target);
    }

    public String toString() {
        return this.toString("\n");
    }

    public String toString(String lineSep) {
        StringBuilder result = new StringBuilder();
        this.forEach3((t2, f, u, v) -> {
            result.append(lineSep);
            result.append("{" + (t2 == null ? "" : t2.toString()) + "}\t{" + (f == null ? "" : f.toString()) + "}\t{" + (u == null ? "" : u.toString()) + "}\t{" + (v == null ? "" : Joiner.on(' ').join((Iterable<? extends Object>)v)) + "}");
        });
        return result.toString();
    }

    public static String getGrammaticalInfoAttributes(GrammarInfo grammarInfo, UnitPathType pathType, String plural, String gender, String caseVariant) {
        Collection<String> genders;
        Object grammaticalAttributes = "";
        if (pathType.features.contains((Object)GrammaticalFeature.grammaticalNumber)) {
            grammaticalAttributes = (String)grammaticalAttributes + "[@count=\"" + (plural == null ? "other" : plural) + "\"]";
        }
        if (grammarInfo != null && gender != null && pathType.features.contains((Object)GrammaticalFeature.grammaticalGender) && !gender.equals(GrammaticalFeature.grammaticalGender.getDefault(genders = grammarInfo.get(GrammaticalTarget.nominal, GrammaticalFeature.grammaticalGender, GrammaticalScope.units)))) {
            grammaticalAttributes = (String)grammaticalAttributes + "[@gender=\"" + gender + "\"]";
        }
        if (grammarInfo != null && caseVariant != null && pathType.features.contains((Object)GrammaticalFeature.grammaticalCase) && !caseVariant.equals(GrammaticalFeature.grammaticalCase.getDefault(null))) {
            grammaticalAttributes = (String)grammaticalAttributes + "[@case=\"" + caseVariant + "\"]";
        }
        return grammaticalAttributes;
    }

    public void getSourceCaseAndPlural(String locale, String gender, String value, String desiredCase, String desiredPlural, Output<String> sourceCase, Output<String> sourcePlural) {
        switch (locale) {
            case "pl": {
                this.getSourceCaseAndPluralPolish(gender, value, desiredCase, desiredPlural, sourceCase, sourcePlural);
                break;
            }
            case "ru": {
                this.getSourceCaseAndPluralRussian(gender, value, desiredCase, desiredPlural, sourceCase, sourcePlural);
                break;
            }
            default: {
                throw new UnsupportedOperationException(locale);
            }
        }
    }

    private void getSourceCaseAndPluralRussian(String gender, String value, String desiredCase, String desiredPlural, Output<String> sourceCase, Output<String> sourcePlural) {
        switch (desiredPlural) {
            case "few": {
                sourceCase.value = desiredCase;
                sourcePlural.value = "many";
                switch (desiredCase) {
                    case "nominative": {
                        sourceCase.value = "genitive";
                        sourcePlural.value = "one";
                        break;
                    }
                    case "accusative": {
                        switch (gender) {
                            case "masculine": {
                                sourceCase.value = "genitive";
                                sourcePlural.value = "one";
                            }
                        }
                    }
                }
            }
            case "other": {
                sourceCase.value = "genitive";
                sourcePlural.value = "one";
                return;
            }
        }
    }

    private void getSourceCaseAndPluralPolish(String gender, String value, String desiredCase, String desiredPlural, Output<String> sourceCase, Output<String> sourcePlural) {
        switch (desiredPlural) {
            case "few": {
                sourceCase.value = desiredCase;
                sourcePlural.value = "many";
                boolean isNominative = false;
                block13 : switch (desiredCase) {
                    case "nominative": {
                        isNominative = true;
                    }
                    case "vocative": 
                    case "accusative": {
                        switch (gender) {
                            case "neuter": {
                                if (value.endsWith("um")) {
                                    sourceCase.value = "vocative";
                                    break block13;
                                }
                            }
                            case "feminine": {
                                sourceCase.value = "nominative";
                                sourcePlural.value = "few";
                                break block13;
                            }
                            case "animate": 
                            case "inanimate": {
                                sourceCase.value = "vocative";
                                break block13;
                            }
                            case "personal": {
                                sourceCase.value = isNominative ? "vocative" : "genitive";
                            }
                        }
                    }
                }
                return;
            }
            case "other": {
                sourceCase.value = "genitive";
                sourcePlural.value = "one";
                return;
            }
        }
    }

    public static Set<String> getGrammarLocales() {
        return GrammarLocales.data;
    }

    public static Set<String> getSpecialsToTranslate() {
        return INCLUDE_OTHER;
    }

    public static Set<String> getUnitsToAddGrammar() {
        return UnitsToAddGrammar.data;
    }

    static class UnitsToAddGrammar {
        static final Set<String> data;

        UnitsToAddGrammar() {
        }

        static {
            CLDRConfig config = CLDRConfig.getInstance();
            UnitConverter converter = config.getSupplementalDataInfo().getUnitConverter();
            TreeSet<String> missing = new TreeSet<String>();
            TreeSet<String> _data = new TreeSet<String>();
            for (String path : With.in(config.getRoot().iterator("//ldml/units/unitLength[@type=\"short\"]/unit"))) {
                Set<UnitConverter.UnitSystem> systems;
                XPathParts parts = XPathParts.getFrozenInstance(path);
                String unit = parts.getAttributeValue(3, "type");
                String shortUnit = converter.getShortId(unit);
                if (INCLUDE_OTHER.contains(shortUnit)) {
                    _data.add(unit);
                    continue;
                }
                if (!EXCLUDE_GRAMMAR.contains(shortUnit) && !Collections.disjoint(systems = converter.getSystemsEnum(shortUnit), UnitConverter.UnitSystem.SiOrMetric)) {
                    _data.add(unit);
                    continue;
                }
                missing.add(unit);
            }
            data = ImmutableSet.copyOf(_data);
        }
    }

    static class GrammarLocales {
        static final Set<String> data = ImmutableSortedSet.copyOf(((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(CLDRConfig.getInstance().getSupplementalDataInfo().getLocalesWithFeatures(GrammaticalTarget.nominal, GrammaticalScope.units, GrammaticalFeature.grammaticalCase))).addAll(CLDRConfig.getInstance().getSupplementalDataInfo().getLocalesWithFeatures(GrammaticalTarget.nominal, GrammaticalScope.units, GrammaticalFeature.grammaticalGender))).build());

        GrammarLocales() {
        }
    }

    static interface Handler3<T, F, U, V> {
        public void apply(T var1, F var2, U var3, V var4);
    }

    static interface Handler4<T, F, U, V> {
        public void apply(T var1, F var2, U var3, V var4);
    }

    public static enum GrammaticalScope {
        general,
        units,
        personNames;

    }

    public static enum GrammaticalFeature {
        grammaticalNumber("plural", "\u24c5", "other", PluralValues.COMPARATOR),
        grammaticalCase("case", "\u24b8", "nominative", CaseValues.COMPARATOR),
        grammaticalDefiniteness("definiteness", "\u24b9", "indefinite", DefinitenessValues.COMPARATOR),
        grammaticalGender("gender", "\u24bc", "neuter", GenderValues.COMPARATOR);

        private final String shortName;
        private final String symbol;
        private final String defaultValue;
        private final Comparator<String> comparator;
        public static final Pattern PATH_HAS_FEATURE;
        static final Map<String, GrammaticalFeature> shortNameToEnum;

        private GrammaticalFeature(String shortName, String symbol, String defaultValue, Comparator<String> comparator) {
            this.shortName = shortName;
            this.symbol = symbol;
            this.defaultValue = defaultValue;
            this.comparator = comparator;
        }

        public String getShortName() {
            return this.shortName;
        }

        public CharSequence getSymbol() {
            return this.symbol;
        }

        public String getDefault(Collection<String> featureValuesFromGrammaticalInfo) {
            return this == grammaticalGender && featureValuesFromGrammaticalInfo != null && !featureValuesFromGrammaticalInfo.contains("neuter") ? "masculine" : this.defaultValue;
        }

        public static Matcher pathHasFeature(String path) {
            Matcher result = PATH_HAS_FEATURE.matcher(path);
            return result.find() ? result : null;
        }

        public static GrammaticalFeature fromName(String name) {
            GrammaticalFeature result = shortNameToEnum.get(name);
            return result != null ? result : GrammaticalFeature.valueOf(name);
        }

        public Comparator getValueComparator() {
            return this.comparator;
        }

        static {
            PATH_HAS_FEATURE = Pattern.compile("\\[@(count|case|gender|definiteness)=");
            shortNameToEnum = ImmutableMap.copyOf(Arrays.asList(GrammaticalFeature.values()).stream().collect(Collectors.toMap(e -> e.shortName, e -> e)));
        }
    }

    public static enum PluralValues {
        zero,
        one,
        two,
        few,
        many,
        other;

        public static Comparator<String> COMPARATOR;

        static {
            COMPARATOR = EnumComparator.create(PluralValues.class);
        }
    }

    public static enum DefinitenessValues {
        unspecified,
        indefinite,
        definite,
        construct;

        public static Comparator<String> COMPARATOR;

        static {
            COMPARATOR = EnumComparator.create(DefinitenessValues.class);
        }
    }

    public static enum GenderValues {
        personal,
        animate,
        inanimate,
        masculine,
        feminine,
        common,
        neuter;

        public static Comparator<String> COMPARATOR;

        static {
            COMPARATOR = EnumComparator.create(GenderValues.class);
        }
    }

    public static enum CaseValues {
        nominative,
        vocative,
        accusative,
        oblique,
        genitive,
        partitive,
        locative,
        dative,
        instrumental,
        prepositional,
        ablative,
        inessive,
        elative,
        illative,
        adessive,
        allative,
        essive,
        translative,
        abessive,
        comitative,
        causal,
        delative,
        ergative,
        locativecopulative,
        sociative,
        sublative,
        superessive,
        terminative;

        public static Comparator<String> COMPARATOR;

        static {
            COMPARATOR = EnumComparator.create(CaseValues.class);
        }
    }

    public static enum GrammaticalTarget {
        nominal;

    }
}

