/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.impl.OlsonTimeZone;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.TimeZoneTransition;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

public class TestMetazones {
    public static boolean DEBUG = false;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final long MINUTE = 60000L;
    static final SupplementalDataInfo supplementalData = SupplementalDataInfo.getInstance();
    Factory factory = Factory.make(CLDRPaths.MAIN_DIRECTORY, "root");
    int errorCount = 0;
    int warningCount = 0;
    NumberFormat days = new DecimalFormat("0.000");
    NumberFormat hours = new DecimalFormat("+0.00;-0.00");
    PrintWriter log = null;
    PrintWriter errorLog = null;
    private boolean skipConsistency;
    private boolean skipPartialDays;
    private boolean noDaylight;

    public static void main(String[] args) throws IOException {
        TimeZone.setDefault(TimeZone.getTimeZone("Etc/GMT"));
        new TestMetazones().testAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testAll() throws IOException {
        try {
            this.noDaylight = CldrUtility.getProperty("nodaylight", null) != null;
            this.skipPartialDays = CldrUtility.getProperty("skippartialdays", null, "") != null;
            this.skipConsistency = CldrUtility.getProperty("skipconsistency", null, "") != null;
            String exemplarOutFile = CldrUtility.getProperty("log", null, CLDRPaths.GEN_DIRECTORY + "metazoneLog.txt");
            if (exemplarOutFile != null) {
                this.log = FileUtilities.openUTF8Writer("", exemplarOutFile);
            }
            String errorOutFile = CldrUtility.getProperty("errors", null, CLDRPaths.GEN_DIRECTORY + "metazoneErrors" + (this.noDaylight ? "-noDaylight" : "") + (this.skipPartialDays ? "-skipPartialDays" : "") + ".txt");
            this.errorLog = errorOutFile != null ? FileUtilities.openUTF8Writer("", errorOutFile) : new PrintWriter(System.out);
            for (String locale : this.factory.getAvailable()) {
                this.test(locale);
            }
        }
        finally {
            this.errorLog.println("Total Errors: " + this.errorCount);
            this.errorLog.println("Total Warnings: " + this.warningCount);
            if (this.log != null) {
                this.log.close();
            }
            if (this.errorLog != null) {
                this.errorLog.close();
            }
        }
    }

    void test(String locale) {
        CLDRFile file = this.factory.make(locale, false);
        if (!this.fileHasMetazones(file)) {
            return;
        }
        this.errorLog.println("Testing metazone info in: " + locale);
        file = this.factory.make(locale, true);
        Relation<String, DateRangeAndZone> mzoneToData = Relation.of(new TreeMap(), TreeSet.class);
        Relation<String, DateRangeAndZone> zoneToDateRanges = Relation.of(new TreeMap(), TreeSet.class);
        this.fillMetazoneData(file, mzoneToData, zoneToDateRanges);
        this.checkCoverage(zoneToDateRanges);
        this.checkGapsAndOverlaps(zoneToDateRanges);
        this.checkExemplars(mzoneToData, zoneToDateRanges);
        if (this.skipConsistency) {
            return;
        }
        this.checkMetazoneConsistency(mzoneToData);
    }

    private void fillMetazoneData(CLDRFile file, Relation<String, DateRangeAndZone> mzoneToData, Relation<String, DateRangeAndZone> zoneToDateRanges) {
        for (String path : file) {
            if (!path.contains("/usesMetazone")) continue;
            XPathParts parts = XPathParts.getFrozenInstance(path);
            String from = parts.getAttributeValue(-1, "from");
            long fromDate = DateRange.parse(from, false);
            String to = parts.getAttributeValue(-1, "to");
            long toDate = DateRange.parse(to, true);
            DateRange range = new DateRange(fromDate, toDate);
            String mzone = parts.getAttributeValue(-1, "mzone");
            String zone = parts.getAttributeValue(-2, "type");
            mzoneToData.put(mzone, new DateRangeAndZone(zone, range));
            zoneToDateRanges.put(zone, new DateRangeAndZone(mzone, range));
        }
    }

    private void checkMetazoneConsistency(Relation<String, DateRangeAndZone> mzoneToData) {
        this.errorLog.println();
        this.errorLog.println("*** Verify everything matches in metazones");
        this.errorLog.println();
        for (String mzone : mzoneToData.keySet()) {
            if (DEBUG) {
                this.errorLog.println(mzone);
            }
            Set<DateRangeAndZone> values = mzoneToData.getAll(mzone);
            if (DEBUG) {
                for (DateRangeAndZone value : values) {
                    this.errorLog.println("\t" + value);
                }
            }
            for (DateRangeAndZone value : values) {
                for (DateRangeAndZone value2 : values) {
                    OlsonTimeZone timezone2;
                    OlsonTimeZone timezone1;
                    List<Pair<Long, Long>> list;
                    DateRange overlap;
                    if (value2.compareTo(value) <= 0 || (overlap = value.range.getOverlap(value2.range)).getExtent() == 0L || (list = this.getDifferencesOverRange(timezone1 = new OlsonTimeZone(value.zone), timezone2 = new OlsonTimeZone(value2.zone), overlap)).size() == 0) continue;
                    this.errln("Zones " + this.showZone(value.zone) + " and " + this.showZone(value2.zone) + " shouldn't be in the same metazone <" + mzone + "> during the period " + overlap + ". Sample dates:\n\t" + this.showDifferences(timezone1, timezone2, list));
                }
            }
        }
    }

    private String showZone(String zone) {
        return zone + " [" + supplementalData.getZone_territory(zone) + "]";
    }

    String showDifferences(OlsonTimeZone zone1, OlsonTimeZone zone2, List<Pair<Long, Long>> list) {
        StringBuffer buffer = new StringBuffer();
        int count = 0;
        boolean abbreviating = list.size() > 7;
        long totalErrorPeriod = 0L;
        for (Pair<Long, Long> pair : list) {
            int endDelta;
            ++count;
            long start = pair.getFirst();
            long end = pair.getSecond();
            int startDelta = this.getOffset(zone1, start) - this.getOffset(zone2, start);
            if (startDelta != (endDelta = this.getOffset(zone1, end) - this.getOffset(zone2, end))) {
                this.showDeltas(zone1, zone2, start, end);
                throw new IllegalArgumentException();
            }
            long errorPeriod = end - start + 60000L;
            totalErrorPeriod += errorPeriod;
            if (abbreviating) {
                if (count == 4) {
                    buffer.append("...\n\t");
                }
                if (count >= 4 && count < list.size() - 2) continue;
            }
            buffer.append("delta=\t" + this.hours.format((double)startDelta / 3600000.0) + " hours:\t" + DateRange.format(start) + "\tto\t" + DateRange.format(end) + ";\ttotal:\t" + this.days.format((double)errorPeriod / 8.64E7) + " days\n\t");
        }
        buffer.append("\tTotal Period in Error:\t" + this.days.format((double)totalErrorPeriod / 8.64E7) + " days");
        return buffer.toString();
    }

    private void showDeltas(OlsonTimeZone zone1, OlsonTimeZone zone2, long start, long end) {
        this.errorLog.println(zone1.getID() + ", start: " + start + ", startOffset " + this.getOffset(zone1, start));
        this.errorLog.println(zone1.getID() + ", end: " + start + ", endOffset " + this.getOffset(zone1, end));
        this.errorLog.println(zone2.getID() + ", start: " + start + ", startOffset " + this.getOffset(zone2, start));
        this.errorLog.println(zone2.getID() + ", end: " + start + ", endOffset " + this.getOffset(zone2, end));
    }

    private List<Pair<Long, Long>> getDifferencesOverRange(OlsonTimeZone zone1, OlsonTimeZone zone2, DateRange overlap) {
        TreeSet<Long> list1 = new TreeSet<Long>();
        this.addTransitions(zone1, overlap, list1);
        this.addTransitions(zone2, overlap, list1);
        ArrayList<Long> list = new ArrayList<Long>();
        int lastDelta = 0;
        Iterator iterator = list1.iterator();
        while (iterator.hasNext()) {
            int offset2;
            long point = (Long)iterator.next();
            int offset1 = this.getOffset(zone1, point);
            int delta = offset1 - (offset2 = this.getOffset(zone2, point));
            if (delta == lastDelta) continue;
            list.add(point);
            lastDelta = delta;
        }
        ArrayList<Pair<Long, Long>> result = new ArrayList<Pair<Long, Long>>();
        long lastPoint = Long.MIN_VALUE;
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            long point = (Long)iterator2.next();
            if (lastPoint != Long.MIN_VALUE) {
                int endOffset2;
                int endOffset1;
                int endDelta;
                int startOffset2;
                int startOffset1;
                int startDelta;
                long start = lastPoint;
                long end = point - 60000L;
                if (DEBUG && start == 25678800000L && end == 33193740000L) {
                    this.errorLog.println("debugStop");
                    this.showDeltas(zone1, zone2, start, end);
                }
                if ((startDelta = (startOffset1 = this.getOffset(zone1, start)) - (startOffset2 = this.getOffset(zone2, start))) != (endDelta = (endOffset1 = this.getOffset(zone1, end)) - (endOffset2 = this.getOffset(zone2, end)))) {
                    throw new IllegalArgumentException("internal error");
                }
                if (!(startDelta == 0 || this.skipPartialDays && end - start < 86400000L)) {
                    result.add(new Pair<Long, Long>(start, end));
                }
            }
            lastPoint = point;
        }
        return result;
    }

    private int getOffset(OlsonTimeZone zone1, long point) {
        int offset1 = zone1.getOffset(point);
        if (this.noDaylight && zone1.inDaylightTime(new Date(point))) {
            offset1 -= 3600000;
        }
        return offset1;
    }

    private void addTransitions(OlsonTimeZone zone1, DateRange overlap, Set<Long> list) {
        long newTime;
        TimeZoneTransition transition;
        long startTime = overlap.startDate;
        long endTime = overlap.endDate;
        list.add(startTime);
        list.add(endTime);
        while ((transition = zone1.getNextTransition(startTime, false)) != null && (newTime = transition.getTime()) <= endTime) {
            list.add(newTime);
            startTime = newTime;
        }
    }

    private void checkGapsAndOverlaps(Relation<String, DateRangeAndZone> zoneToDateRanges) {
        this.errorLog.println();
        this.errorLog.println("*** Verify no gaps or overlaps in zones");
        for (String zone : zoneToDateRanges.keySet()) {
            if (DEBUG) {
                this.errorLog.println(zone);
            }
            Set<DateRangeAndZone> values = zoneToDateRanges.getAll(zone);
            long last = DateRange.MIN_DATE;
            for (DateRangeAndZone value : values) {
                if (DEBUG) {
                    this.errorLog.println("\t" + value);
                }
                this.checkGapOrOverlap(last, value.range.startDate);
                last = value.range.endDate;
            }
            this.checkGapOrOverlap(last, DateRange.MAX_DATE);
        }
    }

    private void checkExemplars(Relation<String, DateRangeAndZone> mzoneToData, Relation<String, DateRangeAndZone> zoneToData) {
        if (this.log != null) {
            this.log.println();
            this.log.println("Mapping from Zones to Metazones");
            this.log.println();
            for (String zone : zoneToData.keySet()) {
                this.log.println(zone);
                for (DateRangeAndZone value : zoneToData.getAll(zone)) {
                    this.log.println("\t" + value.zone + "\t" + value.range);
                }
            }
            this.log.println();
            this.log.println("Mapping from Metazones to Zones");
            this.log.println();
        }
        this.errorLog.println();
        this.errorLog.println("*** Verify that every metazone has at least one zone that is always in that metazone, over the span of the metazone's existance.");
        this.errorLog.println();
        Map<String, Map<String, String>> metazoneToRegionToZone = supplementalData.getMetazoneToRegionToZone();
        for (String mzone : mzoneToData.keySet()) {
            String bestZone;
            if (DEBUG) {
                this.errorLog.println(mzone);
            }
            if ((bestZone = metazoneToRegionToZone.get(mzone).get("001")) == null) {
                this.errorLog.println("Metazone <" + mzone + "> is missing a 'best zone' (for 001) in supplemental data.");
            }
            Set<DateRangeAndZone> values = mzoneToData.getAll(mzone);
            TreeMap<String, DateRanges> zoneToRanges = new TreeMap<String, DateRanges>();
            DateRanges mzoneRanges = new DateRanges();
            for (DateRangeAndZone value : values) {
                DateRanges ranges = (DateRanges)zoneToRanges.get(value.zone);
                if (ranges == null) {
                    ranges = new DateRanges();
                    zoneToRanges.put(value.zone, ranges);
                }
                ranges.add(value.range);
                mzoneRanges.add(value.range);
            }
            if (bestZone != null && !zoneToRanges.keySet().contains(bestZone)) {
                zoneToRanges.keySet().contains(bestZone);
                this.errorLog.println("The 'best zone' (" + this.showZone(bestZone) + ") for the metazone <" + mzone + "> is not in the metazone!");
            }
            int count = 0;
            if (this.log != null) {
                this.log.println(mzone + ":\t" + mzoneRanges);
            }
            for (String zone : zoneToRanges.keySet()) {
                boolean isComplete = mzoneRanges.equals(zoneToRanges.get(zone));
                if (zone.equals(bestZone) && !isComplete) {
                    this.errorLog.println("The 'best zone' (" + this.showZone(bestZone) + ") for the metazone <" + mzone + "> is only partially in the metazone!");
                }
                if (isComplete) {
                    ++count;
                }
                if (this.log == null) continue;
                this.log.println("\t" + zone + ":\t" + supplementalData.getZone_territory(zone) + "\t" + zoneToRanges.get(zone) + (isComplete ? "" : "\t\tPartial"));
            }
            if (count != 0) continue;
            this.errln("Metazone <" + mzone + "> does not have exemplar for whole span: " + mzoneRanges);
            for (DateRangeAndZone value : values) {
                this.errorLog.println("\t" + mzone + ":\t" + value);
                for (DateRangeAndZone mvalues : zoneToData.getAll(value.zone)) {
                    this.errorLog.println("\t\t\t" + this.showZone(value.zone) + ":\t" + mvalues);
                }
            }
            this.errorLog.println("=====");
            for (String zone : zoneToRanges.keySet()) {
                this.errorLog.println("\t\t\t" + zone + ":\t" + zoneToRanges.get(zone));
            }
        }
    }

    private void checkCoverage(Relation<String, DateRangeAndZone> zoneToDateRanges) {
        this.errorLog.println();
        this.errorLog.println("*** Verify coverage of canonical zones");
        this.errorLog.println();
        Set<String> canonicalZones = supplementalData.getCanonicalZones();
        TreeSet<String> missing = new TreeSet<String>(canonicalZones);
        missing.removeAll(zoneToDateRanges.keySet());
        Iterator it = missing.iterator();
        while (it.hasNext()) {
            String value = (String)it.next();
            if (!value.startsWith("Etc/")) continue;
            it.remove();
        }
        if (missing.size() != 0) {
            this.errln("Missing canonical zones: " + missing);
        }
        TreeSet<String> extras = new TreeSet<String>(zoneToDateRanges.keySet());
        extras.removeAll(canonicalZones);
        if (extras.size() != 0) {
            this.errln("Superfluous  zones (not canonical): " + extras);
        }
    }

    private void checkGapOrOverlap(long last, long nextDate) {
        if (last != nextDate) {
            if (last < nextDate) {
                this.warnln("Gap in coverage: " + DateRange.format(last) + ", " + DateRange.format(nextDate));
            } else {
                this.errln("Overlap in coverage: " + DateRange.format(last) + ", " + DateRange.format(nextDate));
            }
        }
    }

    private void errln(String string) {
        this.errorLog.println("ERROR: " + string);
        ++this.errorCount;
    }

    private void warnln(String string) {
        this.errorLog.println("WARNING: " + string);
        ++this.warningCount;
    }

    boolean fileHasMetazones(CLDRFile file) {
        for (String path : file) {
            if (!path.contains("usesMetazone")) continue;
            return true;
        }
        return false;
    }

    static class DateRange
    implements Comparable<DateRange> {
        long startDate;
        long endDate;
        static DateFormat iso1 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        static DateFormat iso2 = new SimpleDateFormat("yyyy-MM-dd");
        static long MIN_DATE = DateRange.getDateTimeinMillis(70, 0, 1, 0, 0, 0);
        static long MAX_DATE = DateRange.getDateTimeinMillis(110, 0, 1, 0, 0, 0);

        public DateRange(String startDate, String endDate) {
            this(DateRange.parse(startDate, false), DateRange.parse(endDate, true));
        }

        public boolean containsAll(DateRange otherRange) {
            return this.startDate <= otherRange.startDate && otherRange.endDate <= this.endDate;
        }

        public boolean containsNone(DateRange otherRange) {
            return this.startDate > otherRange.endDate || otherRange.startDate > this.endDate;
        }

        public boolean containsSome(DateRange otherRange) {
            return this.startDate <= otherRange.endDate && otherRange.startDate <= this.endDate;
        }

        public DateRange(long startDate, long endDate) {
            this.startDate = startDate;
            this.endDate = endDate;
        }

        public long getExtent() {
            return this.endDate - this.startDate;
        }

        public DateRange getOverlap(DateRange other) {
            long end;
            long start = this.startDate;
            if (start < other.startDate) {
                start = other.startDate;
            }
            if ((end = this.endDate) > other.endDate) {
                end = other.endDate;
            }
            if (end < start) {
                end = start;
            }
            return new DateRange(start, end);
        }

        public DateRange getUnion(DateRange other) {
            long end;
            long start = this.startDate;
            if (start > other.startDate) {
                start = other.startDate;
            }
            if ((end = this.endDate) < other.endDate) {
                end = other.endDate;
            }
            if (end < start) {
                end = start;
            }
            return new DateRange(start, end);
        }

        static long parse(String date, boolean end) {
            if (date == null) {
                return end ? MAX_DATE : MIN_DATE;
            }
            try {
                return iso1.parse(date).getTime();
            }
            catch (ParseException e) {
                try {
                    return iso2.parse(date).getTime();
                }
                catch (ParseException e2) {
                    throw new IllegalArgumentException("unexpected error in data", e);
                }
            }
        }

        @Override
        public int compareTo(DateRange other) {
            if (this.startDate < other.startDate) {
                return -1;
            }
            if (this.startDate > other.startDate) {
                return 1;
            }
            if (this.endDate < other.endDate) {
                return -1;
            }
            if (this.endDate > other.endDate) {
                return 1;
            }
            return 0;
        }

        private static long getDateTimeinMillis(int year, int month, int date, int hourOfDay, int minute, int second) {
            Calendar cal = Calendar.getInstance();
            cal.set(year, month, date, hourOfDay, minute, second);
            return cal.getTimeInMillis();
        }

        public String toString() {
            return "{" + DateRange.format(this.startDate) + " to " + DateRange.format(this.endDate) + "}";
        }

        public static String format(Date date) {
            return iso1.format(date);
        }

        public static String format(long date) {
            return DateRange.format(new Date(date));
        }
    }

    static class DateRanges {
        Set<DateRange> contents = new TreeSet<DateRange>();

        DateRanges() {
        }

        public void add(DateRange o) {
            boolean madeFix;
            this.contents.add(o);
            do {
                madeFix = false;
                DateRange last = null;
                for (DateRange range : this.contents) {
                    if (last != null && last.containsSome(range)) {
                        madeFix = true;
                        DateRange newRange = last.getUnion(range);
                        this.contents.remove(last);
                        this.contents.remove(range);
                        this.contents.add(newRange);
                    }
                    last = range;
                }
            } while (madeFix);
        }

        boolean contains(DateRanges other) {
            for (DateRange otherRange : other.contents) {
                if (this.contains(otherRange)) continue;
                return false;
            }
            return true;
        }

        private boolean contains(DateRange otherRange) {
            for (DateRange range : this.contents) {
                if (range.containsAll(otherRange)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object other) {
            return this.contents.equals(((DateRanges)other).contents);
        }

        public int hashCode() {
            return this.contents.hashCode();
        }

        public String toString() {
            return this.contents.toString();
        }
    }

    static class DateRangeAndZone
    implements Comparable<DateRangeAndZone> {
        DateRange range;
        String zone;

        public DateRangeAndZone(String zone, String startDate, String endDate) {
            this(zone, new DateRange(startDate, endDate));
        }

        public DateRangeAndZone(String zone, DateRange range) {
            this.range = range;
            this.zone = zone;
        }

        @Override
        public int compareTo(DateRangeAndZone other) {
            int result = this.range.compareTo(other.range);
            if (result != 0) {
                return result;
            }
            return this.zone.compareTo(other.zone);
        }

        public String toString() {
            return "{" + this.range + " => " + this.zone + "}";
        }
    }
}

