/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.util.VersionInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.Counter2;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.RegexLookup;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.TempPrintWriter;
import org.unicode.cldr.util.VettingViewer;

public class ChartLocaleGrowth {
    private static final boolean DEBUG = true;
    private static final char DEBUG_FILTER = '\u0000';
    private static CLDRConfig testInfo = ToolConfig.getToolInstance();
    private static final SupplementalDataInfo SUPPLEMENTAL_DATA_INFO = testInfo.getSupplementalDataInfo();
    static final Set<String> CldrModernLocales = StandardCodes.make().getLocaleCoverageLocales(Organization.cldr, Set.of(Level.MODERN));
    static final Set<String> SpecialLocales = StandardCodes.make().getLocaleCoverageLocales(Organization.special, Set.of(Level.MODERN));
    private static Factory factory = testInfo.getCommonAndSeedAndMainAndAnnotationsFactory();
    private static final CLDRFile ENGLISH = testInfo.getEnglish();
    private static final RegexLookup<Boolean> COUNT_AS_MISSING_WHEN_ABSENT = RegexLookup.of(RegexLookup.LookupType.STANDARD, RegexLookup.RegexFinderTransformPath).add("//ldml/localeDisplayNames/keys/key[@type=\"(d0|em|fw|i0|k0|lw|m0|rg|s0|ss|t0|x0)\"]", Boolean.valueOf(true)).add("//ldml/localeDisplayNames/types/type[@key=\"(em|fw|kr|lw|ss)\"].*", (Boolean)true).add("//ldml/localeDisplayNames/languages/language[@type=\".*_.*\"]", (Boolean)true).add("//ldml/localeDisplayNames/languages/language[@type=\".*\"][@alt=\".*\"]", (Boolean)true).add("//ldml/localeDisplayNames/territories/territory[@type=\".*\"][@alt=\".*\"]", (Boolean)true).add("//ldml/localeDisplayNames/territories/territory[@type=\"EZ\"]", (Boolean)true);
    static final Option.Options myOptions = new Option.Options();
    private static final PathHeader.Factory pathHeaderFactory = PathHeader.getFactory(ENGLISH);
    private static final List<ReleaseInfo> versionToYear;

    /*
     * Exception decompiling
     */
    public static void main(String[] args) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void doGrowth(Matcher localeMatcher, Matcher versionMatcher, TempPrintWriter out, TempPrintWriter log, TempPrintWriter logPaths) {
        TreeMap<String, List<Double>> growthData = new TreeMap<String, List<Double>>(Ordering.natural().reverse());
        Map<String, FoundAndTotal> latestData = null;
        ReleaseInfo last = versionToYear.get(0);
        for (ReleaseInfo versionNormalizedVersionAndYear : versionToYear) {
            if (versionMatcher != null && !versionMatcher.reset(versionNormalizedVersionAndYear.version.getVersionString(1, 2)).matches()) continue;
            VersionInfo version = versionNormalizedVersionAndYear.version;
            int year = versionNormalizedVersionAndYear.year;
            String dir = ToolConstants.getBaseDirectory(version.getVersionString(2, 3));
            boolean showMissing = last == versionNormalizedVersionAndYear;
            Map<String, FoundAndTotal> currentData = ChartLocaleGrowth.addGrowth(factory, dir, localeMatcher, showMissing, log, logPaths);
            long found = 0L;
            long total = 0L;
            for (Map.Entry<String, FoundAndTotal> entry : currentData.entrySet()) {
                found += entry.getValue().found;
                total += entry.getValue().total;
            }
            System.out.println("year\t" + year + "\tversion\t" + version + "\tlocales\t" + currentData.size() + "\tfound\t" + found + "\ttotal\t" + total + "\tdetails\t" + currentData);
            out.flush();
            if (latestData == null) {
                latestData = currentData;
            }
            Counter2<String> completionData = ChartLocaleGrowth.getCompletion(latestData, currentData);
            ChartLocaleGrowth.addCompletionList("" + year, completionData, growthData);
            System.out.println(currentData);
        }
        boolean first = true;
        for (Map.Entry entry : growthData.entrySet()) {
            if (first) {
                for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                    out.print("\t" + i);
                }
                out.println();
                first = false;
            }
            out.println((String)entry.getKey() + "\t" + Joiner.on("\t").join((Iterable)entry.getValue()));
        }
    }

    private static void addCompletionList(String version, Counter2<String> completionData, TreeMap<String, List<Double>> growthData) {
        ArrayList<Double> x = new ArrayList<Double>();
        for (String key : completionData.getKeysetSortedByCount(false)) {
            x.add(completionData.getCount(key));
        }
        growthData.put(version, x);
        System.out.println(version + "\t" + x.size());
    }

    private static Counter2<String> getCompletion(Map<String, FoundAndTotal> latestData, Map<String, FoundAndTotal> currentData) {
        Counter2<String> completionData = new Counter2<String>();
        for (Map.Entry<String, FoundAndTotal> entry : latestData.entrySet()) {
            double total;
            String locale = entry.getKey();
            FoundAndTotal currentRecord = currentData.get(locale);
            if (currentRecord == null || (total = (double)entry.getValue().total) == 0.0) continue;
            double completion = (double)currentRecord.found / total;
            completionData.add(locale, completion);
        }
        return completionData;
    }

    private static Map<String, FoundAndTotal> addGrowth(Factory latestFactory, String dir, Matcher localeMatcher, boolean showMissing, TempPrintWriter log, TempPrintWriter logPaths) {
        File[] fileArray;
        File mainDir = new File(dir + "/common/main/");
        File annotationDir = new File(dir + "/common/annotations/");
        if (annotationDir.exists()) {
            File[] fileArray2 = new File[2];
            fileArray2[0] = mainDir;
            fileArray = fileArray2;
            fileArray2[1] = annotationDir;
        } else {
            File[] fileArray3 = new File[1];
            fileArray = fileArray3;
            fileArray3[0] = mainDir;
        }
        File[] paths = fileArray;
        Factory newFactory = SimpleFactory.make(paths, ".*");
        HashMap<String, FoundAndTotal> data = new HashMap<String, FoundAndTotal>();
        char c = '\u0000';
        Set<String> latestAvailable = newFactory.getAvailableLanguages();
        boolean firstShowMissing = true;
        for (String locale : newFactory.getAvailableLanguages()) {
            if (!localeMatcher.reset(locale).matches() || !latestAvailable.contains(locale) || SUPPLEMENTAL_DATA_INFO.getDefaultContentLocales().contains(locale) || locale.equals("root") || locale.equals("und") || locale.equals("supplementalData")) continue;
            char nc = locale.charAt(0);
            if (nc != c) {
                System.out.println("\t" + locale);
                c = nc;
            }
            CLDRFile latestFile = null;
            try {
                latestFile = latestFactory.make(locale, true);
            }
            catch (Exception e2) {
                System.out.println("Can't make latest CLDRFile for: " + locale + "\tpast: " + mainDir + "\tlatest: " + Arrays.asList(latestFactory.getSourceDirectories()));
                continue;
            }
            CLDRFile file = null;
            try {
                file = newFactory.make(locale, true);
            }
            catch (Exception e2) {
                System.out.println("Can't make CLDRFile for: " + locale + "\tpast: " + mainDir);
                continue;
            }
            Counter<Level> foundCounter = new Counter<Level>();
            Counter<Level> unconfirmedCounter = new Counter<Level>();
            Counter<Level> missingCounter = new Counter<Level>();
            LinkedHashSet<String> unconfirmedPaths = null;
            Relation<VettingViewer.MissingStatus, String> missingPaths = null;
            unconfirmedPaths = new LinkedHashSet<String>();
            missingPaths = Relation.of(new LinkedHashMap(), LinkedHashSet.class);
            VettingViewer.getStatus(latestFile.fullIterable(), file, pathHeaderFactory, foundCounter, unconfirmedCounter, missingCounter, missingPaths, unconfirmedPaths);
            if (showMissing && CldrModernLocales.contains(locale)) {
                boolean isSpecial = SpecialLocales.contains(locale);
                if (firstShowMissing) {
                    firstShowMissing = false;
                    log.printlnWithTabs(16, "Locale\tTC\tCore\tUnc\tMiss\tBasic\tUnc\tMiss\tModer\tUnc\tMiss\tModern\tUnc\tMiss\tTotal\tUnc\tMiss");
                    logPaths.printlnWithTabs(3, "Locale\tLevel\tStatus\tPath");
                }
                log.printlnWithTabs(16, locale + "\t" + (isSpecial ? "" : "TC") + ChartLocaleGrowth.show(Level.CORE, foundCounter, unconfirmedCounter, missingCounter) + ChartLocaleGrowth.show(Level.BASIC, foundCounter, unconfirmedCounter, missingCounter) + ChartLocaleGrowth.show(Level.MODERATE, foundCounter, unconfirmedCounter, missingCounter) + ChartLocaleGrowth.show(Level.MODERN, foundCounter, unconfirmedCounter, missingCounter) + ChartLocaleGrowth.show(null, foundCounter, unconfirmedCounter, missingCounter));
                if (!isSpecial) {
                    long count = unconfirmedCounter.getTotal() + missingCounter.getTotal();
                    for (Map.Entry<VettingViewer.MissingStatus, String> statusAndPath : missingPaths.entrySet()) {
                        logPaths.printlnWithTabs(3, locale + "\t" + count + "\t" + (Object)((Object)statusAndPath.getKey()) + "\t" + statusAndPath.getValue());
                    }
                    for (String path : unconfirmedPaths) {
                        logPaths.printlnWithTabs(3, locale + "\t" + count + "\tunconfirmed\t" + path);
                    }
                }
                boolean bl = false;
            }
            HashSet<Map.Entry<VettingViewer.MissingStatus, String>> missingRemovals = new HashSet<Map.Entry<VettingViewer.MissingStatus, String>>();
            for (Map.Entry<VettingViewer.MissingStatus, String> e : missingPaths.keyValueSet()) {
                if (e.getKey() != VettingViewer.MissingStatus.ABSENT) continue;
                String path = e.getValue();
                if (COUNT_AS_MISSING_WHEN_ABSENT.get(path) != null) {
                    missingRemovals.add(e);
                    missingCounter.add(Level.MODERN, -1L);
                    foundCounter.add(Level.MODERN, 1L);
                    continue;
                }
                CLDRFile.Status status = new CLDRFile.Status();
                String loc = file.getSourceLocaleID(path, status);
                boolean bl = false;
            }
            for (Map.Entry<VettingViewer.MissingStatus, String> e : missingRemovals) {
                missingPaths.remove(e.getKey(), e.getValue());
            }
            data.put(locale, new FoundAndTotal(foundCounter, unconfirmedCounter, missingCounter));
        }
        return Collections.unmodifiableMap(data);
    }

    private static String show(Level level, Counter<Level> foundCounter, Counter<Level> unconfirmedCounter, Counter<Level> missingCounter) {
        return "\t" + (level != null ? foundCounter.get(level) : foundCounter.getTotal()) + "\t" + (level != null ? unconfirmedCounter.get(level) : unconfirmedCounter.getTotal()) + "\t" + (level != null ? missingCounter.get(level) : missingCounter.getTotal());
    }

    static {
        Object[][] mapping = new Object[][]{{VersionInfo.getInstance(46), 2024}, {VersionInfo.getInstance(44), 2023}, {VersionInfo.getInstance(42), 2022}, {VersionInfo.getInstance(40), 2021}, {VersionInfo.getInstance(38), 2020}, {VersionInfo.getInstance(36), 2019}, {VersionInfo.getInstance(34), 2018}, {VersionInfo.getInstance(32), 2017}, {VersionInfo.getInstance(30), 2016}, {VersionInfo.getInstance(28), 2015}, {VersionInfo.getInstance(26), 2014}, {VersionInfo.getInstance(24), 2013}, {VersionInfo.getInstance(22, 1), 2012}, {VersionInfo.getInstance(2, 0, 1), 2011}, {VersionInfo.getInstance(1, 9, 1), 2010}, {VersionInfo.getInstance(1, 7, 2), 2009}, {VersionInfo.getInstance(1, 6, 1), 2008}, {VersionInfo.getInstance(1, 5, 1), 2007}, {VersionInfo.getInstance(1, 4, 1), 2006}, {VersionInfo.getInstance(1, 3), 2005}, {VersionInfo.getInstance(1, 2), 2004}, {VersionInfo.getInstance(1, 1, 1), 2003}};
        ArrayList<ReleaseInfo> _versionToYear = new ArrayList<ReleaseInfo>();
        for (Object[] row : mapping) {
            _versionToYear.add(new ReleaseInfo((VersionInfo)row[0], (Integer)row[1]));
        }
        versionToYear = ImmutableList.copyOf(_versionToYear);
    }

    private static class FoundAndTotal {
        final long found;
        final long total;

        @SafeVarargs
        private FoundAndTotal(Counter<Level> ... counters) {
            long[] count = new long[]{0L, 0L, 0L};
            for (Level level : Level.values()) {
                if (level == Level.COMPREHENSIVE) continue;
                int i = 0;
                for (Counter<Level> counter : counters) {
                    int n = i++;
                    count[n] = count[n] + counter.get(level);
                }
            }
            this.found = count[0];
            this.total = this.found + count[1] + count[2];
        }

        public String toString() {
            return this.found + "/" + this.total;
        }
    }

    private static final class ReleaseInfo {
        VersionInfo version;
        int year;

        private ReleaseInfo(VersionInfo versionInfo, int year) {
            this.version = versionInfo;
            this.year = year;
        }
    }

    private static enum MyOptions {
        filter(".+", ".*", "Filter the information based on locale, using a regex argument."),
        Versions(".+", ".*", "Filter the information based on cldr version, using a regex argument.");

        final Option option;

        private MyOptions(String argumentPattern, String defaultArgument, String helpText) {
            this.option = myOptions.add(this, (Object)argumentPattern, defaultArgument, helpText);
        }
    }
}

