/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CalculatedCoverageLevels;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.TempPrintWriter;

public class GenerateDateTimeTestData {
    private static final String OUTPUT_SUBDIR = "datetime";
    private static final String OUTPUT_FILENAME = "datetime.json";
    private static final SupplementalDataInfo SUPPLEMENTAL_DATA_INFO = SupplementalDataInfo.getInstance();
    private static final CLDRConfig CLDR_CONFIG = CLDRConfig.getInstance();
    private static final Factory CLDR_FACTORY = CLDR_CONFIG.getCldrFactory();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Set<String> CLDR_DATE_TIME_FORMAT_TYPES = ImmutableSet.of("standard", "atTime");
    private static final ImmutableSet<String> NUMBERING_SYSTEMS = ImmutableSet.of("latn", "arab", "beng");
    private static final ImmutableSet<String> LOCALES = ImmutableSet.of("en_US", "en_GB", "zh_Hant_TW", "vi", "ar", "mt_MT", new String[]{"bn", "zu"});
    private static final ImmutableSet<ImmutableMap<Object, Object>> FIELD_STYLE_COMBINATIONS = ImmutableSet.of(GenerateDateTimeTestData.newMapStringToObjectBuilder().put("dateLength", "short").put("timeLength", "short").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("dateLength", "medium").put("timeLength", "medium").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("dateLength", "long").put("timeLength", "long").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("dateLength", "full").put("timeLength", "full").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("dateLength", "full").put("timeLength", "short").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("dateLength", "long").build(), new ImmutableMap[]{GenerateDateTimeTestData.newMapStringToObjectBuilder().put("timeLength", "long").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("hour", "numeric").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("hour", "numeric").put("minute", "numeric").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("hour", "numeric").put("minute", "numeric").put("second", "numeric").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("hour", "numeric").put("minute", "numeric").put("second", "numeric").put("fractionalSecondDigits", 1).build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("hour", "numeric").put("minute", "numeric").put("second", "numeric").put("fractionalSecondDigits", 2).build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("hour", "numeric").put("minute", "numeric").put("second", "numeric").put("fractionalSecondDigits", 3).build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("hour", "numeric").put("minute", "numeric").put("second", "numeric").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("month", "numeric").put("weekday", "long").put("day", "numeric").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("month", "2-digit").put("weekday", "long").put("day", "numeric").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("month", "long").put("weekday", "long").put("day", "numeric").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("month", "short").put("weekday", "long").put("day", "numeric").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("month", "narrow").put("weekday", "long").put("day", "numeric").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("month", "short").put("weekday", "short").put("day", "numeric").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("month", "short").put("weekday", "narrow").put("day", "numeric").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("era", "long").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("era", "short").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("era", "narrow").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("timeZoneName", "long").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("timeZoneName", "short").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("timeZoneName", "shortOffset").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("timeZoneName", "longOffset").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("timeZoneName", "shortGeneric").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("timeZoneName", "longGeneric").build()});
    private static final ImmutableSet<String> CALENDARS = ImmutableSet.of("gregorian", "buddhist", "hebrew", "chinese", "roc", "japanese", new String[]{"islamic", "islamic-umalqura", "persian"});
    private static final ImmutableSet<String> TIME_ZONES = ImmutableSet.of("America/Los_Angeles", "Africa/Luanda", "Asia/Tehran", "Europe/Kiev", "Australia/Brisbane", "Pacific/Palau", new String[]{"America/Montevideo"});
    private static final ImmutableSet<ZonedDateTime> JAVA_TIME_ZONED_DATE_TIMES = ImmutableSet.of(LocalDate.parse("2024-03-17").atStartOfDay(ZoneId.of(ZoneOffset.UTC.getId())), Instant.parse("2001-07-02T13:14:15.00Z").atZone(ZoneOffset.UTC), Instant.parse("1984-05-29T07:53:00.00Z").atZone(ZoneOffset.UTC), Instant.parse("2050-05-29T16:47:00.00Z").atZone(ZoneOffset.UTC), LocalDate.parse("1969-07-16").atStartOfDay(ZoneId.of(ZoneOffset.UTC.getId())), Instant.ofEpochMilli(1000000000L).atZone(ZoneOffset.UTC), new ZonedDateTime[]{Instant.ofEpochMilli(1000000000000L).atZone(ZoneOffset.UTC)});
    private static final ImmutableSet<ImmutableMap<Object, Object>> TEMPORAL_DATES = ImmutableSet.of(GenerateDateTimeTestData.newMapStringToObjectBuilder().put("timeZone", "America/Los_Angeles").put("year", 2024).put("month", 3).put("day", 7).put("hour", 0).put("minute", 0).put("second", 1).put("millisecond", 0).put("microsecond", 0).put("nanosecond", 0).put("calendar", "gregory").build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("timeZone", "America/Los_Angeles").put("year", 2001).put("month", 7).put("day", 2).put("hour", 13).put("minute", 14).put("second", 15).put("millisecond", 0).put("microsecond", 0).put("nanosecond", 0).build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("timeZone", "America/Los_Angeles").put("year", 1984).put("month", 5).put("day", 29).put("hour", 7).put("minute", 53).put("second", 0).put("millisecond", 0).put("microsecond", 0).put("nanosecond", 0).build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("timeZone", "America/Los_Angeles").put("year", 2030).put("month", 5).put("day", 29).put("hour", 16).put("minute", 47).put("second", 0).put("millisecond", 0).put("microsecond", 0).put("nanosecond", 0).build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("timeZone", "America/Los_Angeles").put("year", 1969).put("month", 7).put("day", 16).put("hour", 0).put("minute", 0).put("second", 0).put("millisecond", 0).put("microsecond", 0).put("nanosecond", 0).build(), GenerateDateTimeTestData.newMapStringToObjectBuilder().put("timeZone", "America/Los_Angeles").put("year", 1970).put("month", 1).put("day", 12).put("hour", 13).put("minute", 46).put("second", 40).put("millisecond", 0).put("microsecond", 0).put("nanosecond", 0).build(), new ImmutableMap[]{GenerateDateTimeTestData.newMapStringToObjectBuilder().put("timeZone", "America/Los_Angeles").put("year", 2001).put("month", 9).put("day", 9).put("hour", 1).put("minute", 46).put("second", 40).put("millisecond", 0).put("microsecond", 0).put("nanosecond", 0).build()});
    private static final ImmutableMap<Object, ImmutableMap<Object, Object>> FIELD_STYLE_TO_SKELETON = GenerateDateTimeTestData.newMapStringToMapBuilder().put("era", GenerateDateTimeTestData.newMapStringToObjectBuilder().put("long", "GGGG").put("short", "GG").put("narrow", "GGGGG").build()).put("year", GenerateDateTimeTestData.newMapStringToObjectBuilder().put("numeric", "y").put("2-digit", "yy").build()).put("quarter", GenerateDateTimeTestData.newMapStringToObjectBuilder().put("numeric", "q").build()).put("month", GenerateDateTimeTestData.newMapStringToObjectBuilder().put("numeric", "M").put("2-digit", "MM").put("long", "MMMM").put("short", "MMM").put("narrow", "MMMMM").build()).put("weekday", GenerateDateTimeTestData.newMapStringToObjectBuilder().put("long", "EEEE").put("short", "E").put("narrow", "EEEEE").build()).put("day", GenerateDateTimeTestData.newMapStringToObjectBuilder().put("numeric", "d").put("2-digit", "dd").build()).put("hour", GenerateDateTimeTestData.newMapStringToObjectBuilder().put("numeric", "j").build()).put("minute", GenerateDateTimeTestData.newMapStringToObjectBuilder().put("numeric", "m").build()).put("second", GenerateDateTimeTestData.newMapStringToObjectBuilder().put("numeric", "s").build()).put("fractionalSecondDigits", GenerateDateTimeTestData.newMapStringToObjectBuilder().put(1, "S").put(2, "SS").put(3, "SSS").build()).put("timeZoneName", GenerateDateTimeTestData.newMapStringToObjectBuilder().put("short", "z").put("long", "zzzz").put("shortOffset", "O").put("longOffset", "OOOO").put("shortGeneric", "v").put("longGeneric", "vvvv").build()).build();

    private static final ImmutableMap.Builder<Object, Object> newMapStringToObjectBuilder() {
        return ImmutableMap.builder();
    }

    private static final ImmutableMap.Builder<Object, ImmutableMap<Object, Object>> newMapStringToMapBuilder() {
        return ImmutableMap.builder();
    }

    private static String fieldStyleCombinationToSkeleton(Map<Object, Object> styleCombination) {
        ArrayList<String> skeletonArray = new ArrayList<String>();
        for (Object dtField : styleCombination.keySet()) {
            if (dtField.equals("dateLength") || dtField.equals("timeLength") || !FIELD_STYLE_TO_SKELETON.containsKey(dtField)) continue;
            String styleValue = (String)styleCombination.get(dtField);
            Map styleToSkeleton = FIELD_STYLE_TO_SKELETON.get(dtField);
            if (!styleToSkeleton.containsKey(styleValue)) continue;
            skeletonArray.add(styleValue);
        }
        return String.join((CharSequence)"", skeletonArray);
    }

    private static Set<String> getLocaleNumberingSystems(CLDRFile localeFile) {
        HashSet<String> result = new HashSet<String>();
        for (CLDRFile.NumberingSystem system : CLDRFile.NumberingSystem.values()) {
            String numberingSystem;
            String string = numberingSystem = system.path == null ? "latn" : localeFile.getStringValue(system.path);
            if (numberingSystem == null) continue;
            result.add(numberingSystem);
        }
        return result;
    }

    private static ZonedDateTime getZonedDateTimeFromTemporalDateInput(Map<Object, Object> input) {
        if (!input.containsKey("year")) {
            return null;
        }
        if (!input.containsKey("month")) {
            return null;
        }
        if (!input.containsKey("day")) {
            return null;
        }
        if (input.containsKey("calendar") && !((String)input.get("calendar")).equals("gregory")) {
            return null;
        }
        int year = (Integer)input.get("year");
        int monthInt = (Integer)input.get("month");
        int day = (Integer)input.get("day");
        Month month = Month.of(monthInt);
        int hour = (Integer)input.getOrDefault("hour", 0);
        int minute = (Integer)input.getOrDefault("minute", 0);
        int second = (Integer)input.getOrDefault("second", 0);
        int millisecond = (Integer)input.getOrDefault("millisecond", 0);
        int microsecond = (Integer)input.getOrDefault("microsecond", 0);
        int nanosecondOrig = (Integer)input.getOrDefault("nanosecond", 0);
        int nanosecond = (millisecond * 1000 + microsecond) * 1000 + nanosecondOrig;
        String timeZoneIdStr = (String)input.getOrDefault("timeZone", "UTC");
        ZoneId timeZoneId = ZoneId.of(timeZoneIdStr);
        LocalDateTime localDt = LocalDateTime.of(year, month, day, hour, minute, second, nanosecond);
        return ZonedDateTime.of(localDt, timeZoneId);
    }

    private static final Optional<CLDRFile> getCLDRFile(String locale) {
        CLDRFile cldrFile = CLDR_FACTORY.make(locale, true, CLDRFile.DraftStatus.contributed);
        Level coverageLevel = CalculatedCoverageLevels.getInstance().getEffectiveCoverageLevel(locale);
        if (coverageLevel == null || !coverageLevel.isAtLeast(Level.MODERN)) {
            return Optional.empty();
        }
        return Optional.of(cldrFile);
    }

    private static String getDateLength(Map<Object, Object> optionsMap) {
        String length = null;
        if (optionsMap.containsKey("dateLength")) {
            length = (String)optionsMap.get("dateLength");
        }
        return length;
    }

    private static String getTimeLength(Map<Object, Object> optionsMap) {
        String length = null;
        if (optionsMap.containsKey("timeLength")) {
            length = (String)optionsMap.get("timeLength");
        }
        return length;
    }

    private static List<ImmutableMap<Object, Object>> getTestCasesForZonedDateTime(ICUServiceBuilder icuServiceBuilder, CLDRFile localeCldrFile, ImmutableMap<Object, Object> options, ImmutableMap.Builder<Object, Object> optionsBuilder, ZonedDateTime zdt, String calendar, SimpleDateFormat dateFormatter, SimpleDateFormat timeFormatter, String dateLength) {
        optionsBuilder.put("input", zdt.toString());
        if (dateFormatter == null) {
            String formattedDateTime = timeFormatter.format(zdt);
            optionsBuilder.put("expected", formattedDateTime);
            return ImmutableList.of(optionsBuilder.buildKeepingLast());
        }
        if (timeFormatter == null) {
            String formattedDateTime = dateFormatter.format(zdt);
            optionsBuilder.put("expected", formattedDateTime);
            return ImmutableList.of(optionsBuilder.buildKeepingLast());
        }
        String formattedDate = dateFormatter.format(zdt);
        String formattedTime = timeFormatter.format(zdt);
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (String dateTimeGluePatternFormatType : CLDR_DATE_TIME_FORMAT_TYPES) {
            String formattedDateTime = localeCldrFile.glueDateTimeFormat(formattedDate, formattedTime, calendar, dateLength, dateTimeGluePatternFormatType, icuServiceBuilder);
            optionsBuilder.put("dateTimeFormatType", dateTimeGluePatternFormatType);
            optionsBuilder.put("expected", formattedDateTime);
            resultBuilder.add(optionsBuilder.buildKeepingLast());
        }
        return resultBuilder.build();
    }

    private static Collection<Map<Object, Object>> generateAllTestCases() {
        LinkedList<Map<Object, Object>> result = new LinkedList<Map<Object, Object>>();
        for (String localeStr : LOCALES) {
            ULocale locale = new ULocale(localeStr);
            CLDRFile localeCldrFile = GenerateDateTimeTestData.getCLDRFile(localeStr).orElse(null);
            if (localeCldrFile == null) continue;
            ICUServiceBuilder icuServiceBuilder = new ICUServiceBuilder();
            icuServiceBuilder.clearCache();
            icuServiceBuilder.setCldrFile(localeCldrFile);
            ULocale maximizedLoc = ULocale.addLikelySubtags(locale);
            String region = maximizedLoc.getCountry();
            List<String> localePreferredCalendars = SUPPLEMENTAL_DATA_INFO.getCalendars(region);
            if (localePreferredCalendars == null) {
                localePreferredCalendars = SUPPLEMENTAL_DATA_INFO.getCalendars("001");
            }
            for (String calendar : CALENDARS) {
                if (!localePreferredCalendars.contains(calendar)) continue;
                for (Map map : FIELD_STYLE_COMBINATIONS) {
                    if (map.containsKey("era") && calendar.equals("chinese") || !map.containsKey("dateLength") && !map.containsKey("timeLength")) continue;
                    for (String timeZone : TIME_ZONES) {
                        String timeLength;
                        SimpleDateFormat timeFormatter;
                        String skeleton = GenerateDateTimeTestData.fieldStyleCombinationToSkeleton(map);
                        ImmutableMap.Builder<Object, Object> optionsBuilder = ImmutableMap.builder().putAll(map);
                        if (!calendar.isEmpty()) {
                            optionsBuilder.put("calendar", calendar);
                        }
                        optionsBuilder.put("locale", locale.toLanguageTag());
                        ImmutableMap<Object, Object> options = optionsBuilder.build();
                        TimeZone icuTimeZone = TimeZone.getTimeZone(timeZone);
                        String dateLength = GenerateDateTimeTestData.getDateLength(options);
                        SimpleDateFormat dateFormatter = localeCldrFile.getDateFormat(calendar, dateLength, icuServiceBuilder);
                        if (dateFormatter != null) {
                            dateFormatter.setTimeZone(icuTimeZone);
                        }
                        if ((timeFormatter = localeCldrFile.getTimeFormat(calendar, timeLength = GenerateDateTimeTestData.getTimeLength(options), icuServiceBuilder)) != null) {
                            timeFormatter.setTimeZone(icuTimeZone);
                        }
                        ZoneId zoneId = ZoneId.of(timeZone);
                        for (ZonedDateTime zonedDateTime : JAVA_TIME_ZONED_DATE_TIMES) {
                            ZonedDateTime zdtNewTz = zonedDateTime.withZoneSameInstant(zoneId);
                            List<ImmutableMap<Object, Object>> testCases = GenerateDateTimeTestData.getTestCasesForZonedDateTime(icuServiceBuilder, localeCldrFile, options, optionsBuilder, zdtNewTz, calendar, dateFormatter, timeFormatter, dateLength);
                            result.addAll(testCases);
                        }
                        for (Map map2 : TEMPORAL_DATES) {
                            ZonedDateTime zdt = GenerateDateTimeTestData.getZonedDateTimeFromTemporalDateInput(map2);
                            ZonedDateTime zdtNewTz = zdt.withZoneSameInstant(zoneId);
                            List<ImmutableMap<Object, Object>> testCases = GenerateDateTimeTestData.getTestCasesForZonedDateTime(icuServiceBuilder, localeCldrFile, options, optionsBuilder, zdtNewTz, calendar, dateFormatter, timeFormatter, dateLength);
                            result.addAll(testCases);
                        }
                    }
                }
            }
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        try (TempPrintWriter pw = TempPrintWriter.openUTF8Writer(CLDRPaths.TEST_DATA + OUTPUT_SUBDIR, OUTPUT_FILENAME);){
            Collection<Map<Object, Object>> testCases = GenerateDateTimeTestData.generateAllTestCases();
            pw.println(GSON.toJson(testCases));
        }
    }
}

