/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Utility;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.ListResourceBundle;
import java.util.Set;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.XPathParts;

public class GenerateTempDateData {
    public static void main(String[] args) throws IOException {
        Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        Set<String> x = cldrFactory.getAvailable();
        PrintWriter pw = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY + "datedata/", "DateData.java");
        pw.println("package com.ibm.icu.impl.data;");
        pw.println("import java.util.ListResourceBundle;");
        pw.println("class DateData { // extracted from CLDR 1.4");
        for (String locale : x) {
            CLDRFile file = cldrFactory.make(locale, false);
            if (file.isNonInheriting()) continue;
            System.out.println(locale);
            boolean gotOne = false;
            Iterator<String> it2 = file.iterator("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/");
            while (it2.hasNext()) {
                String pattern;
                XPathParts parts;
                String path = it2.next();
                if (path.indexOf("dateTimeFormats/availableFormats/dateFormatItem") >= 0) {
                    gotOne = GenerateTempDateData.doHeader(pw, locale, gotOne);
                    parts = XPathParts.getFrozenInstance(path);
                    String id = parts.getAttributeValue(-1, "id");
                    pattern = file.getStringValue(path);
                    pw.println("     {\"pattern/" + id + "\",\"" + Utility.escape(pattern) + "\"},");
                    continue;
                }
                if (path.indexOf("dateTimeFormats/appendItems") >= 0) {
                    gotOne = GenerateTempDateData.doHeader(pw, locale, gotOne);
                    parts = XPathParts.getFrozenInstance(path);
                    String request = parts.getAttributeValue(-1, "request");
                    pattern = file.getStringValue(path);
                    pw.println("     {\"append/" + request + "\",\"" + Utility.escape(pattern) + "\"},");
                    continue;
                }
                if (path.indexOf("fields/field") < 0) continue;
                gotOne = GenerateTempDateData.doHeader(pw, locale, gotOne);
                parts = XPathParts.getFrozenInstance(path);
                String type = parts.getAttributeValue(-2, "type");
                pattern = file.getStringValue(path);
                pw.println("     {\"field/" + type + "\",\"" + Utility.escape(pattern) + "\"},");
            }
            if (!gotOne) continue;
            pw.println(" };}}");
        }
        pw.println("}");
        pw.close();
    }

    private static boolean doHeader(PrintWriter pw, String locale, boolean gotOne) {
        if (!gotOne) {
            gotOne = true;
            Object suffix = locale.equals("root") ? "" : "_" + locale;
            pw.println(" public static class MyDateResources" + (String)suffix + " extends ListResourceBundle {");
            pw.println("  protected Object[][] getContents() {");
            pw.println("   return new Object[][] {");
        }
        return gotOne;
    }

    static class RBundle
    extends ListResourceBundle {
        RBundle() {
        }

        @Override
        protected Object[][] getContents() {
            return null;
        }
    }
}

