/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.test;

import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.text.GenderInfo;
import com.ibm.icu.util.ULocale;
import java.util.Arrays;
import java.util.List;

public class GenderInfoTest
extends TestFmwk {
    public static GenderInfo NEUTRAL_LOCALE = new GenderInfo(ULocale.ENGLISH);
    public static GenderInfo MIXED_NEUTRAL_LOCALE = new GenderInfo(new ULocale("is"));
    public static GenderInfo MALE_TAINTS_LOCALE = new GenderInfo(ULocale.FRANCE);

    public static void main(String[] args) {
        new GenderInfoTest().run(args);
    }

    public void TestEmpty() {
        this.check(GenderInfo.Gender.OTHER, GenderInfo.Gender.OTHER, new GenderInfo.Gender[0]);
    }

    public void TestOne() {
        for (GenderInfo.Gender g2 : GenderInfo.Gender.values()) {
            this.check(g2, g2, g2);
        }
    }

    public void TestOther() {
        this.check(GenderInfo.Gender.OTHER, GenderInfo.Gender.MALE, GenderInfo.Gender.MALE, GenderInfo.Gender.FEMALE);
        this.check(GenderInfo.Gender.OTHER, GenderInfo.Gender.MALE, GenderInfo.Gender.FEMALE, GenderInfo.Gender.MALE);
        this.check(GenderInfo.Gender.MALE, GenderInfo.Gender.MALE, GenderInfo.Gender.MALE, GenderInfo.Gender.MALE);
        this.check(GenderInfo.Gender.FEMALE, GenderInfo.Gender.FEMALE, GenderInfo.Gender.FEMALE, GenderInfo.Gender.FEMALE);
        this.check(GenderInfo.Gender.OTHER, GenderInfo.Gender.MALE, GenderInfo.Gender.FEMALE, GenderInfo.Gender.OTHER);
    }

    public void check(GenderInfo.Gender mixed, GenderInfo.Gender taints, GenderInfo.Gender ... genders) {
        List<GenderInfo.Gender> mixed0 = Arrays.asList(genders);
        this.assertEquals("neutral " + mixed0, (Object)GenderInfo.Gender.OTHER, (Object)NEUTRAL_LOCALE.getListGender(mixed0));
        this.assertEquals("mixed neutral " + mixed0, (Object)mixed, (Object)MIXED_NEUTRAL_LOCALE.getListGender(mixed0));
        this.assertEquals("male taints " + mixed0, (Object)taints, (Object)MALE_TAINTS_LOCALE.getListGender(mixed0));
    }
}

