/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.ibm.icu.util.ICUException;
import com.ibm.icu.util.VersionInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.unicode.cldr.test.DisplayAndInputProcessor;
import org.unicode.cldr.tool.CldrVersion;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.SimpleFactory;

public class FindFlipFlops {
    private static int flipFlopCount = 0;
    private static CldrVersion[] VERSIONS;
    private static Factory[] factories;
    private static final boolean USE_RESOLVED = false;
    static final Option.Options myOptions;
    private static final TestData d0;
    private static final TestData d1;
    private static final TestData d2;
    private static final TestData d3;
    private static final TestData d4;
    private static final TestData d5;
    private static final TestData[] testData;

    public static void main(String[] args) throws IOException {
        myOptions.parse(args, true);
        FindFlipFlops.confirmVersionArchiveIsPresent();
        VERSIONS = FindFlipFlops.makeVersionArray();
        factories = FindFlipFlops.setUpFactories();
        FindFlipFlops.testFindFlipFlop();
        System.out.println("#Version\tFrom\t\u21d2\tTo\tIndex\tLocale\tPath");
        FindFlipFlops.findFlops("en");
        LanguageTagParser ltp = new LanguageTagParser();
        for (String fileName : factories[0].getAvailable()) {
            if (fileName.equals("en") || !ltp.set(fileName).getRegion().isEmpty()) continue;
            FindFlipFlops.findFlops(fileName);
        }
        System.out.println("Total " + flipFlopCount + " flip-flops");
    }

    private static void confirmVersionArchiveIsPresent() {
        try {
            CldrVersion.checkVersions();
        }
        catch (Exception e) {
            throw new ICUException("This tool can only be run if the archive of released versions matching CldrVersion is available.", e);
        }
    }

    private static CldrVersion[] makeVersionArray() {
        VersionInfo oldest = VersionInfo.getInstance(myOptions.get("oldest").getValue());
        ArrayList<CldrVersion> versions = new ArrayList<CldrVersion>();
        boolean foundStart = false;
        for (CldrVersion version : CldrVersion.CLDR_VERSIONS_DESCENDING) {
            versions.add(version);
            if (version.getVersionInfo() != oldest) continue;
            foundStart = true;
            break;
        }
        if (!foundStart) {
            throw new IllegalArgumentException("The last version is " + myOptions.get("oldest").getValue() + "; it must be in: " + Joiner.on(", ").join(CldrVersion.CLDR_VERSIONS_DESCENDING));
        }
        return versions.toArray(new CldrVersion[0]);
    }

    private static Factory[] setUpFactories() {
        Factory[] factories = new Factory[VERSIONS.length];
        String filePattern = myOptions.get("file").getValue();
        ArrayList<Factory> list = new ArrayList<Factory>();
        for (CldrVersion version : VERSIONS) {
            if (version == CldrVersion.unknown) continue;
            List<File> paths = version.getPathsForFactory();
            System.out.println(version + ", " + paths);
            Factory aFactory = SimpleFactory.make(paths.toArray(new File[0]), filePattern);
            list.add(aFactory);
        }
        list.toArray(factories);
        return factories;
    }

    private static void findFlops(String fileName) {
        CLDRFile[] files = new CLDRFile[factories.length];
        DisplayAndInputProcessor[] processors = new DisplayAndInputProcessor[factories.length];
        FindFlipFlops.setUpFilesAndProcessors(fileName, files, processors);
        for (String xpath : files[0]) {
            String previous;
            xpath = xpath.intern();
            String base = FindFlipFlops.getProcessedStringValue(xpath, files[0], processors[0]);
            ArrayList<String> history = new ArrayList<String>();
            history.add(base);
            for (int i = 1; i < files.length && files[i] != null && (previous = FindFlipFlops.getProcessedStringValue(xpath, files[i], processors[0])) != null; ++i) {
                history.add(previous);
            }
            if (!FindFlipFlops.findFlipFlop(history)) continue;
            FindFlipFlops.recordFlipFlop(history, xpath, fileName);
        }
    }

    private static void setUpFilesAndProcessors(String fileName, CLDRFile[] files, DisplayAndInputProcessor[] processors) {
        for (int i = 0; i < factories.length; ++i) {
            try {
                files[i] = factories[i].make(fileName, false);
                processors[i] = new DisplayAndInputProcessor(files[i], false);
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
    }

    private static void testFindFlipFlop() {
        for (TestData data : testData) {
            ArrayList<String> history = new ArrayList<String>(List.of(data.values));
            if (FindFlipFlops.findFlipFlop(history) == data.expectFlipFlop) continue;
            System.out.println("\ud83c\udfd3\ud83c\udfd3\ud83c\udfd3 testFindFlipFlop FAILURE:" + String.join((CharSequence)",\t", history));
        }
    }

    private static boolean findFlipFlop(ArrayList<String> history) {
        if (history.size() < 3) {
            return false;
        }
        for (int i = 0; i < history.size() - 1; ++i) {
            String hi = history.get(i);
            for (int j = i + 2; j < history.size(); ++j) {
                String hj = history.get(j);
                if (!hj.equals(hi) || FindFlipFlops.equalsWithoutWhitespace(hj, history.get(j - 1))) continue;
                return true;
            }
        }
        return false;
    }

    private static void recordFlipFlop(ArrayList<String> history, String xpath, String fileName) {
        ++flipFlopCount;
        ArrayList<Event> events = FindFlipFlops.getEventsWithChanges(history);
        ArrayList<Event> significantEvents = FindFlipFlops.filterSignificantEvents(events);
        FindFlipFlops.printEvents(significantEvents, fileName, xpath);
    }

    private static ArrayList<Event> getEventsWithChanges(ArrayList<String> history) {
        ArrayList<Event> events = new ArrayList<Event>();
        for (int i = history.size() - 1; i > 0; --i) {
            Event e = new Event(String.valueOf((Object)VERSIONS[i]), history.get(i), history.get(i - 1));
            if (e.to == null || e.from == null || FindFlipFlops.equalsWithoutWhitespace(e.to, e.from)) continue;
            events.add(e);
        }
        return events;
    }

    private static ArrayList<Event> filterSignificantEvents(ArrayList<Event> events) {
        ArrayList<Event> significantEvents = new ArrayList<Event>();
        block0: for (Event e : events) {
            for (Event ee : events) {
                if (ee.version.equals(e.version) || !FindFlipFlops.equalsWithoutWhitespace(ee.from, e.to) && !FindFlipFlops.equalsWithoutWhitespace(ee.to, e.from)) continue;
                significantEvents.add(e);
                continue block0;
            }
        }
        return significantEvents;
    }

    private static void printEvents(ArrayList<Event> events, String fileName, String xpath) {
        for (Event e : events) {
            System.out.println(e.version + "\t" + e.from + "\t\u21d2\t" + e.to + "\t" + flipFlopCount + "\t" + fileName + "\t" + xpath);
        }
        System.out.println();
    }

    private static String getProcessedStringValue(String xpath, CLDRFile file, DisplayAndInputProcessor processor) {
        String value = file.getStringValue(xpath);
        if (CldrUtility.INHERITANCE_MARKER.equals(value) && CldrUtility.INHERITANCE_MARKER.equals(value = file.getBaileyValue(xpath, null, null))) {
            System.out.println("Warning: INHERITANCE_MARKER not resolved in FindFlipFlops: " + xpath);
        }
        if (value != null) {
            value = processor.processInput(xpath, value, null);
        }
        return value;
    }

    private static boolean equalsWithoutWhitespace(String x, String y) {
        if (x == null) {
            if (y == null) {
                return true;
            }
            System.out.println("Warning: in equalsWithoutWhitespace, x is null, y = " + y);
            return false;
        }
        if (x.equals(y)) {
            return true;
        }
        return x.replaceAll("\\h*", "").equals(y.replaceAll("\\h*", ""));
    }

    static {
        myOptions = new Option.Options().add("file", (Object)".*", ".*", "Filter the information based on file name, using a regex argument. The '.xml' is removed from the file before filtering").add("oldest", (Object)"\\d+(\\.\\d+)?(\\.\\d+)?", "21.0", "Oldest version to go back to, eg 36.1");
        d0 = new TestData(new String[]{"a", "a"}, false);
        d1 = new TestData(new String[]{"a", "b", "c"}, false);
        d2 = new TestData(new String[]{"a", "b", "a"}, true);
        d3 = new TestData(new String[]{"a", "b", "c", "d"}, false);
        d4 = new TestData(new String[]{"a", "b", "c", "a"}, true);
        d5 = new TestData(new String[]{"a", "b", "c", "b"}, true);
        testData = new TestData[]{d0, d1, d2, d3, d4, d5};
    }

    private static class Event {
        String version;
        String from;
        String to;

        public Event(String version, String from, String to) {
            this.version = version;
            this.from = from;
            this.to = to;
        }
    }

    private static class TestData {
        String[] values;
        boolean expectFlipFlop;

        public TestData(String[] values, boolean expectFlipFlop) {
            this.values = values;
            this.expectFlipFlop = expectFlipFlop;
        }
    }
}

