/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.util.ApproximateWidth;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.StandardCodes;

public class FindWidths {
    private static final CLDRConfig testInfo = ToolConfig.getToolInstance();
    private static final Factory CLDR_FACTORY = testInfo.getCldrFactory();
    private static final double MIN_TEST_INCREASE = 1.5;
    private static final int MIN_TEST_WIDTH = 2 * ApproximateWidth.getWidth("\u3048");

    public static void main(String[] args) {
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMaximumFractionDigits(0);
        CLDRFile english = testInfo.getEnglish();
        PathHeader.Factory phf = PathHeader.getFactory(english);
        HashMap<PathHeader, Integer> englishWidths = new HashMap<PathHeader, Integer>();
        TreeMap<PathHeader, Data> maxWidths = new TreeMap<PathHeader, Data>();
        Set<String> sampleLocales = StandardCodes.make().getLocaleCoverageLocales("google");
        for (String path : english) {
            PathHeader ph = phf.fromPath(path);
            PathHeader.PageId pageId = ph.getPageId();
            PathHeader.SectionId sectionId = ph.getSectionId();
            if (pageId == PathHeader.PageId.Alphabetic_Information || sectionId == PathHeader.SectionId.Special) continue;
            String value = english.getStringValue(path);
            int width = ApproximateWidth.getWidth(value);
            englishWidths.put(ph, width);
        }
        for (String locale : CLDR_FACTORY.getAvailableLanguages()) {
            if (!sampleLocales.contains(locale) || locale.equals("en")) continue;
            System.out.println(locale);
            CLDRFile file = CLDR_FACTORY.make(locale, false);
            for (String path : file) {
                double sizeIncrease;
                String value;
                int width;
                PathHeader ph = phf.fromPath(path);
                Integer englishWidth = (Integer)englishWidths.get(ph);
                if (englishWidth == null) continue;
                PathHeader.PageId pageId = ph.getPageId();
                PathHeader.SectionId sectionId = ph.getSectionId();
                if (pageId == PathHeader.PageId.Alphabetic_Information || sectionId == PathHeader.SectionId.Special || (width = ApproximateWidth.getWidth(value = file.getStringValue(path))) < MIN_TEST_WIDTH || (sizeIncrease = (double)width / (double)englishWidth.intValue() - 1.0) < 1.5) continue;
                Data data = (Data)maxWidths.get(ph);
                if (data == null) {
                    data = new Data();
                    maxWidths.put(ph, data);
                }
                data.add(locale, value, width, englishWidth);
            }
        }
        int count = 0;
        for (Map.Entry entry : maxWidths.entrySet()) {
            PathHeader path = (PathHeader)entry.getKey();
            Data data = (Data)entry.getValue();
            double sizeIncrease = (double)data.width / (double)data.englishWidth - 1.0;
            System.out.println(++count + "\t" + path + "\t" + data.locale + "\t\u00ab" + english.getStringValue(path.getOriginalPath()) + "\u00bb\t\u00ab" + data.value + "\u00bb\t+" + nf.format(sizeIncrease) + "\t" + data.width + "\t" + data.count);
        }
    }

    static final class Data {
        String locale;
        String value;
        int width = Integer.MIN_VALUE;
        int count = 0;
        int englishWidth;

        Data() {
        }

        public void add(String locale2, String value2, int width2, int englishWidth) {
            if (width2 > this.width) {
                this.width = width2;
                this.locale = locale2;
                this.value = value2;
                this.englishWidth = englishWidth;
            }
            ++this.count;
        }
    }
}

