/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.ibm.icu.dev.test.TestFmwk;
import com.ibm.icu.dev.test.TestLog;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.VersionInfo;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRURLS;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.CoverageInfo;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.StackTracker;
import org.unicode.cldr.util.StaticCLDRURLS;
import org.unicode.cldr.util.SupplementalDataInfo;

public class CLDRConfig
extends Properties {
    public static boolean SKIP_SEED = System.getProperty("CLDR_SKIP_SEED") != null;
    private static final long serialVersionUID = -2605254975303398336L;
    public static boolean DEBUG = false;
    public static final String SUBCLASS = CLDRConfig.class.getName() + "Impl";
    String initStack = null;
    private CheckCLDR.Phase phase = null;
    private LoadingCache<String, CLDRFile> cldrFileResolvedCache = CacheBuilder.newBuilder().maximumSize(200L).build(new CacheLoader<String, CLDRFile>(){

        @Override
        public CLDRFile load(String locale) {
            return CLDRConfig.this.getFullCldrFactory().make(locale, true);
        }
    });
    private LoadingCache<String, CLDRFile> cldrFileUnresolvedCache = CacheBuilder.newBuilder().maximumSize(1000L).build(new CacheLoader<String, CLDRFile>(){

        @Override
        public CLDRFile load(String locale) {
            return CLDRConfig.this.getFullCldrFactory().make(locale, false);
        }
    });
    private TestLog testLog = null;
    private Set<String> shown = new HashSet<String>();
    private Map<String, String> localSet = null;
    private Environment curEnvironment = null;
    private static final String COMMON_DIR = "common";
    private static final String EXEMPLARS_DIR = "exemplars";
    private static final String SEED_DIR = "seed";
    private static final String KEYBOARDS_DIR = "keyboards";
    private static final String MAIN_DIR = "main";
    private static final String ANNOTATIONS_DIR = "annotations";
    private static final String SUBDIVISIONS_DIR = "subdivisions";
    private static final String[] CLDR_DATA_DIRECTORIES = new String[]{"common", "seed", "keyboards", "exemplars"};
    private static final ImmutableSet<String> STANDARD_SUBDIRS = ImmutableSet.of("main", "annotations", "subdivisions");
    private CLDRURLS urls = null;
    private CLDRURLS absoluteUrls = null;

    public static CLDRConfig getInstance() {
        return CLDRConfigHelper.SINGLETON;
    }

    protected CLDRConfig() {
        this.initStack = StackTracker.currentStack();
    }

    public String getInitStack() {
        return this.initStack;
    }

    public TestLog setTestLog(TestLog log) {
        this.testLog = log;
        return log;
    }

    public TestFmwk setTestLog(TestFmwk log) {
        this.testLog = log;
        return log;
    }

    protected void logln(String msg) {
        if (this.testLog != null) {
            this.testLog.logln(msg);
        } else {
            System.out.println(msg);
            System.out.flush();
        }
    }

    public SupplementalDataInfo getSupplementalDataInfo() {
        return SupplementalDataInfoHelper.SINGLETON;
    }

    public final CoverageInfo getCoverageInfo() {
        return CoverageInfoHelper.SINGLETON;
    }

    public final Factory getCldrFactory() {
        return CldrFactoryHelper.SINGLETON;
    }

    public final Factory getExemplarsFactory() {
        return ExemplarsFactoryHelper.SINGLETON;
    }

    public final Factory getCollationFactory() {
        return CollationFactoryHelper.SINGLETON;
    }

    public final Factory getAllCollationFactory() {
        CollationFactoryHelper.ALL_SINGLETON.setIgnoreExplicitParentLocale(true);
        return CollationFactoryHelper.ALL_SINGLETON;
    }

    public final Factory getRBNFFactory() {
        return RBNFFactoryHelper.SINGLETON;
    }

    public Factory getAnnotationsFactory() {
        return AnnotationsFactoryHelper.SINGLETON;
    }

    public final Factory getSubdivisionFactory() {
        return SubdivisionsFactoryHelper.SINGLETON;
    }

    public final Factory getMainAndAnnotationsFactory() {
        return MainAndAnnotationsFactoryHelper.SINGLETON;
    }

    public final Factory getCommonSeedExemplarsFactory() {
        return CommonSeedExemplarsFactoryHelper.SINGLETON;
    }

    public final Factory getCommonAndSeedAndMainAndAnnotationsFactory() {
        return CommonAndSeedAndMainAndAnnotationsFactoryHelper.SINGLETON;
    }

    public final Factory getFullCldrFactory() {
        return FullCldrFactoryHelper.SINGLETON;
    }

    public final Factory getSupplementalFactory() {
        return SupplementalFactoryHelper.SINGLETON;
    }

    public CLDRFile getEnglish() {
        return this.getCLDRFile("en", true);
    }

    public CLDRFile getCLDRFile(String locale, boolean resolved) {
        return resolved ? this.cldrFileResolvedCache.getUnchecked(locale) : this.cldrFileUnresolvedCache.getUnchecked(locale);
    }

    public CLDRFile getRoot() {
        return this.getCLDRFile("root", true);
    }

    public final Collator getCollatorRoot() {
        return CollatorRootHelper.SINGLETON;
    }

    public final Comparator<String> getComparatorRoot() {
        return this.getCollatorRoot();
    }

    public Collator getCollator() {
        return CollatorHelper.EMOJI_COLLATOR;
    }

    public Collator getRootNumeric() {
        return CollatorHelper.ROOT_NUMERIC;
    }

    public synchronized CheckCLDR.Phase getPhase() {
        if (this.phase == null) {
            this.phase = this.getEnvironment() == Environment.UNITTEST ? CheckCLDR.Phase.BUILD : CheckCLDR.Phase.SUBMISSION;
        }
        return this.phase;
    }

    public CheckCLDR.Phase getExtendedPhase() {
        return this.getPhase();
    }

    @Override
    public String getProperty(String key, String d) {
        String result = this.getProperty(key);
        if (result == null) {
            return d;
        }
        return result;
    }

    @Override
    public String get(Object key) {
        return this.getProperty(key.toString());
    }

    @Override
    public String getProperty(String key) {
        String result = null;
        if (this.localSet != null) {
            result = this.localSet.get(key);
        }
        if (result == null) {
            result = System.getProperty(key);
        }
        if (result == null) {
            result = System.getProperty(key.toUpperCase(Locale.ENGLISH));
        }
        if (result == null) {
            result = System.getProperty(key.toLowerCase(Locale.ENGLISH));
        }
        if (result == null) {
            result = System.getenv(key);
        }
        if (DEBUG && !this.shown.contains(key)) {
            this.logln("-D" + key + "=" + result);
            this.shown.add(key);
        }
        return result;
    }

    public Environment getEnvironment() {
        if (this.curEnvironment == null) {
            String envString = this.getProperty("CLDR_ENVIRONMENT");
            if (envString != null) {
                this.curEnvironment = Environment.valueOf(envString.trim());
            }
            if (this.curEnvironment == null) {
                this.curEnvironment = this.getDefaultEnvironment();
            }
        }
        return this.curEnvironment;
    }

    protected Environment getDefaultEnvironment() {
        return Environment.LOCAL;
    }

    public void setEnvironment(Environment environment) {
        this.curEnvironment = environment;
    }

    @Override
    public Object setProperty(String k, String v) {
        if (this.getEnvironment() != Environment.UNITTEST) {
            throw new InternalError("setProperty() only valid in UNITTEST Environment.");
        }
        if (this.localSet == null) {
            this.localSet = new ConcurrentHashMap<String, String>();
        }
        this.shown.remove(k);
        return this.localSet.put(k, v);
    }

    @Override
    public Object put(Object k, Object v) {
        return this.setProperty(k.toString(), v.toString());
    }

    public boolean getProperty(String k, boolean defVal) {
        String val = this.getProperty(k, defVal ? "true" : null);
        if (val == null) {
            return false;
        }
        return (val = val.trim().toLowerCase()).equals("true") || val.equals("t") || val.equals("yes") || val.equals("y");
    }

    public int getProperty(String k, int defVal) {
        String val = this.getProperty(k, Integer.toString(defVal));
        if (val == null) {
            return defVal;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            return defVal;
        }
    }

    public File getCldrBaseDirectory() {
        return FileWrapper.getFileWrapperInstance().getCldrDir();
    }

    public Set<File> getAllCLDRFilesEndingWith(final String suffix) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(suffix) && !CLDRConfig.isJunkFile(name);
            }
        };
        File dir = this.getCldrBaseDirectory();
        Set<File> list = this.getCLDRFilesMatching(filter, dir);
        return list;
    }

    public Set<File> getCLDRFilesMatching(FilenameFilter filter, File baseDir) {
        LinkedHashSet<File> list = new LinkedHashSet<File>();
        for (String subdir : CLDRConfig.getCLDRDataDirectories()) {
            this.getFilesRecursively(new File(baseDir, subdir), filter, list);
        }
        return list;
    }

    public static Iterable<String> getCLDRDataDirectories() {
        return Arrays.asList(CLDR_DATA_DIRECTORIES);
    }

    public File[] getCLDRDataDirectories(String list) {
        File dir = this.getCldrBaseDirectory();
        String[] stubs = list.split(",");
        File[] ret = new File[stubs.length];
        for (int i = 0; i < stubs.length; ++i) {
            ret[i] = new File(dir, stubs[i]);
        }
        return ret;
    }

    public File[] addStandardSubdirectories(String ... base) {
        return this.addStandardSubdirectories(CLDRConfig.fileArrayFromStringArray(this.getCldrBaseDirectory(), base));
    }

    public File[] addStandardSubdirectories(File ... base) {
        ArrayList<File> ret = new ArrayList<File>();
        for (int i = 0; i < base.length; ++i) {
            File baseFile = base[i];
            String name = baseFile.getName();
            if (STANDARD_SUBDIRS.contains(name)) {
                ret.add(baseFile);
                continue;
            }
            for (String sub : STANDARD_SUBDIRS) {
                CLDRConfig.addIfExists(ret, baseFile, sub);
            }
        }
        return ret.toArray(new File[ret.size()]);
    }

    public static File[] fileArrayFromStringArray(File dir, String ... subdirNames) {
        File[] fileList = new File[subdirNames.length];
        int i = 0;
        for (String item : subdirNames) {
            fileList[i++] = new File(dir, item);
        }
        return fileList;
    }

    private static void addIfExists(List<File> ret, File baseFile, String sub) {
        File file = new File(baseFile, sub);
        if (file.exists()) {
            ret.add(file);
        }
    }

    public Set<File> getFilesRecursively(File directory, FilenameFilter filter, Set<File> toAddTo) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File subfile : files) {
                if (subfile.isDirectory()) {
                    if (CLDRConfig.isJunkFile(subfile.getName())) continue;
                    this.getFilesRecursively(subfile, filter, toAddTo);
                    continue;
                }
                if (!filter.accept(directory, subfile.getName())) continue;
                toAddTo.add(subfile);
            }
        }
        return toAddTo;
    }

    public static final boolean isJunkFile(String name) {
        return name.startsWith(".") || name.startsWith("#");
    }

    public boolean getDebugSettingsFor(Class<?> callingClass) {
        return this.getDebugSettingsFor(callingClass, false);
    }

    public boolean getDebugSettingsFor(Class<?> callingClass, boolean defaultValue) {
        if (callingClass == null) {
            return defaultValue;
        }
        return this.getProperty(callingClass.getCanonicalName() + ".debug", defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLDRURLS urls() {
        if (this.urls == null) {
            CLDRConfig cLDRConfig = this;
            synchronized (cLDRConfig) {
                this.urls = this.internalGetUrls();
            }
        }
        return this.urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLDRURLS absoluteUrls() {
        if (this.absoluteUrls == null) {
            CLDRConfig cLDRConfig = this;
            synchronized (cLDRConfig) {
                this.absoluteUrls = this.internalGetAbsoluteUrls();
            }
        }
        return this.absoluteUrls;
    }

    protected CLDRURLS internalGetAbsoluteUrls() {
        return new StaticCLDRURLS(this.getProperty("CLDR_SURVEY_BASE", "https://st.unicode.org/cldr-apps"));
    }

    protected CLDRURLS internalGetUrls() {
        return this.absoluteUrls();
    }

    public boolean isCldrVersionBefore(int ... version) {
        return this.getEnglish().getDtdVersionInfo().compareTo(CLDRConfig.getVersion(version)) < 0;
    }

    public static VersionInfo getVersion(int ... versionInput) {
        int[] version = new int[4];
        for (int i = 0; i < versionInput.length; ++i) {
            version[i] = versionInput[i];
        }
        return VersionInfo.getInstance(version[0], version[1], version[2], version[3]);
    }

    private static class FileWrapper {
        private File cldrDir = null;
        private static FileWrapper fileWrapperInstance = new FileWrapper();

        private FileWrapper() {
            String dir = CLDRConfig.getInstance().getProperty("CLDR_DIR", null);
            this.cldrDir = dir != null ? new File(dir) : null;
        }

        public File getCldrDir() {
            return this.cldrDir;
        }

        public static FileWrapper getFileWrapperInstance() {
            return fileWrapperInstance;
        }
    }

    private static final class CollatorHelper {
        static final Collator EMOJI_COLLATOR = CollatorHelper.makeEmojiCollator();
        static final Collator ROOT_NUMERIC = CollatorHelper.makeRootNumeric();

        private CollatorHelper() {
        }

        private static final Collator makeEmojiCollator() {
            RuleBasedCollator col = (RuleBasedCollator)Collator.getInstance(ULocale.forLanguageTag("en-u-co-emoji"));
            col.setStrength(15);
            col.setNumericCollation(true);
            col.freeze();
            return col;
        }

        private static final Collator makeRootNumeric() {
            RuleBasedCollator _ROOT_COL = (RuleBasedCollator)Collator.getInstance(ULocale.ENGLISH);
            _ROOT_COL.setNumericCollation(true);
            _ROOT_COL.freeze();
            return _ROOT_COL;
        }
    }

    private static final class CollatorRootHelper {
        static final RuleBasedCollator SINGLETON = CollatorRootHelper.make();

        private CollatorRootHelper() {
        }

        private static final RuleBasedCollator make() {
            RuleBasedCollator colRoot;
            CLDRFile root = CLDRConfig.getInstance().getCollationFactory().make("root", false);
            String rules = root.getStringValue("//ldml/collations/collation[@type=\"emoji\"][@visibility=\"external\"]/cr");
            try {
                colRoot = new RuleBasedCollator(rules);
            }
            catch (Exception e) {
                RuleBasedCollator colRoot2 = (RuleBasedCollator)CLDRConfig.getInstance().getCollator();
                return colRoot2;
            }
            colRoot.setStrength(15);
            colRoot.setNumericCollation(true);
            colRoot.freeze();
            return colRoot;
        }
    }

    private static final class SupplementalFactoryHelper {
        static final Factory SINGLETON = Factory.make(CLDRPaths.DEFAULT_SUPPLEMENTAL_DIRECTORY, ".*");

        private SupplementalFactoryHelper() {
        }
    }

    private static final class FullCldrFactoryHelper {
        private static final File[] paths = new File[]{new File(CLDRPaths.MAIN_DIRECTORY), SKIP_SEED ? null : new File(CLDRPaths.SEED_DIRECTORY)};
        static final Factory SINGLETON = SimpleFactory.make(paths, ".*");

        private FullCldrFactoryHelper() {
        }
    }

    private static final class CommonAndSeedAndMainAndAnnotationsFactoryHelper {
        private static final File[] paths = new File[]{new File(CLDRPaths.MAIN_DIRECTORY), new File(CLDRPaths.ANNOTATIONS_DIRECTORY), SKIP_SEED ? null : new File(CLDRPaths.SEED_DIRECTORY), SKIP_SEED ? null : new File(CLDRPaths.SEED_ANNOTATIONS_DIRECTORY)};
        static final Factory SINGLETON = SimpleFactory.make(paths, ".*");

        private CommonAndSeedAndMainAndAnnotationsFactoryHelper() {
        }
    }

    private static final class CommonSeedExemplarsFactoryHelper {
        static final Factory SINGLETON = SimpleFactory.make(CLDRConfig.getInstance().addStandardSubdirectories(CLDR_DATA_DIRECTORIES), ".*");

        private CommonSeedExemplarsFactoryHelper() {
        }
    }

    private static final class MainAndAnnotationsFactoryHelper {
        private static final File[] paths = new File[]{new File(CLDRPaths.MAIN_DIRECTORY), new File(CLDRPaths.ANNOTATIONS_DIRECTORY)};
        static final Factory SINGLETON = SimpleFactory.make(paths, ".*");

        private MainAndAnnotationsFactoryHelper() {
        }
    }

    private static final class SubdivisionsFactoryHelper {
        static final Factory SINGLETON = Factory.make(CLDRPaths.SUBDIVISIONS_DIRECTORY, ".*");

        private SubdivisionsFactoryHelper() {
        }
    }

    private static final class AnnotationsFactoryHelper {
        private static final File[] paths = new File[]{new File(CLDRPaths.ANNOTATIONS_DIRECTORY), SKIP_SEED ? null : new File(CLDRPaths.SEED_ANNOTATIONS_DIRECTORY)};
        static final Factory SINGLETON = SimpleFactory.make(paths, ".*");

        private AnnotationsFactoryHelper() {
        }
    }

    private static final class RBNFFactoryHelper {
        static final Factory SINGLETON = Factory.make(CLDRPaths.RBNF_DIRECTORY, ".*");

        private RBNFFactoryHelper() {
        }
    }

    private static final class CollationFactoryHelper {
        static final Factory SINGLETON = Factory.make(CLDRPaths.COLLATION_DIRECTORY, ".*").setIgnoreExplicitParentLocale(true);
        static final File[] COLLATION_PATHS = new File[]{new File(CLDRPaths.COLLATION_DIRECTORY), SKIP_SEED ? null : new File(CLDRPaths.SEED_COLLATION_DIRECTORY)};
        static final Factory ALL_SINGLETON = SimpleFactory.make(COLLATION_PATHS, ".*").setIgnoreExplicitParentLocale(true);

        private CollationFactoryHelper() {
        }
    }

    private static final class ExemplarsFactoryHelper {
        static final Factory SINGLETON = Factory.make(CLDRPaths.EXEMPLARS_DIRECTORY, ".*");

        private ExemplarsFactoryHelper() {
        }
    }

    private static final class CldrFactoryHelper {
        static final Factory SINGLETON = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");

        private CldrFactoryHelper() {
        }
    }

    private static final class CoverageInfoHelper {
        static final CoverageInfo SINGLETON = new CoverageInfo(CLDRConfig.getInstance().getSupplementalDataInfo());

        private CoverageInfoHelper() {
        }
    }

    private static final class SupplementalDataInfoHelper {
        static final SupplementalDataInfo SINGLETON = SupplementalDataInfo.getInstance(CLDRPaths.DEFAULT_SUPPLEMENTAL_DIRECTORY);

        private SupplementalDataInfoHelper() {
        }
    }

    public static final class CLDRConfigHelper {
        static final CLDRConfig SINGLETON = CLDRConfigHelper.make();

        private static CLDRConfig make() {
            CLDRConfig instance = null;
            String env = System.getProperty("CLDR_ENVIRONMENT");
            if (env != null && env.equals(Environment.UNITTEST.name())) {
                if (DEBUG) {
                    System.err.println("-DCLDR_ENVIRONMENT=" + env + " - not loading " + SUBCLASS);
                }
            } else {
                try {
                    instance = (CLDRConfig)Class.forName(SUBCLASS).newInstance();
                    if (instance != null) {
                        System.err.println("Using CLDRConfig: " + instance.toString() + " - " + instance.getClass().getName());
                    } else if (DEBUG) {
                        System.err.println("Note: CLDRConfig Subclass " + SUBCLASS + ".newInstance() returned NULL ( this is OK if we aren't inside the SurveyTool's web server )");
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    // empty catch block
                }
            }
            if (instance == null) {
                instance = new CLDRConfig();
                CldrUtility.checkValidDirectory(instance.getProperty("CLDR_DIR"), "You have to set -DCLDR_DIR=<validdirectory>");
            }
            return instance;
        }
    }

    public static enum Environment {
        LOCAL,
        SMOKETEST,
        PRODUCTION,
        UNITTEST;

    }
}

