/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.DisplayAndInputProcessor;
import org.unicode.cldr.util.AnnotationUtil;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.DeferredTranscript;
import org.unicode.cldr.util.InternalCldrException;
import org.unicode.cldr.util.LocaleSet;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.VoterInfoList;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class VoteResolver<T> {
    public static final boolean DROP_HARD_INHERITANCE = true;
    private final VoterInfoList voterInfoList;
    private static final boolean DEBUG = false;
    private DeferredTranscript transcript = null;
    private static final String NO_WINNING_VALUE = "no-winning-value";
    public static final int HIGH_BAR = Level.tc.votes;
    public static final int LOWER_BAR = 2 * Level.vetter.votes;
    private T winningValue;
    private T oValue;
    private T nValue;
    private final List<T> valuesWithSameVotes = new ArrayList<T>();
    private Counter<T> totals = null;
    private Status winningStatus;
    private final EnumSet<Organization> conflictedOrganizations = EnumSet.noneOf(Organization.class);
    private final OrganizationToValueAndVote<T> organizationToValueAndVote = new OrganizationToValueAndVote();
    private T baselineValue;
    private Status baselineStatus;
    private boolean resolved;
    private boolean valueIsLocked;
    private int requiredVotes = 0;
    private final SupplementalDataInfo supplementalDataInfo = SupplementalDataInfo.getInstance();
    private CLDRLocale locale;
    private PathHeader pathHeader;
    private static final Collator englishCollator = Collator.getInstance(ULocale.ENGLISH).freeze();
    private final Comparator<T> objectCollator = (o1, o2) -> englishCollator.compare(String.valueOf(o1), String.valueOf(o2));
    private int maxcounter = 100;
    private final Set<T> values = new TreeSet<T>(this.objectCollator);
    private final Comparator<T> votesThenUcaCollator = new Comparator<T>(){

        @Override
        public int compare(T o1, T o2) {
            long v2;
            long v1 = VoteResolver.this.organizationToValueAndVote.allVotesIncludingIntraOrgDispute.get(o1);
            if (v1 != (v2 = VoteResolver.this.organizationToValueAndVote.allVotesIncludingIntraOrgDispute.get(o2))) {
                return v1 < v2 ? 1 : -1;
            }
            if (o1.equals(VoteResolver.this.baselineValue)) {
                return -1;
            }
            if (o2.equals(VoteResolver.this.baselineValue)) {
                return 1;
            }
            if (o1.equals(CldrUtility.INHERITANCE_MARKER)) {
                return -1;
            }
            if (o2.equals(CldrUtility.INHERITANCE_MARKER)) {
                return 1;
            }
            return englishCollator.compare(String.valueOf(o1), String.valueOf(o2));
        }
    };
    private boolean bothInheritanceAndBaileyHadVotes = false;

    public VoteResolver(VoterInfoList vil) {
        this.voterInfoList = vil;
    }

    public void enableTranscript() {
        if (this.transcript == null) {
            this.transcript = new DeferredTranscript();
        }
    }

    public void disableTranscript() {
        this.transcript = null;
    }

    public String getTranscript() {
        if (this.transcript == null) {
            return null;
        }
        return this.transcript.get();
    }

    private final void annotateTranscript(String fmt, Object ... args) {
        if (this.transcript != null) {
            this.transcript.add(fmt, args);
        }
    }

    public void setBaseline(T baselineValue, Status baselineStatus) {
        this.baselineValue = baselineValue;
        this.baselineStatus = baselineValue == null ? Status.missing : baselineStatus;
    }

    public T getBaselineValue() {
        return this.baselineValue;
    }

    public Status getBaselineStatus() {
        return this.baselineStatus;
    }

    public void setLocale(CLDRLocale locale, PathHeader pathHeader) {
        this.locale = locale;
        this.pathHeader = pathHeader;
    }

    public int getRequiredVotes() {
        if (this.requiredVotes == 0) {
            int preliminaryRequiredVotes = this.supplementalDataInfo.getRequiredVotes(this.locale, this.pathHeader);
            this.requiredVotes = preliminaryRequiredVotes == HIGH_BAR && this.baselineStatus != Status.approved ? LOWER_BAR : preliminaryRequiredVotes;
        }
        return this.requiredVotes;
    }

    public void clear() {
        this.baselineValue = null;
        this.baselineStatus = Status.missing;
        this.requiredVotes = 0;
        this.locale = null;
        this.pathHeader = null;
        this.organizationToValueAndVote.clear();
        this.valueIsLocked = false;
        this.resolved = false;
        this.values.clear();
        this.oValue = null;
        this.setWinningValue(null);
        this.nValue = null;
        if (this.transcript != null) {
            this.transcript.clear();
        }
    }

    public T getBaileyValue() {
        if (!this.organizationToValueAndVote.baileySet) {
            throw new IllegalArgumentException("setBaileyValue must be called before getBaileyValue");
        }
        return this.organizationToValueAndVote.baileyValue;
    }

    public void setBaileyValue(T baileyValue) {
        this.organizationToValueAndVote.baileySet = true;
        this.organizationToValueAndVote.baileyValue = baileyValue;
    }

    public void add(T value, int voter, Integer withVotes, Date date) {
        value = this.changeBaileyToInheritance(value);
        if (this.resolved) {
            throw new IllegalArgumentException("Must be called after clear, and before any getters.");
        }
        if (withVotes != null && withVotes == 2000) {
            this.valueIsLocked = true;
        }
        this.organizationToValueAndVote.add(value, voter, withVotes, date);
        this.values.add(value);
    }

    public void add(T value, int voter, Integer withVotes) {
        value = this.changeBaileyToInheritance(value);
        if (this.resolved) {
            throw new IllegalArgumentException("Must be called after clear, and before any getters.");
        }
        Date date = new Date();
        this.organizationToValueAndVote.add(value, voter, withVotes, date);
        this.values.add(value);
    }

    private <T> T changeBaileyToInheritance(T value) {
        if (value != null && value.equals(this.getBaileyValue())) {
            return (T)CldrUtility.INHERITANCE_MARKER;
        }
        return value;
    }

    public void add(T value, int voter) {
        Date date = new Date(++this.maxcounter);
        this.add(value, voter, null, date);
    }

    public void add(T value) {
        if (this.resolved) {
            throw new IllegalArgumentException("Must be called after clear, and before any getters.");
        }
        this.values.add(value);
    }

    private void annotateNextBestValue(long O, long N2, T oValue, T nValue) {
        if (O > N2) {
            this.annotateTranscript("- This is the optimal value because it has the highest weight (voting score).", new Object[0]);
        } else if (this.winningValue.equals(this.baselineValue)) {
            this.annotateTranscript("- This is the optimal value because it is the same as the baseline value, though the weight was otherwise equal to the next-best.", new Object[0]);
        } else if (this.winningValue.equals(CldrUtility.INHERITANCE_MARKER)) {
            this.annotateTranscript("- This is the optimal value because it is the inheritance marker, though the weight was otherwise equal to the next-best.", new Object[0]);
        } else {
            this.annotateTranscript("- This is the optimal value because it comes earlier than '%s' when the text was sorted, though the weight was otherwise equal to the next-best.", nValue);
        }
        this.annotateTranscript("The Next-best (N) value is '%s', with weight %d", nValue, N2);
    }

    private void resolveVotes() {
        this.annotateTranscript("Resolving votes:", new Object[0]);
        this.resolved = true;
        this.valuesWithSameVotes.clear();
        this.totals = this.organizationToValueAndVote.getTotals(this.conflictedOrganizations);
        Set<T> sortedValues = this.totals.getKeysetSortedByCount(false, this.votesThenUcaCollator);
        if (sortedValues.size() == 0) {
            if (this.baselineValue != null) {
                this.setWinningValue(this.baselineValue);
                this.winningStatus = this.baselineStatus;
                this.annotateTranscript("Winning Value: '%s' with status '%s' because there were no unconflicted votes.", new Object[]{this.winningValue, this.winningStatus});
            } else if (this.organizationToValueAndVote.baileySet) {
                this.setWinningValue(CldrUtility.INHERITANCE_MARKER);
                this.winningStatus = Status.missing;
                this.annotateTranscript("Winning Value: '%s' with status '%s' because there were no unconflicted votes, and there was a Bailey value set.", new Object[]{this.winningValue, this.winningStatus});
            } else {
                this.setWinningValue(NO_WINNING_VALUE);
                this.winningStatus = Status.missing;
                this.annotateTranscript("No winning value! status '%s' because there were no unconflicted votes", new Object[]{this.winningStatus});
            }
            this.valuesWithSameVotes.add(this.winningValue);
            return;
        }
        if (this.values.size() == 0) {
            throw new IllegalArgumentException("No values added to resolver");
        }
        HashMap<T, Long> voteCount = this.makeVoteCountMap(sortedValues);
        if (this.isUsingKeywordAnnotationVoting()) {
            this.adjustAnnotationVoteCounts(sortedValues, voteCount);
        }
        long[] weights = this.setBestNextAndSameVoteValues(sortedValues, voteCount);
        this.oValue = this.winningValue;
        this.winningStatus = this.computeStatus(weights[0], weights[1]);
        if (this.baselineStatus != null && this.winningStatus.compareTo(this.baselineStatus) < 0) {
            this.setWinningValue(this.baselineValue);
            this.annotateTranscript("The optimal value so far with status '%s' would not be as good as the baseline status. Therefore, the winning value is '%s' with status '%s'.", new Object[]{this.winningStatus, this.winningValue, this.baselineStatus});
            this.winningStatus = this.baselineStatus;
            this.valuesWithSameVotes.clear();
            this.valuesWithSameVotes.add(this.winningValue);
        } else {
            this.annotateTranscript("The winning value is '%s' with status '%s'.", new Object[]{this.winningValue, this.winningStatus});
        }
    }

    private HashMap<T, Long> makeVoteCountMap(Set<T> sortedValues) {
        HashMap<T, Long> map = new HashMap<T, Long>();
        for (T value : sortedValues) {
            map.put(value, this.totals.getCount(value));
        }
        return map;
    }

    private boolean combineInheritanceWithBaileyForVoting(Set<T> sortedValues, HashMap<T, Long> voteCount) {
        if (!this.organizationToValueAndVote.baileySet || this.organizationToValueAndVote.baileyValue == null) {
            return false;
        }
        Object hardValue = this.organizationToValueAndVote.baileyValue;
        String softValue = CldrUtility.INHERITANCE_MARKER;
        if (!voteCount.containsKey(hardValue) || !voteCount.containsKey(softValue)) {
            return false;
        }
        long hardCount = voteCount.get(hardValue);
        long softCount = voteCount.get(softValue);
        if (hardCount == 0L || softCount == 0L) {
            return false;
        }
        this.reallyCombineInheritanceWithBailey(sortedValues, voteCount, hardValue, softValue, hardCount, softCount);
        return true;
    }

    private void reallyCombineInheritanceWithBailey(Set<T> sortedValues, HashMap<T, Long> voteCount, T hardValue, T softValue, long hardCount, long softCount) {
        T combValue = hardCount > softCount ? hardValue : softValue;
        T skipValue = hardCount > softCount ? softValue : hardValue;
        long combinedCount = hardCount + softCount;
        voteCount.put(combValue, combinedCount);
        voteCount.put(skipValue, 0L);
        ArrayList<T> list = new ArrayList<T>(sortedValues);
        list.sort((v1, v2) -> {
            long c2;
            long c1 = (Long)voteCount.get(v1);
            if (c1 != (c2 = ((Long)voteCount.get(v2)).longValue())) {
                return c1 < c2 ? 1 : -1;
            }
            return englishCollator.compare(String.valueOf(v1), String.valueOf(v2));
        });
        sortedValues.clear();
        for (Object value : list) {
            if (value.equals(skipValue)) continue;
            sortedValues.add(value);
        }
    }

    public void adjustAnnotationVoteCounts(Set<T> sortedValues, HashMap<T, Long> voteCount) {
        if (voteCount == null || sortedValues == null) {
            return;
        }
        this.annotateTranscript("Vote weights are being adjusted due to annotation keywords.", new Object[0]);
        HashMap<T, Long> compMap = this.makeAnnotationComponentMap(sortedValues, voteCount);
        HashMap<T, Long> rawVoteCount = new HashMap<T, Long>(voteCount);
        this.calculateNewCountsBasedOnAnnotationComponents(sortedValues, voteCount, compMap);
        this.resortValuesBasedOnAdjustedVoteCounts(sortedValues, voteCount);
        this.promoteSuperiorAnnotationSuperset(sortedValues, voteCount, rawVoteCount);
    }

    private HashMap<T, Long> makeAnnotationComponentMap(Set<T> sortedValues, HashMap<T, Long> voteCount) {
        HashMap<T, Long> compMap = new HashMap<T, Long>();
        this.annotateTranscript("- First, components are split up and total votes calculated", new Object[0]);
        for (T t2 : sortedValues) {
            Long count = voteCount.get(t2);
            List<T> comps = this.splitAnnotationIntoComponentsList(t2);
            for (T comp : comps) {
                if (compMap.containsKey(comp)) {
                    compMap.replace(comp, (Long)compMap.get(comp) + count);
                    continue;
                }
                compMap.put(comp, count);
            }
        }
        if (this.transcript != null) {
            for (Map.Entry entry : compMap.entrySet()) {
                this.annotateTranscript("-- component '%s' has weight %d", entry.getKey().toString(), entry.getValue());
            }
        }
        return compMap;
    }

    private void calculateNewCountsBasedOnAnnotationComponents(Set<T> sortedValues, HashMap<T, Long> voteCount, HashMap<T, Long> compMap) {
        voteCount.clear();
        this.annotateTranscript("- Next, the original values get new counts, each based on the geometric mean of the products of all components.", new Object[0]);
        for (T value : sortedValues) {
            List<T> comps = this.splitAnnotationIntoComponentsList(value);
            double product = 1.0;
            for (T comp : comps) {
                product *= (double)compMap.get(comp).longValue();
            }
            Long newCount = Math.round(Math.pow(product, 1.0 / (double)comps.size()));
            voteCount.put(value, newCount);
        }
    }

    private List<T> splitAnnotationIntoComponentsList(T value) {
        return DisplayAndInputProcessor.SPLIT_BAR.splitToList((CharSequence)value);
    }

    private void resortValuesBasedOnAdjustedVoteCounts(Set<T> sortedValues, HashMap<T, Long> voteCount) {
        ArrayList<T> list = new ArrayList<T>(sortedValues);
        list.sort((v1, v2) -> {
            int size2;
            long c2;
            long c1 = (Long)voteCount.get(v1);
            if (c1 != (c2 = ((Long)voteCount.get(v2)).longValue())) {
                return c1 < c2 ? 1 : -1;
            }
            int size1 = this.splitAnnotationIntoComponentsList(v1).size();
            if (size1 != (size2 = this.splitAnnotationIntoComponentsList(v2).size())) {
                return size1 < size2 ? -1 : 1;
            }
            return englishCollator.compare(String.valueOf(v1), String.valueOf(v2));
        });
        sortedValues.clear();
        sortedValues.addAll(list);
    }

    private void promoteSuperiorAnnotationSuperset(Set<T> sortedValues, HashMap<T, Long> voteCount, HashMap<T, Long> rawVoteCount) {
        long requiredGap = 2L;
        Object oldWinner = null;
        long oldWinnerRawCount = 0L;
        LinkedHashSet<T> oldWinnerComps = null;
        LinkedHashSet<T> superiorSupersets = null;
        for (T value : sortedValues) {
            long newCount;
            long rawCount = rawVoteCount.get(value);
            if (rawCount != (newCount = voteCount.get(value).longValue())) {
                this.annotateTranscript("-- Value '%s' has updated value '%d'", value, newCount);
            }
            if (oldWinner == null) {
                oldWinner = value;
                oldWinnerRawCount = rawVoteCount.get(value);
                oldWinnerComps = new LinkedHashSet<T>(this.splitAnnotationIntoComponentsList(value));
                continue;
            }
            LinkedHashSet<T> comps = new LinkedHashSet<T>(this.splitAnnotationIntoComponentsList(value));
            if (comps.size() > 20 || !comps.containsAll(oldWinnerComps) || rawVoteCount.get(value) < oldWinnerRawCount + 2L) continue;
            if (superiorSupersets == null) {
                superiorSupersets = new LinkedHashSet<T>();
            }
            superiorSupersets.add(value);
        }
        if (superiorSupersets != null) {
            this.resortValuesBasedOnAdjustedVoteCounts(superiorSupersets, rawVoteCount);
            Object newWinner = null;
            for (Object value : superiorSupersets) {
                if (newWinner == null) {
                    newWinner = value;
                    long newWinnerCount = voteCount.get(oldWinner) + 2L;
                    this.annotateTranscript("- Optimal value (O) '%s' was promoted to value '%d' due to having a superior raw vote count", newWinner, newWinnerCount);
                    voteCount.put(newWinner, newWinnerCount);
                    continue;
                }
                Object newSecond = value;
                long newSecondCount = voteCount.get(oldWinner) + 1L;
                this.annotateTranscript("- Next value (N) '%s' was promoted to value '%d' due to having a superior raw vote count", newSecond, newSecondCount);
                voteCount.put(newSecond, newSecondCount);
                break;
            }
            this.resortValuesBasedOnAdjustedVoteCounts(sortedValues, voteCount);
        }
    }

    private long[] setBestNextAndSameVoteValues(Set<T> sortedValues, HashMap<T, Long> voteCount) {
        long[] weightArray = new long[2];
        this.nValue = null;
        int i = -1;
        Iterator<T> iterator = sortedValues.iterator();
        for (T value : sortedValues) {
            long valueWeight = voteCount.get(value);
            if (++i == 0) {
                this.setWinningValue(value);
                weightArray[0] = valueWeight;
                this.valuesWithSameVotes.add(value);
                this.annotateTranscript("The optimal value (O) is '%s', with a weight of %d", this.winningValue, valueWeight);
                if (sortedValues.size() != 1) continue;
                this.annotateTranscript("- No other values received votes.", new Object[0]);
                continue;
            }
            if (i == 1 && iterator.hasNext()) {
                this.nValue = value;
                weightArray[1] = valueWeight;
                this.annotateNextBestValue(weightArray[0], weightArray[1], this.winningValue, this.nValue);
            }
            if (valueWeight != weightArray[0]) break;
            this.valuesWithSameVotes.add(value);
        }
        return weightArray;
    }

    private Status computeStatus(long O, long N2) {
        if (O > N2) {
            int G;
            int requiredVotes = this.getRequiredVotes();
            if (O >= (long)requiredVotes) {
                Status computedStatus = Status.approved;
                this.annotateTranscript("O>N, and O>%d: %s", new Object[]{requiredVotes, computedStatus});
                return computedStatus;
            }
            if (O >= 4L && Status.contributed.compareTo(this.baselineStatus) > 0) {
                Status computedStatus = Status.contributed;
                this.annotateTranscript("O>=4, and oldstatus (%s)<contributed: %s", new Object[]{this.baselineStatus, computedStatus});
                return computedStatus;
            }
            if (O >= 2L && (G = this.organizationToValueAndVote.getOrgCount(this.winningValue)) >= 2) {
                Status computedStatus = Status.contributed;
                this.annotateTranscript("O>=2, and G (%d)>=2: %s", new Object[]{G, computedStatus});
                return computedStatus;
            }
        }
        if (O >= N2 && O >= 2L) {
            Status computedStatus = Status.provisional;
            this.annotateTranscript("O>=N and O>=2: %s", new Object[]{computedStatus});
            return computedStatus;
        }
        Status computedStatus = Status.unconfirmed;
        this.annotateTranscript("O was not high enough: %s", new Object[]{computedStatus});
        return computedStatus;
    }

    private Status getPossibleWinningStatus() {
        Status possibleStatus;
        if (!this.resolved) {
            this.resolveVotes();
        }
        return (possibleStatus = this.computeStatus(this.organizationToValueAndVote.getBestPossibleVote(), 0L)).compareTo(this.winningStatus) > 0 ? possibleStatus : this.winningStatus;
    }

    public boolean isDisputed() {
        if (!this.resolved) {
            this.resolveVotes();
        }
        if (this.winningStatus.compareTo(Status.contributed) >= 0) {
            return false;
        }
        Status possibleStatus = this.getPossibleWinningStatus();
        return possibleStatus.compareTo(Status.contributed) >= 0;
    }

    public Status getWinningStatus() {
        if (!this.resolved) {
            this.resolveVotes();
        }
        return this.winningStatus;
    }

    private T getOValue() {
        if (!this.resolved) {
            this.resolveVotes();
        }
        return this.oValue;
    }

    private T getNValue() {
        if (!this.resolved) {
            this.resolveVotes();
        }
        return this.nValue;
    }

    public T getWinningValue() {
        if (!this.resolved) {
            this.resolveVotes();
        }
        return this.winningValue;
    }

    private void setWinningValue(T value) {
        this.winningValue = this.changeBaileyToInheritance(value);
    }

    public List<T> getValuesWithSameVotes() {
        if (!this.resolved) {
            this.resolveVotes();
        }
        return new ArrayList<T>(this.valuesWithSameVotes);
    }

    public EnumSet<Organization> getConflictedOrganizations() {
        if (!this.resolved) {
            this.resolveVotes();
        }
        return this.conflictedOrganizations;
    }

    public T getOrgVote(Organization org) {
        return this.organizationToValueAndVote.getOrgVote(org);
    }

    public Map<T, Long> getOrgToVotes(Organization org) {
        return this.organizationToValueAndVote.getOrgToVotes(org);
    }

    public Map<String, Long> getNameTime() {
        return this.organizationToValueAndVote.getNameTime();
    }

    public String toString() {
        return "{bailey: " + (String)(this.organizationToValueAndVote.baileySet ? "\u201c" + this.organizationToValueAndVote.baileyValue + "\u201d " : "none ") + "baseline: {" + this.baselineValue + ", " + this.baselineStatus + "}, " + this.organizationToValueAndVote + ", sameVotes: " + this.valuesWithSameVotes + ", O: " + this.getOValue() + ", N: " + this.getNValue() + ", totals: " + this.totals + ", winning: {" + this.getWinningValue() + ", " + this.getWinningStatus() + "}}";
    }

    public static Map<Integer, String> getIdToPath(String fileName) {
        XPathTableHandler myHandler = new XPathTableHandler();
        XMLFileReader xfr = new XMLFileReader().setHandler(myHandler);
        xfr.read(fileName, XMLFileReader.CONTENT_HANDLER | XMLFileReader.ERROR_HANDLER, false);
        return myHandler.pathIdToPath;
    }

    public static Map<Integer, Map<Integer, CandidateInfo>> getBaseToAlternateToInfo(String fileName, VoterInfoList vil) {
        try {
            VotesHandler myHandler = new VotesHandler(vil);
            XMLFileReader xfr = new XMLFileReader().setHandler(myHandler);
            xfr.read(fileName, XMLFileReader.CONTENT_HANDLER | XMLFileReader.ERROR_HANDLER, false);
            return myHandler.basepathToInfo;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't handle file: " + fileName, e);
        }
    }

    private static String fixBogusDraftStatusValues(String attributeValue) {
        if (attributeValue == null) {
            return "approved";
        }
        if ("confirmed".equals(attributeValue)) {
            return "approved";
        }
        if ("true".equals(attributeValue)) {
            return "unconfirmed";
        }
        if ("unknown".equals(attributeValue)) {
            return "unconfirmed";
        }
        return attributeValue;
    }

    public int size() {
        return this.values.size();
    }

    public Map<T, Long> getResolvedVoteCountsIncludingIntraOrgDisputes() {
        if (!this.resolved) {
            this.resolveVotes();
        }
        LinkedHashMap<T, Long> result = new LinkedHashMap<T, Long>();
        if (this.winningValue != null && !this.totals.containsKey(this.winningValue)) {
            result.put(this.winningValue, 0L);
        }
        for (T value : this.totals.getKeysetSortedByCount(false, this.votesThenUcaCollator)) {
            result.put(value, this.totals.get(value));
        }
        if (this.baselineValue != null && !this.totals.containsKey(this.baselineValue)) {
            result.put(this.baselineValue, 0L);
        }
        for (T value : this.organizationToValueAndVote.allVotesIncludingIntraOrgDispute.getMap().keySet()) {
            if (result.containsKey(value)) continue;
            result.put(value, 0L);
        }
        return result;
    }

    public VoteStatus getStatusForOrganization(Organization orgOfUser) {
        if (!this.resolved) {
            this.resolveVotes();
        }
        if (Status.provisional.compareTo(this.winningStatus) >= 0) {
            return VoteStatus.provisionalOrWorse;
        }
        T orgVote = this.organizationToValueAndVote.getOrgVoteRaw(orgOfUser);
        if (!this.equalsOrgVote(this.winningValue, orgVote)) {
            return VoteStatus.losing;
        }
        int itemsWithVotes = this.totals.size();
        if (itemsWithVotes > 1) {
            return VoteStatus.disputed;
        }
        T singleVotedItem = this.getSingleVotedItem();
        if (!this.equalsOrgVote(this.winningValue, singleVotedItem)) {
            return VoteStatus.disputed;
        }
        if (itemsWithVotes == 0) {
            return VoteStatus.ok_novotes;
        }
        return VoteStatus.ok;
    }

    private T getSingleVotedItem() {
        return this.totals.size() != 1 ? null : (T)this.totals.iterator().next();
    }

    private boolean equalsOrgVote(T value, T orgVote) {
        return orgVote == null || orgVote.equals(value) || CldrUtility.INHERITANCE_MARKER.equals(value) && orgVote.equals(this.organizationToValueAndVote.baileyValue) || CldrUtility.INHERITANCE_MARKER.equals(orgVote) && value.equals(this.organizationToValueAndVote.baileyValue);
    }

    private int countDistinctValuesWithVotes() {
        if (!this.resolved) {
            throw new RuntimeException("countDistinctValuesWithVotes !resolved");
        }
        int count = this.organizationToValueAndVote.allVotesIncludingIntraOrgDispute.size();
        if (count > 1 && this.bothInheritanceAndBaileyHadVotes) {
            return count - 1;
        }
        return count;
    }

    private boolean isUsingKeywordAnnotationVoting() {
        if (this.pathHeader == null) {
            return false;
        }
        String path = this.pathHeader.getOriginalPath();
        return AnnotationUtil.pathIsAnnotation(path) && !path.contains("[@type=\"tts\"]");
    }

    public boolean isValueLocked() {
        return this.valueIsLocked;
    }

    public boolean canFlagOnLosing() {
        return this.valueIsLocked || this.getRequiredVotes() == HIGH_BAR;
    }

    public static Status calculateStatus(CLDRFile baselineFile, String path) {
        XPathParts xpp;
        String draft;
        String fullXPath = baselineFile.getFullXPath(path);
        if (fullXPath == null) {
            fullXPath = path;
        }
        Status status = (draft = (xpp = XPathParts.getFrozenInstance(fullXPath)).getAttributeValue(-1, "draft")) == null ? Status.approved : Status.fromString(draft);
        String srcid = baselineFile.getSourceLocaleIdExtended(path, null, false);
        if (srcid.equals("code-fallback")) {
            status = Status.missing;
        } else if (srcid.equals("root") && !srcid.equals(baselineFile.getLocaleID())) {
            status = Status.missing;
        }
        return status;
    }

    public static String reviseInheritanceAsNeeded(String path, String value, CLDRFile cldrFile) {
        if (!cldrFile.isResolved()) {
            throw new InternalCldrException("must be resolved");
        }
        Output<String> pathWhereFound = new Output<String>();
        Output<String> localeWhereFound = new Output<String>();
        String baileyValue = cldrFile.getBaileyValue(path, pathWhereFound, localeWhereFound);
        if (baileyValue != null && (CldrUtility.INHERITANCE_MARKER.equals(value) || baileyValue.equals(value))) {
            boolean CONSTRUCTED_PSEUDO_PATH_NOT_LATERAL = false;
            value = ((String)pathWhereFound.value).equals(path) ? CldrUtility.INHERITANCE_MARKER : baileyValue;
        }
        return value;
    }

    public static class UnknownVoterException
    extends RuntimeException {
        private static final long serialVersionUID = 3430877787936678609L;
        int voter;

        public UnknownVoterException(int voter) {
            this.voter = voter;
        }

        @Override
        public String toString() {
            return "Unknown voter: " + this.voter;
        }
    }

    static class VotesHandler
    extends XMLFileReader.SimpleHandler {
        private final VoterInfoList voterInfoList;
        Map<Integer, Map<Integer, CandidateInfo>> basepathToInfo = new TreeMap<Integer, Map<Integer, CandidateInfo>>();

        VotesHandler(VoterInfoList vil) {
            this.voterInfoList = vil;
        }

        @Override
        public void handlePathValue(String path, String value) {
            block7: {
                try {
                    int itemId;
                    XPathParts parts = XPathParts.getFrozenInstance(path);
                    if (parts.size() < 2) {
                        return;
                    }
                    int baseId = Integer.parseInt(parts.getAttributeValue(1, "baseXpath"));
                    Map info = this.basepathToInfo.computeIfAbsent(baseId, k -> new TreeMap());
                    CandidateInfo candidateInfo = (CandidateInfo)info.get(itemId = Integer.parseInt(parts.getAttributeValue(2, "xpath")));
                    if (candidateInfo == null) {
                        candidateInfo = new CandidateInfo(this.voterInfoList);
                        info.put(itemId, candidateInfo);
                        candidateInfo.surveyType = Type.valueOf(parts.getAttributeValue(2, "type"));
                        candidateInfo.surveyStatus = Status.valueOf(VoteResolver.fixBogusDraftStatusValues(parts.getAttributeValue(2, "status")));
                    }
                    if (parts.size() < 4) {
                        return;
                    }
                    String lastElement = parts.getElement(3);
                    if (lastElement.equals("old")) {
                        candidateInfo.oldStatus = Status.valueOf(VoteResolver.fixBogusDraftStatusValues(parts.getAttributeValue(3, "status")));
                        break block7;
                    }
                    if (lastElement.equals("vote")) {
                        candidateInfo.voters.add(Integer.parseInt(parts.getAttributeValue(3, "user")));
                        break block7;
                    }
                    throw new IllegalArgumentException("unknown option: " + path);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Can't handle path: " + path, e);
                }
            }
        }
    }

    public static class CandidateInfo {
        public Status oldStatus;
        public Type surveyType;
        public Status surveyStatus;
        public Set<Integer> voters = new TreeSet<Integer>();
        private final VoterInfoList voterInfoList;

        CandidateInfo(VoterInfoList vil) {
            this.voterInfoList = vil;
        }

        public String toString() {
            StringBuilder voterString = new StringBuilder("{");
            for (int voter : this.voters) {
                VoterInfo voterInfo = this.voterInfoList.get(voter);
                if (voterString.length() > 1) {
                    voterString.append(" ");
                }
                voterString.append(voter);
                if (voterInfo == null) continue;
                voterString.append(" ").append(voterInfo);
            }
            voterString.append("}");
            return "{oldStatus: " + this.oldStatus + ", surveyType: " + this.surveyType + ", surveyStatus: " + this.surveyStatus + ", voters: " + voterString + "};";
        }
    }

    public static enum Type {
        proposal,
        optimal;

    }

    static class XPathTableHandler
    extends XMLFileReader.SimpleHandler {
        Matcher matcher = Pattern.compile("id=\"([0-9]+)\"").matcher("");
        Map<Integer, String> pathIdToPath = new HashMap<Integer, String>();

        XPathTableHandler() {
        }

        @Override
        public void handlePathValue(String path, String value) {
            if (!this.matcher.reset(path).find()) {
                throw new IllegalArgumentException("Unknown path " + path);
            }
            this.pathIdToPath.put(Integer.parseInt(this.matcher.group(1)), value);
        }
    }

    private class OrganizationToValueAndVote<T> {
        private final Map<Organization, MaxCounter<T>> orgToVotes = new EnumMap<Organization, MaxCounter<T>>(Organization.class);
        private final Counter<T> allVotesIncludingIntraOrgDispute = new Counter();
        private final Map<Organization, Integer> orgToMax = new EnumMap<Organization, Integer>(Organization.class);
        private final Counter<T> totals = new Counter(true);
        private final Map<String, Long> nameTime = new LinkedHashMap<String, Long>();
        private final Map<Organization, T> orgToAdd = new EnumMap<Organization, T>(Organization.class);
        private T baileyValue;
        private boolean baileySet;

        OrganizationToValueAndVote() {
            for (Organization org : Organization.values()) {
                this.orgToVotes.put(org, new MaxCounter(true));
            }
        }

        public void clear() {
            for (Map.Entry<Organization, MaxCounter<T>> entry : this.orgToVotes.entrySet()) {
                entry.getValue().clear();
            }
            this.orgToAdd.clear();
            this.orgToMax.clear();
            this.allVotesIncludingIntraOrgDispute.clear();
            this.baileyValue = null;
            this.baileySet = false;
            if (VoteResolver.this.transcript != null) {
                VoteResolver.this.transcript = new DeferredTranscript();
            }
        }

        public Map<String, Long> getNameTime() {
            return this.nameTime;
        }

        public void add(T value, int voter, Integer withVotes, Date date) {
            VoterInfo info = VoteResolver.this.voterInfoList.get(voter);
            if (info == null) {
                throw new UnknownVoterException(voter);
            }
            Level level = info.getLevel();
            if (withVotes == null || !level.canVoteWithCount(info.organization, withVotes)) {
                withVotes = level.getVotes(info.organization);
            }
            this.addInternal(value, info, withVotes, date);
        }

        private void addInternal(T value, VoterInfo info, int votes, Date time) {
            value = VoteResolver.this.changeBaileyToInheritance(value);
            this.allVotesIncludingIntraOrgDispute.add(value, (long)votes, time.getTime());
            this.nameTime.put(info.getName(), time.getTime());
            Organization organization = info.getOrganization();
            this.orgToVotes.get((Object)organization).add((Object)value, (long)votes, time.getTime());
            Integer max = this.orgToMax.get((Object)info.getOrganization());
            if (max == null || max < votes) {
                this.orgToMax.put(organization, votes);
            }
        }

        public Counter<T> getTotals(EnumSet<Organization> conflictedOrganizations) {
            if (conflictedOrganizations != null) {
                conflictedOrganizations.clear();
            }
            this.totals.clear();
            VoteResolver.this.annotateTranscript("- Getting all totals by organization:", new Object[0]);
            for (Map.Entry<Organization, MaxCounter<T>> entry : this.orgToVotes.entrySet()) {
                Object value2;
                long weight2;
                Iterator iterator;
                Object value;
                long weight;
                Counter items = entry.getValue();
                if (items.size() == 0 || (weight = items.getCount(value = (iterator = items.getKeysetSortedByCount(false).iterator()).next())) == 0L) continue;
                VoteResolver.this.annotateTranscript("-- Considering %s which has %d item(s)", entry.getKey().getDisplayName(), items.size());
                Organization org = entry.getKey();
                if (iterator.hasNext() && weight == (weight2 = items.getCount(value2 = iterator.next())) && conflictedOrganizations != null) {
                    VoteResolver.this.annotateTranscript("--- There are conflicts due to different values by users of this organization.", new Object[0]);
                    conflictedOrganizations.add(org);
                }
                this.orgToAdd.put(org, value);
                long maxCount = 0L;
                Object considerItem = null;
                long considerCount = 0L;
                long maxtime = 0L;
                long considerTime = 0L;
                for (Object item : items.keySet()) {
                    long count = items.getCount(item);
                    long time = items.getTime(item);
                    if (count > maxCount) {
                        maxCount = count;
                        maxtime = time;
                        if (considerItem != null) {
                            VoteResolver.this.annotateTranscript("---- Org is not voting for '%s': there is a higher ranked vote", considerItem);
                        }
                        considerItem = item;
                        considerCount = items.getCount(considerItem);
                        considerTime = items.getTime(considerItem);
                        continue;
                    }
                    if (time <= maxtime || count != maxCount) continue;
                    maxtime = time;
                    if (considerItem != null) {
                        VoteResolver.this.annotateTranscript("---- Org is not voting for '%s': there is a later vote", considerItem);
                    }
                    considerItem = item;
                    considerCount = items.getCount(considerItem);
                    considerTime = items.getTime(considerItem);
                }
                VoteResolver.this.annotateTranscript("--- %s vote is for '%s' with strength %d", org.getDisplayName(), considerItem, considerCount);
                this.orgToAdd.put(org, considerItem);
                this.totals.add(considerItem, considerCount, considerTime);
            }
            return this.totals;
        }

        public int getOrgCount(T winningValue) {
            int orgCount = 0;
            for (Map.Entry<Organization, MaxCounter<T>> entry : this.orgToVotes.entrySet()) {
                Counter counter = entry.getValue();
                long count = counter.getCount(winningValue);
                if (count <= 0L) continue;
                ++orgCount;
            }
            return orgCount;
        }

        private int getBestPossibleVote() {
            int total = 0;
            for (Map.Entry<Organization, Integer> entry : this.orgToMax.entrySet()) {
                total += entry.getValue().intValue();
            }
            return total;
        }

        public String toString() {
            Object orgToVotesString = "";
            for (Map.Entry<Organization, MaxCounter<T>> entry : this.orgToVotes.entrySet()) {
                Counter counter = entry.getValue();
                if (counter.size() == 0) continue;
                if (((String)orgToVotesString).length() != 0) {
                    orgToVotesString = (String)orgToVotesString + ", ";
                }
                Organization org = entry.getKey();
                orgToVotesString = (String)orgToVotesString + org.toString() + "=" + counter;
            }
            EnumSet<Organization> conflicted = EnumSet.noneOf(Organization.class);
            return "{orgToVotes: " + (String)orgToVotesString + ", totals: " + this.getTotals(conflicted) + ", conflicted: " + conflicted + "}";
        }

        @Deprecated
        public T getOrgVote(Organization org) {
            return this.orgToAdd.get((Object)org);
        }

        public T getOrgVoteRaw(Organization orgOfUser) {
            return this.orgToAdd.get((Object)orgOfUser);
        }

        public Map<T, Long> getOrgToVotes(Organization org) {
            LinkedHashMap result = new LinkedHashMap();
            MaxCounter counter = this.orgToVotes.get((Object)org);
            for (Object item : counter) {
                result.put(item, counter.getCount(item));
            }
            return result;
        }
    }

    static class MaxCounter<T>
    extends Counter<T> {
        public MaxCounter(boolean b) {
            super(b);
        }

        @Override
        public MaxCounter<T> add(T obj, long countValue, long time) {
            long value = this.getCount(obj);
            if (value <= countValue) {
                super.add(obj, countValue - value, time);
            }
            return this;
        }
    }

    public static class VoterInfo {
        private Organization organization;
        private Level level;
        private String name;
        private final Set<CLDRLocale> locales = new TreeSet<CLDRLocale>();

        public Iterable<CLDRLocale> getLocales() {
            return this.locales;
        }

        public VoterInfo(Organization organization, Level level, String name, LocaleSet localeSet) {
            this.setOrganization(organization);
            this.setLevel(level);
            this.setName(name);
            if (!localeSet.isAllLocales()) {
                this.locales.addAll(localeSet.getSet());
            }
        }

        public VoterInfo(Organization organization, Level level, String name) {
            this.setOrganization(organization);
            this.setLevel(level);
            this.setName(name);
        }

        public VoterInfo() {
        }

        public String toString() {
            return "{" + this.getName() + ", " + this.getLevel() + ", " + this.getOrganization() + "}";
        }

        public void setOrganization(Organization organization) {
            this.organization = organization;
        }

        public Organization getOrganization() {
            return this.organization;
        }

        public void setLevel(Level level) {
            this.level = level;
        }

        public Level getLevel() {
            return this.level;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        void addLocale(CLDRLocale locale) {
            this.locales.add(locale);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            VoterInfo other = (VoterInfo)obj;
            return this.organization.equals((Object)other.organization) && this.level.equals((Object)other.level) && this.name.equals(other.name) && Objects.equal(this.locales, other.locales);
        }

        public int hashCode() {
            return this.organization.hashCode() ^ this.level.hashCode() ^ this.name.hashCode();
        }
    }

    public static enum VoteStatus {
        ok_novotes,
        ok,
        provisionalOrWorse,
        losing,
        disputed;

    }

    public static enum Level {
        locked(0, 999),
        guest(1, 10),
        anonymous(0, 8),
        vetter(4, 5, 6),
        manager(4, 2),
        tc(50, 1),
        admin(100, 0);

        public static final int PERMANENT_VOTES = 1000;
        public static final int LOCKING_VOTES = 2000;
        private final int votes;
        private final int tcorgvotes;
        private final int stlevel;
        private ImmutableSet<Integer> voteCountMenu = null;

        private Level(int votes, int stlevel, int tcorgvotes) {
            this.votes = votes;
            this.stlevel = stlevel;
            this.tcorgvotes = tcorgvotes;
        }

        private Level(int votes, int stlevel) {
            this(votes, stlevel, votes);
        }

        public int getVotes(Organization o) {
            if (this == vetter && o.isTCOrg()) {
                return this.tcorgvotes;
            }
            return this.votes;
        }

        public int getSTLevel() {
            return this.stlevel;
        }

        public static Level fromSTLevel(int stlevel) {
            for (Level l : Level.values()) {
                if (l.getSTLevel() != stlevel) continue;
                return l;
            }
            return null;
        }

        public boolean isManagerFor(Organization myOrg, Level otherLevel, Organization otherOrg) {
            return this == admin || this.canManageSomeUsers() && myOrg == otherOrg && this.atLeastAsPowerfulAs(otherLevel);
        }

        public boolean canManageSomeUsers() {
            return this.atLeastAsPowerfulAs(manager);
        }

        boolean morePowerfulThan(Level other) {
            return this.getSTLevel() < other.getSTLevel();
        }

        boolean atLeastAsPowerfulAs(Level other) {
            return this.getSTLevel() <= other.getSTLevel();
        }

        public boolean canCreateOrSetLevelTo(Level otherLevel) {
            if (!this.canManageSomeUsers()) {
                return false;
            }
            return !otherLevel.morePowerfulThan(this);
        }

        public boolean canVoteWithCount(Organization org, int withVotes) {
            if (withVotes == 2000 && this == admin) {
                return true;
            }
            ImmutableSet<Integer> menu = this.getVoteCountMenu(org);
            return menu == null ? withVotes == this.getVotes(org) : menu.contains(withVotes);
        }

        public ImmutableSet<Integer> getVoteCountMenu(Organization ignoredOrg) {
            return this.voteCountMenu;
        }

        public boolean isAdmin() {
            return this.stlevel <= Level.admin.stlevel;
        }

        public boolean isTC() {
            return this.stlevel <= Level.tc.stlevel;
        }

        public boolean isExactlyManager() {
            return this.stlevel == Level.manager.stlevel;
        }

        public boolean isManagerOrStronger() {
            return this.stlevel <= Level.manager.stlevel;
        }

        public boolean isVetter() {
            return this.stlevel <= Level.vetter.stlevel;
        }

        public boolean isGuest() {
            return this.stlevel <= Level.guest.stlevel;
        }

        public boolean isLocked() {
            return this.stlevel == Level.locked.stlevel;
        }

        public boolean isExactlyAnonymous() {
            return this.stlevel == Level.anonymous.stlevel;
        }

        public boolean isAdminForOrg(Organization myOrg, Organization target) {
            return this.isAdmin() || (this.isTC() || this.stlevel == Level.manager.stlevel) && myOrg == target;
        }

        public boolean canImportOldVotes(CheckCLDR.Phase inPhase) {
            return this.isVetter() && inPhase == CheckCLDR.Phase.SUBMISSION;
        }

        public boolean canListUsers() {
            return this.isManagerOrStronger();
        }

        public boolean canCreateUsers() {
            return this.isTC() || this.isExactlyManager();
        }

        public boolean canEmailUsers() {
            return this.isTC() || this.isExactlyManager();
        }

        public boolean canModifyUsers() {
            return this.isTC() || this.isExactlyManager();
        }

        public boolean canCreateOtherOrgs() {
            return this.isAdmin();
        }

        public boolean canUseVettingSummary() {
            return this.isManagerOrStronger();
        }

        public boolean canSubmit(CheckCLDR.Phase inPhase) {
            if (inPhase == CheckCLDR.Phase.FINAL_TESTING) {
                return false;
            }
            return this.isGuest();
        }

        public boolean canCreateSummarySnapshot() {
            return this.isAdmin();
        }

        public boolean canMonitorForum() {
            return this.isTC() || this.isExactlyManager();
        }

        public boolean canSetInterestLocales() {
            return this.isManagerOrStronger();
        }

        public boolean canGetEmailList() {
            return this.isManagerOrStronger();
        }

        public boolean canDeleteUsers() {
            return this.isAdmin();
        }

        public boolean canUseVettingParticipation() {
            return this.isManagerOrStronger();
        }

        static {
            Level.admin.voteCountMenu = ImmutableSet.of(Integer.valueOf(Level.guest.votes), Integer.valueOf(Level.vetter.votes), Integer.valueOf(Level.vetter.tcorgvotes), Integer.valueOf(Level.tc.votes), Integer.valueOf(Level.admin.votes), Integer.valueOf(1000), new Integer[0]);
            Level.tc.voteCountMenu = ImmutableSet.of(Integer.valueOf(Level.guest.votes), Integer.valueOf(Level.vetter.votes), Integer.valueOf(Level.vetter.tcorgvotes), Integer.valueOf(Level.tc.votes), Integer.valueOf(1000));
        }
    }

    public static enum Status {
        missing,
        unconfirmed,
        provisional,
        contributed,
        approved;


        public static Status fromString(String source) {
            return source == null ? missing : Status.valueOf(source);
        }
    }
}

