/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.posix;

import com.ibm.icu.dev.util.UOption;
import com.ibm.icu.text.UnicodeSet;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.posix.POSIXLocale;
import org.unicode.cldr.posix.POSIXVariant;

public class GeneratePOSIX {
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int DESTDIR = 2;
    private static final int MATCH = 3;
    private static final int UNICODESET = 4;
    private static final int COLLATESET = 5;
    private static final int CHARSET = 6;
    private static final UOption[] options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.create("destdir", 'd', 1).setDefault("."), UOption.create("match", 'm', 1), UOption.create("unicodeset", 'u', 1), UOption.create("collateset", 'x', 1), UOption.create("charset", 'c', 1).setDefault("UTF-8")};

    public static void main(String[] args) throws Exception {
        UOption.parseArgs(args, options);
        if (!GeneratePOSIX.options[3].doesOccur || GeneratePOSIX.options[0].doesOccur || GeneratePOSIX.options[1].doesOccur) {
            GeneratePOSIX.Usage();
        }
        String[] matchargs = GeneratePOSIX.options[3].value.split("@", 2);
        String locale = matchargs[0];
        POSIXVariant variant = GeneratePOSIX.options[3].value.indexOf("@") > 0 ? new POSIXVariant(matchargs[1]) : new POSIXVariant();
        String codeset = GeneratePOSIX.options[6].value;
        UnicodeSet collate_set = GeneratePOSIX.options[5].doesOccur ? new UnicodeSet(GeneratePOSIX.options[5].value) : new UnicodeSet();
        UnicodeSet repertoire = GeneratePOSIX.options[4].doesOccur ? new UnicodeSet(GeneratePOSIX.options[4].value) : new UnicodeSet();
        if (!codeset.equals("UTF-8") && (GeneratePOSIX.options[5].doesOccur || GeneratePOSIX.options[4].doesOccur)) {
            System.out.println("Error: Specifying a non-UTF-8 codeset and repertoire or collation overrides are mutually exclusive.");
            GeneratePOSIX.Usage();
        }
        POSIXLocale pl = new POSIXLocale(locale, repertoire, Charset.forName(GeneratePOSIX.options[6].value), codeset, collate_set, variant);
        PrintWriter out = FileUtilities.openUTF8Writer(GeneratePOSIX.options[2].value + File.separator, GeneratePOSIX.options[3].value + "." + codeset + ".src");
        pl.write(out);
        out.close();
    }

    public static void Usage() {
        System.out.println("Usage: GeneratePOSIX [-d target_dir] -m locale_name[@variants]");
        System.out.println("                     { [-c codeset] | [-u repertoire_set][-x collation_set] }");
        System.out.println("where:");
        System.out.println("   -d target_dir is the directory where POSIX .src files will be written");
        System.out.println("   -m locale_name is the language/territory you want to generate");
        System.out.println("   -c codeset is the character set to use for the locale (Default = UTF-8)");
        System.out.println("   -u repertoire_set : Use to override the default repertoire set (UnicodeSet format)");
        System.out.println("   -x collation_set  : Use to override the default collation set (UnicodeSet format)");
        System.exit(-1);
    }
}

