/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.FactoryCheckCLDR;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleXMLSource;
import org.unicode.cldr.util.XPathParts;

public class CheckDisplayCollisions
extends FactoryCheckCLDR {
    private static final String DEBUG_PATH_PART = "-mass";
    private static final boolean LOG_PATH_REMOVALS = false;
    private static final boolean CHECK_FLAG_AND_EMOJI = false;
    static long year = 31556952000L;
    static long startDate = CheckDisplayCollisions.getDateTimeinMillis(1995, 0, 15);
    static long endDate = CheckDisplayCollisions.getDateTimeinMillis(2011, 0, 15);
    static final boolean SKIP_TYPE_CHECK = true;
    private final Matcher exclusions = PatternCache.get("=\"narrow\"]").matcher("");
    private final Matcher typePattern = PatternCache.get("\\[@type=\"([^\"]*+)\"]").matcher("");
    private final Matcher ignoreAltAndCountAttributes = PatternCache.get("\\[@(?:count|alt|gender|case)=\"[^\"]*+\"]").matcher("");
    private final Matcher ignoreAltAttributes = PatternCache.get("\\[@(?:alt)=\"[^\"]*+\"]").matcher("");
    private final Matcher ignoreAltShortOrVariantAttributes = PatternCache.get("\\[@(?:alt)=\"(?:short|variant)\"]").matcher("");
    private final Matcher compoundUnitPatterns = PatternCache.get("compoundUnitPattern").matcher("");
    private static final Map<String, Set<String>> mapPathPartsToSetsForDupOK = CheckDisplayCollisions.createMapPathPartsToSets();
    private Map<String, String> exceptions;

    private static long getDateTimeinMillis(int year, int month, int date) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, date);
        return cal.getTimeInMillis();
    }

    private static Map<String, Set<String>> createMapPathPartsToSets() {
        HashMap<String, Set<String>> mapPathPartsToSets = new HashMap<String, Set<String>>();
        HashSet<String> set1 = new HashSet<String>();
        set1.add("/unit[@type=\"energy-foodcalorie\"]");
        set1.add("/unit[@type=\"length-inch\"]");
        mapPathPartsToSets.put("/unit[@type=\"energy-calorie\"]", set1);
        HashSet<String> set2 = new HashSet<String>();
        set2.add("/unit[@type=\"energy-calorie\"]");
        set2.add("/unit[@type=\"energy-kilocalorie\"]");
        set2.add("/unit[@type=\"length-inch\"]");
        mapPathPartsToSets.put("/unit[@type=\"energy-foodcalorie\"]", set2);
        HashSet<String> set3 = new HashSet<String>();
        set3.add("/unit[@type=\"energy-foodcalorie\"]");
        mapPathPartsToSets.put("/unit[@type=\"energy-kilocalorie\"]", set3);
        HashSet<String> set4 = new HashSet<String>();
        set4.add("/unit[@type=\"concentr-karat\"]");
        mapPathPartsToSets.put("/unit[@type=\"mass-carat\"]", set4);
        HashSet<String> set5 = new HashSet<String>();
        set5.add("/unit[@type=\"mass-carat\"]");
        set5.add("/unit[@type=\"temperature-kelvin\"]");
        mapPathPartsToSets.put("/unit[@type=\"concentr-karat\"]", set5);
        HashSet<String> set6 = new HashSet<String>();
        set6.add("/unit[@type=\"mass-tonne\"]");
        mapPathPartsToSets.put("/unit[@type=\"digital-byte\"]", set6);
        HashSet<String> set7 = new HashSet<String>();
        set7.add("/unit[@type=\"digital-byte\"]");
        mapPathPartsToSets.put("/unit[@type=\"mass-tonne\"]", set7);
        HashSet<String> set9 = new HashSet<String>();
        set9.add("/unit[@type=\"energy-calorie\"]");
        set9.add("/unit[@type=\"energy-foodcalorie\"]");
        mapPathPartsToSets.put("/unit[@type=\"length-inch\"]", set9);
        HashSet<String> set10 = new HashSet<String>();
        set10.add("/unit[@type=\"angle-arc-minute\"]");
        mapPathPartsToSets.put("/unit[@type=\"length-foot\"]", set10);
        HashSet<String> set11 = new HashSet<String>();
        set11.add("/unit[@type=\"length-foot\"]");
        mapPathPartsToSets.put("/unit[@type=\"angle-arc-minute\"]", set11);
        HashSet<String> set12 = new HashSet<String>();
        set12.add("/unit[@type=\"concentr-karat\"]");
        mapPathPartsToSets.put("/unit[@type=\"temperature-kelvin\"]", set12);
        HashSet<String> set13 = new HashSet<String>();
        set13.add("/unit[@type=\"angle-degree\"]");
        mapPathPartsToSets.put("/unit[@type=\"temperature-generic\"]", set13);
        HashSet<String> set14 = new HashSet<String>();
        set14.add("/unit[@type=\"temperature-generic\"]");
        mapPathPartsToSets.put("/unit[@type=\"angle-degree\"]", set14);
        HashSet<String> set15 = new HashSet<String>();
        set15.add("/unit[@type=\"volume-pint\"]");
        set15.add("/unit[@type=\"mass-pound\"]");
        mapPathPartsToSets.put("/unit[@type=\"length-point\"]", set15);
        HashSet<String> set16 = new HashSet<String>();
        set16.add("/unit[@type=\"length-point\"]");
        mapPathPartsToSets.put("/unit[@type=\"volume-pint\"]", set16);
        HashSet<String> set17 = new HashSet<String>();
        set17.add("/unit[@type=\"pressure-millibar\"]");
        mapPathPartsToSets.put("/unit[@type=\"pressure-hectopascal\"]", set17);
        HashSet<String> set18 = new HashSet<String>();
        set18.add("/unit[@type=\"pressure-hectopascal\"]");
        mapPathPartsToSets.put("/unit[@type=\"pressure-millibar\"]", set18);
        HashSet<String> set19 = new HashSet<String>();
        set19.add("/unit[@type=\"length-point\"]");
        mapPathPartsToSets.put("/unit[@type=\"mass-pound\"]", set19);
        HashSet<String> set20 = new HashSet<String>();
        set20.add("/unitLength[@type=\"short\"]/unit[@type=\"duration-second\"]");
        mapPathPartsToSets.put("/unitLength[@type=\"short\"]/unit[@type=\"duration-century\"]", set20);
        HashSet<String> set21 = new HashSet<String>();
        set21.add("/unitLength[@type=\"short\"]/unit[@type=\"duration-century\"]");
        mapPathPartsToSets.put("/unitLength[@type=\"short\"]/unit[@type=\"duration-second\"]", set21);
        CheckDisplayCollisions.addNonColliding(mapPathPartsToSets, "[@type=\"graphics-pixel\"]", "[@type=\"graphics-dot\"]");
        CheckDisplayCollisions.addNonColliding(mapPathPartsToSets, "[@type=\"graphics-pixel-per-inch\"]", "[@type=\"graphics-dot-per-inch\"]");
        CheckDisplayCollisions.addNonColliding(mapPathPartsToSets, "[@type=\"graphics-dot-per-centimeter\"]", "[@type=\"graphics-pixel-per-centimeter\"]");
        CheckDisplayCollisions.addNonColliding(mapPathPartsToSets, "[@type=\"duration-year-person\"]", "[@type=\"duration-year\"]");
        CheckDisplayCollisions.addNonColliding(mapPathPartsToSets, "[@type=\"duration-month-person\"]", "[@type=\"duration-month\"]");
        CheckDisplayCollisions.addNonColliding(mapPathPartsToSets, "[@type=\"duration-week-person\"]", "[@type=\"duration-week\"]");
        CheckDisplayCollisions.addNonColliding(mapPathPartsToSets, "[@type=\"duration-day-person\"]", "[@type=\"duration-day\"]");
        return ImmutableMap.copyOf(mapPathPartsToSets);
    }

    public static void addNonColliding(Map<String, Set<String>> mapPathPartsToSets, String ... alternatives) {
        LinkedHashSet<String> items = new LinkedHashSet<String>(Arrays.asList(alternatives));
        for (String item : items) {
            LinkedHashSet<String> others = new LinkedHashSet<String>(items);
            others.remove(item);
            mapPathPartsToSets.put(item, ImmutableSet.copyOf(others));
        }
    }

    public CheckDisplayCollisions(Factory factory) {
        super(factory);
    }

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        String fieldType;
        String curVal;
        Iterator<String> iterator;
        Set<String> paths;
        XPathParts parts;
        if (fullPath == null) {
            return this;
        }
        if (value == null || value.length() == 0) {
            return this;
        }
        if (value.equals(CldrUtility.NO_INHERITANCE_MARKER) || value.equals(CldrUtility.INHERITANCE_MARKER)) {
            return this;
        }
        if (!this.accept(result)) {
            return this;
        }
        Type myType = Type.getType(path);
        if (myType == null || myType == Type.UNITS_IGNORE) {
            return this;
        }
        String myPrefix = myType.getPrefix();
        if (this.exclusions.reset(path).find() && myType != Type.UNITS_COORDINATE) {
            return this;
        }
        Matcher matcher = null;
        String message = "Can't have same translation as {0}. Please change either this name or the other one.";
        Matcher currentAttributesToIgnore = this.ignoreAltAndCountAttributes;
        if (myType == Type.DECIMAL_FORMAT) {
            if (!path.contains("[@count=") || "0".equals(value)) {
                return this;
            }
            parts = XPathParts.getFrozenInstance(path).cloneAsThawed();
            String type = parts.getAttributeValue(-1, "type");
            myPrefix = parts.removeElement(-1).toString();
            matcher = PatternCache.get(myPrefix.replaceAll("\\[", "\\\\[") + "/pattern\\[@type=(?!\"" + type + "\")\"\\d+\"].*").matcher(path);
            currentAttributesToIgnore = this.ignoreAltAttributes;
            message = "Can't have same number pattern as {0}";
            paths = this.getPathsWithValue(this.getResolvedCldrFileToCheck(), path, value, myType, myPrefix, matcher, currentAttributesToIgnore, Equivalence.exact);
        } else if (myType == Type.UNITS || myType == Type.UNIT_PREFIX) {
            currentAttributesToIgnore = this.ignoreAltAttributes;
            paths = this.getPathsWithValue(this.getResolvedCldrFileToCheck(), path, value, myType, myPrefix, matcher, currentAttributesToIgnore, Equivalence.unit);
        } else if (myType == Type.CARDINAL_MINIMAL || myType == Type.ORDINAL_MINIMAL) {
            if (value.equals("{0}?")) {
                return this;
            }
            currentAttributesToIgnore = this.ignoreAltAttributes;
            paths = this.getPathsWithValue(this.getResolvedCldrFileToCheck(), path, value, myType, myPrefix, matcher, currentAttributesToIgnore, Equivalence.normal);
        } else if (myType == Type.SCRIPT) {
            currentAttributesToIgnore = this.ignoreAltShortOrVariantAttributes;
            paths = this.getPathsWithValue(this.getResolvedCldrFileToCheck(), path, value, myType, myPrefix, matcher, currentAttributesToIgnore, Equivalence.normal);
        } else {
            paths = this.getPathsWithValue(this.getResolvedCldrFileToCheck(), path, value, myType, myPrefix, matcher, currentAttributesToIgnore, Equivalence.normal);
        }
        if (myType == Type.TERRITORY || myType == Type.ZONE) {
            Type otherType = myType == Type.TERRITORY ? Type.ZONE : Type.TERRITORY;
            Set<String> duplicatePaths = this.getPathsWithValue(this.getResolvedCldrFileToCheck(), path, value, otherType, otherType.getPrefix(), null, currentAttributesToIgnore, Equivalence.normal);
            String exceptionRegion = this.getRegionException(this.getRegion(myType, path));
            if (exceptionRegion != null) {
                for (String duplicatePath : duplicatePaths) {
                    String duplicateRegion = this.getRegion(otherType, duplicatePath);
                    if (!exceptionRegion.equals(duplicateRegion)) continue;
                    duplicatePaths.remove(duplicatePath);
                    this.log("Removed duplicate path: '" + duplicatePath + "'");
                }
            }
            paths.addAll(duplicatePaths);
        }
        if (paths.isEmpty()) {
            return this;
        }
        if (myType == Type.CURRENCY) {
            if (path.contains("/decimal") || path.contains("/group")) {
                return this;
            }
            if (path.contains("/symbol") && value.equals("\\u200B")) {
                String decimalPath = path.replace("/symbol", "/decimal");
                String decimalValue = this.getResolvedCldrFileToCheck().getWinningValue(decimalPath);
                if (decimalValue != null && decimalValue.length() > 0) {
                    return this;
                }
            }
            parts = XPathParts.getFrozenInstance(path);
            String currency = parts.getAttributeValue(-2, "type");
            iterator = paths.iterator();
            while (iterator.hasNext()) {
                curVal = iterator.next();
                parts = XPathParts.getFrozenInstance(curVal);
                if (!currency.equals(parts.getAttributeValue(-2, "type")) && !curVal.contains("/decimal") && !curVal.contains("/group")) continue;
                iterator.remove();
                this.log("Removed '" + curVal + "': COLLISON WITH CURRENCY " + currency);
            }
        }
        if (myType == Type.UNITS || myType == Type.UNIT_PREFIX) {
            parts = XPathParts.getFrozenInstance(path);
            int typeLocation = 3;
            String myUnit = parts.getAttributeValue(typeLocation, "type");
            boolean isDuration = myUnit.startsWith("duration");
            Iterator<String> iterator2 = paths.iterator();
            block2: while (iterator2.hasNext()) {
                String curVal2 = iterator2.next();
                parts = XPathParts.getFrozenInstance(curVal2);
                String unit = parts.getAttributeValue(typeLocation, "type");
                if (unit == null || myUnit.equals(unit) || isDuration != unit.startsWith("duration") || this.compoundUnitPatterns.reset(curVal2).find()) {
                    iterator2.remove();
                    this.log("Removed '" + curVal2 + "': COLLISON WITH UNIT  " + unit);
                    continue;
                }
                for (Map.Entry<String, Set<String>> mapPathPartToSet : mapPathPartsToSetsForDupOK.entrySet()) {
                    if (!path.contains(mapPathPartToSet.getKey())) continue;
                    for (String pathPart : mapPathPartToSet.getValue()) {
                        if (!curVal2.contains(pathPart)) continue;
                        iterator2.remove();
                        this.log("Removed '" + curVal2 + "': COLLISON WITH UNIT  " + unit);
                        continue block2;
                    }
                    continue block2;
                }
            }
        }
        if (myType == Type.FIELDS_RELATIVE) {
            parts = XPathParts.getFrozenInstance(path);
            String myFieldType = parts.getAttributeValue(3, "type").split("-")[0];
            iterator = paths.iterator();
            while (iterator.hasNext()) {
                curVal = iterator.next();
                parts = XPathParts.getFrozenInstance(curVal);
                fieldType = parts.getAttributeValue(3, "type").split("-")[0];
                if (!myFieldType.equals(fieldType)) continue;
                iterator.remove();
                this.log("Removed '" + curVal + "': COLLISON WITH FIELD  " + fieldType);
            }
        }
        if (myType == Type.UNITS_COORDINATE) {
            parts = XPathParts.getFrozenInstance(path);
            String myFieldType = parts.containsElement("displayName") ? "displayName" : parts.findAttributeValue("coordinateUnitPattern", "type");
            iterator = paths.iterator();
            while (iterator.hasNext()) {
                curVal = iterator.next();
                parts = XPathParts.getFrozenInstance(curVal);
                fieldType = parts.containsElement("displayName") ? "displayName" : parts.findAttributeValue("coordinateUnitPattern", "type");
                if (!myFieldType.equals(fieldType)) continue;
                iterator.remove();
                this.log("Removed '" + curVal + "': COLLISON WITH FIELD  " + fieldType);
            }
        }
        if (paths.isEmpty()) {
            return this;
        }
        TreeSet<String> collidingTypes = new TreeSet<String>();
        for (String pathName : paths) {
            currentAttributesToIgnore.reset(pathName);
            collidingTypes.add(this.getPathReferenceForMessage(pathName, false));
        }
        this.log("CollidingTypes has a size of " + collidingTypes.size());
        CheckCLDR.CheckStatus.Type thisErrorType = this.getPhase() == CheckCLDR.Phase.BUILD ? CheckCLDR.CheckStatus.warningType : CheckCLDR.CheckStatus.errorType;
        if (path.contains("timeZoneNames") && collidingTypes.size() == 1) {
            int csEnd;
            int csStart;
            PathHeader pathHeader = this.getPathHeaderFactory().fromPath(path);
            String thisZone = pathHeader.getHeader();
            String thisZoneType = pathHeader.getCode();
            String collisionString = ((Object)collidingTypes).toString();
            if (collisionString.startsWith("[<a")) {
                csStart = collisionString.indexOf(62) + 1;
                csEnd = collisionString.indexOf(60, csStart);
            } else {
                csStart = collisionString.indexOf(91) + 1;
                csEnd = collisionString.indexOf(93, csStart);
            }
            collisionString = collisionString.substring(csStart, csEnd);
            int delimiter_index = collisionString.indexOf(58);
            String collidingZone = collisionString.substring(0, delimiter_index);
            String collidingZoneType = collisionString.substring(delimiter_index + 2);
            if (thisZone.equals(collidingZone)) {
                if (thisZone.startsWith("Etc/") && (thisZoneType.equals("exemplarCity") || collidingZoneType.equals("exemplarCity"))) {
                    this.log("Ignore a collision between exemplarCity and another name for Etc/* zones");
                    return this;
                }
                TreeSet<String> collidingZoneTypes = new TreeSet<String>();
                collidingZoneTypes.add(thisZoneType);
                collidingZoneTypes.add(collidingZoneType);
                if (collidingZoneTypes.size() == 2 && collidingZoneTypes.contains("standard-short") && collidingZoneTypes.contains("generic-short")) {
                    thisErrorType = CheckCLDR.CheckStatus.warningType;
                }
            }
        } else if (myType == Type.SCRIPT && collidingTypes.size() == 1) {
            String collisionString = ((Object)collidingTypes).toString();
            if (path.contains("stand-alone") || collisionString.contains("stand-alone")) {
                thisErrorType = CheckCLDR.CheckStatus.warningType;
            }
        }
        CheckCLDR.CheckStatus item = new CheckCLDR.CheckStatus().setCause(this).setMainType(thisErrorType).setSubtype(CheckCLDR.CheckStatus.Subtype.displayCollision).setCheckOnSubmit(false).setMessage(message, ((Object)collidingTypes).toString());
        result.add(item);
        return this;
    }

    private void log(String string) {
    }

    private Set<String> getPathsWithValue(CLDRFile file, String path, String value, Type myType, String myPrefix, Matcher matcher, Matcher currentAttributesToIgnore, Equivalence equivalence) {
        if (DEBUG_PATH_PART != null & path.contains(DEBUG_PATH_PART)) {
            boolean bl = false;
        }
        HashSet<String> retrievedPaths = new HashSet<String>();
        if (myType.matchType == MatchType.PREFIX) {
            file.getPathsWithValue(value, myPrefix, matcher, retrievedPaths);
        } else {
            file.getPathsWithValue(value, "//ldml", myType.getPattern().matcher(""), retrievedPaths);
        }
        String normValue = null;
        if (equivalence == Equivalence.unit) {
            normValue = SimpleXMLSource.normalizeCaseSensitive(value);
        }
        HashSet<String> paths = new HashSet<String>();
        for (String pathName : retrievedPaths) {
            String otherValue;
            Type thisPathType = Type.getType(pathName);
            if (myType != thisPathType || this.exclusions.reset(pathName).find() && thisPathType != Type.UNITS_COORDINATE || !this.getResolvedCldrFileToCheck().isWinningPath(path) || myType == Type.CURRENCY && this.isCodeFallback(path) || (equivalence == Equivalence.exact ? !(otherValue = file.getWinningValue(pathName)).equals(value) : equivalence == Equivalence.unit && !(otherValue = SimpleXMLSource.normalizeCaseSensitive(file.getWinningValue(pathName))).equals(normValue))) continue;
            String newPath = currentAttributesToIgnore.reset(pathName).replaceAll("");
            paths.add(newPath);
        }
        String cleanPath = currentAttributesToIgnore.reset(path).replaceAll("");
        paths.remove(cleanPath);
        return paths;
    }

    private boolean isCodeFallback(String dpath) {
        String locale = this.getResolvedCldrFileToCheck().getSourceLocaleID(dpath, null);
        return locale.equals("code-fallback");
    }

    @Override
    public CheckCLDR handleSetCldrFileToCheck(CLDRFile cldrFileToCheck, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        if (cldrFileToCheck == null) {
            return this;
        }
        super.handleSetCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        return this;
    }

    private String getRegion(Type type, String xpath) {
        int index = type == Type.ZONE ? -2 : -1;
        return XPathParts.getFrozenInstance(xpath).getAttributeValue(index, "type");
    }

    public String getRegionException(String regionCode) {
        if (this.exceptions != null) {
            String lookup = this.exceptions.get(regionCode);
            return lookup;
        }
        CLDRFile english = this.getEnglishFile();
        this.exceptions = new HashMap<String, String>();
        Iterator<String> it = english.iterator(Type.ZONE.getPrefix());
        while (it.hasNext()) {
            String value;
            Set<String> duplicates;
            String xpath = it.next();
            if (!xpath.endsWith("/exemplarCity") || (duplicates = this.getPathsWithValue(english, xpath, value = english.getStringValue(xpath), Type.TERRITORY, Type.TERRITORY.getPrefix(), null, this.ignoreAltAndCountAttributes, Equivalence.normal)).size() <= 0) continue;
            String duplicatePath = duplicates.iterator().next();
            String exemplarCity = this.getRegion(Type.ZONE, xpath);
            String territory = this.getRegion(Type.TERRITORY, duplicatePath);
            this.addRegionException(exemplarCity, territory);
        }
        this.addRegionException("America/Antigua", "AG");
        this.addRegionException("Atlantic/Canary", "IC");
        this.addRegionException("America/Cayman", "KY");
        this.addRegionException("Indian/Christmas", "CX");
        this.addRegionException("Indian/Cocos", "CC");
        this.addRegionException("Indian/Comoro", "KM");
        this.addRegionException("Atlantic/Faeroe", "FO");
        this.addRegionException("Pacific/Pitcairn", "PN");
        this.addRegionException("Atlantic/St_Helena", "SH");
        this.addRegionException("America/St_Kitts", "KN");
        this.addRegionException("America/St_Lucia", "LC");
        this.addRegionException("Europe/Vatican", "VA");
        this.addRegionException("Pacific/Norfolk", "NF");
        this.addRegionException("Africa/Algiers", "DZ");
        this.addRegionException("Africa/Tunis", "TN");
        return this.exceptions.get(regionCode);
    }

    private void addRegionException(String exemplarCity, String territory) {
        this.exceptions.put(exemplarCity, territory);
        this.exceptions.put(territory, exemplarCity);
    }

    static enum Equivalence {
        normal,
        exact,
        unit;

    }

    private static enum Type {
        LANGUAGE("//ldml/localeDisplayNames/languages/language", MatchType.PREFIX),
        SCRIPT("//ldml/localeDisplayNames/scripts/script", MatchType.PREFIX),
        TERRITORY("//ldml/localeDisplayNames/(territories/territory|subdivisions/subdivision\\[@type=\"gb(eng|sct|wls)\")", MatchType.REGEX),
        VARIANT("//ldml/localeDisplayNames/variants/variant", MatchType.PREFIX),
        CURRENCY("//ldml/numbers/currencies/currency", MatchType.PREFIX),
        ZONE("//ldml/dates/timeZoneNames/zone", MatchType.PREFIX),
        METAZONE("//ldml/dates/timeZoneNames/metazone", MatchType.PREFIX),
        DECIMAL_FORMAT("//ldml/numbers/decimalFormats", MatchType.PREFIX),
        UNIT_PREFIX("//ldml/units/unitLength.*/unitPrefixPattern", MatchType.REGEX),
        UNITS_COMPOUND_LONG("//ldml/units/unitLength[@type=\"long\"]/compoundUnit", MatchType.PREFIX),
        UNITS_COMPOUND_SHORT("//ldml/units/unitLength[@type=\"short\"]/compoundUnit", MatchType.PREFIX),
        UNITS_COORDINATE("//ldml/units/unitLength\\[@type=\".*\"\\]/coordinateUnit/", MatchType.REGEX),
        UNITS_IGNORE("//ldml/units/unitLength[@type=\"narrow\"]", MatchType.PREFIX),
        UNITS("//ldml/units/unitLength.*/(displayName|unitPattern|perUnitPattern)", MatchType.REGEX),
        FIELDS_NARROW("//ldml/dates/fields/field\\[@type=\"(sun|mon|tue|wed|thu|fri|sat)-narrow\"\\]/relative", MatchType.REGEX),
        FIELDS_RELATIVE("//ldml/dates/fields/field\\[@type=\".*\"\\]/relative\\[@type=\"(-1|0|1)\"\\]", MatchType.REGEX),
        ANNOTATIONS("//ldml/annotations/annotation\\[@cp=\".*\"\\]\\[@type=\"tts\"\\]", MatchType.REGEX),
        CARDINAL_MINIMAL("//ldml/numbers/minimalPairs/pluralMinimalPairs", MatchType.PREFIX),
        ORDINAL_MINIMAL("//ldml/numbers/minimalPairs/ordinalMinimalPairs", MatchType.PREFIX),
        TYPOGRAPHIC_AXIS("//ldml/typographicNames/axisName", MatchType.PREFIX),
        TYPOGRAPHIC_FEATURE("//ldml/typographicNames/featureName", MatchType.PREFIX),
        TYPOGRAPHIC_STYLE("//ldml/typographicNames/styleName", MatchType.PREFIX);

        private MatchType matchType;
        private String basePrefix;
        private Pattern basePattern;

        private Type(String basePrefix, MatchType matchType) {
            this.matchType = matchType;
            this.basePrefix = basePrefix;
            this.basePattern = PatternCache.get("^" + basePrefix + ".*");
        }

        public String getPrefix() {
            return this.basePrefix;
        }

        public Pattern getPattern() {
            return this.basePattern;
        }

        public static Type getType(String path) {
            for (Type type : Type.values()) {
                Matcher m4;
                if (type == FIELDS_NARROW || !(type.matchType == MatchType.PREFIX ? path.startsWith(type.getPrefix()) : (m4 = type.getPattern().matcher(path)).matches())) continue;
                return type;
            }
            return null;
        }
    }

    private static enum MatchType {
        PREFIX,
        REGEX;

    }
}

