/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.unicode.cldr.test.ExampleDependencies;
import org.unicode.cldr.util.PathStarrer;

class ExampleCache {
    private static final boolean AVOID_CLEARING_CACHE = true;
    private static final String NONE = "\uffff";
    private final Map<String, Map<String, Map<String, String>>> cache = new ConcurrentHashMap<String, Map<String, Map<String, String>>>();
    private final Multimap<String, ClearableCache> registeredCache = HashMultimap.create();
    private final PathStarrer pathStarrer = new PathStarrer().setSubstitutionPattern("*");
    private boolean cachingIsEnabled = true;

    ExampleCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends ClearableCache> T registerCache(T clearableCache, String ... starredPaths) {
        Multimap<String, ClearableCache> multimap = this.registeredCache;
        synchronized (multimap) {
            for (String starredPath : starredPaths) {
                this.registeredCache.put(starredPath, clearableCache);
            }
            return clearableCache;
        }
    }

    void setCachingEnabled(boolean enabled) {
        this.cachingIsEnabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(String xpath) {
        String starredA = this.pathStarrer.set(xpath);
        for (String starredB : ExampleDependencies.dependencies.get((Object)starredA)) {
            this.cache.remove(starredB);
        }
        Multimap<String, ClearableCache> multimap = this.registeredCache;
        synchronized (multimap) {
            for (ClearableCache item : this.registeredCache.get(starredA)) {
                item.clear();
            }
        }
    }

    static interface ClearableCache {
        public void clear();
    }

    class ExampleCacheItem {
        private String xpath;
        private String value;
        private String starredPath = null;
        private Map<String, Map<String, String>> pathMap = null;
        private Map<String, String> valueMap = null;

        ExampleCacheItem(String xpath, String value) {
            this.xpath = xpath;
            this.value = value;
        }

        String getExample() {
            if (!ExampleCache.this.cachingIsEnabled) {
                return null;
            }
            String result = null;
            this.starredPath = ExampleCache.this.pathStarrer.set(this.xpath);
            this.pathMap = ExampleCache.this.cache.get(this.starredPath);
            if (this.pathMap != null) {
                this.valueMap = this.pathMap.get(this.xpath);
                if (this.valueMap != null) {
                    result = this.valueMap.get(this.value);
                }
            }
            return ExampleCache.NONE.equals(result) ? null : result;
        }

        void putExample(String result) {
            if (ExampleCache.this.cachingIsEnabled) {
                if (this.pathMap == null) {
                    this.pathMap = new ConcurrentHashMap<String, Map<String, String>>();
                    ExampleCache.this.cache.put(this.starredPath, this.pathMap);
                }
                if (this.valueMap == null) {
                    this.valueMap = new ConcurrentHashMap<String, String>();
                    this.pathMap.put(this.xpath, this.valueMap);
                }
                this.valueMap.put(this.value, result == null ? ExampleCache.NONE : result);
            }
        }
    }
}

