/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.impl.UnicodeMap;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.List;

public class StateMachine<T> {
    static boolean SHOW_STATE_TRANSITIONS = false;
    private static final short START = 0;
    static final short EXIT = -1;
    static final short POP = -2;
    static final short ERROR = -3;
    static final short UNDEFINED = -4;
    private final UnicodeMap[] stateToData;
    private final StateObjectBuilderFactory<T> factory;
    private String[] stateNames;
    private String[] actionNames;

    StateMachine(List<UnicodeMap> stateToData, StateObjectBuilderFactory<T> factory, List<String> stateNames, List<String> actionNames) {
        this.stateToData = stateToData.toArray(new UnicodeMap[stateToData.size()]);
        this.stateNames = stateNames.toArray(new String[stateNames.size()]);
        this.actionNames = actionNames.toArray(new String[actionNames.size()]);
        this.factory = factory;
    }

    public String toString(StateAction action) {
        return "{" + (action.advanceToNextCodePoint ? "+" : "") + this.getStateName(action.nextState) + (String)(action.pushState == -4 ? "" : " ^" + this.getStateName(action.pushState)) + (String)(action.action < 0 ? "" : " " + this.getActionName(action.action)) + "}";
    }

    private String getStateName(short nextState) {
        switch (nextState) {
            case -2: {
                return "pop";
            }
            case -1: {
                return "exit";
            }
            case -3: {
                return "errorDeath";
            }
        }
        return this.stateNames == null ? String.valueOf(nextState) : this.stateNames[nextState];
    }

    private String getActionName(short action) {
        return this.actionNames == null ? String.valueOf(action) : this.actionNames[action];
    }

    public List<String> getActionNames() {
        return Arrays.asList(this.actionNames);
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        int i = 0;
        for (UnicodeMap unicodeMap : this.stateToData) {
            String stateName = this.stateNames == null ? String.valueOf(i) : this.stateNames[i];
            output.append(stateName).append(":\n");
            if (unicodeMap == null) {
                output.append("\tnull\n");
            } else {
                for (Object action : unicodeMap.getAvailableValues()) {
                    UnicodeSet sources = unicodeMap.keySet(action);
                    output.append("\t" + sources.toPattern(false) + "\t" + this.toString((StateAction)action) + "\n");
                }
            }
            ++i;
        }
        return output.toString();
    }

    public T parse(CharSequence string, ParsePosition parsePosition) {
        int i = parsePosition.getIndex();
        if (i < 0 || i >= string.length()) {
            throw new StringIndexOutOfBoundsException(i);
        }
        short state = 0;
        StateObjectBuilder<T> stateObject = this.factory.getInstance();
        stateObject.init(string, this, i);
        int cp = Character.codePointAt(string, 0);
        if (SHOW_STATE_TRANSITIONS) {
            System.out.println("@Fetched: " + UTF16.valueOf(cp));
        }
        while (true) {
            StateAction action = (StateAction)this.stateToData[state].getValue(cp);
            if (action.pushState >= 0) {
                stateObject.push(action.pushState);
                if (SHOW_STATE_TRANSITIONS) {
                    System.out.println("\t@Pushed " + stateObject);
                }
            }
            if (action.action >= 0) {
                stateObject.handle(i, action);
            }
            short s2 = action.nextState;
            state = s2;
            switch (s2) {
                default: {
                    if (!SHOW_STATE_TRANSITIONS) break;
                    System.out.println("\t@NextState " + this.getStateName(state));
                    break;
                }
                case -2: {
                    if (SHOW_STATE_TRANSITIONS) {
                        System.out.println("\t@Popping " + stateObject);
                    }
                    state = stateObject.pop();
                    break;
                }
                case -1: {
                    parsePosition.setIndex(i);
                    return stateObject.getResult();
                }
                case -3: {
                    parsePosition.setErrorIndex(i);
                    throw new IllegalArgumentException(this.getActionName(action.action));
                }
            }
            if (!action.advanceToNextCodePoint) continue;
            int n = cp = (i += UTF16.getCharCount(cp)) < string.length() ? Character.codePointAt(string, i) : 65535;
            if (!SHOW_STATE_TRANSITIONS) continue;
            System.out.println("@Fetched: " + UTF16.valueOf(cp));
        }
    }

    public static class StateObjectBuilder<T> {
        protected CharSequence string;
        private StateMachine<T> stateMachine;
        private short[] stateStack = new short[100];
        private int stackSize = 0;

        private final void push(short state) {
            this.stateStack[this.stackSize++] = state;
        }

        private final short pop() {
            return this.stateStack[--this.stackSize];
        }

        protected void init(CharSequence string, StateMachine<T> stateMachine, int start) {
            this.string = string;
            this.stateMachine = stateMachine;
        }

        protected T getResult() {
            return null;
        }

        protected String getActionName(short action) {
            return this.stateMachine.getActionName(action);
        }

        protected void handle(int position, StateAction action) {
        }

        public String toString() {
            StringBuilder result = new StringBuilder("[");
            for (int i = this.stackSize - 1; i >= 0; --i) {
                if (i != this.stackSize - 1) {
                    result.append(", ");
                }
                result.append(this.stateMachine.getStateName(this.stateStack[i]));
            }
            return result.append("]").toString();
        }
    }

    public static interface StateObjectBuilderFactory<T> {
        public StateObjectBuilder<T> getInstance();
    }

    public static class StateAction {
        boolean advanceToNextCodePoint = false;
        short nextState = (short)-4;
        short pushState = (short)-4;
        short action = (short)-1;

        public boolean equals(Object other) {
            StateAction that = (StateAction)other;
            return this.advanceToNextCodePoint == that.advanceToNextCodePoint && this.nextState == that.nextState && this.pushState == that.pushState && this.action == that.action;
        }
    }
}

