/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.impl.number.DecimalFormatProperties;
import com.ibm.icu.impl.number.PatternStringParser;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.CompactDecimalFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

public class BuildIcuCompactDecimalFormat {
    static SupplementalDataInfo sdi = SupplementalDataInfo.getInstance();
    static final int MINIMUM_ARRAY_LENGTH = 15;
    static final Pattern PATTERN = PatternCache.get("([^0,]*)([0]+)([.]0+)?([^0]*)");
    static final Pattern TYPE = PatternCache.get("1([0]*)");
    private static final boolean DEBUG = false;

    public static final CompactDecimalFormat build(CLDRFile resolvedCldrFile, Set<String> debugCreationErrors, String[] debugOriginals, CompactDecimalFormat.CompactStyle style, ULocale locale, CurrencyStyle currencyStyle, String currencyCodeOrUnit) {
        String currencySymbol = null;
        if (currencyStyle == CurrencyStyle.CURRENCY) {
            String currencySymbolPath = "//ldml/numbers/currencies/currency[@type=\"" + currencyCodeOrUnit + "\"]/symbol";
            currencySymbol = resolvedCldrFile.getWinningValueWithBailey(currencySymbolPath);
        }
        final Map<String, Map<String, String>> customData = BuildIcuCompactDecimalFormat.buildCustomData(resolvedCldrFile, style, currencyStyle, currencySymbol);
        ICUServiceBuilder builder = new ICUServiceBuilder().setCldrFile(resolvedCldrFile);
        DecimalFormat decimalFormat = currencyStyle == CurrencyStyle.PLAIN ? builder.getNumberFormat(1) : builder.getCurrencyFormat(currencyCodeOrUnit, currencySymbol);
        final String pattern = decimalFormat.toPattern();
        final PluralRules rules = SupplementalDataInfo.getInstance().getPlurals(locale.toString()).getPluralRules();
        CompactDecimalFormat cdf = CompactDecimalFormat.getInstance(locale, style);
        cdf.setDecimalFormatSymbols(builder.getDecimalFormatSymbols("latn"));
        cdf.setProperties(new DecimalFormat.PropertySetter(){

            @Override
            public void set(DecimalFormatProperties props) {
                props.setCompactCustomData(customData);
                PatternStringParser.parseToExistingProperties(pattern, props, 2);
                props.setPluralRules(rules);
            }
        });
        return cdf;
    }

    public static Map<String, Map<String, String>> buildCustomData(CLDRFile resolvedCldrFile, CompactDecimalFormat.CompactStyle style, CurrencyStyle currencyStyle) {
        return BuildIcuCompactDecimalFormat.buildCustomData(resolvedCldrFile, style, currencyStyle, null);
    }

    public static Map<String, Map<String, String>> buildCustomData(CLDRFile resolvedCldrFile, CompactDecimalFormat.CompactStyle style, CurrencyStyle currencyStyle, String currencySymbol) {
        TreeMap<String, Map<String, String>> customData = new TreeMap<String, Map<String, String>>();
        boolean currSymbolAlphaLeading = false;
        boolean currSymbolAlphaTrailing = false;
        if (currencySymbol != null && currencySymbol.length() > 0) {
            currSymbolAlphaLeading = UCharacter.isLetter(currencySymbol.codePointAt(0));
            currSymbolAlphaTrailing = currencySymbol.length() > 1 ? UCharacter.isLetter(currencySymbol.codePointBefore(currencySymbol.length())) : currSymbolAlphaLeading;
        }
        String prefix = currencyStyle == CurrencyStyle.PLAIN ? "//ldml/numbers/decimalFormats[@numberSystem=\"latn\"]/decimalFormatLength" : "//ldml/numbers/currencyFormats[@numberSystem=\"latn\"]/currencyFormatLength";
        Iterator<String> it = resolvedCldrFile.iterator(prefix);
        String styleString = style.toString().toLowerCase(Locale.ENGLISH);
        while (it.hasNext()) {
            XPathParts parts;
            String stype;
            String path = it.next();
            if (path.endsWith("/alias") || !styleString.equals(stype = (parts = XPathParts.getFrozenInstance(path)).getAttributeValue(3, "type"))) continue;
            String type = parts.getAttributeValue(-1, "type");
            String key = parts.getAttributeValue(-1, "count");
            String alt = parts.getAttributeValue(-1, "alt");
            String pattern = resolvedCldrFile.getStringValue(path);
            if (pattern.contentEquals("0")) continue;
            if (alt != null && alt.equals("alphaNextToNumber")) {
                int currPos = pattern.indexOf(164);
                if (currPos < 0 || currPos == 0 && !currSymbolAlphaTrailing || currPos == pattern.length() - 1 && !currSymbolAlphaLeading || !currSymbolAlphaLeading && !currSymbolAlphaTrailing) continue;
                BuildIcuCompactDecimalFormat.add(customData, type, key, pattern, true);
            }
            BuildIcuCompactDecimalFormat.add(customData, type, key, pattern, false);
        }
        return customData;
    }

    private static <A, B, C> void add(Map<A, Map<B, C>> customData, A a, B b, C c, boolean replace) {
        Map<B, C> inner = customData.get(a);
        if (inner == null) {
            inner = new HashMap<B, C>();
            customData.put(a, inner);
        }
        if (replace) {
            inner.put(b, c);
        } else {
            inner.putIfAbsent(b, c);
        }
    }

    private static /* synthetic */ void lambda$build$0(String k, Map v) {
        System.out.println("\t" + k + "\t" + v);
    }

    static class MyCurrencySymbolDisplay {
        CLDRFile cldrFile;

        public MyCurrencySymbolDisplay(CLDRFile cldrFile) {
            this.cldrFile = cldrFile;
        }

        public String getName(Currency currency, int count) {
            String currencyCode = currency.getCurrencyCode();
            if (count > 1) {
                return currencyCode;
            }
            String prefix = "//ldml/numbers/currencies/currency[@type=\"" + currencyCode + "\"]/";
            String currencySymbol = this.cldrFile.getWinningValue(prefix + "symbol");
            return currencySymbol != null ? currencySymbol : currencyCode;
        }
    }

    public static enum CurrencyStyle {
        PLAIN,
        CURRENCY,
        LONG_CURRENCY,
        ISO_CURRENCY,
        UNIT;

    }
}

