/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.locale.XCldrStub;
import com.ibm.icu.util.VersionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CalculatedCoverageLevels;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.Validity;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class DiffLanguageGroups {
    private static final Joiner JOIN_TAB = Joiner.on('\t');
    private static final String IN = " \u27a1\ufe0e ";
    static final CLDRConfig CONFIG = CLDRConfig.getInstance();
    static final SupplementalDataInfo SDI = CONFIG.getSupplementalDataInfo();
    static final CLDRFile ENGLISH = CONFIG.getEnglish();
    static final Map<String, LanguageStatus> LanguageToStatus;
    static final Map<LanguageStatus, Set<String>> StatusToLanguages;
    static String OLD;
    static String NEW;

    public static LanguageStatus getStatusForLanguage(String joint) {
        return CldrUtility.ifNull(LanguageToStatus.get(joint), LanguageStatus.NON_REGULAR);
    }

    public static void main(String[] args) {
        List<String> childToParent;
        System.out.println("Args are OLD and NEW CLDR versions. Defaults: OLD = last release, NEW = current data. Format is X.Y, eg: " + ToolConstants.LAST_RELEASE_VERSION_WITH0);
        System.out.println("\nReading old supplemental: may have unrelated errors.");
        SupplementalDataInfo oldSupplementalInfo = SupplementalDataInfo.getInstance(CldrUtility.getPath(CLDRPaths.LAST_COMMON_DIRECTORY, "supplemental/"));
        System.out.println();
        VersionInfo oldVersion = oldSupplementalInfo.getCldrVersion();
        String oldBase = ToolConstants.LAST_RELEASE_VERSION_WITH0;
        String newBase = null;
        if (args.length > 0) {
            oldBase = args[0];
            if (args.length > 1) {
                newBase = args[1];
            }
        }
        String oldPath = CLDRPaths.ARCHIVE_DIRECTORY + "cldr-" + oldBase + "/common/supplemental/languageGroup.xml";
        String newPath = newBase == null ? CLDRPaths.COMMON_DIRECTORY + "supplemental/languageGroup.xml" : CLDRPaths.ARCHIVE_DIRECTORY + "cldr-" + newBase + "/common/supplemental/languageGroup.xml";
        OLD = "v" + oldVersion.getVersionString(1, 2);
        NEW = "V" + SDI.getCldrVersion().getVersionString(1, 2);
        System.out.println("* KEY");
        for (LanguageStatus status : LanguageStatus.values()) {
            System.out.println("\t" + status.abbr + "\t" + status.toString());
        }
        System.out.println();
        TreeMultimap<String, String> oldErrors = TreeMultimap.create();
        SortedMap<String, String> oldChildToParent = DiffLanguageGroups.invertToMap(DiffLanguageGroups.loadLanguageGroups(oldPath), oldErrors);
        if (!oldErrors.isEmpty()) {
            DiffLanguageGroups.showErrors(OLD, oldErrors);
        }
        Set<String> oldSet = DiffLanguageGroups.getAllKeysAndValues(oldChildToParent);
        for (Map.Entry entry : StatusToLanguages.entrySet()) {
            DiffLanguageGroups.checkAgainstReference(OLD, (LanguageStatus)((Object)entry.getKey()), (Set)entry.getValue(), oldSet);
        }
        TreeMultimap<String, String> newErrors = TreeMultimap.create();
        SortedMap<String, String> sortedMap = DiffLanguageGroups.invertToMap(DiffLanguageGroups.loadLanguageGroups(newPath), newErrors);
        if (!newErrors.isEmpty()) {
            DiffLanguageGroups.showErrors(NEW, newErrors);
        }
        Set<String> newSet = DiffLanguageGroups.getAllKeysAndValues(sortedMap);
        for (Map.Entry<LanguageStatus, Set<String>> entry : StatusToLanguages.entrySet()) {
            DiffLanguageGroups.checkAgainstReference(NEW, entry.getKey(), entry.getValue(), newSet);
        }
        for (LanguageStatus status : LanguageStatus.values()) {
            for (String joint : Sets.difference(oldSet, newSet)) {
                if (DiffLanguageGroups.getStatusForLanguage(joint) != status) continue;
                childToParent = DiffLanguageGroups.getChain(joint, oldChildToParent, new ArrayList<String>());
                System.out.println(JOIN_TAB.join(OLD, DiffLanguageGroups.getStatusForLanguage((String)joint).abbr, DiffLanguageGroups.show(joint), "Removed", childToParent.stream().map(x -> DiffLanguageGroups.show(x)).collect(Collectors.joining(IN))));
            }
        }
        for (LanguageStatus status : LanguageStatus.values()) {
            for (String joint : Sets.difference(newSet, oldSet)) {
                if (DiffLanguageGroups.getStatusForLanguage(joint) != status) continue;
                childToParent = DiffLanguageGroups.getChain(joint, sortedMap, new ArrayList<String>());
                System.out.println(JOIN_TAB.join(NEW, DiffLanguageGroups.getStatusForLanguage((String)joint).abbr, DiffLanguageGroups.show(joint), "Added", childToParent.stream().map(x -> DiffLanguageGroups.show(x)).collect(Collectors.joining(IN))));
            }
        }
        TreeSet<String> changed = new TreeSet<String>();
        for (String joint : Sets.intersection(oldSet, newSet)) {
            List<String> newChain;
            List<String> oldChain = DiffLanguageGroups.getChain(joint, oldChildToParent, new ArrayList<String>());
            if (oldChain.equals(newChain = DiffLanguageGroups.getChain(joint, sortedMap, new ArrayList<String>()))) continue;
            changed.add(joint);
        }
        for (LanguageStatus status : LanguageStatus.values()) {
            for (String joint : changed) {
                if (DiffLanguageGroups.getStatusForLanguage(joint) != status) continue;
                List<String> oldChain = DiffLanguageGroups.getChain(joint, oldChildToParent, new ArrayList<String>());
                List<String> newChain = DiffLanguageGroups.getChain(joint, sortedMap, new ArrayList<String>());
                System.out.println(JOIN_TAB.join(OLD + "-" + NEW, DiffLanguageGroups.getStatusForLanguage((String)joint).abbr, DiffLanguageGroups.show(joint), "Moved FROM", oldChain.stream().map(x -> DiffLanguageGroups.show(x)).collect(Collectors.joining(IN)), "TO", newChain.stream().map(x -> DiffLanguageGroups.show(x)).collect(Collectors.joining(IN))));
            }
        }
    }

    private static void checkAgainstReference(String version, LanguageStatus languageStatus, Set<String> cldrLanguages, Set<String> oldSet) {
        if (LanguageStatus.SKIP_MISSING.contains((Object)languageStatus)) {
            return;
        }
        Sets.SetView<String> missing = Sets.difference(cldrLanguages, oldSet);
        if (!missing.isEmpty()) {
            System.out.println(JOIN_TAB.join(version, languageStatus.abbr, "\u2026", "Missing", missing.stream().map(x -> DiffLanguageGroups.show(x)).collect(Collectors.joining(", "))));
        }
    }

    public static void showDiff(String title, Set<String> oldMinusOther) {
        if (!oldMinusOther.isEmpty()) {
            System.out.println(title + "\t" + oldMinusOther.size() + ":\t" + oldMinusOther.stream().map(x -> DiffLanguageGroups.show(x)).collect(Collectors.joining(", ")));
        }
    }

    public static String show(String languageCode) {
        return languageCode.equals("mul") ? "\u03a9" : DiffLanguageGroups.getName(languageCode) + " \u2045" + languageCode + "\u2046";
    }

    public static String getName(String languageCode) {
        String result = ENGLISH.getName(0, languageCode);
        return result == null ? "(no name)" : result.replace(" (Other)", "");
    }

    public static void showErrors(String title, Multimap<String, String> oldErrors) {
        for (LanguageStatus status : LanguageStatus.values()) {
            for (Map.Entry<String, Collection<String>> entry : oldErrors.asMap().entrySet()) {
                if (DiffLanguageGroups.getStatusForLanguage(entry.getKey()) != status) continue;
                System.out.println(DiffLanguageGroups.formatMessage(title, entry.getKey(), "Multiple parents", entry.getValue().stream().map(x -> DiffLanguageGroups.show(x)).collect(Collectors.joining(" \ud835\udc2f\ud835\udc2c "))));
            }
        }
    }

    private static List<String> getChain(String joint, Map<String, String> childToParent, List<String> result) {
        String parent = childToParent.get(joint);
        if (parent == null) {
            return result;
        }
        result.add(parent);
        return DiffLanguageGroups.getChain(parent, childToParent, result);
    }

    public static Multimap<String, String> loadLanguageGroups(String filename) {
        TreeMultimap<String, String> newParentToChildren = TreeMultimap.create();
        for (Pair<String, String> item : XMLFileReader.loadPathValues(filename, new ArrayList<Pair<String, String>>(), false)) {
            DiffLanguageGroups.handleLanguageGroups(item.getSecond(), XPathParts.getFrozenInstance(item.getFirst()), newParentToChildren);
        }
        newParentToChildren = ImmutableSetMultimap.copyOf(newParentToChildren);
        return newParentToChildren;
    }

    public static SortedMap<String, String> invertToMap(Multimap<String, String> oldParentToChildren, Multimap<String, String> childToParents) {
        TreeMap<String, String> childToParent = new TreeMap<String, String>();
        for (Map.Entry<String, String> parentToChildren : oldParentToChildren.entries()) {
            String parent = parentToChildren.getKey();
            String child = parentToChildren.getValue();
            String old = childToParent.put(child, parent);
            if (old == null) continue;
            childToParents.put(child, old);
            childToParents.put(child, parent);
        }
        return ImmutableSortedMap.copyOf(childToParent);
    }

    public static Set<String> getAllKeysAndValues(Map<String, String> newItems) {
        TreeSet<String> newSet = new TreeSet<String>(newItems.values());
        newSet.addAll(newItems.keySet());
        return ImmutableSet.copyOf(newSet);
    }

    private static boolean handleLanguageGroups(String value, XPathParts parts, Multimap<String, String> languageGroups) {
        String parent = parts.getAttributeValue(-1, "parent");
        List<String> children = SupplementalDataInfo.WHITESPACE_SPLTTER.splitToList(value);
        languageGroups.putAll(parent, children);
        return true;
    }

    static String formatMessage(String version, String language, String issue, String data) {
        return JOIN_TAB.join(version, DiffLanguageGroups.getStatusForLanguage((String)language).abbr, DiffLanguageGroups.show(language), issue, data);
    }

    static {
        TreeMap temp = new TreeMap();
        Sets.union(Validity.getInstance().getStatusToCodes(StandardCodes.LstrType.language).get((Object)Validity.Status.regular), Set.of("mul")).stream().forEach(x -> temp.put(x, LanguageStatus.NON_CLDR));
        CONFIG.getCldrFactory().getAvailableLanguages().stream().forEach(x -> {
            if (!x.contains("_") && !x.equals("root")) {
                temp.put(x, LanguageStatus.OTHER_CLDR);
            }
        });
        CalculatedCoverageLevels.getInstance().getLevels().entrySet().stream().forEach(x -> {
            if (!((String)x.getKey()).contains("_")) {
                temp.put((String)x.getKey(), LanguageStatus.OTHER_BASIC_PLUS);
            }
        });
        Sets.difference(StandardCodes.make().getLocaleCoverageLocales(Organization.cldr), StandardCodes.make().getLocaleCoverageLocales(Organization.special)).stream().forEach(x -> {
            if (!x.contains("_")) {
                temp.put(x, LanguageStatus.TC);
            }
        });
        LanguageToStatus = XCldrStub.ImmutableMap.copyOf(temp);
        TreeMultimap temp2 = TreeMultimap.create();
        LanguageToStatus.entrySet().stream().forEach(x -> temp2.put((LanguageStatus)((Object)((Object)x.getValue())), (String)x.getKey()));
        LinkedHashMap temp3 = new LinkedHashMap();
        temp2.asMap().entrySet().forEach(x -> temp3.put((LanguageStatus)((Object)((Object)x.getKey())), new TreeSet((Collection)x.getValue())));
        StatusToLanguages = CldrUtility.protectCollection(temp3);
        OLD = "OLD";
        NEW = "NEW";
    }

    static enum LanguageStatus {
        TC("TC"),
        OTHER_BASIC_PLUS("OB"),
        OTHER_CLDR("OC"),
        NON_CLDR("NC"),
        NON_REGULAR("XX");

        public final String abbr;
        static final Set<LanguageStatus> SKIP_MISSING;

        private LanguageStatus(String s2) {
            this.abbr = s2;
        }

        static {
            SKIP_MISSING = Set.of(NON_CLDR, NON_REGULAR);
        }
    }
}

