/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.SupplementalDataInfo;

public class LocaleScriptInfo {
    private static final CLDRConfig CLDR_CONFIG = CLDRConfig.getInstance();
    public static String UNKNOWN_SCRIPT = UScript.getShortName(103);
    public static String UNKNOWN_REGION = "ZZ";
    private static SupplementalDataInfo supplementalData = CLDR_CONFIG.getSupplementalDataInfo();
    private static Factory factory = CLDR_CONFIG.getCldrFactory();

    public static String getScriptFromLocaleOrSupplemental(String locale) {
        String script = LocaleScriptInfo.getScriptFromLocale(locale);
        if (script == null) {
            script = LocaleScriptInfo.getScriptFromSupplementalData(locale);
        }
        return script;
    }

    public static String getScriptFromLocale(String locale) {
        CLDRLocale cLocale = CLDRLocale.getInstance(locale);
        String script = cLocale.getScript();
        if (!script.isEmpty()) {
            return script;
        }
        try {
            CLDRFile cldrFile = factory.make(locale, true);
            UnicodeSet exemplars = cldrFile.getExemplarSet(CLDRFile.ExemplarType.main, CLDRFile.WinningChoice.WINNING);
            script = LocaleScriptInfo.getExemplarScriptCode(exemplars);
            if (!script.equals(UNKNOWN_SCRIPT)) {
                return script;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    public static String getScriptFromSupplementalData(String locale) {
        Map<SupplementalDataInfo.BasicLanguageData.Type, SupplementalDataInfo.BasicLanguageData> basicLanguageData = supplementalData.getBasicLanguageDataMap(locale);
        if (basicLanguageData != null) {
            String result = null;
            for (SupplementalDataInfo.BasicLanguageData datum : basicLanguageData.values()) {
                boolean isPrimary;
                Set<String> scripts = datum.getScripts();
                boolean bl = isPrimary = datum.getType() == SupplementalDataInfo.BasicLanguageData.Type.primary;
                if (scripts.isEmpty()) continue;
                String script = scripts.iterator().next();
                if (isPrimary) {
                    result = script;
                    return result;
                }
                if (result != null) continue;
                result = script;
            }
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    public static String getExemplarScriptCode(UnicodeSet unicodeSet) {
        return UScript.getShortName(LocaleScriptInfo.getExemplarUScriptId(unicodeSet));
    }

    public static int getExemplarUScriptId(UnicodeSet unicodeSet) {
        UnicodeSetIterator it = new UnicodeSetIterator(unicodeSet);
        block6: while (it.next()) {
            int cp;
            if (it.codepoint != -1) {
                int script = UScript.getScript(it.codepoint);
                switch (script) {
                    case 0: 
                    case 1: 
                    case 103: {
                        continue block6;
                    }
                }
                return script;
            }
            block7: for (int i = 0; i < it.string.length(); i += UTF16.getCharCount(cp)) {
                cp = UTF16.charAt(it.string, i);
                int script = UScript.getScript(cp);
                switch (script) {
                    case 0: 
                    case 1: 
                    case 103: {
                        continue block7;
                    }
                    default: {
                        return script;
                    }
                }
            }
        }
        return 103;
    }
}

