/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.google.common.base.Objects;
import com.ibm.icu.util.Output;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.draft.XLocaleDistance;

final class IntDistanceNode
extends XLocaleDistance.DistanceNode {
    final IntDistanceTable distanceTable;

    public IntDistanceNode(int distance, IntDistanceTable distanceTable) {
        super(distance);
        this.distanceTable = distanceTable;
    }

    @Override
    public IntDistanceTable getDistanceTable() {
        return this.distanceTable;
    }

    @Override
    public boolean equals(Object obj) {
        IntDistanceNode other = (IntDistanceNode)obj;
        return this.distance == other.distance && Objects.equal(this.distanceTable, other.distanceTable);
    }

    @Override
    public int hashCode() {
        return this.distance ^ Objects.hashCode(this.distanceTable);
    }

    @Override
    public String toString() {
        return "\ndistance: " + this.distance + ", " + this.distanceTable;
    }

    public static XLocaleDistance.DistanceNode from(int distance, IntDistanceTable otherTable) {
        return otherTable == null ? new XLocaleDistance.DistanceNode(distance) : new IntDistanceNode(distance, otherTable);
    }

    static class IntDistanceTable
    extends XLocaleDistance.DistanceTable {
        private static final XLocaleDistance.IdMakerFull[] ids = new XLocaleDistance.IdMakerFull[]{new XLocaleDistance.IdMakerFull<String>("lang", "\ufffd"), new XLocaleDistance.IdMakerFull<String>("script", "\ufffd"), new XLocaleDistance.IdMakerFull<String>("region", "\ufffd")};
        private static final XLocaleDistance.IdMakerFull<IntDistanceTable> cache = new XLocaleDistance.IdMakerFull("table");
        private final XLocaleDistance.IdMakerFull<String> id;
        private final XLocaleDistance.DistanceNode[][] distanceNodes;

        public IntDistanceTable(XLocaleDistance.StringDistanceTable source) {
            this(source, IntDistanceTable.loadIds(source, 0));
        }

        private static int loadIds(XLocaleDistance.StringDistanceTable source, int idNumber) {
            XLocaleDistance.IdMakerFull id = ids[idNumber];
            for (Map.Entry<String, Map<String, XLocaleDistance.DistanceNode>> e1 : source.subtables.entrySet()) {
                int desired = id.add(e1.getKey());
                for (Map.Entry<String, XLocaleDistance.DistanceNode> e2 : e1.getValue().entrySet()) {
                    int supported = id.add(e2.getKey());
                    XLocaleDistance.StringDistanceNode oldNode = (XLocaleDistance.StringDistanceNode)e2.getValue();
                    if (oldNode.distanceTable == null) continue;
                    IntDistanceTable.loadIds((XLocaleDistance.StringDistanceTable)oldNode.distanceTable, idNumber + 1);
                }
            }
            return 0;
        }

        private IntDistanceTable(XLocaleDistance.StringDistanceTable source, int idNumber) {
            this.id = ids[idNumber];
            int size = this.id.size();
            this.distanceNodes = new XLocaleDistance.DistanceNode[size][size];
            for (Map.Entry<String, Map<String, XLocaleDistance.DistanceNode>> e1 : source.subtables.entrySet()) {
                int desired = this.id.add(e1.getKey());
                for (Map.Entry<String, XLocaleDistance.DistanceNode> e2 : e1.getValue().entrySet()) {
                    XLocaleDistance.DistanceNode node;
                    int supported = this.id.add(e2.getKey());
                    XLocaleDistance.DistanceNode oldNode = e2.getValue();
                    XLocaleDistance.StringDistanceTable oldDistanceTable = (XLocaleDistance.StringDistanceTable)oldNode.getDistanceTable();
                    IntDistanceTable otherTable = oldDistanceTable == null ? null : cache.intern(new IntDistanceTable(oldDistanceTable, idNumber + 1));
                    this.distanceNodes[desired][supported] = node = IntDistanceNode.from(oldNode.distance, otherTable);
                }
            }
            for (int row = 0; row < size; ++row) {
                for (int column = 0; column < size; ++column) {
                    XLocaleDistance.DistanceNode value = this.distanceNodes[row][column];
                    if (value != null) continue;
                    value = this.distanceNodes[0][column];
                    if (value == null && (value = this.distanceNodes[row][0]) == null) {
                        value = this.distanceNodes[0][0];
                    }
                    this.distanceNodes[row][column] = value;
                }
            }
        }

        @Override
        public int getDistance(String desired, String supported, Output<XLocaleDistance.DistanceTable> distanceTable, boolean starEquals) {
            int desiredId = (Integer)this.id.toId((Object)desired);
            int supportedId = (Integer)this.id.toId((Object)supported);
            XLocaleDistance.DistanceNode value = this.distanceNodes[desiredId][supportedId];
            if (distanceTable != null) {
                distanceTable.value = value.getDistanceTable();
            }
            return starEquals && desiredId == supportedId && (desiredId != 0 || desired.equals(supported)) ? 0 : value.distance;
        }

        public boolean equals(Object obj) {
            IntDistanceTable other = (IntDistanceTable)obj;
            if (!this.id.equals(other.id)) {
                return false;
            }
            return Arrays.deepEquals((Object[])this.distanceNodes, (Object[])other.distanceNodes);
        }

        public int hashCode() {
            return this.id.hashCode() ^ Arrays.deepHashCode((Object[])this.distanceNodes);
        }

        public String toString() {
            return this.abbreviate("\t", new HashMap<XLocaleDistance.DistanceNode, Integer>(), new StringBuilder(this.id.name + ": ")).toString();
        }

        private StringBuilder abbreviate(String indent, Map<XLocaleDistance.DistanceNode, Integer> cache, StringBuilder result) {
            for (int i = 0; i < this.distanceNodes.length; ++i) {
                XLocaleDistance.DistanceNode[] row = this.distanceNodes[i];
                for (int j = 0; j < row.length; ++j) {
                    XLocaleDistance.DistanceNode value = row[j];
                    if (value == null) continue;
                    result.append(value.distance);
                    IntDistanceTable dt = (IntDistanceTable)value.getDistanceTable();
                    if (dt == null) {
                        result.append(";");
                        continue;
                    }
                    Integer old = cache.get(value);
                    result.append("/");
                    if (old != null) {
                        result.append(old + ";");
                        continue;
                    }
                    int table = cache.size();
                    cache.put(value, table);
                    result.append("\n" + indent + table + "=" + dt.id.name + ": ");
                    dt.abbreviate(indent + "\t", cache, result);
                }
            }
            return result;
        }

        @Override
        public Set<String> getCloser(int threshold) {
            HashSet<String> result = new HashSet<String>();
            block0: for (int i = 0; i < this.distanceNodes.length; ++i) {
                XLocaleDistance.DistanceNode[] row = this.distanceNodes[i];
                for (int j = 0; j < row.length; ++j) {
                    XLocaleDistance.DistanceNode value = row[j];
                    if (value.distance >= threshold) continue;
                    result.add(this.id.fromId(i));
                    continue block0;
                }
            }
            return result;
        }

        @Override
        String toString(boolean abbreviate) {
            return this.toString();
        }
    }
}

