/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu.text;

import com.ibm.icu.util.ULocale;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.unicode.cldr.icu.text.ListFormatData;

public final class ListFormat {
    private final String two;
    private final String start;
    private final String middle;
    private final String end;
    private static ULocale zhTW = new ULocale("zh_TW");
    static Map<ULocale, ListFormat> localeToData = new HashMap<ULocale, ListFormat>();

    public ListFormat(String two, String start, String middle, String end) {
        this.two = two;
        this.start = start;
        this.middle = middle;
        this.end = end;
    }

    public static ListFormat getInstance(ULocale locale) {
        do {
            ListFormat data;
            if ((data = localeToData.get(locale)) == null) continue;
            return data;
        } while ((locale = locale.equals(zhTW) ? ULocale.TRADITIONAL_CHINESE : locale.getFallback()) != null);
        return localeToData.get(ULocale.ROOT);
    }

    public static ListFormat getInstance(Locale locale) {
        return ListFormat.getInstance(ULocale.forLocale(locale));
    }

    public String format(Object ... items) {
        return this.format(Arrays.asList(items));
    }

    public String format(Collection<Object> items) {
        Iterator<Object> it = items.iterator();
        int count = items.size();
        switch (count) {
            case 0: {
                return "";
            }
            case 1: {
                return it.next().toString();
            }
            case 2: {
                return this.format2(this.two, it.next(), it.next());
            }
        }
        String result = it.next().toString();
        result = this.format2(this.start, result, it.next());
        count -= 3;
        while (count > 0) {
            result = this.format2(this.middle, result, it.next());
            --count;
        }
        return this.format2(this.end, result, it.next());
    }

    private String format2(String pattern, Object a, Object b) {
        return pattern.replace("{1}", b.toString()).replace("{0}", a.toString());
    }

    static void add(String locale, String ... data) {
        localeToData.put(new ULocale(locale), new ListFormat(data[0], data[1], data[2], data[3]));
    }

    static {
        ListFormatData.load();
    }
}

