/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.util.VersionInfo;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.util.Builder;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.RegexLookup;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class CoverageLevel2 {
    private static final boolean DEBUG_LOOKUP = false;
    private RegexLookup<Level> lookup = null;
    final LocaleSpecificInfo myInfo = new LocaleSpecificInfo();
    private final List<String> approvalRequirements = new LinkedList<String>();
    private CldrUtility.VariableReplacer coverageVariables = new CldrUtility.VariableReplacer();
    private SortedSet<SupplementalDataInfo.CoverageLevelInfo> coverageLevels = new TreeSet<SupplementalDataInfo.CoverageLevelInfo>();
    volatile List<SupplementalDataInfo.ApprovalRequirementMatcher> approvalMatchers = null;

    private CoverageLevel2(SupplementalDataInfo sdi, String locale) {
        this.myInfo.targetLanguage = CLDRLocale.getInstance(locale).getLanguage();
        this.myInfo.cvi = sdi.getCoverageVariableInfo(this.myInfo.targetLanguage);
        this.lookup = sdi.getCoverageLookup();
    }

    private CoverageLevel2(SupplementalDataInfo sdi, String locale, String ruleFile) {
        this.myInfo.targetLanguage = CLDRLocale.getInstance(locale).getLanguage();
        this.myInfo.cvi = sdi.getCoverageVariableInfo(this.myInfo.targetLanguage);
        RawCoverageFile rcf = new RawCoverageFile();
        this.lookup = rcf.load(ruleFile);
    }

    @Deprecated
    public static CoverageLevel2 getInstance(String locale) {
        return new CoverageLevel2(SupplementalDataInfo.getInstance(), locale);
    }

    public static CoverageLevel2 getInstance(SupplementalDataInfo sdi, String locale) {
        return new CoverageLevel2(sdi, locale);
    }

    public static CoverageLevel2 getInstance(SupplementalDataInfo sdi, String locale, String ruleFile) {
        return new CoverageLevel2(sdi, locale, ruleFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Level getLevel(String path) {
        if (path == null) {
            return Level.UNDETERMINED;
        }
        RegexLookup<Level> regexLookup = this.lookup;
        synchronized (regexLookup) {
            Level result = this.lookup.get(path, this.myInfo, null);
            return result == null ? Level.COMPREHENSIVE : result;
        }
    }

    public int getIntLevel(String path) {
        return this.getLevel(path).getLevel();
    }

    public int getRequiredVotes(CLDRLocale loc, PathHeader ph) {
        if (this.approvalMatchers == null) {
            this.approvalMatchers = SupplementalDataInfo.ApprovalRequirementMatcher.buildAll(this.approvalRequirements);
        }
        for (SupplementalDataInfo.ApprovalRequirementMatcher m4 : this.approvalMatchers) {
            if (!m4.matches(loc, ph)) continue;
            return m4.getRequiredVotes();
        }
        throw new RuntimeException("Error: " + loc + " " + ph + " ran off the end of the approvalMatchers.");
    }

    public static void main(String[] args) {
        CoverageLevel2.checkCoverage("root");
        CoverageLevel2.checkCoverage("de");
    }

    private static void checkCoverage(String locale) {
        CLDRConfig testInfo = ToolConfig.getToolInstance();
        SupplementalDataInfo supplementalDataInfo2 = testInfo.getSupplementalDataInfo();
        CoverageLevel2 cvOld = CoverageLevel2.getInstance(supplementalDataInfo2, locale);
        CoverageLevel2 cvNew = CoverageLevel2.getInstance(supplementalDataInfo2, locale, CLDRPaths.COMMON_DIRECTORY + "supplemental-temp/coverageLevels2.xml");
        CLDRFile cldrFile = testInfo.getCldrFactory().make(locale, true);
        Set paths = Builder.with(new TreeSet()).addAll(cldrFile).get();
        PathHeader.Factory phf = PathHeader.getFactory();
        TreeMap<PathHeader, CallSite> diff = new TreeMap<PathHeader, CallSite>();
        TreeMap<PathHeader, CallSite> same = new TreeMap<PathHeader, CallSite>();
        for (String string : paths) {
            Level levelNew;
            Level levelOld = cvOld.getLevel(string);
            if (levelOld != (levelNew = cvNew.getLevel(string))) {
                diff.put(phf.fromPath(string), (CallSite)((Object)(locale + "\t" + levelOld + "\t" + levelNew + "\t" + string)));
                continue;
            }
            if (levelOld.compareTo(Level.MODERATE) >= 0) continue;
            same.put(phf.fromPath(string), (CallSite)((Object)(locale + "\t" + string)));
        }
        System.out.println("\nLocale\tPath\tPathHeader");
        for (Map.Entry entry : same.entrySet()) {
            System.out.println((String)entry.getValue() + "\t" + entry.getKey());
        }
        System.out.println("\nLocale\tOld\tNew\tPath\tPathHeader");
        for (Map.Entry entry : diff.entrySet()) {
            System.out.println((String)entry.getValue() + "\t" + entry.getKey());
        }
    }

    public class RawCoverageFile {
        private VersionInfo cldrVersion;

        public RegexLookup<Level> makeCoverageLookup() {
            RegexLookup<Level> lookup = new RegexLookup<Level>(RegexLookup.LookupType.STAR_PATTERN_LOOKUP);
            Matcher variable = PatternCache.get("\\$\\{[A-Za-z][\\-A-Za-z]*\\}").matcher("");
            for (SupplementalDataInfo.CoverageLevelInfo ci : CoverageLevel2.this.coverageLevels) {
                Object pattern = ci.match.replace('\'', '\"').replace("[@", "\\[@").replace("(", "(?:").replace("(?:?!", "(?!");
                pattern = "^//ldml/" + (String)pattern + "$";
                String variableType = null;
                variable.reset((CharSequence)pattern);
                if (variable.find()) {
                    pattern = ((String)pattern).substring(0, variable.start()) + "([^\"]*)" + ((String)pattern).substring(variable.end());
                    variableType = variable.group();
                    if (variable.find()) {
                        throw new IllegalArgumentException("We can only handle a single variable on a line");
                    }
                }
                lookup.add(new MyRegexFinder((String)pattern, variableType, ci), ci.value);
            }
            return lookup;
        }

        public RegexLookup<Level> load(String file) {
            MyHandler myHandler = new MyHandler();
            XMLFileReader xfr = new XMLFileReader().setHandler(myHandler);
            xfr.read(file, -1, true);
            myHandler.cleanup();
            return this.makeCoverageLookup();
        }

        class MyHandler
        extends XMLFileReader.SimpleHandler {
            MyHandler() {
            }

            @Override
            public void handlePathValue(String path, String pathValue) {
                String level1;
                XPathParts parts = XPathParts.getFrozenInstance(path);
                String string = level1 = parts.size() < 2 ? null : parts.getElement(1);
                if (level1.equals("version")) {
                    if (RawCoverageFile.this.cldrVersion == null) {
                        String version = parts.getAttributeValue(1, "cldrVersion");
                        if (version == null) {
                            version = parts.getAttributeValue(0, "version");
                        }
                        RawCoverageFile.this.cldrVersion = VersionInfo.getInstance(version);
                    }
                } else if (parts.containsElement("approvalRequirement")) {
                    CoverageLevel2.this.approvalRequirements.add(parts.toString());
                } else if (parts.containsElement("coverageLevel")) {
                    Integer value;
                    String match = parts.containsAttribute("match") ? CoverageLevel2.this.coverageVariables.replace(parts.getAttributeValue(-1, "match")) : null;
                    String valueStr = parts.getAttributeValue(-1, "value");
                    valueStr = Integer.toString(Level.get(valueStr).getLevel());
                    String inLanguage = parts.containsAttribute("inLanguage") ? CoverageLevel2.this.coverageVariables.replace(parts.getAttributeValue(-1, "inLanguage")) : null;
                    String inScript = parts.containsAttribute("inScript") ? CoverageLevel2.this.coverageVariables.replace(parts.getAttributeValue(-1, "inScript")) : null;
                    String inTerritory = parts.containsAttribute("inTerritory") ? CoverageLevel2.this.coverageVariables.replace(parts.getAttributeValue(-1, "inTerritory")) : null;
                    Integer n = value = valueStr != null ? Integer.valueOf(valueStr) : Integer.valueOf("101");
                    if (RawCoverageFile.this.cldrVersion.getMajor() < 2) {
                        value = 40;
                    }
                    SupplementalDataInfo.CoverageLevelInfo ci = new SupplementalDataInfo.CoverageLevelInfo(match, value, inLanguage, inScript, inTerritory);
                    CoverageLevel2.this.coverageLevels.add(ci);
                } else if (parts.containsElement("coverageVariable")) {
                    String key = parts.getAttributeValue(-1, "key");
                    String value = parts.getAttributeValue(-1, "value");
                    CoverageLevel2.this.coverageVariables.add(key, value);
                }
            }

            public void cleanup() {
                CLDRConfig testInfo = ToolConfig.getToolInstance();
                SupplementalDataInfo supplementalDataInfo2 = testInfo.getSupplementalDataInfo();
                SupplementalDataInfo.CoverageLevelInfo.fixEU(CoverageLevel2.this.coverageLevels, supplementalDataInfo2);
                CoverageLevel2.this.coverageLevels = Collections.unmodifiableSortedSet(CoverageLevel2.this.coverageLevels);
            }
        }
    }

    public static class MyRegexFinder
    extends RegexLookup.RegexFinder {
        private final SetMatchType additionalMatch;
        private final SupplementalDataInfo.CoverageLevelInfo ci;

        public MyRegexFinder(String pattern, String additionalMatch, SupplementalDataInfo.CoverageLevelInfo ci) {
            super(pattern);
            this.additionalMatch = additionalMatch == null ? null : SetMatchType.valueOf(additionalMatch.substring(2, additionalMatch.length() - 1).replace('-', '_'));
            this.ci = ci;
        }

        @Override
        public boolean find(String item, Object context, RegexLookup.Finder.Info info) {
            LocaleSpecificInfo localeSpecificInfo = (LocaleSpecificInfo)context;
            boolean lstOK = false;
            if (this.ci.inLanguage == null && this.ci.inScriptSet == null && this.ci.inTerritorySet == null) {
                lstOK = true;
            } else if (this.ci.inLanguage != null && this.ci.inLanguage.matcher(localeSpecificInfo.targetLanguage).matches()) {
                lstOK = true;
            } else if (this.ci.inScriptSet != null && !Collections.disjoint(this.ci.inScriptSet, localeSpecificInfo.cvi.targetScripts)) {
                lstOK = true;
            } else if (this.ci.inTerritorySet != null && !Collections.disjoint(this.ci.inTerritorySet, localeSpecificInfo.cvi.targetTerritories)) {
                lstOK = true;
            }
            if (!lstOK) {
                return false;
            }
            boolean result = super.find(item, context, info);
            if (!result) {
                return false;
            }
            if (this.additionalMatch != null) {
                String groupMatch = info.value[1];
                switch (this.additionalMatch) {
                    case Target_Language: {
                        return localeSpecificInfo.targetLanguage.equals(groupMatch);
                    }
                    case Target_Scripts: {
                        return localeSpecificInfo.cvi.targetScripts.contains(groupMatch);
                    }
                    case Target_Territories: {
                        return localeSpecificInfo.cvi.targetTerritories.contains(groupMatch);
                    }
                    case Target_TimeZones: {
                        return localeSpecificInfo.cvi.targetTimeZones.contains(groupMatch);
                    }
                    case Target_Currencies: {
                        return localeSpecificInfo.cvi.targetCurrencies.contains(groupMatch);
                    }
                    case Target_Plurals: {
                        return groupMatch == null || groupMatch.length() == 0 || localeSpecificInfo.cvi.targetPlurals.contains(groupMatch);
                    }
                    case Calendar_List: {
                        return localeSpecificInfo.cvi.calendars.contains(groupMatch);
                    }
                }
            }
            return true;
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }
    }

    private static class LocaleSpecificInfo {
        SupplementalDataInfo.CoverageVariableInfo cvi;
        String targetLanguage;

        private LocaleSpecificInfo() {
        }
    }

    static enum SetMatchType {
        Target_Language,
        Target_Scripts,
        Target_Territories,
        Target_TimeZones,
        Target_Currencies,
        Target_Plurals,
        Calendar_List;

    }
}

