/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.text.MessageFormat;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.util.Date;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Iso639Data;
import org.unicode.cldr.util.SimpleXMLSource;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

@CLDRTool(alias="langdata", description="Generate a list of ISO639 language data. Use '--en' to build en.xml.")
public class GenerateLanguageData {
    static SupplementalDataInfo supplementalData = SupplementalDataInfo.getInstance(CLDRPaths.SUPPLEMENTAL_DIRECTORY);
    static Iso639Data iso639Data = new Iso639Data();

    public static void main(String[] args) throws IOException {
        MessageFormat nameFmt = new MessageFormat("{0,plural, one{# other name} other{# other names}}");
        Set<String> bcp47languages = StandardCodes.make().getAvailableCodes("language");
        if (args.length > 0 && args[0].equals("--en")) {
            CLDRConfig cldrConfig = CLDRConfig.getInstance();
            XPathParts xpp = new XPathParts().addElement("ldml").addElement("localeDisplayNames").addElement("languages").addElement("language");
            xpp.setAttribute(-1, "draft", CLDRFile.DraftStatus.unconfirmed.toString());
            System.out.println("generating en.xml.. to " + CLDRPaths.GEN_DIRECTORY);
            SimpleXMLSource xmlSource = new SimpleXMLSource("en");
            CLDRFile newEn = new CLDRFile(xmlSource);
            CLDRFile oldEn = cldrConfig.getEnglish();
            Set<String> all = Iso639Data.getAvailable();
            newEn.addComment("//ldml", "by " + GenerateLanguageData.class.getSimpleName() + " from Iso639Data v" + Iso639Data.getVersion() + " on " + new Date() + " - " + all.size() + " codes.", XPathParts.Comments.CommentType.PREBLOCK);
            System.out.println(all.size() + " ISO 639 codes to process");
            for (String languageCode : all) {
                xpp.setAttribute(-1, "type", languageCode);
                String xpath = xpp.toString();
                newEn.add(xpp.toString(), oldEn.nameGetter().getNameFromIdentifier(languageCode));
                String oldValue = oldEn.getStringValue(xpath);
                if (oldValue == null || oldValue.equals(languageCode)) continue;
                newEn.addComment(xpath, "was already in en.xml", XPathParts.Comments.CommentType.LINE);
            }
            String filename = newEn.getLocaleID() + ".xml";
            try (PrintWriter w = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, filename);){
                newEn.write(w);
                System.out.println("Wrote to " + CLDRPaths.GEN_DIRECTORY + "/" + filename);
            }
            return;
        }
        TreeSet<String> languageCodes = new TreeSet<String>(Iso639Data.getAvailable());
        System.out.println("Macrolanguages");
        for (String languageCode : languageCodes) {
            Set<String> suffixes = Iso639Data.getEncompassedForMacro(languageCode);
            if (suffixes == null) continue;
            for (String suffix : new TreeSet<String>(suffixes)) {
                System.out.println(languageCode + "\t" + (bcp47languages.contains(languageCode) ? "4646" : "new") + "\t" + Iso639Data.getNames(languageCode).iterator().next() + "\t" + suffix + "\t" + (bcp47languages.contains(suffix) ? "4646" : "new") + "\t" + Iso639Data.getNames(suffix).iterator().next());
            }
        }
        System.out.println("All");
        Relation<CallSite, CallSite> type_codes = Relation.of(new TreeMap(), TreeSet.class);
        for (String languageCode : languageCodes) {
            Iso639Data.Scope scope = Iso639Data.getScope(languageCode);
            Iso639Data.Type type = Iso639Data.getType(languageCode);
            Set<String> names = Iso639Data.getNames(languageCode);
            Iso639Data.Source source = Iso639Data.getSource(languageCode);
            String prefix = Iso639Data.getMacroForEncompassed(languageCode);
            Set<String> prefixNames = prefix == null ? null : Iso639Data.getNames(prefix);
            String prefixName = prefixNames == null || prefixNames.size() == 0 ? "" : prefixNames.iterator().next() + "::\t";
            String fullCode = (String)(prefix != null ? prefix + "-" : "") + languageCode;
            Object scopeString = String.valueOf((Object)scope);
            if (Iso639Data.getEncompassedForMacro(languageCode) != null) {
                scopeString = (String)scopeString + "*";
            }
            System.out.println(fullCode + "\t" + source + "\t" + (String)scopeString + "\t" + type + "\t" + prefixName + CldrUtility.join(names, "\t"));
            type_codes.put((CallSite)((Object)(source + "\t" + (String)scopeString + "\t" + type)), (CallSite)((Object)fullCode));
        }
        for (String type : type_codes.keySet()) {
            Set codes = type_codes.getAll(type);
            System.out.println(codes.size() + "\t" + type + "\t" + GenerateLanguageData.truncate(codes));
        }
    }

    private static String truncate(Object codes) {
        String result = codes.toString();
        if (result.length() < 100) {
            return result;
        }
        return result.substring(0, 99) + "\u2026";
    }
}

