/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.BiMap;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.test.TestTransformsSimple;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.ShowData;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRTransforms;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.CollatorHelper;
import org.unicode.cldr.util.FileCopier;
import org.unicode.cldr.util.MultiComparator;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.TransliteratorUtilities;

public class GenerateTransformCharts {
    private static final String TRANSFORM_DIRECTORY = CLDRPaths.CHART_DIRECTORY + File.separatorChar + "transforms/";
    private static final UnicodeSet NON_LATIN = new UnicodeSet("[^[:latin:][:common:][:inherited:]]");
    private static final boolean verbose = CldrUtility.getProperty("verbose", false);
    static int[] indicScripts = new int[]{25, 0, 10, 4, 16, 15, 31, 35, 36, 21, 26};
    static String[] names = new String[indicScripts.length];
    static String[] shortnames = new String[indicScripts.length];
    static UnicodeSet[] sets = new UnicodeSet[indicScripts.length];
    static Transliterator[] fallbacks = new Transliterator[indicScripts.length];
    static UnicodeSet lengthMarks = new UnicodeSet("[\u09d7\u0b56-\u0b57\u0bd7\u0c56\u0cd5-\u0cd6\u0d57\u0c55\u0cd5]");
    static String testString = "\u0946\u093e";
    static Map<String, UnicodeSet> scriptExtras = new HashMap<String, UnicodeSet>();
    static PrintWriter index;
    static UnicodeSet stuffToSkip;
    static Comparator<String> UCA;
    static Map<String, String> language_to_script;
    private static UnicodeSet BIDI_R;

    public static void main(String[] args) throws IOException {
        String filter = CldrUtility.getProperty("filter", null);
        System.out.println("Start");
        FileCopier.ensureDirectoryExists(TRANSFORM_DIRECTORY);
        FileCopier.copy(ShowData.class, "transforms-index.css", TRANSFORM_DIRECTORY, "index.css");
        FormattedFileWriter.copyIncludeHtmls(TRANSFORM_DIRECTORY);
        CLDRTransforms.registerCldrTransforms(null, filter, verbose ? new PrintWriter(System.out) : null, false);
        System.out.println("Transliterators registered");
        try {
            GenerateTransformCharts.showAllLatin();
        }
        finally {
            System.out.println("Done");
        }
    }

    private static String findItemInScript(Set<String> equivs, UnicodeSet scriptSet) {
        Iterator<String> sit = equivs.iterator();
        String item = "";
        while (sit.hasNext()) {
            String trial = sit.next();
            if (!scriptSet.containsAll(trial)) continue;
            item = trial;
            break;
        }
        return item;
    }

    private static Transliterator getTransliterator(String source, String target, String variant) {
        Object id = CLDRTransforms.ParsedTransformID.getId(source, target, variant);
        if (((String)id).indexOf("InterIndic") >= 0) {
            id = "NFD; " + (String)id + "; NFC";
            return Transliterator.getInstance((String)id);
        }
        return Transliterator.getInstance((String)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showAllLatin() throws IOException {
        String[] headerAndFooter = new String[2];
        ShowData.getChartTemplate("Transliteration Charts", null, "", headerAndFooter, "Main Charts Index", false);
        index = FileUtilities.openUTF8Writer(TRANSFORM_DIRECTORY, "index.html");
        index.println(headerAndFooter[0]);
        index.println("<p>The following illustrates some of the CLDR transliterations to/from the Latin script.</p>");
        index.println("<blockquote><b>Note:</b> These charts do not show the available script and language transliterations that are not to/from Latin. It also does not show other transforms that are available in CLDR, such as the casing transformations, full-width and half-width transformations, and specialized transformations such as IPA-XSampa. For the latest snapshot of the data files, see <a href='https://github.com/unicode-org/cldr/tree/main/common/transforms'>Transform XML Data</a>. For more information, see below.</blockquote>");
        index.flush();
        index.println("<ul>");
        TreeSet<String> nonScripts = new TreeSet<String>(Arrays.asList("ConjoiningJamo", "InterIndic", "Han", "el", "Jamo", "JapaneseKana", "Korean", "NumericPinyin", "ThaiLogical", "ThaiSemi"));
        try {
            BiMap<String, String> availableTransliterators = GenerateTransformCharts.getAvailableTransliterators();
            TreeMultimap<Pair<String, String>, String> scriptToIds = TreeMultimap.create();
            for (Map.Entry entry : availableTransliterators.entrySet()) {
                String display = (String)entry.getKey();
                String id = (String)entry.getValue();
                System.out.println(display + " => " + id);
                CLDRTransforms.ParsedTransformID parsedID = new CLDRTransforms.ParsedTransformID().set(id);
                String sourceScript = CLDRTransforms.ParsedTransformID.getScriptCode(parsedID.getSource());
                String targetScript = CLDRTransforms.ParsedTransformID.getScriptCode(parsedID.getTarget());
                if (sourceScript == null || targetScript == null) {
                    System.out.println("Skipping " + display + " => " + id);
                    continue;
                }
                index.flush();
                Pair<String, String> key = sourceScript.compareTo(targetScript) < 0 ? Pair.of(sourceScript, targetScript) : Pair.of(targetScript, sourceScript);
                scriptToIds.put(key, id);
            }
            for (Map.Entry entry : scriptToIds.asMap().entrySet()) {
                System.out.println(entry.getKey() + " => " + entry.getValue());
                GenerateTransformCharts.showLatin((Pair)entry.getKey(), (Set)entry.getValue());
            }
        }
        finally {
            index.println("</ul>");
            index.println("<h2>Key</h2><ul>");
            index.println("<li>A cell with a blue background indicates a case that doesn't roundtrip.</li>");
            index.println("<li>A cell with a red background indicates a missing case.</li>");
            index.println("<li>Hovering over each cell should show the character name, if enabled on your browser.</li>");
            index.println("</ul>");
            index.println("<h2>Known Data Issues</h2><ul>");
            index.println("<li>The CLDR data currently does not contain many language-specific transliterations. So, for example, the Cyrillic transliteration is not very natural for English speakers.</li>");
            index.println("<li>The unmarked script transliterations to Latin are generally designed to be reversible, thus some of the transliterations use extra accents to provide for a round-trip. (Implementations like ICU allows those to be easily stripped.). Variant transliterations (such as BGN) typically only go one direction.</li>");
            index.println("<li>Less common characters may be missing; as may be some characters that don't appear in isolation.</li>");
            index.println("<li>Some transliterations only work in context, which won't be visible. For example, an isolated 'a' transliterates to </li>");
            index.println("<li>There are known bugs in some of the charts, such as Hangul.</li>");
            index.println("</ul>");
            index.println("<h2>Known Chart Issues</h2><ul>");
            index.println("<li>Some browsers will not show combinations of accents correctly. See <a href='http://www.unicode.org/help/display_problems.html'>Display Problems?</a></li>");
            index.println("<li>Because the context is not taken into account, significant combinations will not show in the charts. For example: For greek, \u03a8 shows as 'PH', when the transliteration rules will change it to 'Ph' in front of lowercase letters. Characters that are not normally used in isolation, such as \u3041, will show as an odd format (eg with extra punctuations marks or accents).</li>");
            index.println("<li>Only the script-script charts are shown.</li>");
            index.println("<li>The display in some of the charts needs to be improved, such as Greek, Indic, and Kana. In particular, the nonLatin-Latin display needs to be merged.</li>");
            index.println("</ul>");
            index.println(headerAndFooter[1]);
            index.close();
        }
    }

    private static boolean isLatin(String target) {
        return target.equals("Latin") || target.equals("Latn");
    }

    private static void showLatin(Pair<String, String> scriptChoice, Set<String> targetVariant) throws IOException {
        CLDRTransforms.ParsedTransformID parsedID = new CLDRTransforms.ParsedTransformID();
        TreeSet<String> ids = new TreeSet<String>();
        HashMap<String, UnicodeSet> id_unmapped = new HashMap<String, UnicodeSet>();
        HashMap id_noRoundTrip = new HashMap();
        TreeSet<String> latinItems = new TreeSet<String>(UCA);
        TreeMap<String, String> nonLatinToLatin = new TreeMap<String, String>(UCA);
        TreeSet<String> totalLatin = new TreeSet<String>();
        TreeMap<String, Map<String, Map<String, Boolean>>> latinToTaggedNonLatin = new TreeMap<String, Map<String, Map<String, Boolean>>>(UCA);
        TreeMap<String, Map<String, Map<String, Boolean>>> nonLatinToLatinTagged = new TreeMap<String, Map<String, Map<String, Boolean>>>(UCA);
        UnicodeSet totalNonLatinSet = new UnicodeSet();
        for (String id : targetVariant) {
            String latin;
            int c;
            Transliterator latin_nonLatin;
            Transliterator nonLatin_latin;
            parsedID.set(id);
            String nonLatinId = null;
            String script = scriptChoice.getFirst();
            int scriptCode = UScript.getCodeFromName(scriptChoice.getFirst());
            if (scriptCode < 0) {
                throw new IllegalArgumentException("Missing script: " + scriptChoice);
            }
            UnicodeSet nonLatinUnmapped = new UnicodeSet();
            id_unmapped.put(id, nonLatinUnmapped);
            TreeMap<String, String> noRoundTrip = new TreeMap<String, String>(UCA);
            id_noRoundTrip.put(id, noRoundTrip);
            ids.add(parsedID.toString());
            UnicodeSet nonLatinUnicodeSet = GenerateTransformCharts.getNonLatinSet(script, scriptCode);
            totalNonLatinSet.addAll(nonLatinUnicodeSet);
            try {
                nonLatin_latin = GenerateTransformCharts.getTransliterator(parsedID.source, parsedID.target, parsedID.variant);
            }
            catch (RuntimeException e) {
                continue;
            }
            try {
                latin_nonLatin = GenerateTransformCharts.getTransliterator(parsedID.target, parsedID.source, parsedID.variant);
            }
            catch (RuntimeException e) {
                latin_nonLatin = Transliterator.getInstance("null");
            }
            boolean sourceIsCased = false;
            UnicodeSetIterator it = new UnicodeSetIterator(nonLatinUnicodeSet);
            while (it.next()) {
                boolean nonLatinToLatinReversible;
                String backToNonLatin;
                String latin2;
                String nonLatin = it.getString();
                if (nonLatin.equals("\ub290")) {
                    System.out.println("??");
                }
                if (GenerateTransformCharts.areSame(nonLatin, latin2 = nonLatin_latin.transliterate(nonLatin)) || NON_LATIN.containsSome(latin2)) {
                    nonLatinUnmapped.add(nonLatin);
                    continue;
                }
                if (latin2.length() != 0) {
                    latinItems.add(latin2);
                }
                boolean convertsLatin = !GenerateTransformCharts.areSame(backToNonLatin = latin_nonLatin.transliterate(latin2), latin2);
                boolean bl = nonLatinToLatinReversible = convertsLatin && GenerateTransformCharts.areSame(backToNonLatin, nonLatin);
                if (!nonLatinToLatinReversible) {
                    noRoundTrip.put(nonLatin, latin2);
                } else if (!sourceIsCased && !UCharacter.foldCase(nonLatin, true).equals(nonLatin)) {
                    sourceIsCased = true;
                }
                if (!totalLatin.contains(latin2) && latin2.length() > 0) {
                    nonLatinToLatin.put(nonLatin, latin2);
                    totalLatin.add(latin2);
                }
                CldrUtility.addTreeMapChain(nonLatinToLatinTagged, nonLatin, nonLatinId, latin2, GenerateTransformCharts.areSame(nonLatin, backToNonLatin));
                if (!convertsLatin) continue;
                String backToLatin = nonLatin_latin.transliterate(backToNonLatin);
                CldrUtility.addTreeMapChain(latinToTaggedNonLatin, latin2, nonLatinId, backToNonLatin, GenerateTransformCharts.areSame(latin2, backToLatin));
            }
            for (c = 97; c <= 122; ++c) {
                latin = UTF16.valueOf(c);
                GenerateTransformCharts.addToLatinMap(latinItems, latinToTaggedNonLatin, nonLatinToLatinTagged, nonLatinId, nonLatin_latin, latin_nonLatin, latin);
            }
            if (!sourceIsCased) continue;
            for (c = 65; c <= 90; ++c) {
                latin = UTF16.valueOf(c);
                GenerateTransformCharts.addToLatinMap(latinItems, latinToTaggedNonLatin, nonLatinToLatinTagged, nonLatinId, nonLatin_latin, latin_nonLatin, latin);
            }
        }
        String filename = scriptChoice.getFirst() + "-" + scriptChoice.getSecond() + ".html";
        index.println("<li><a href='" + filename + "'>" + scriptChoice.getFirst() + "-" + scriptChoice.getSecond() + "</a></li>");
        PrintWriter pw = FileUtilities.openUTF8Writer(TRANSFORM_DIRECTORY, filename);
        String[] headerAndFooter = new String[2];
        ShowData.getChartTemplate("Latin-" + scriptChoice + " Transliteration Chart", null, "", headerAndFooter, null, false);
        pw.println(headerAndFooter[0]);
        pw.println("<p>This chart illustrates one or more of the transliterations in CLDR. It is not complete; in particular, it does not show examples where transliterations differ according to context.</p><p><b>Note:</b> This chart is preliminary; for known issues and more information (such as how to see character names), see the <a href='index.html'>index</a>.</p>");
        pw.println("<div align='center'>");
        pw.println("<table border='1' cellspacing='0' cellpadding='8'>");
        pw.println("<tr>");
        pw.println("<th>" + scriptChoice + "-Latin</th>");
        if (!latinToTaggedNonLatin.isEmpty()) {
            pw.println("<th>Latin-" + scriptChoice + "</th>");
        }
        pw.println("</tr><tr><td class='main'>");
        GenerateTransformCharts.doMainTable(parsedID, targetVariant, pw, nonLatinToLatinTagged, true, scriptChoice.getFirst(), totalNonLatinSet);
        if (!latinToTaggedNonLatin.isEmpty()) {
            pw.println("</td><td class='main'>");
            GenerateTransformCharts.doMainTable(parsedID, targetVariant, pw, latinToTaggedNonLatin, false, scriptChoice.getFirst(), new UnicodeSet());
        }
        pw.println("</td></tr></table></div>");
        pw.println(headerAndFooter[1]);
        pw.close();
    }

    private static boolean areSame(String a, String b) {
        return Normalizer.compare(a, b, 0) == 0;
    }

    private static void addToLatinMap(Set<String> latinItems, Map<String, Map<String, Map<String, Boolean>>> latinToTaggedNonLatin, Map<String, Map<String, Map<String, Boolean>>> nonLatinToLatinTagged, String nonLatinId, Transliterator nonLatin_latin, Transliterator latin_nonLatin, String latin) {
        latinItems.add(latin);
        String nonLatin = latin_nonLatin.transliterate(latin);
        if (!nonLatin.equals(latin)) {
            String backLatin = nonLatin_latin.transliterate(nonLatin);
            CldrUtility.addTreeMapChain(latinToTaggedNonLatin, latin, nonLatinId, nonLatin, GenerateTransformCharts.areSame(latin, backLatin));
            String backNonLatin = latin_nonLatin.transliterate(backLatin);
            CldrUtility.addTreeMapChain(nonLatinToLatinTagged, nonLatin, nonLatinId, backLatin, GenerateTransformCharts.areSame(nonLatin, backNonLatin));
        }
    }

    private static UnicodeSet getNonLatinSet(String script, int scriptCode) {
        String scriptName = UScript.getShortName(scriptCode);
        UnicodeSet nonLatinUnicodeSet = new UnicodeSet("[:script=" + scriptName + ":]");
        nonLatinUnicodeSet.removeAll(stuffToSkip);
        UnicodeSet extras = new UnicodeSet();
        UnicodeSetIterator usi = new UnicodeSetIterator(nonLatinUnicodeSet);
        while (usi.next()) {
            String d = Normalizer.normalize(usi.getString(), Normalizer.NFD, 0);
            extras.addAll(d);
        }
        extras.removeAll(nonLatinUnicodeSet);
        if (extras.size() != 0) {
            System.out.println(script + "\tAdding2: " + extras);
            nonLatinUnicodeSet.addAll(extras);
        }
        if ((extras = scriptExtras.get(scriptName)) != null) {
            System.out.println(script + "\tAdding1: " + extras);
            System.out.println(extras.toPattern(false));
            nonLatinUnicodeSet.addAll(extras);
        }
        return nonLatinUnicodeSet;
    }

    private static void doMainTable(CLDRTransforms.ParsedTransformID parsedID, Set<String> ids_old, PrintWriter pw, Map<String, Map<String, Map<String, Boolean>>> xToTagToYToRoundtrip, boolean fromNonLatinToLatin, String scriptChoice, UnicodeSet totalNonLatinSet) {
        TreeSet<String> extras = new TreeSet<String>(UCA);
        UnicodeSetIterator it = new UnicodeSetIterator(totalNonLatinSet);
        while (it.next()) {
            extras.add(it.getString());
        }
        TreeSet<String> ids = new TreeSet<String>(UCA);
        for (String x : xToTagToYToRoundtrip.keySet()) {
            ids.addAll(xToTagToYToRoundtrip.get(x).keySet());
        }
        if (ids.isEmpty()) {
            return;
        }
        System.out.println("ids: " + ids);
        pw.println("<table border='1' cellspacing='0'><tr>");
        if (fromNonLatinToLatin) {
            pw.println("<th>" + scriptChoice + "</th>");
        } else {
            pw.println("<th>Latin</th>");
        }
        for (String id : ids) {
            id = id.replace("/", "/\u200b");
            pw.println("<th>" + (fromNonLatinToLatin ? id + "<br>to Latin" : "Latin to<br>" + id) + "</th>");
        }
        pw.println("</tr>");
        for (String x : xToTagToYToRoundtrip.keySet()) {
            pw.println("<tr>");
            GenerateTransformCharts.showCell(pw, x, "");
            extras.remove(x);
            Map<String, Map<String, Boolean>> idToYToRoundTrip = xToTagToYToRoundtrip.get(x);
            for (String id : ids) {
                boolean multiple;
                Map<String, Boolean> yToRoundTrip = idToYToRoundTrip.get(id);
                if (yToRoundTrip == null || yToRoundTrip.keySet().isEmpty()) {
                    GenerateTransformCharts.showCell(pw, "", "");
                    continue;
                }
                boolean bl = multiple = yToRoundTrip.keySet().size() != 1;
                if (multiple) {
                    pw.println("<td><div align='center'><table><tr>");
                }
                Iterator<String> iterator = yToRoundTrip.keySet().iterator();
                while (iterator.hasNext()) {
                    String y;
                    boolean roundTrip = yToRoundTrip.get(y = iterator.next());
                    GenerateTransformCharts.showCell(pw, y, roundTrip ? "" : " class='miss'");
                }
                if (!multiple) continue;
                pw.println("</tr></table></div></td>");
            }
            pw.println("</tr>");
        }
        if (extras.size() != 0) {
            pw.println("<tr><th>Unmapped</th></tr>");
            for (String x : extras) {
                pw.println("<tr>");
                GenerateTransformCharts.showCell(pw, x, "");
                pw.println("</tr>");
            }
        }
        pw.println("</table>");
    }

    private static void doMainTable2(CLDRTransforms.ParsedTransformID parsedID, Set<String> ids, PrintWriter pw, Map<String, String> mapping, boolean latinAtEnd) {
        pw.println("<table border='1' cellspacing='0'><tr>");
        if (!latinAtEnd) {
            pw.println("<th>Latin</th>");
        }
        Iterator<String> it2 = ids.iterator();
        while (it2.hasNext()) {
            parsedID.set(it2.next());
            pw.println("<th>" + parsedID.source + (String)(parsedID.variant == null ? "" : "/" + parsedID.variant) + "</th>");
        }
        if (latinAtEnd) {
            pw.println("<th>Latin</th>");
        }
        pw.println("</tr>");
        for (String source : mapping.keySet()) {
            String target = mapping.get(source);
            pw.println("<tr>");
            GenerateTransformCharts.showCell(pw, source, "");
            GenerateTransformCharts.showCell(pw, target, "");
            pw.println("</tr>");
        }
        pw.println("</table>");
    }

    private static BiMap<String, String> getAvailableTransliterators() {
        return CLDRTransforms.getInstance().getDisplayNameToId();
    }

    private static void showCell(PrintWriter pw, String item, String classString) {
        String backup = item;
        String name = GenerateTransformCharts.getName(item, "; ");
        if (item.equals("")) {
            backup = "\u00a0";
            classString = " class='none'";
            name = "{missing}";
        } else if (item.charAt(0) >= '\ue000') {
            backup = "\u00a0";
        }
        name = TransliteratorUtilities.toXML.transliterate(name);
        backup = TransliteratorUtilities.toHTML.transliterate(backup);
        String dir = BIDI_R.containsSome(backup) ? " style='direction:rtl'" : "";
        pw.print("<td" + classString + dir + " title='" + name + "'>\u00a0\u00a0" + backup + "\u00a0\u00a0<br><tt>" + Utility.hex(item) + "</tt></td>");
    }

    public static String fix(String s2) {
        if (s2.equals("\u0946\u093e")) {
            return "\u094a";
        }
        if (s2.equals("\u0c46\u0c3e")) {
            return "\u0c4a";
        }
        if (s2.equals("\u0cc6\u0cbe")) {
            return "\u0cca";
        }
        if (s2.equals("\u0947\u093e")) {
            return "\u094b";
        }
        if (s2.equals("\u0a47\u0a3e")) {
            return "\u0a4b";
        }
        if (s2.equals("\u0ac7\u0abe")) {
            return "\u0acb";
        }
        if (s2.equals("\u0c47\u0c3e")) {
            return "\u0c4b";
        }
        if (s2.equals("\u0cc7\u0cbe")) {
            return "\u0ccb";
        }
        return s2;
    }

    public static String getName(String s2, String separator) {
        int cp;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s2.length(); i += UTF16.getCharCount(cp)) {
            cp = UTF16.charAt(s2, i);
            if (i != 0) {
                sb.append(separator);
            }
            sb.append(UCharacter.getName(cp));
        }
        return sb.toString();
    }

    static {
        scriptExtras.put("Arab", new UnicodeSet("[\u0660-\u0669]"));
        scriptExtras.put("Hang", TestTransformsSimple.getRepresentativeHangul());
        stuffToSkip = new UnicodeSet("[[:block=Hangul Syllables:][:NFKC_QuickCheck=No:]]").freeze();
        UCA = new MultiComparator<String>(CollatorHelper.ROOT_NUMERIC_IDENTICAL, new UTF16.StringComparator(true, false, 0));
        language_to_script = CldrUtility.asMap(new String[][]{{"Jamo", "Hangul"}, {"Amharic", "Ethiopic"}, {"Azerbaijani", "Cyrillic"}, {"Belarusian", "Cyrillic"}, {"Bulgarian", "Cyrillic"}, {"Kazakh", "Cyrillic"}, {"Kirghiz", "Cyrillic"}, {"Macedonian", "Cyrillic"}, {"Maldivian", "Thaana"}, {"Mongolian", "Cyrillic"}, {"Pashto", "Arabic"}, {"Persian", "Arabic"}, {"Russian", "Cyrillic"}, {"Serbian", "Cyrillic"}, {"Turkmen", "Cyrillic"}, {"Ukrainian", "Cyrillic"}, {"Uzbek", "Cyrillic"}});
        BIDI_R = new UnicodeSet("[[:Bidi_Class=R:][:Bidi_Class=AL:]]").freeze();
    }

    static class ReverseComparator
    implements Comparator<Object> {
        ReverseComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            String a = o1.toString();
            char a1 = a.charAt(0);
            String b = o2.toString();
            char b1 = b.charAt(0);
            if (a1 < '\u0900' && b1 > '\u0900') {
                return -1;
            }
            if (a1 > '\u0900' && b1 < '\u0900') {
                return 1;
            }
            return a.compareTo(b);
        }
    }

    public static class CollectionOfComparablesComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            Iterator i1 = ((Collection)o1).iterator();
            Iterator i2 = ((Collection)o2).iterator();
            while (i1.hasNext() && i2.hasNext()) {
                Comparable b;
                Comparable a = (Comparable)i1.next();
                int result = a.compareTo(b = (Comparable)i2.next());
                if (result == 0) continue;
                return result;
            }
            if (i1.hasNext()) {
                return 1;
            }
            if (i2.hasNext()) {
                return -1;
            }
            return 0;
        }
    }

    private static class TranslitStatus {
        String source;
        String back;

        public TranslitStatus(String source, String back) {
            this.source = source;
            this.back = back;
        }
    }
}

