/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.Serializable;
import java.util.Set;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.NameType;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.SupplementalDataInfo;

public class GetLanguageData {
    SupplementalDataInfo sdata = SupplementalDataInfo.getInstance(CLDRPaths.SUPPLEMENTAL_DIRECTORY);
    Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
    CLDRFile english = this.cldrFactory.make("en", true);
    Set<String> euCountries = this.sdata.getContained("EU");
    Counter<String> languageToGdp = new Counter();
    Counter<String> languageToPop = new Counter();

    public static void main(String[] args) {
        new GetLanguageData().run();
    }

    private void run() {
        this.findSuspectData();
        System.out.println("Code\tLang\tLpop\tApprox. Gdp");
        for (String language : this.sdata.getLanguages()) {
            long pop = this.languageToPop.getCount(language);
            System.out.print(language + "\t" + this.english.nameGetter().getNameFromIdentifier(language));
            if (pop > 0L) {
                Pair<SupplementalDataInfo.OfficialStatus, String> status = this.isOfficialLanguageOfEUCountry(language);
                System.out.print("\t" + pop + "\t" + this.languageToGdp.getCount(language) + "\t" + (Serializable)(status.getFirst().isOfficial() ? (Serializable)((Object)status.getFirst()) : "") + "\t" + status.getSecond());
            }
            System.out.println();
        }
    }

    private void findSuspectData() {
        Set<String> territories = this.sdata.getTerritoriesWithPopulationData();
        for (String territory : territories) {
            double scale = 1.0;
            SupplementalDataInfo.PopulationData populationDataForTerritory = this.sdata.getPopulationDataForTerritory(territory);
            double gdp = populationDataForTerritory.getGdp();
            double territoryPop = populationDataForTerritory.getPopulation();
            double langPop = 0.0;
            double officialLangPop = 0.0;
            Set<String> languages = this.sdata.getLanguagesForTerritoryWithPopulationData(territory);
            for (String language : languages) {
                if (language.equals("tl")) continue;
                SupplementalDataInfo.PopulationData pop2 = this.sdata.getLanguageAndTerritoryPopulationData(language, territory);
                langPop += pop2.getPopulation();
                if (!pop2.getOfficialStatus().isOfficial()) continue;
                officialLangPop += pop2.getPopulation();
            }
            double missing = 0.75 * territoryPop - langPop;
            if (missing > 0.0) {
                System.out.println(territory + "\t" + this.english.nameGetter().getNameFromTypeEnumCode(NameType.TERRITORY, territory) + "\t" + territoryPop + "\t" + langPop + "\t" + gdp);
                scale = 1.0 + missing / officialLangPop;
                langPop = territoryPop * 0.75;
                System.out.println("\tScaling " + territory + "\t" + scale * 100.0 + "%");
            }
            long langUnknown = (long)territoryPop;
            for (String language : languages) {
                if (language.equals("tl")) continue;
                SupplementalDataInfo.PopulationData pop2 = this.sdata.getLanguageAndTerritoryPopulationData(language, territory);
                double langPop2 = pop2.getPopulation();
                if (pop2.getOfficialStatus().isOfficial()) {
                    langPop2 *= scale;
                }
                this.languageToGdp.add(language, (long)(gdp * langPop2 / territoryPop));
                this.languageToPop.add(language, (long)langPop2);
                langUnknown = (long)((double)langUnknown - langPop2);
            }
            if (langUnknown <= 0L) continue;
            this.languageToGdp.add("und", (long)(gdp * (double)langUnknown / territoryPop));
            this.languageToPop.add("und", langUnknown);
        }
    }

    private Pair<SupplementalDataInfo.OfficialStatus, String> isOfficialLanguageOfEUCountry(String language) {
        SupplementalDataInfo.OfficialStatus bestStatus = SupplementalDataInfo.OfficialStatus.unknown;
        String eu = "";
        double bestEuPop = 0.0;
        Set<String> territories = this.sdata.getTerritoriesForPopulationData(language);
        for (String territory : territories) {
            SupplementalDataInfo.PopulationData pop = this.sdata.getLanguageAndTerritoryPopulationData(language, territory);
            SupplementalDataInfo.OfficialStatus status = pop.getOfficialStatus();
            if (bestStatus.compareTo(status) < 0) {
                bestStatus = status;
            }
            if (!status.isMajor() || !this.euCountries.contains(territory) || !(pop.getLiteratePopulation() > bestEuPop)) continue;
            bestEuPop = pop.getLiteratePopulation();
            eu = territory;
        }
        return Pair.of(bestStatus, eu);
    }
}

