/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.TreeMultimap;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.util.Map;
import java.util.TreeMap;
import org.unicode.cldr.util.Annotations;
import org.unicode.cldr.util.Counter;

public class MakeAnnotationHistogram {
    private static final Integer ZERO = 0;

    public static void main(String[] args) {
        Annotations.AnnotationSet english = Annotations.getDataSet("en");
        UnicodeSet codes = english.getExplicitValues().keySet();
        TreeMultimap<String, ULocale> missingCodeToLocales = TreeMultimap.create();
        TreeMap<String, Counter<Integer>> codeToCounter = new TreeMap<String, Counter<Integer>>();
        int maxmax = 0;
        for (String string : Annotations.getAvailable()) {
            ULocale ulocale = new ULocale(string);
            Annotations.AnnotationSet annotationSet = Annotations.getDataSet(string);
            Counter<Integer> counter = new Counter<Integer>();
            int max = 0;
            for (String code : codes) {
                String name = annotationSet.getShortName(code);
                if (name == null) {
                    missingCodeToLocales.put(code, ulocale);
                    continue;
                }
                int clusterCount = MakeAnnotationHistogram.getCount(name, ulocale);
                counter.add(clusterCount, 1L);
                max = Math.max(max, clusterCount);
                Counter<Integer> counterForCode = (Counter<Integer>)codeToCounter.get(code);
                if (counterForCode == null) {
                    counterForCode = new Counter<Integer>();
                    codeToCounter.put(code, counterForCode);
                }
                counterForCode.add(clusterCount, 1L);
            }
            System.out.print(string + "\t" + ulocale.getDisplayName());
            for (int i = 1; i <= max; ++i) {
                System.out.print("\t" + MakeAnnotationHistogram.emptyIfZero(counter.getCount(i)));
            }
            System.out.println();
            if (maxmax >= max) continue;
            maxmax = max;
        }
        System.out.println("Missing");
        for (Map.Entry entry : missingCodeToLocales.asMap().entrySet()) {
            System.out.println((String)entry.getKey() + "\t" + entry.getValue());
        }
        System.out.println("CodeToGCs");
        for (Map.Entry entry : codeToCounter.entrySet()) {
            String code = (String)entry.getKey();
            Counter counter = (Counter)entry.getValue();
            System.out.print(code);
            for (int i = 1; i <= maxmax; ++i) {
                System.out.print("\t" + MakeAnnotationHistogram.emptyIfZero(counter.getCount(i)));
            }
            System.out.println();
        }
    }

    private static String emptyIfZero(long count) {
        return count == 0L ? "" : String.valueOf(count);
    }

    private static int getCount(String name, ULocale locale) {
        BreakIterator boundary = BreakIterator.getCharacterInstance(locale);
        int count = 0;
        boundary.setText(name);
        int start = boundary.first();
        int end = boundary.next();
        while (end != -1) {
            if (name.charAt(start) != ' ') {
                ++count;
            }
            start = end;
            end = boundary.next();
        }
        return count;
    }
}

