/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.Comparators;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.CalType;
import com.ibm.icu.util.BuddhistCalendar;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ChineseCalendar;
import com.ibm.icu.util.CopticCalendar;
import com.ibm.icu.util.DangiCalendar;
import com.ibm.icu.util.EthiopicCalendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.HebrewCalendar;
import com.ibm.icu.util.IndianCalendar;
import com.ibm.icu.util.IslamicCalendar;
import com.ibm.icu.util.JapaneseCalendar;
import com.ibm.icu.util.PersianCalendar;
import com.ibm.icu.util.TaiwanCalendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.unicode.cldr.util.CldrUtility;

public class ShowCalendarGroups {
    public static void main(String[] args) {
        TreeMultimap footprintToCalendar = TreeMultimap.create();
        for (CalType calType : CalType.values()) {
            footprintToCalendar.put(new Footprint(calType), (Object)calType);
        }
        System.out.println("Calendars\tmax days/year\tmax months/year\tmax days/month\tdays/year\tmonths/year\tdays/month");
        for (Map.Entry entry : footprintToCalendar.asMap().entrySet()) {
            System.out.println(((Collection)entry.getValue()).stream().map(x -> x.getId()).collect(Collectors.joining(" ")) + "\t" + entry.getKey());
        }
    }

    static Calendar makeCalendar(CalType calType, TimeZone zone, ULocale locale) {
        Calendar cal = null;
        switch (calType) {
            case ISO8601: 
            case GREGORIAN: {
                cal = new GregorianCalendar(zone, locale);
                break;
            }
            case BUDDHIST: {
                cal = new BuddhistCalendar(zone, locale);
                break;
            }
            case CHINESE: {
                cal = new ChineseCalendar(zone, locale);
                break;
            }
            case COPTIC: {
                cal = new CopticCalendar(zone, locale);
                break;
            }
            case DANGI: {
                cal = new DangiCalendar(zone, locale);
                break;
            }
            case ETHIOPIC: {
                cal = new EthiopicCalendar(zone, locale);
                break;
            }
            case ETHIOPIC_AMETE_ALEM: {
                cal = new EthiopicCalendar(zone, locale);
                ((EthiopicCalendar)cal).setAmeteAlemEra(true);
                break;
            }
            case HEBREW: {
                cal = new HebrewCalendar(zone, locale);
                break;
            }
            case INDIAN: {
                cal = new IndianCalendar(zone, locale);
                break;
            }
            case ISLAMIC_CIVIL: 
            case ISLAMIC_UMALQURA: 
            case ISLAMIC_TBLA: 
            case ISLAMIC_RGSA: 
            case ISLAMIC: {
                cal = new IslamicCalendar(zone, locale);
                break;
            }
            case JAPANESE: {
                cal = new JapaneseCalendar(zone, locale);
                break;
            }
            case PERSIAN: {
                cal = new PersianCalendar(zone, locale);
                break;
            }
            case ROC: {
                cal = new TaiwanCalendar(zone, locale);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown calendar type");
            }
        }
        return cal;
    }

    static class Footprint
    implements Comparable<Footprint> {
        private static final Joiner SPACE_JOINER = Joiner.on(' ');
        private static final Joiner EQ_JOINER = Joiner.on('=');
        private static final Joiner COMMA_JOINER = Joiner.on(',');
        private static final Joiner TAB_JOINER = Joiner.on("\t");
        private static final MultimapJoiner MM_JOINER = new MultimapJoiner(SPACE_JOINER, EQ_JOINER, COMMA_JOINER);
        final int maxMonthsPerYear;
        final Set<Integer> monthsInYear;
        final int maxDaysPerYear;
        final Set<Integer> daysInYear;
        final int maxDaysPerMonth;
        final Multimap<Integer, Integer> daysInMonths;
        final int hash;
        static Date d = new Date(0, 0, 1, 0, 0, 0);
        private static final Comparator<Map.Entry<Integer, Integer>> ENTRY_COMP = new Comparator<Map.Entry<Integer, Integer>>(){

            @Override
            public int compare(Map.Entry<Integer, Integer> o1, Map.Entry<Integer, Integer> o2) {
                return ComparisonChain.start().compare(o1.getKey(), o2.getKey()).compare(o1.getValue(), o2.getValue()).result();
            }
        };
        private static final Comparator<Iterable<Map.Entry<Integer, Integer>>> LIST_ENTRY_COMP = Comparators.lexicographical(ENTRY_COMP);
        private static final Comparator<Iterable<Integer>> LEX_NATURAL_INTEGER = Comparators.lexicographical(Comparator.naturalOrder());

        public Footprint(CalType calType) {
            int startYear;
            if (calType.equals((Object)CalType.CHINESE)) {
                boolean bl = false;
            }
            Calendar cal2 = ShowCalendarGroups.makeCalendar(calType, TimeZone.GMT_ZONE, ULocale.ENGLISH);
            int hack = cal2.getMaximum(2) + 1;
            boolean isChineseCalendarBased = cal2 instanceof ChineseCalendar;
            boolean isHebrewCalendarBased = cal2 instanceof HebrewCalendar;
            if (isChineseCalendarBased) {
                ++hack;
            }
            this.maxMonthsPerYear = hack;
            this.maxDaysPerMonth = cal2.getMaximum(5);
            this.maxDaysPerYear = cal2.getMaximum(6);
            TreeSet<Integer> _monthsInYear = new TreeSet<Integer>();
            TreeSet<Integer> _daysInYear = new TreeSet<Integer>();
            TreeMultimap<Integer, Integer> _daysInMonths = TreeMultimap.create();
            cal2.setTime(d);
            int currYear = startYear = cal2.get(1);
            block0: for (int year = startYear; year < startYear + 1000; ++year) {
                cal2.set(5, 1);
                cal2.set(2, 0);
                int currDaysPerYear = cal2.getActualMaximum(6);
                int currMonthsInYear = cal2.getActualMaximum(2) + 1;
                if (isChineseCalendarBased && currDaysPerYear >= 365) {
                    ++currMonthsInYear;
                } else if (isHebrewCalendarBased && currDaysPerYear < 365) {
                    --currMonthsInYear;
                }
                _monthsInYear.add(currMonthsInYear);
                _daysInYear.add(currDaysPerYear);
                int daysLeft = currDaysPerYear;
                int month = 0;
                while (true) {
                    int daysInThisMonth = cal2.getActualMaximum(5);
                    _daysInMonths.put(month + 1, daysInThisMonth);
                    daysLeft -= daysInThisMonth;
                    int oldMonth = cal2.get(2);
                    cal2.add(2, 1);
                    if (cal2.get(2) < oldMonth) {
                        if (daysLeft == 0) continue block0;
                        System.out.println(calType + " " + (month + 1) + " " + daysLeft);
                        continue block0;
                    }
                    ++month;
                }
            }
            ImmutableSet<Integer> maxSingleton = ImmutableSet.of(Integer.valueOf(this.maxDaysPerMonth));
            _daysInMonths.asMap().values().removeIf(value -> value.equals(maxSingleton));
            this.daysInYear = ImmutableSet.copyOf(_daysInYear);
            this.monthsInYear = ImmutableSet.copyOf(_monthsInYear);
            this.daysInMonths = CldrUtility.protectCollection(_daysInMonths);
            this.hash = Objects.hash(this.maxMonthsPerYear, this.maxDaysPerMonth, this.maxDaysPerYear, this.monthsInYear, this.daysInYear, this.daysInMonths);
        }

        public boolean equals(Object obj) {
            return this.compareTo((Footprint)obj) == 0;
        }

        public int hashCode() {
            return this.hash;
        }

        @Override
        public int compareTo(Footprint o) {
            return ComparisonChain.start().compare(this.maxDaysPerYear, o.maxDaysPerYear).compare(this.maxMonthsPerYear, o.maxMonthsPerYear).compare(this.maxDaysPerMonth, o.maxDaysPerMonth).compare(this.daysInYear, o.daysInYear, LEX_NATURAL_INTEGER).compare(this.monthsInYear, o.monthsInYear, LEX_NATURAL_INTEGER).compare(this.daysInMonths.entries(), o.daysInMonths.entries(), LIST_ENTRY_COMP).result();
        }

        public String toString() {
            return TAB_JOINER.join(this.maxDaysPerYear, this.maxMonthsPerYear, this.maxDaysPerMonth, SPACE_JOINER.join(this.daysInYear), SPACE_JOINER.join(this.monthsInYear), MM_JOINER.join(this.daysInMonths));
        }
    }

    public static class MultimapJoiner {
        final Joiner entriesJoiner;
        final Joiner entryJoiner;
        final Joiner entryValueJoiner;

        public MultimapJoiner(Joiner entriesJoiner, Joiner entryJoiner, Joiner entryValueJoiner) {
            this.entriesJoiner = entriesJoiner;
            this.entryJoiner = entryJoiner;
            this.entryValueJoiner = entryValueJoiner;
        }

        public <K, V> String join(Multimap<K, V> multimap) {
            Function<Map.Entry, String> fii = x -> this.entryJoiner.join(x.getKey(), this.entryValueJoiner.join((Iterable)x.getValue()), new Object[0]);
            List list = multimap.asMap().entrySet().stream().map(fii).collect(Collectors.toList());
            return this.entriesJoiner.join(list);
        }
    }
}

