/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.HashMap;
import java.util.Map;
import org.unicode.cldr.draft.FileUtilities;

public class TranslationHints {
    private static final String HINTS_FILE = "data/translation-hints/hints.txt";
    private static Map<String, String> xpathToHint = null;

    public static String get(String xpath) {
        if (xpathToHint == null) {
            TranslationHints.initXpathToHint();
        }
        return xpathToHint.get(xpath);
    }

    private static void initXpathToHint() {
        xpathToHint = new HashMap<String, String>();
        String hint = null;
        for (String line : FileUtilities.in(TranslationHints.class, HINTS_FILE)) {
            if ((line = line.trim()).startsWith("HINT:")) {
                hint = line.substring(5).trim();
                continue;
            }
            if (line.startsWith("PATH:")) {
                String xpath = line.substring(5).trim();
                if (hint == null) {
                    throw new RuntimeException("Bad file, must set HINT before PATH: data/translation-hints/hints.txt");
                }
                xpathToHint.put(xpath, hint);
                continue;
            }
            if (line.isEmpty() || line.startsWith("#")) continue;
            throw new RuntimeException("Unrecognized line in data/translation-hints/hints.txt: " + line);
        }
    }
}

