/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.text.SimpleFormatter;
import com.ibm.icu.text.UnicodeSet;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.GrammarInfo;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.UnitConverter;
import org.unicode.cldr.util.UnitPathType;
import org.unicode.cldr.util.XPathParts;

public class CheckUnits
extends CheckCLDR {
    private static final Pattern HOUR_SYMBOL = PatternCache.get("h{1,2}");
    private static final Pattern MINUTE_SYMBOL = PatternCache.get("m{1,2}");
    private static final Pattern SECONDS_SYMBOL = PatternCache.get("ss");
    private static final UnicodeSet DISALLOW_LONG_POWER = new UnicodeSet("[\u00b2\u00b3]").freeze();
    static final UnitConverter unitConverter = CLDRConfig.getInstance().getSupplementalDataInfo().getUnitConverter();
    private Collection<String> genders = null;

    @Override
    public CheckCLDR handleSetCldrFileToCheck(CLDRFile cldrFileToCheck, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        super.handleSetCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        GrammarInfo grammarInfo = CLDRConfig.getInstance().getSupplementalDataInfo().getGrammarInfo(cldrFileToCheck.getLocaleID());
        this.genders = grammarInfo == null ? null : grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, GrammarInfo.GrammaticalFeature.grammaticalGender, GrammarInfo.GrammaticalScope.units);
        return this;
    }

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        UnitPathType pathType;
        if (value == null || !path.startsWith("//ldml/units")) {
            return this;
        }
        if (!this.accept(result)) {
            return this;
        }
        XPathParts parts = XPathParts.getFrozenInstance(path);
        String finalElement = parts.getElement(-1);
        if (this.genders != null && !this.genders.isEmpty() && finalElement.equals("gender") && !this.genders.contains(value)) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidGenderCode).setMessage("The gender value for this locale must be one of: {0}", this.genders));
        }
        if ((pathType = UnitPathType.getPathType(parts)) != null) {
            int min2 = 0;
            int max = 0;
            switch (pathType) {
                case power: 
                case prefix: {
                    min2 = 1;
                    max = 1;
                    break;
                }
                case times: 
                case per: {
                    min2 = 2;
                    max = 2;
                    break;
                }
                case perUnit: 
                case coordinate: {
                    min2 = 1;
                    max = 1;
                    break;
                }
                case unit: {
                    min2 = 0;
                    max = 1;
                    break;
                }
            }
            if (max > 0) {
                try {
                    SimpleFormatter simpleFormatter = SimpleFormatter.compileMinMaxArguments(value, min2, max);
                }
                catch (Exception e) {
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("Invalid unit pattern, must have min " + min2 + " and max " + max + " distinct placeholders of the form {n}"));
                }
            }
            switch (pathType) {
                case power: {
                    String unresolvedValue;
                    String width = parts.getAttributeValue(-3, "type");
                    if (value != null && "long".contentEquals(width) && DISALLOW_LONG_POWER.containsSome(this.fixedValueIfInherited(value, path)) && (unresolvedValue = this.getCldrFileToCheck().getUnresolved().getStringValue(path)) != null) {
                        String message = this.genders == null ? "Long value for power can\u2019t use superscripts; it must be spelled out." : "Long value for power can\u2019t use superscripts; it must be spelled out. [NOTE: values can vary by gender.]";
                        result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.longPowerWithSubscripts).setMessage(message));
                    }
                }
                case prefix: {
                    String idType = parts.getAttributeValue(-2, "type");
                    for (String shortUnitId : pathType.sampleComposedShortUnitIds.get((Object)idType)) {
                        String composedPattern;
                        UnitConverter.UnitId unitId = unitConverter.createUnitId(shortUnitId);
                        String width = parts.getAttributeValue(-3, "type");
                        String count = parts.getAttributeValue(-1, "count");
                        String caseVariant = parts.getAttributeValue(-1, "case");
                        CLDRFile cldrFile = this.getCldrFileToCheck();
                        String explicitPattern = UnitPathType.unit.getTrans(cldrFile, width, shortUnitId, count, caseVariant, null, null);
                        if (explicitPattern == null || (composedPattern = unitId.toString(cldrFile, width, count, caseVariant, null, false)) == null || explicitPattern.equals(composedPattern)) continue;
                        unitId.toString(cldrFile, width, count, caseVariant, null, false);
                        String MESSAGE = "Mismatched component: \u00ab{0}\u00bb produces \u00ab{1}\u00bb, but the explicit translation is \u00ab{2}\u00bb. See https://cldr.unicode.org/translation/units/unit-names-and-patterns#h.7kdholgw8hpx";
                        result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.mismatchedUnitComponent).setMessage("Mismatched component: \u00ab{0}\u00bb produces \u00ab{1}\u00bb, but the explicit translation is \u00ab{2}\u00bb. See https://cldr.unicode.org/translation/units/unit-names-and-patterns#h.7kdholgw8hpx", value, composedPattern, explicitPattern));
                    }
                    break;
                }
            }
        }
        if (pathType == UnitPathType.duration) {
            XPathParts xpp = parts;
            String durationUnitType = xpp.findAttributeValue("durationUnit", "type");
            boolean hasHourSymbol = HOUR_SYMBOL.matcher(value).find();
            boolean hasMinuteSymbol = MINUTE_SYMBOL.matcher(value).find();
            boolean hasSecondsSymbol = SECONDS_SYMBOL.matcher(value).find();
            if (durationUnitType.contains("h") && !hasHourSymbol) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidDurationUnitPattern).setMessage("The hour indicator should be either h or hh for duration."));
            } else if (durationUnitType.contains("m") && !hasMinuteSymbol) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidDurationUnitPattern).setMessage("The minutes symbol (m or mm) is missing."));
            } else if (durationUnitType.contains("s") && !hasSecondsSymbol) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidDurationUnitPattern).setMessage("The seconds symbol (ss) is missing."));
            }
        }
        return this;
    }
}

