/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class DiscreteComparator<T>
implements Comparator<T> {
    private static final boolean DEBUG = false;
    private static int debugIndent;
    private Map<T, Integer> ordering;
    private Comparator<T> backupOrdering;

    private DiscreteComparator(Map<T, Integer> ordering, Comparator<T> backupOrdering) {
        this.backupOrdering = backupOrdering;
        this.ordering = ordering;
    }

    @Override
    public int compare(T o1, T o2) {
        Integer a = this.ordering.get(o1);
        Integer b = this.ordering.get(o2);
        if (a == null || b != null) {
            // empty if block
        }
        if (a == null) {
            if (this.backupOrdering != null) {
                if (b == null) {
                    return this.backupOrdering.compare(o1, o2);
                }
                return 1;
            }
            throw new MissingItemException("Item not in ordering:\t" + o1);
        }
        if (b == null) {
            if (this.backupOrdering != null) {
                return -1;
            }
            throw new MissingItemException("Item not in ordering:\t" + o2);
        }
        return a.compareTo(b);
    }

    public List<T> getOrdering() {
        return new ArrayList<T>(this.ordering.keySet());
    }

    public String toString() {
        return this.ordering.keySet().toString();
    }

    public static class MissingItemException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public MissingItemException(String message) {
            super(message);
        }
    }

    public static class CycleException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public <T> CycleException(String message) {
            super(message);
        }

        public <T> CycleException(String message, Exception e) {
            super(message, e);
        }
    }

    private static class Node<T>
    implements Comparable<Node<T>> {
        private Set<Node<T>> less = new LinkedHashSet<Node<T>>();
        private T me;
        private boolean visited = false;
        private boolean chained = false;

        public Node(T a, Ordering order) {
            this.less = order == Ordering.CHRONOLOGICAL ? new LinkedHashSet<Node<T>>() : (order == Ordering.NATURAL ? new TreeSet() : new HashSet());
            this.me = a;
        }

        private void visit(Map<T, Integer> resultOrdering) {
            Node currentNode = this;
            currentNode.visited = true;
            currentNode.chained = true;
            for (Node<T> subNode : currentNode.less) {
                if (subNode.chained) {
                    throw new CycleException("Cycle in input data: " + subNode.toString());
                }
                if (subNode.visited) continue;
                subNode.visit(resultOrdering);
            }
            currentNode.chained = false;
            resultOrdering.put(currentNode.me, resultOrdering.size());
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.me == null ? null : this.me.toString()).append(" >");
            for (Node<T> lesser : this.less) {
                result.append(" ").append(lesser.me);
            }
            return result.toString();
        }

        @Override
        public int compareTo(Node<T> o) {
            return ((Comparable)this.me).compareTo(o.me);
        }
    }

    public static class Builder<T> {
        private Map<T, Node<T>> all;
        private Comparator<T> backupOrdering;
        private Ordering order;

        public Builder(Ordering order) {
            this.order = order;
            this.all = order == Ordering.CHRONOLOGICAL ? new LinkedHashMap<T, Node<T>>() : (order == Ordering.NATURAL ? new TreeMap() : new HashMap());
        }

        public Builder<T> setFallbackComparator(Comparator<T> backupOrdering) {
            this.backupOrdering = backupOrdering;
            return this;
        }

        public Builder<T> add(Collection<T> items) {
            if (items.size() < 2) {
                T item;
                if (items.size() == 1 && !this.all.containsKey(item = items.iterator().next())) {
                    this.addNew(item);
                }
                return this;
            }
            T last = null;
            boolean first = true;
            for (T item : items) {
                if (first) {
                    first = false;
                } else {
                    this.add(last, item);
                }
                last = item;
            }
            return this;
        }

        public Builder<T> add(T ... items) {
            T item;
            if (items.length < 2 && items.length == 1 && !this.all.containsKey(item = items[0])) {
                this.addNew(item);
            }
            T last = null;
            boolean first = true;
            for (T item2 : items) {
                if (first) {
                    first = false;
                } else {
                    this.add(last, item2);
                }
                last = item2;
            }
            return this;
        }

        public Builder<T> add(T a, T b) {
            Node<T> bNode;
            Node<T> aNode = this.all.get(a);
            if (aNode == null) {
                aNode = this.addNew(a);
            }
            if ((bNode = this.all.get(b)) == null) {
                bNode = this.addNew(b);
            }
            this.addLink(aNode, bNode);
            return this;
        }

        public DiscreteComparator<T> get() {
            LinkedHashMap ordering = new LinkedHashMap();
            for (Node node : this.all.values()) {
                if (node.visited) continue;
                try {
                    node.visit(ordering);
                }
                catch (CycleException e) {
                    throw new CycleException("\n\tcycle:" + this.getCycle() + "\n\tall:" + this.all + "\n\tordering:" + ordering, e);
                }
            }
            this.all.clear();
            return new DiscreteComparator(ordering, this.backupOrdering);
        }

        public List<T> getCycle() {
            LinkedList result = new LinkedList();
            Collection<Node<T>> lesser = this.all.values();
            block0: while (true) {
                for (Node<T> item : lesser) {
                    if (!item.chained) continue;
                    if (result.contains(item.me)) {
                        return result;
                    }
                    result.add(0, item.me);
                    lesser = item.less;
                    continue block0;
                }
                break;
            }
            throw new IllegalArgumentException("Must only be called after a CycleException");
        }

        public String toString() {
            return this.order + ":\t" + this.all.values().toString();
        }

        private void addLink(Node<T> aNode, Node<T> bNode) {
            bNode.less.add(aNode);
        }

        private Node<T> addNew(T a) {
            Node<T> aNode = new Node<T>(a, this.order);
            this.all.put(a, aNode);
            return aNode;
        }
    }

    public static enum Ordering {
        CHRONOLOGICAL,
        NATURAL,
        ARBITRARY;

    }
}

