/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.IterableComparator;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.impl.number.DecimalQuantity;
import com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Freezable;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.VersionInfo;
import java.io.File;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.unicode.cldr.test.CoverageLevel2;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.tool.SubdivisionNames;
import org.unicode.cldr.util.Builder;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DayPeriodInfo;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.GrammarDerivation;
import org.unicode.cldr.util.GrammarInfo;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.PluralRanges;
import org.unicode.cldr.util.PreferredAndAllowedHour;
import org.unicode.cldr.util.Rational;
import org.unicode.cldr.util.RegexLookup;
import org.unicode.cldr.util.SimpleXPathParts;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.UnitConverter;
import org.unicode.cldr.util.UnitPreferences;
import org.unicode.cldr.util.Validity;
import org.unicode.cldr.util.VoteResolver;
import org.unicode.cldr.util.With;
import org.unicode.cldr.util.XEquivalenceClass;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathValue;
import org.unicode.cldr.util.personname.PersonNameFormatter;

public class SupplementalDataInfo {
    private static final boolean DEBUG = false;
    private static final StandardCodes sc = StandardCodes.make();
    private static final String UNKNOWN_SCRIPT = "Zzzz";
    public static final Splitter split_space = Splitter.on(' ').omitEmptyStrings();
    public static final String STAR = "*";
    public static final Set<String> STAR_SET = Builder.with(new HashSet()).add("*").freeze();
    private VersionInfo cldrVersion;
    private String cldrVersionString = null;
    private String unicodeVersion = null;
    private Map<String, PopulationData> territoryToPopulationData = new TreeMap<String, PopulationData>();
    private Map<String, Map<String, PopulationData>> territoryToLanguageToPopulationData = new TreeMap<String, Map<String, PopulationData>>();
    private Map<String, PopulationData> languageToPopulation = new TreeMap<String, PopulationData>();
    private Map<String, PopulationData> baseLanguageToPopulation = new TreeMap<String, PopulationData>();
    private Relation<String, String> languageToScriptVariants = Relation.of(new TreeMap(), TreeSet.class);
    private Relation<String, String> languageToTerritories = Relation.of(new TreeMap(), LinkedHashSet.class);
    private transient Relation<String, Pair<Boolean, Pair<Double, String>>> languageToTerritories2 = Relation.of(new TreeMap(), TreeSet.class);
    private Map<String, Map<BasicLanguageData.Type, BasicLanguageData>> languageToBasicLanguageData = new TreeMap<String, Map<BasicLanguageData.Type, BasicLanguageData>>();
    private Set<String> allLanguages = new TreeSet<String>();
    private final List<String> approvalRequirements = new LinkedList<String>();
    private Relation<String, String> containment = Relation.of(new LinkedHashMap(), LinkedHashSet.class);
    private Relation<String, String> containmentCore = Relation.of(new LinkedHashMap(), LinkedHashSet.class);
    private Relation<String, String> containmentGrouping = Relation.of(new LinkedHashMap(), LinkedHashSet.class);
    private Relation<String, String> containmentDeprecated = Relation.of(new LinkedHashMap(), LinkedHashSet.class);
    private Relation<String, String> containerToSubdivision = Relation.of(new LinkedHashMap(), LinkedHashSet.class);
    private Map<String, CurrencyNumberInfo> currencyToCurrencyNumberInfo = new TreeMap<String, CurrencyNumberInfo>();
    private Relation<String, CurrencyDateInfo> territoryToCurrencyDateInfo = Relation.of(new TreeMap(), LinkedHashSet.class);
    private Map<String, Set<TelephoneCodeInfo>> territoryToTelephoneCodeInfo = new TreeMap<String, Set<TelephoneCodeInfo>>();
    private Map<String, String> zone_territory = new TreeMap<String, String>();
    private Relation<String, String> zone_aliases = Relation.of(new TreeMap(), LinkedHashSet.class);
    private Map<String, Map<String, Map<String, String>>> typeToZoneToRegionToZone = new TreeMap<String, Map<String, Map<String, String>>>();
    private Relation<String, MetaZoneRange> zoneToMetaZoneRanges = Relation.of(new TreeMap(), TreeSet.class);
    private Map<String, String> metazoneContinentMap = new HashMap<String, String>();
    private Set<String> allMetazones = new TreeSet<String>();
    private Map<String, String> alias_zone = new TreeMap<String, String>();
    public Relation<String, Integer> numericTerritoryMapping = Relation.of(new HashMap(), HashSet.class);
    public Relation<String, String> alpha3TerritoryMapping = Relation.of(new HashMap(), HashSet.class);
    public Relation<String, Integer> numericCurrencyCodeMapping = Relation.of(new HashMap(), HashSet.class);
    static Map<String, SupplementalDataInfo> directory_instance = new HashMap<String, SupplementalDataInfo>();
    public Map<String, Map<String, Row.R2<List<String>, String>>> typeToTagToReplacement = new TreeMap<String, Map<String, Row.R2<List<String>, String>>>();
    Map<String, List<Row.R4<String, String, Integer, Boolean>>> languageMatch = new HashMap<String, List<Row.R4<String, String, Integer, Boolean>>>();
    public Relation<String, String> bcp47Key2Subtypes = Relation.of(new TreeMap(), TreeSet.class);
    public Relation<String, String> bcp47Extension2Keys = Relation.of(new TreeMap(), TreeSet.class);
    public Relation<Row.R2<String, String>, String> bcp47Aliases = Relation.of(new TreeMap(), LinkedHashSet.class);
    public Map<Row.R2<String, String>, String> bcp47Descriptions = new TreeMap<Row.R2<String, String>, String>();
    public Map<Row.R2<String, String>, String> bcp47Since = new TreeMap<Row.R2<String, String>, String>();
    public Map<Row.R2<String, String>, String> bcp47Preferred = new TreeMap<Row.R2<String, String>, String>();
    public Map<Row.R2<String, String>, String> bcp47Deprecated = new TreeMap<Row.R2<String, String>, String>();
    Map<String, Map<String, Bcp47KeyInfo>> bcp47KeyToSubtypeToInfo = new TreeMap<String, Map<String, Bcp47KeyInfo>>();
    Map<String, Map<String, String>> bcp47KeyToAliasToSubtype = new TreeMap<String, Map<String, String>>();
    public Map<String, String> bcp47ValueType = new TreeMap<String, String>();
    public Map<String, Row.R2<String, String>> validityInfo = new LinkedHashMap<String, Row.R2<String, String>>();
    public Map<AttributeValidityInfo, String> attributeValidityInfo = new LinkedHashMap<AttributeValidityInfo, String>();
    public Multimap<String, String> languageGroups = TreeMultimap.create();
    public Rational.RationalParser rationalParser = new Rational.RationalParser();
    private UnitConverter unitConverter = null;
    private final UnitPreferences unitPreferences = new UnitPreferences();
    private Map<String, UnitIdComponentType> unitIdComponentType = new TreeMap<String, UnitIdComponentType>();
    private Map<String, UnitPrefixInfo> unitPrefixInfo = new TreeMap<String, UnitPrefixInfo>();
    public Map<String, GrammarInfo> grammarLocaleToTargetToFeatureToValues = new TreeMap<String, GrammarInfo>();
    public Map<String, GrammarDerivation> localeToGrammarDerivation = new TreeMap<String, GrammarDerivation>();
    public Multimap<PersonNameFormatter.Order, String> personNameOrder = TreeMultimap.create();
    Map<MeasurementType, Map<String, String>> measurementData = new HashMap<MeasurementType, Map<String, String>>();
    Map<String, PreferredAndAllowedHour> timeData = new HashMap<String, PreferredAndAllowedHour>();
    private final File directory;
    private Validity validity;
    Set<String> skippedElements = new TreeSet<String>();
    private Map<String, Pair<String, String>> references = new TreeMap<String, Pair<String, String>>();
    private Map<String, String> likelySubtags = new TreeMap<String, String>();
    private Map<String, String> likelyOrigins = new TreeMap<String, String>();
    private Set<CoverageLevelInfo> coverageLevels = new LinkedHashSet<CoverageLevelInfo>();
    private Map<ParentLocaleComponent, Map<String, String>> parentLocales = new HashMap<ParentLocaleComponent, Map<String, String>>();
    private Set<ParentLocaleComponent> parentLocalesSkipNonLikely;
    private Map<String, List<String>> calendarPreferences;
    private Map<String, CoverageVariableInfo> localeSpecificVariables;
    private CldrUtility.VariableReplacer coverageVariables;
    private Map<String, NumberingSystemInfo> numberingSystems;
    private Set<String> numericSystems;
    private Set<String> defaultContentLocales;
    public Map<CLDRLocale, CLDRLocale> baseToDefaultContent;
    public Map<CLDRLocale, CLDRLocale> defaultContentToBase;
    private Set<String> CLDRLanguageCodes;
    private Set<String> languageNonTcLtBasic;
    private Set<String> CLDRScriptCodes;
    private RegexLookup<Level> coverageLookup;
    private static Map<String, BasicLanguageData> languageToScriptsAndRegions = null;
    volatile List<ApprovalRequirementMatcher> approvalMatchers;
    private EnumMap<PluralType, Map<String, PluralInfo>> localeToPluralInfo2;
    private Map<String, PluralRanges> localeToPluralRanges;
    private Map<DayPeriodInfo.Type, Map<String, DayPeriodInfo>> typeToLocaleToDayPeriodInfo;
    private Map<String, CoverageLevel2> localeToCoverageLevelInfo;
    private CoverageCache coverageCache;
    private transient String lastPluralLocales;
    private transient PluralType lastPluralWasOrdinal;
    private transient Map<PluralInfo.Count, String> lastPluralMap;
    private transient String lastDayPeriodLocales;
    private transient DayPeriodInfo.Type lastDayPeriodType;
    private transient DayPeriodInfo.Builder dayPeriodBuilder;
    static Pattern PARSE_TIME = PatternCache.get("(\\d\\d?):(\\d\\d)");
    static String lastPluralRangesLocales = null;
    static PluralRanges lastPluralRanges = null;
    private static CurrencyNumberInfo DEFAULT_NUMBER_INFO = new CurrencyNumberInfo(2, -1, -1, -1);
    private List<String> serialElements;
    private Collection<String> distinguishingAttributes;
    static Set<String> MainTimeZones;
    private XEquivalenceClass<String, String> equivalentLocales;
    public static final LengthFirstComparator LENGTH_FIRST;
    public static final Splitter WHITESPACE_SPLITTER;
    Supplier<Set<String>> goodTimezones;

    public Relation<String, String> getAlpha3TerritoryMapping() {
        return this.alpha3TerritoryMapping;
    }

    public Relation<String, Integer> getNumericTerritoryMapping() {
        return this.numericTerritoryMapping;
    }

    public Relation<String, Integer> getNumericCurrencyCodeMapping() {
        return this.numericCurrencyCodeMapping;
    }

    public Map<String, Map<String, Row.R2<List<String>, String>>> getLocaleAliasInfo() {
        return this.typeToTagToReplacement;
    }

    public Row.R2<List<String>, String> getDeprecatedInfo(String type, String code) {
        return this.typeToTagToReplacement.get(type).get(code);
    }

    public static SupplementalDataInfo getInstance(File supplementalDirectory) {
        return SupplementalDataInfo.getInstance(PathUtilities.getNormalizedPathString(supplementalDirectory));
    }

    public static SupplementalDataInfo getInstance() {
        return SupplementalDataInfoHelper.SINGLETON;
    }

    public void setAsDefaultInstance() {
        SupplementalDataInfoHelper.SINGLETON = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SupplementalDataInfo getInstance(String supplementalDirectory) {
        Class<SupplementalDataInfo> clazz = SupplementalDataInfo.class;
        synchronized (SupplementalDataInfo.class) {
            if (supplementalDirectory == null) {
                throw new IllegalArgumentException("Error: null supplemental directory.");
            }
            if (supplementalDirectory.isEmpty()) {
                throw new IllegalArgumentException("Error: The string passed as a parameter resolves to the empty string.");
            }
            String normalizedPath = PathUtilities.getNormalizedPathString(supplementalDirectory, new String[0]);
            SupplementalDataInfo instance = directory_instance.get(normalizedPath);
            if (instance != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return instance;
            }
            File directory = new File(normalizedPath);
            instance = new SupplementalDataInfo(directory);
            MyHandler myHandler = instance.new MyHandler();
            XMLFileReader xfr = new XMLFileReader().setHandler(myHandler);
            File[] files1 = directory.listFiles();
            if (files1 == null || files1.length == 0) {
                throw new ICUUncheckedIOException("Error: Supplemental files missing from " + directory.getAbsolutePath());
            }
            File bcp47dir = instance.getBcp47Directory();
            if (!bcp47dir.isDirectory()) {
                throw new ICUUncheckedIOException("Error: BCP47 dir is not a directory: " + bcp47dir.getAbsolutePath());
            }
            File[] files2 = bcp47dir.listFiles();
            if (files2 == null || files2.length == 0) {
                throw new ICUUncheckedIOException("Error: BCP47 files missing from " + bcp47dir.getAbsolutePath());
            }
            Builder.CBuilder<File, ArrayList<File>> builder = Builder.with(new ArrayList());
            builder.addAll(files1);
            builder.addAll(files2);
            for (File file : builder.get()) {
                String name = file.toString();
                String shortName = file.getName();
                if (!shortName.endsWith(".xml") || shortName.startsWith("#") || shortName.startsWith(".")) continue;
                xfr.read(name, -1, true);
                myHandler.cleanup();
            }
            instance.makeStuffSafe();
            directory_instance.put(normalizedPath, instance);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private File getBcp47Directory() {
        return new File(this.getDirectory().getParent(), "bcp47");
    }

    private SupplementalDataInfo(File directory) {
        Arrays.stream(ParentLocaleComponent.values()).forEach(x -> this.parentLocales.put((ParentLocaleComponent)((Object)x), new HashMap()));
        this.parentLocalesSkipNonLikely = EnumSet.noneOf(ParentLocaleComponent.class);
        this.calendarPreferences = new HashMap<String, List<String>>();
        this.localeSpecificVariables = new TreeMap<String, CoverageVariableInfo>();
        this.coverageVariables = new CldrUtility.VariableReplacer();
        this.numberingSystems = new HashMap<String, NumberingSystemInfo>();
        this.numericSystems = new TreeSet<String>();
        this.CLDRLanguageCodes = new TreeSet<String>();
        this.languageNonTcLtBasic = new TreeSet<String>();
        this.coverageLookup = null;
        this.approvalMatchers = null;
        this.localeToPluralInfo2 = new EnumMap(PluralType.class);
        this.localeToPluralInfo2.put(PluralType.cardinal, new LinkedHashMap());
        this.localeToPluralInfo2.put(PluralType.ordinal, new LinkedHashMap());
        this.localeToPluralRanges = new LinkedHashMap<String, PluralRanges>();
        this.typeToLocaleToDayPeriodInfo = new EnumMap<DayPeriodInfo.Type, Map<String, DayPeriodInfo>>(DayPeriodInfo.Type.class);
        this.localeToCoverageLevelInfo = new ConcurrentHashMap<String, CoverageLevel2>();
        this.coverageCache = new CoverageCache();
        this.lastPluralLocales = "";
        this.lastPluralWasOrdinal = null;
        this.lastPluralMap = new EnumMap<PluralInfo.Count, String>(PluralInfo.Count.class);
        this.lastDayPeriodLocales = null;
        this.lastDayPeriodType = null;
        this.dayPeriodBuilder = new DayPeriodInfo.Builder();
        this.equivalentLocales = null;
        this.goodTimezones = Suppliers.memoize(new Supplier<Set<String>>(){

            @Override
            public Set<String> get() {
                Set<String> availableLongTz = sc.getAvailableCodes(StandardCodes.CodeType.tzid);
                Set<String> result = null;
                Set<String> hack = Set.of("America/Santa_Isabel", "Australia/Currie", "America/Yellowknife", "America/Rainy_River", "America/Thunder_Bay", "America/Nipigon", "America/Pangnirtung", "Europe/Uzhgorod", "Europe/Zaporozhye", "Pacific/Johnston");
                result = Set.copyOf(Sets.difference(availableLongTz, hack));
                return result;
            }

            private static /* synthetic */ boolean lambda$get$0(Map aliasToRegular, Map subtypeToInfo, String x) {
                String shortId = (String)aliasToRegular.get(x);
                Bcp47KeyInfo info = (Bcp47KeyInfo)subtypeToInfo.get(shortId);
                System.out.println(String.format("%s %s %s", x, shortId, info));
                return !info.deprecated;
            }
        });
        this.directory = directory;
        this.validity = Validity.getInstance(directory.toString() + "/../validity/");
    }

    private void makeStuffSafe() {
        this.allLanguages.addAll(this.languageToPopulation.keySet());
        this.allLanguages.addAll(this.baseLanguageToPopulation.keySet());
        this.allLanguages = Collections.unmodifiableSet(this.allLanguages);
        this.skippedElements = Collections.unmodifiableSet(this.skippedElements);
        this.zone_territory = Collections.unmodifiableMap(this.zone_territory);
        this.alias_zone = Collections.unmodifiableMap(this.alias_zone);
        this.references = Collections.unmodifiableMap(this.references);
        this.likelySubtags = Collections.unmodifiableMap(this.likelySubtags);
        this.likelyOrigins = Collections.unmodifiableMap(this.likelyOrigins);
        this.currencyToCurrencyNumberInfo = Collections.unmodifiableMap(this.currencyToCurrencyNumberInfo);
        this.territoryToCurrencyDateInfo.freeze();
        this.territoryToTelephoneCodeInfo = Collections.unmodifiableMap(this.territoryToTelephoneCodeInfo);
        this.typeToZoneToRegionToZone = CldrUtility.protectCollection(this.typeToZoneToRegionToZone);
        this.typeToTagToReplacement = CldrUtility.protectCollection(this.typeToTagToReplacement);
        this.zoneToMetaZoneRanges.freeze();
        this.containment.freeze();
        this.containmentCore.freeze();
        this.containmentGrouping.freeze();
        this.containmentDeprecated.freeze();
        this.containerToSubdivision.freeze();
        CldrUtility.protectCollection(this.languageToBasicLanguageData);
        for (String string : this.languageToTerritories2.keySet()) {
            for (Pair<Boolean, Pair<Double, String>> pair : this.languageToTerritories2.getAll(string)) {
                this.languageToTerritories.put(string, pair.getSecond().getSecond());
            }
        }
        this.languageToTerritories2 = null;
        this.languageToTerritories.freeze();
        this.zone_aliases.freeze();
        this.languageToScriptVariants.freeze();
        this.numericTerritoryMapping.freeze();
        this.alpha3TerritoryMapping.freeze();
        this.numericCurrencyCodeMapping.freeze();
        for (String string : this.languageToPopulation.keySet()) {
            this.languageToPopulation.get(string).freeze();
        }
        for (String string : this.baseLanguageToPopulation.keySet()) {
            this.baseLanguageToPopulation.get(string).freeze();
        }
        for (String string : this.territoryToPopulationData.keySet()) {
            this.territoryToPopulationData.get(string).freeze();
        }
        for (String string : this.territoryToLanguageToPopulationData.keySet()) {
            Map<String, PopulationData> languageToPopulationDataTemp = this.territoryToLanguageToPopulationData.get(string);
            for (String language : languageToPopulationDataTemp.keySet()) {
                languageToPopulationDataTemp.get(language).freeze();
            }
        }
        this.localeToPluralInfo2.put(PluralType.cardinal, Collections.unmodifiableMap(this.localeToPluralInfo2.get((Object)PluralType.cardinal)));
        this.localeToPluralInfo2.put(PluralType.ordinal, Collections.unmodifiableMap(this.localeToPluralInfo2.get((Object)PluralType.ordinal)));
        this.localeToPluralRanges = Collections.unmodifiableMap(this.localeToPluralRanges);
        for (PluralRanges pluralRanges : this.localeToPluralRanges.values()) {
            pluralRanges.freeze();
        }
        if (this.lastDayPeriodLocales != null) {
            this.addDayPeriodInfo();
        }
        this.typeToLocaleToDayPeriodInfo = CldrUtility.protectCollection(this.typeToLocaleToDayPeriodInfo);
        this.languageMatch = CldrUtility.protectCollection(this.languageMatch);
        this.bcp47Extension2Keys.freeze();
        this.bcp47Key2Subtypes.freeze();
        CldrUtility.protectCollection(this.bcp47ValueType);
        if (this.bcp47Key2Subtypes.isEmpty()) {
            throw new InternalError("No BCP47 key 2 subtype data was loaded from bcp47 dir " + this.getBcp47Directory().getAbsolutePath());
        }
        this.bcp47Aliases.freeze();
        CldrUtility.protectCollection(this.bcp47Descriptions);
        CldrUtility.protectCollection(this.bcp47Since);
        CldrUtility.protectCollection(this.bcp47Preferred);
        CldrUtility.protectCollection(this.bcp47Deprecated);
        for (Map.Entry entry : this.bcp47Extension2Keys.keyValuesSet()) {
            for (String string : (Set)entry.getValue()) {
                Map<String, String> aliasToRegular;
                Map<String, Bcp47KeyInfo> subtypeToInfo = this.bcp47KeyToSubtypeToInfo.get(string);
                if (subtypeToInfo == null) {
                    subtypeToInfo = new TreeMap<String, Bcp47KeyInfo>();
                    this.bcp47KeyToSubtypeToInfo.put(string, subtypeToInfo);
                }
                if ((aliasToRegular = this.bcp47KeyToAliasToSubtype.get(string)) == null) {
                    aliasToRegular = new TreeMap<String, String>();
                    this.bcp47KeyToAliasToSubtype.put(string, aliasToRegular);
                }
                for (String subtype : this.bcp47Key2Subtypes.get(string)) {
                    Row.R2<String, String> pair = Row.R2.of(string, subtype);
                    Set<String> aliases = this.bcp47Aliases.get(pair);
                    Bcp47KeyInfo info = new Bcp47KeyInfo(aliases, this.bcp47Descriptions.get(pair), this.bcp47Since.get(pair), this.bcp47Preferred.get(pair), this.bcp47Deprecated.get(pair));
                    subtypeToInfo.put(subtype, info);
                    Map<String, String> aliasToRegularFinal = aliasToRegular;
                    if (aliases == null) continue;
                    aliases.forEach(x -> aliasToRegularFinal.put((String)x, subtype));
                }
            }
        }
        this.bcp47KeyToSubtypeToInfo = CldrUtility.protectCollection(this.bcp47KeyToSubtypeToInfo);
        this.bcp47KeyToAliasToSubtype = CldrUtility.protectCollection(this.bcp47KeyToAliasToSubtype);
        CoverageLevelInfo.fixEU(this.coverageLevels, this);
        this.coverageLevels = CldrUtility.protectCollection(this.coverageLevels);
        this.measurementData = CldrUtility.protectCollection(this.measurementData);
        Map<String, Row.R2<List<String>, String>> unitAliases = this.typeToTagToReplacement.get("unit");
        if (unitAliases != null) {
            this.unitConverter.addAliases(unitAliases);
        }
        this.unitConverter.freeze(new File(this.directory, "../validity").toString());
        this.rationalParser.freeze();
        this.unitPreferences.freeze();
        this.unitIdComponentType = CldrUtility.protectCollection(this.unitIdComponentType);
        this.unitPrefixInfo = CldrUtility.protectCollection(this.unitPrefixInfo);
        this.timeData = CldrUtility.protectCollection(this.timeData);
        this.validityInfo = CldrUtility.protectCollection(this.validityInfo);
        this.attributeValidityInfo = CldrUtility.protectCollection(this.attributeValidityInfo);
        this.parentLocales = CldrUtility.protectCollection(this.parentLocales);
        this.parentLocalesSkipNonLikely = ImmutableSet.copyOf(this.parentLocalesSkipNonLikely);
        this.languageGroups = ImmutableSetMultimap.copyOf(this.languageGroups);
        this.grammarLocaleToTargetToFeatureToValues = CldrUtility.protectCollection(this.grammarLocaleToTargetToFeatureToValues);
        this.localeToGrammarDerivation = CldrUtility.protectCollection(this.localeToGrammarDerivation);
        this.personNameOrder = CldrUtility.protectCollection(this.personNameOrder);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Map<Validity.Status, Set<String>> scripts = Validity.getInstance().getStatusToCodes(StandardCodes.LstrType.script);
        for (Map.Entry<Validity.Status, Set<String>> e : scripts.entrySet()) {
            switch (e.getKey()) {
                case regular: 
                case special: 
                case unknown: {
                    builder.addAll(e.getValue());
                    break;
                }
            }
        }
        this.CLDRScriptCodes = builder.build();
        this.CLDRLanguageCodes = CldrUtility.protectCollection(this.CLDRLanguageCodes);
        this.languageNonTcLtBasic = CldrUtility.protectCollection(this.languageNonTcLtBasic);
    }

    public static String toRegexString(Set<String> s2) {
        Iterator<String> it = s2.iterator();
        StringBuilder sb = new StringBuilder("(");
        int count = 0;
        while (it.hasNext()) {
            if (count > 0) {
                sb.append("|");
            }
            sb.append(it.next());
            ++count;
        }
        sb.append(")");
        return sb.toString();
    }

    public int parseIntegerOrNull(String attributeValue) {
        return attributeValue == null ? -1 : Integer.parseInt(attributeValue);
    }

    public PopulationData getLanguagePopulationData(String language) {
        return this.languageToPopulation.get(language);
    }

    public PopulationData getBaseLanguagePopulationData(String language) {
        return this.baseLanguageToPopulation.get(language);
    }

    public Set<String> getLanguages() {
        return this.allLanguages;
    }

    public Set<String> getTerritoryToLanguages(String territory) {
        Map<String, PopulationData> result = this.territoryToLanguageToPopulationData.get(territory);
        if (result == null) {
            return Collections.emptySet();
        }
        return result.keySet();
    }

    public PopulationData getLanguageAndTerritoryPopulationData(String language, String territory) {
        Map<String, PopulationData> result = this.territoryToLanguageToPopulationData.get(territory);
        if (result == null) {
            return null;
        }
        return result.get(language);
    }

    public Set<String> getTerritoriesWithPopulationData() {
        return this.territoryToLanguageToPopulationData.keySet();
    }

    public Set<String> getLanguagesForTerritoryWithPopulationData(String territory) {
        Map<String, PopulationData> languageToPopulationMap = this.territoryToLanguageToPopulationData.get(territory);
        return languageToPopulationMap == null ? Collections.emptySet() : languageToPopulationMap.keySet();
    }

    public Set<BasicLanguageData> getBasicLanguageData(String language) {
        Map<BasicLanguageData.Type, BasicLanguageData> map = this.languageToBasicLanguageData.get(language);
        if (map == null) {
            throw new IllegalArgumentException("Bad language code: " + language);
        }
        return new LinkedHashSet<BasicLanguageData>(map.values());
    }

    public Map<BasicLanguageData.Type, BasicLanguageData> getBasicLanguageDataMap(String language) {
        return this.languageToBasicLanguageData.get(language);
    }

    public Set<String> getBasicLanguageDataLanguages() {
        return this.languageToBasicLanguageData.keySet();
    }

    public Relation<String, String> getContainmentCore() {
        return this.containmentCore;
    }

    public Set<String> getContained(String territoryCode) {
        return this.containment.getAll(territoryCode);
    }

    public Set<String> getContainers() {
        return this.containment.keySet();
    }

    public Set<String> getContainedSubdivisions(String territoryOrSubdivisionCode) {
        return this.containerToSubdivision.getAll(territoryOrSubdivisionCode);
    }

    public Set<String> getContainersForSubdivisions() {
        return this.containerToSubdivision.keySet();
    }

    public Relation<String, String> getTerritoryToContained() {
        return this.getTerritoryToContained(ContainmentStyle.all);
    }

    public Relation<String, String> getTerritoryToContained(ContainmentStyle containmentStyle) {
        switch (containmentStyle) {
            case all: {
                return this.containment;
            }
            case core: {
                return this.containmentCore;
            }
            case grouping: {
                return this.containmentGrouping;
            }
            case deprecated: {
                return this.containmentDeprecated;
            }
        }
        throw new IllegalArgumentException("internal error");
    }

    public Set<String> getSkippedElements() {
        return this.skippedElements;
    }

    public Set<String> getZone_aliases(String zone) {
        Set<String> result = this.zone_aliases.getAll(zone);
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    public String getZone_territory(String zone) {
        return this.zone_territory.get(zone);
    }

    public Set<String> getCanonicalZones() {
        return this.zone_territory.keySet();
    }

    public Set<String> getTerritoriesForPopulationData(String language) {
        return this.languageToTerritories.getAll(language);
    }

    public Set<String> getLanguagesForTerritoriesPopulationData() {
        return this.languageToTerritories.keySet();
    }

    public Set<String> getDefaultContentLocales() {
        return this.defaultContentLocales;
    }

    public static Map<String, String> makeLocaleToDefaultContents(Set<String> defaultContents, Map<String, String> result, Set<String> errors) {
        for (String s2 : defaultContents) {
            String simpleParent = LanguageTagParser.getSimpleParent(s2);
            String oldValue = result.get(simpleParent);
            if (oldValue != null) {
                errors.add("*** Error: Default contents cannot contain two children for the same parent:\t" + oldValue + ", " + s2 + "; keeping " + oldValue);
                continue;
            }
            result.put(simpleParent, s2);
        }
        return result;
    }

    public Set<CLDRLocale> getDefaultContentCLDRLocales() {
        this.initCLDRLocaleBasedData();
        return this.defaultContentToBase.keySet();
    }

    public String getDefaultContentLocale(String locale) {
        CLDRLocale cLocale = CLDRLocale.getInstance(locale);
        for (String dc : this.defaultContentLocales) {
            if (CLDRLocale.getInstance(dc).getParent() != cLocale) continue;
            return dc;
        }
        return null;
    }

    public String getDefaultContentLocale(String language, String script) {
        if (script == null) {
            return this.getDefaultContentLocale(language);
        }
        for (String dc : this.defaultContentLocales) {
            if (!dc.startsWith(language + "_" + script + "_")) continue;
            return dc;
        }
        return null;
    }

    public CLDRLocale getBaseFromDefaultContent(CLDRLocale dcLocale) {
        this.initCLDRLocaleBasedData();
        return this.defaultContentToBase.get(dcLocale);
    }

    public CLDRLocale getDefaultContentFromBase(CLDRLocale baseLocale) {
        this.initCLDRLocaleBasedData();
        return this.baseToDefaultContent.get(baseLocale);
    }

    public boolean isDefaultContent(CLDRLocale dcLocale) {
        this.initCLDRLocaleBasedData();
        if (dcLocale == null) {
            throw new NullPointerException("null locale");
        }
        return this.defaultContentToBase.get(dcLocale) != null;
    }

    public Set<String> getNumberingSystems() {
        return this.numberingSystems.keySet();
    }

    public Set<String> getNumericNumberingSystems() {
        return Collections.unmodifiableSet(this.numericSystems);
    }

    public String getDigits(String numberingSystem) {
        try {
            return this.numberingSystems.get((Object)numberingSystem).digits;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't get digits for:" + numberingSystem);
        }
    }

    public NumberingSystemInfo.NumberingSystemType getNumberingSystemType(String numberingSystem) {
        return this.numberingSystems.get((Object)numberingSystem).type;
    }

    public Set<CoverageLevelInfo> getCoverageLevelInfo() {
        return this.coverageLevels;
    }

    public Level getCoverageLevel(String xpath, String loc) {
        Level result = null;
        result = this.coverageCache.get(xpath, loc);
        if (result == null) {
            CoverageLevel2 cov = this.localeToCoverageLevelInfo.get(loc);
            if (cov == null) {
                cov = CoverageLevel2.getInstance(this, loc);
                this.localeToCoverageLevelInfo.put(loc, cov);
            }
            result = cov.getLevel(xpath);
            this.coverageCache.put(xpath, loc, result);
        }
        return result;
    }

    public int getCoverageValue(String xpath, String loc) {
        return this.getCoverageLevel(xpath, loc).getLevel();
    }

    public synchronized RegexLookup<Level> getCoverageLookup() {
        if (this.coverageLookup == null) {
            RegexLookup<Level> lookup = new RegexLookup<Level>(RegexLookup.LookupType.STAR_PATTERN_LOOKUP);
            Matcher variable = PatternCache.get("\\$\\{[A-Za-z][\\-A-Za-z]*\\}").matcher("");
            for (CoverageLevelInfo ci : this.getCoverageLevelInfo()) {
                Object pattern = ci.match.replace('\'', '\"').replace("[@", "\\[@").replace("(", "(?:").replace("(?:?!", "(?!");
                pattern = "^//ldml/" + (String)pattern + "$";
                String variableType = null;
                variable.reset((CharSequence)pattern);
                if (variable.find()) {
                    pattern = ((String)pattern).substring(0, variable.start()) + "([^\"]*)" + ((String)pattern).substring(variable.end());
                    variableType = variable.group();
                    if (variable.find()) {
                        throw new IllegalArgumentException("We can only handle a single variable on a line");
                    }
                }
                lookup.add(new CoverageLevel2.MyRegexFinder((String)pattern, variableType, ci), ci.value);
            }
            this.coverageLookup = lookup;
        }
        return this.coverageLookup;
    }

    public int getCoverageValueOld(String xpath, ULocale loc) {
        String targetLanguage = loc.getLanguage();
        CoverageVariableInfo cvi = this.getCoverageVariableInfo(targetLanguage);
        String targetScriptString = SupplementalDataInfo.toRegexString(cvi.targetScripts);
        String targetTerritoryString = SupplementalDataInfo.toRegexString(cvi.targetTerritories);
        String calendarListString = SupplementalDataInfo.toRegexString(cvi.calendars);
        String targetCurrencyString = SupplementalDataInfo.toRegexString(cvi.targetCurrencies);
        String targetTimeZoneString = SupplementalDataInfo.toRegexString(cvi.targetTimeZones);
        String targetPluralsString = SupplementalDataInfo.toRegexString(cvi.targetPlurals);
        for (CoverageLevelInfo ci : this.coverageLevels) {
            String regex = "//ldml/" + ci.match.replace('\'', '\"').replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]").replace("${Target-Language}", targetLanguage).replace("${Target-Scripts}", targetScriptString).replace("${Target-Territories}", targetTerritoryString).replace("${Target-TimeZones}", targetTimeZoneString).replace("${Target-Currencies}", targetCurrencyString).replace("${Target-Plurals}", targetPluralsString).replace("${Calendar-List}", calendarListString);
            if (ci.inTerritory != null) {
                if (ci.inTerritory.equals("EU")) {
                    HashSet<String> containedTerritories = new HashSet<String>();
                    containedTerritories.addAll(this.getContained(ci.inTerritory));
                    containedTerritories.retainAll(cvi.targetTerritories);
                    if (containedTerritories.isEmpty()) {
                        continue;
                    }
                } else if (!cvi.targetTerritories.contains(ci.inTerritory)) continue;
            }
            if (ci.inLanguage != null && !ci.inLanguage.matcher(targetLanguage).matches() || ci.inScript != null && !cvi.targetScripts.contains(ci.inScript)) continue;
            if (xpath.matches(regex)) {
                return ci.value.getLevel();
            }
            if (!xpath.matches(regex)) continue;
            return ci.value.getLevel();
        }
        return Level.OPTIONAL.getLevel();
    }

    private Map<String, BasicLanguageData> doMapLanguagesToScriptsRegion() {
        TreeMap<String, BasicLanguageData> langToScriptsRegions = new TreeMap<String, BasicLanguageData>();
        Factory factory = CLDRConfig.getInstance().getCldrFactory();
        for (CLDRLocale locale : factory.getAvailableCLDRLocales()) {
            String region;
            String script;
            String language = locale.getLanguage();
            if (language.length() == 0 || language.equals("root")) continue;
            BasicLanguageData scriptsAndRegions = (BasicLanguageData)langToScriptsRegions.get(language);
            if (scriptsAndRegions == null) {
                scriptsAndRegions = new BasicLanguageData();
                langToScriptsRegions.put(language, scriptsAndRegions);
            }
            if ((script = locale.getScript()).length() > 0) {
                scriptsAndRegions.addScript(script, 0);
            }
            if ((region = locale.getCountry()).length() <= 0 || region.length() >= 3) continue;
            scriptsAndRegions.addTerritory(region);
        }
        for (String language : langToScriptsRegions.keySet()) {
            BasicLanguageData scriptsAndRegions = (BasicLanguageData)langToScriptsRegions.get(language);
            langToScriptsRegions.put(language, scriptsAndRegions.freeze());
        }
        return Collections.unmodifiableMap(langToScriptsRegions);
    }

    private synchronized Map<String, BasicLanguageData> getLanguageToScriptsAndRegions() {
        if (languageToScriptsAndRegions == null) {
            languageToScriptsAndRegions = this.doMapLanguagesToScriptsRegion();
        }
        return languageToScriptsAndRegions;
    }

    public CoverageVariableInfo getCoverageVariableInfo(String targetLanguage) {
        CoverageVariableInfo cvi;
        if (this.localeSpecificVariables.containsKey(targetLanguage)) {
            cvi = this.localeSpecificVariables.get(targetLanguage);
        } else {
            cvi = new CoverageVariableInfo();
            cvi.targetScripts = this.getTargetScripts(targetLanguage);
            cvi.targetTerritories = this.getTargetTerritories(targetLanguage);
            cvi.calendars = this.getCalendars(cvi.targetTerritories);
            cvi.targetCurrencies = this.getCurrentCurrencies(cvi.targetTerritories);
            cvi.targetTimeZones = this.getCurrentTimeZones(cvi.targetTerritories);
            cvi.targetPlurals = this.getTargetPlurals(targetLanguage);
            this.localeSpecificVariables.put(targetLanguage, cvi);
        }
        return cvi;
    }

    private Set<String> getTargetScripts(String language) {
        HashSet<String> targetScripts = new HashSet<String>();
        try {
            BasicLanguageData scriptsAndRegions;
            Set<BasicLanguageData> langData = this.getBasicLanguageData(language);
            for (BasicLanguageData bl : langData) {
                Set<String> addScripts = bl.scripts;
                if (addScripts == null || bl.getType() == BasicLanguageData.Type.secondary) continue;
                targetScripts.addAll(addScripts);
            }
            Map<String, BasicLanguageData> languageToScriptsAndRegions = this.getLanguageToScriptsAndRegions();
            if (languageToScriptsAndRegions != null && (scriptsAndRegions = languageToScriptsAndRegions.get(language)) != null) {
                targetScripts.addAll(scriptsAndRegions.getScripts());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (targetScripts.size() == 0) {
            targetScripts.add(UNKNOWN_SCRIPT);
        }
        return targetScripts;
    }

    private Set<String> getTargetTerritories(String language) {
        HashSet<String> targetTerritories = new HashSet<String>();
        HashSet<String> secondaryTerritories = new HashSet<String>();
        try {
            BasicLanguageData scriptsAndRegions;
            Set<BasicLanguageData> langData = this.getBasicLanguageData(language);
            for (BasicLanguageData bl : langData) {
                Set<String> addTerritories = bl.territories;
                if (addTerritories == null) continue;
                if (bl.getType() == BasicLanguageData.Type.secondary) {
                    secondaryTerritories.addAll(addTerritories);
                    continue;
                }
                targetTerritories.addAll(addTerritories);
            }
            Map<String, BasicLanguageData> languageToScriptsAndRegions = this.getLanguageToScriptsAndRegions();
            if (languageToScriptsAndRegions != null && (scriptsAndRegions = languageToScriptsAndRegions.get(language)) != null) {
                targetTerritories.addAll(scriptsAndRegions.getTerritories());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (targetTerritories.size() == 0) {
            this.getFallbackTargetTerritories(language, targetTerritories, secondaryTerritories);
        }
        return targetTerritories;
    }

    private void getFallbackTargetTerritories(String language, Set<String> targetTerritories, Set<String> secondaryTerritories) {
        String region = null;
        String maximized = new LikelySubtags().maximize(language);
        if (maximized != null) {
            CLDRLocale cldrLocale = CLDRLocale.getInstance(maximized);
            region = cldrLocale.getCountry();
        }
        if (region != null) {
            targetTerritories.add(region);
        } else if (secondaryTerritories.size() > 0) {
            targetTerritories.addAll(secondaryTerritories);
        } else {
            targetTerritories.add("ZZ");
        }
    }

    private Set<String> getCalendars(Set<String> territories) {
        HashSet<String> targetCalendars = new HashSet<String>();
        Iterator<String> it = territories.iterator();
        while (it.hasNext()) {
            List<String> addCalendars = this.getCalendars(it.next());
            if (addCalendars == null) continue;
            targetCalendars.addAll(addCalendars);
        }
        return targetCalendars;
    }

    public List<String> getCalendars(String territory) {
        return this.calendarPreferences.get(territory);
    }

    private Set<String> getCurrentCurrencies(Set<String> territories) {
        Date now = new Date();
        return this.getCurrentCurrencies(territories, now, now);
    }

    public Set<String> getCurrentCurrencies(Set<String> territories, Date startsBefore, Date endsAfter) {
        HashSet<String> targetCurrencies = new HashSet<String>();
        Iterator<String> it = territories.iterator();
        while (it.hasNext()) {
            Set<CurrencyDateInfo> targetCurrencyInfo = this.getCurrencyDateInfo(it.next());
            if (targetCurrencyInfo == null) continue;
            for (CurrencyDateInfo cdi : targetCurrencyInfo) {
                if (!cdi.getStart().before(startsBefore) || !cdi.getEnd().after(endsAfter) || !cdi.isLegalTender()) continue;
                targetCurrencies.add(cdi.getCurrency());
            }
        }
        return targetCurrencies;
    }

    private Set<String> getCurrentTimeZones(Set<String> territories) {
        HashSet<String> targetTimeZones = new HashSet<String>();
        Iterator<String> it = territories.iterator();
        while (it.hasNext()) {
            String[] countryIDs = TimeZone.getAvailableIDs(it.next());
            for (int i = 0; i < countryIDs.length; ++i) {
                targetTimeZones.add(countryIDs[i]);
            }
        }
        return targetTimeZones;
    }

    private Set<String> getTargetPlurals(String language) {
        HashSet<String> targetPlurals = new HashSet<String>();
        targetPlurals.addAll(this.getPlurals(PluralType.cardinal, language).getCanonicalKeywords());
        targetPlurals.add("0");
        targetPlurals.add("1");
        return targetPlurals;
    }

    public boolean parentLocalesSkipNonLikely(ParentLocaleComponent component) {
        return this.parentLocalesSkipNonLikely.contains((Object)component);
    }

    public String getExplicitParentLocale(String loc, ParentLocaleComponent component) {
        return this.parentLocales.get((Object)component).get(loc);
    }

    public Collection<String> getExplicitParents() {
        return this.getExplicitParents(ParentLocaleComponent.main);
    }

    public Collection<String> getExplicitParents(ParentLocaleComponent component) {
        return this.parentLocales.get((Object)component).values();
    }

    public int getRequiredVotes(CLDRLocale loc, PathHeader ph) {
        if (this.approvalMatchers == null) {
            this.approvalMatchers = ApprovalRequirementMatcher.buildAll(this.approvalRequirements);
        }
        for (ApprovalRequirementMatcher m4 : this.approvalMatchers) {
            if (!m4.matches(loc, ph)) continue;
            return m4.getRequiredVotes();
        }
        throw new RuntimeException("Error: " + loc + " " + ph + " ran off the end of the approvalMatchers.");
    }

    public String getZoneFromAlias(String alias) {
        String zone = this.alias_zone.get(alias);
        if (zone != null) {
            return zone;
        }
        if (this.zone_territory.get(alias) != null) {
            return alias;
        }
        return null;
    }

    public boolean isCanonicalZone(String alias) {
        return this.zone_territory.get(alias) != null;
    }

    public double getApproximateEconomicWeight(String targetLanguage) {
        double weight = 0.0;
        Set<String> territories = this.getTerritoriesForPopulationData(targetLanguage);
        if (territories == null) {
            return weight;
        }
        for (String territory : territories) {
            Set<String> languagesInTerritory = this.getTerritoryToLanguages(territory);
            double totalLiteratePopulation = 0.0;
            double targetLiteratePopulation = 0.0;
            for (String language : languagesInTerritory) {
                PopulationData populationData = this.getLanguageAndTerritoryPopulationData(language, territory);
                totalLiteratePopulation += populationData.getLiteratePopulation();
                if (!language.equals(targetLanguage)) continue;
                targetLiteratePopulation = populationData.getLiteratePopulation();
            }
            PopulationData territoryPopulationData = this.getPopulationDataForTerritory(territory);
            double gdp = territoryPopulationData.getGdp();
            double scaledGdp = gdp * targetLiteratePopulation / totalLiteratePopulation;
            if (!(scaledGdp > 0.0)) continue;
            weight += scaledGdp;
        }
        return weight;
    }

    public PopulationData getPopulationDataForTerritory(String territory) {
        return this.territoryToPopulationData.get(territory);
    }

    public Set<String> getScriptVariantsForPopulationData(String language) {
        return this.languageToScriptVariants.getAll(language);
    }

    public Map<String, Pair<String, String>> getReferences() {
        return this.references;
    }

    public Map<String, Map<String, String>> getMetazoneToRegionToZone() {
        return this.typeToZoneToRegionToZone.get("metazones");
    }

    public String getZoneForMetazoneByRegion(String metazone, String region) {
        String result = null;
        if (this.getMetazoneToRegionToZone().containsKey(metazone)) {
            Map<String, String> myMap = this.getMetazoneToRegionToZone().get(metazone);
            result = myMap.containsKey(region) ? myMap.get(region) : myMap.get("001");
        }
        if (result == null) {
            result = "Etc/GMT";
        }
        return result;
    }

    public Map<String, Map<String, Map<String, String>>> getTypeToZoneToRegionToZone() {
        return this.typeToZoneToRegionToZone;
    }

    public Map<String, String> getMetazoneToContinentMap() {
        return this.metazoneContinentMap;
    }

    public Set<String> getAllMetazones() {
        return this.allMetazones;
    }

    public boolean metazoneIsOutdated(String metazone, String tzid, long timeInMillis) {
        MetaZoneRange range = this.getMetaZoneRange(tzid, timeInMillis);
        if (range == null) {
            return true;
        }
        return !metazone.equals(range.metazone);
    }

    public Map<String, String> getLikelySubtags() {
        return this.likelySubtags;
    }

    public Map<String, String> getLikelyOrigins() {
        return this.likelyOrigins;
    }

    private void addDayPeriodPath(XPathValue path) {
        DayPeriodInfo.DayPeriod dayPeriod;
        DayPeriodInfo.Type type;
        String typeString = path.getAttributeValue(1, "type");
        String locales = path.getAttributeValue(2, "locales").trim();
        DayPeriodInfo.Type type2 = type = typeString == null ? DayPeriodInfo.Type.format : DayPeriodInfo.Type.valueOf(typeString.trim());
        if (!locales.equals(this.lastDayPeriodLocales) || type != this.lastDayPeriodType) {
            if (this.lastDayPeriodLocales != null) {
                this.addDayPeriodInfo();
            }
            this.lastDayPeriodLocales = locales;
            this.lastDayPeriodType = type;
        }
        if (path.size() != 4) {
            if (locales.equals("root")) {
                return;
            }
            throw new IllegalArgumentException(locales + " must have dayPeriodRule elements");
        }
        try {
            dayPeriod = DayPeriodInfo.DayPeriod.fromString(path.getAttributeValue(-1, "type"));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return;
        }
        String at = path.getAttributeValue(-1, "at");
        String from = path.getAttributeValue(-1, "from");
        String after = path.getAttributeValue(-1, "after");
        String to = path.getAttributeValue(-1, "to");
        String before = path.getAttributeValue(-1, "before");
        if (at != null) {
            if (from != null || after != null || to != null || before != null) {
                throw new IllegalArgumentException();
            }
            from = at;
            to = at;
        } else if (from == null == (after == null) || to == null == (before == null)) {
            throw new IllegalArgumentException();
        }
        boolean includesStart = from != null;
        boolean includesEnd = to != null;
        int start = this.parseTime(includesStart ? from : after);
        int end = this.parseTime(includesEnd ? to : before);
        if (start > end) {
            this.dayPeriodBuilder.add(dayPeriod, start, includesStart, this.parseTime("24:00"), includesEnd);
            this.dayPeriodBuilder.add(dayPeriod, this.parseTime("0:00"), includesStart, end, includesEnd);
        } else {
            this.dayPeriodBuilder.add(dayPeriod, start, includesStart, end, includesEnd);
        }
    }

    private int parseTime(String string) {
        Matcher matcher = PARSE_TIME.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException();
        }
        return (Integer.parseInt(matcher.group(1)) * 60 + Integer.parseInt(matcher.group(2))) * 60 * 1000;
    }

    private void addDayPeriodInfo() {
        String[] locales = this.lastDayPeriodLocales.split("\\s+");
        DayPeriodInfo temp = this.dayPeriodBuilder.finish(locales);
        Map<String, DayPeriodInfo> locale2DPI = this.typeToLocaleToDayPeriodInfo.get((Object)this.lastDayPeriodType);
        if (locale2DPI == null) {
            locale2DPI = new LinkedHashMap<String, DayPeriodInfo>();
            this.typeToLocaleToDayPeriodInfo.put(this.lastDayPeriodType, locale2DPI);
        }
        for (String locale : locales) {
            locale2DPI.put(locale, temp);
        }
    }

    private boolean addPluralPath(XPathValue path, String value) {
        String locales = path.getAttributeValue(2, "locales").trim();
        String element = path.getElement(2);
        if ("pluralRanges".equals(element)) {
            if (!locales.equals(lastPluralRangesLocales)) {
                this.addPluralRanges(locales);
            }
            if (path.size() == 3) {
                return true;
            }
            String rangeStart = path.getAttributeValue(-1, "start");
            String rangeEnd = path.getAttributeValue(-1, "end");
            String result = path.getAttributeValue(-1, "result");
            lastPluralRanges.add(rangeStart == null ? null : PluralInfo.Count.valueOf(rangeStart), rangeEnd == null ? null : PluralInfo.Count.valueOf(rangeEnd), PluralInfo.Count.valueOf(result));
            return true;
        }
        if ("pluralRules".equals(element)) {
            String countString;
            PluralType pluralType;
            String type = path.getAttributeValue(1, "type");
            PluralType pluralType2 = pluralType = type == null ? PluralType.cardinal : PluralType.valueOf(type);
            if (!this.lastPluralLocales.equals(locales)) {
                this.addPluralInfo(pluralType);
                this.lastPluralLocales = locales;
            }
            if ((countString = path.getAttributeValue(-1, "count")) == null) {
                return false;
            }
            PluralInfo.Count count = PluralInfo.Count.valueOf(countString);
            if (this.lastPluralMap.containsKey((Object)count)) {
                throw new IllegalArgumentException("Duplicate plural count: " + count + " in " + locales);
            }
            this.lastPluralMap.put(count, value);
            this.lastPluralWasOrdinal = pluralType;
            return true;
        }
        return false;
    }

    private void addPluralRanges(String localesString) {
        String[] locales = localesString.split("\\s+");
        lastPluralRanges = new PluralRanges();
        for (String locale : locales) {
            if (this.localeToPluralRanges.containsKey(locale)) {
                throw new IllegalArgumentException("Duplicate plural locale: " + locale);
            }
            this.localeToPluralRanges.put(locale, lastPluralRanges);
        }
        lastPluralRangesLocales = localesString;
    }

    private void addPluralInfo(PluralType pluralType) {
        String[] locales = this.lastPluralLocales.split("\\s+");
        PluralInfo info = new PluralInfo(this.lastPluralMap, pluralType);
        Map<String, PluralInfo> localeToInfo = this.localeToPluralInfo2.get((Object)pluralType);
        for (String locale : locales) {
            if (localeToInfo.containsKey(locale)) {
                throw new IllegalArgumentException("Duplicate plural locale: " + locale);
            }
            if (locale.isEmpty()) continue;
            localeToInfo.put(locale, info);
        }
        this.lastPluralMap.clear();
    }

    @Deprecated
    public Set<String> getPluralLocales() {
        return this.getPluralLocales(PluralType.cardinal);
    }

    public Set<String> getPluralLocales(PluralType type) {
        return this.localeToPluralInfo2.get((Object)type).keySet();
    }

    public Set<String> getPluralRangesLocales() {
        return this.localeToPluralRanges.keySet();
    }

    public PluralRanges getPluralRanges(String locale) {
        return this.localeToPluralRanges.get(locale);
    }

    @Deprecated
    public PluralInfo getPlurals(String locale) {
        return this.getPlurals(locale, true);
    }

    public PluralInfo getPlurals(PluralType type, String locale) {
        return this.getPlurals(type, locale, true);
    }

    @Deprecated
    public PluralInfo getPlurals(String locale, boolean allowRoot) {
        return this.getPlurals(PluralType.cardinal, locale, allowRoot);
    }

    public PluralInfo getPlurals(PluralType type, String locale, boolean allowRoot) {
        Map<String, PluralInfo> infoMap = this.localeToPluralInfo2.get((Object)type);
        while (locale != null && (allowRoot || !locale.equals("root"))) {
            PluralInfo result = infoMap.get(locale);
            if (result != null) {
                return result;
            }
            locale = LocaleIDParser.getSimpleParent(locale);
        }
        return null;
    }

    public PluralRules getPluralRules(ULocale loc, PluralRules.PluralType type) {
        return this.getPluralRules(loc.getBaseName(), type);
    }

    public PluralRules getPluralRules(String loc, PluralRules.PluralType type) {
        return this.getPlurals(PluralType.fromStandardType(type), loc).getPluralRules();
    }

    public DayPeriodInfo getDayPeriods(DayPeriodInfo.Type type, String locale) {
        Map<String, DayPeriodInfo> map1 = this.typeToLocaleToDayPeriodInfo.get((Object)type);
        while (locale != null) {
            DayPeriodInfo result = map1.get(locale);
            if (result != null) {
                return result;
            }
            locale = LocaleIDParser.getSimpleParent(locale);
        }
        return null;
    }

    public Set<String> getDayPeriodLocales(DayPeriodInfo.Type type) {
        return this.typeToLocaleToDayPeriodInfo.get((Object)type).keySet();
    }

    public CurrencyNumberInfo getCurrencyNumberInfo(String currency) {
        CurrencyNumberInfo result = this.currencyToCurrencyNumberInfo.get(currency);
        if (result == null) {
            result = DEFAULT_NUMBER_INFO;
        }
        return result;
    }

    public Set<CurrencyDateInfo> getCurrencyDateInfo(String territory) {
        return this.territoryToCurrencyDateInfo.getAll(territory);
    }

    public Set<String> getCurrencyTerritories() {
        return this.territoryToCurrencyDateInfo.keySet();
    }

    public String getDefaultCurrency(String territory) {
        String result = "XXX";
        Set<CurrencyDateInfo> targetCurrencyInfo = this.getCurrencyDateInfo(territory);
        if (targetCurrencyInfo == null) {
            return result;
        }
        Date now = new Date();
        for (CurrencyDateInfo cdi : targetCurrencyInfo) {
            if (!cdi.getStart().before(now) || !cdi.getEnd().after(now) || !cdi.isLegalTender()) continue;
            result = cdi.getCurrency();
            break;
        }
        return result;
    }

    public String getDefaultCurrency(CLDRLocale loc) {
        return this.getDefaultCurrency(loc.getCountry());
    }

    public Map<String, Set<TelephoneCodeInfo>> getTerritoryToTelephoneCodeInfo() {
        return this.territoryToTelephoneCodeInfo;
    }

    public Set<TelephoneCodeInfo> getTelephoneCodeInfoForTerritory(String territory) {
        return this.territoryToTelephoneCodeInfo.get(territory);
    }

    public Set<String> getTerritoriesForTelephoneCodeInfo() {
        return this.territoryToTelephoneCodeInfo.keySet();
    }

    public List<Row.R4<String, String, Integer, Boolean>> getLanguageMatcherData(String string) {
        return this.languageMatch.get(string);
    }

    public Set<String> getLanguageMatcherKeys() {
        return this.languageMatch.keySet();
    }

    public Map<MeasurementType, Map<String, String>> getTerritoryMeasurementData() {
        return this.measurementData;
    }

    public Relation<String, String> getBcp47Keys() {
        return this.bcp47Key2Subtypes;
    }

    public Relation<String, String> getBcp47Extension2Keys() {
        return this.bcp47Extension2Keys;
    }

    public Relation<Row.R2<String, String>, String> getBcp47Aliases() {
        return this.bcp47Aliases;
    }

    public Map<Row.R2<String, String>, String> getBcp47Descriptions() {
        return this.bcp47Descriptions;
    }

    public Map<Row.R2<String, String>, String> getBcp47Since() {
        return this.bcp47Since;
    }

    public Map<Row.R2<String, String>, String> getBcp47Preferred() {
        return this.bcp47Preferred;
    }

    public Map<Row.R2<String, String>, String> getBcp47Deprecated() {
        return this.bcp47Deprecated;
    }

    public Map<String, String> getBcp47ValueType() {
        return this.bcp47ValueType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getCanonicalTimeZones() {
        Class<SupplementalDataInfo> clazz = SupplementalDataInfo.class;
        synchronized (SupplementalDataInfo.class) {
            if (MainTimeZones == null) {
                MainTimeZones = new TreeSet<String>();
                SupplementalDataInfo info = SupplementalDataInfo.getInstance();
                for (Map.Entry<Row.R2<String, String>, Set<String>> entry : info.getBcp47Aliases().keyValuesSet()) {
                    Row.R2<String, String> subtype_aliases = entry.getKey();
                    if (!((String)subtype_aliases.get0()).equals("timezone")) continue;
                    MainTimeZones.add(entry.getValue().iterator().next());
                }
                MainTimeZones = Collections.unmodifiableSet(MainTimeZones);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return MainTimeZones;
        }
    }

    public Set<MetaZoneRange> getMetaZoneRanges(String zone) {
        return this.zoneToMetaZoneRanges.get(zone);
    }

    public MetaZoneRange getMetaZoneRange(String zone, long date) {
        Set<MetaZoneRange> metazoneRanges = this.zoneToMetaZoneRanges.get(zone);
        if (metazoneRanges != null) {
            for (MetaZoneRange metazoneRange : metazoneRanges) {
                if (metazoneRange.dateRange.getFrom() > date || date >= metazoneRange.dateRange.getTo()) continue;
                return metazoneRange;
            }
        }
        return null;
    }

    public boolean isDeprecated(DtdType type, String element, String attribute, String value) {
        if (type.getStatus() == DtdType.DtdStatus.removed) {
            return true;
        }
        return DtdData.getInstance(type).isDeprecated(element, attribute, value);
    }

    public boolean isDeprecated(DtdType type, String path) {
        XPathValue parts = SimpleXPathParts.getFrozenInstance(path);
        for (int i = 0; i < parts.size(); ++i) {
            String element = parts.getElement(i);
            if (this.isDeprecated(type, element, STAR, STAR)) {
                return true;
            }
            for (Map.Entry<String, String> entry : parts.getAttributes(i).entrySet()) {
                String value;
                String attribute = entry.getKey();
                if (!this.isDeprecated(type, element, attribute, value = entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public Map<String, Row.R2<String, String>> getValidityInfo() {
        return this.validityInfo;
    }

    public Set<String> getCLDRLanguageCodes() {
        return this.CLDRLanguageCodes;
    }

    public Set<String> getLanguageTcOrBasic() {
        return Sets.difference(this.CLDRLanguageCodes, this.languageNonTcLtBasic);
    }

    public Set<String> getLanguageNonTcLtBasic() {
        return this.languageNonTcLtBasic;
    }

    public boolean isCLDRLanguageCode(String code) {
        return this.CLDRLanguageCodes.contains(code);
    }

    public Set<String> getCLDRScriptCodes() {
        return this.CLDRScriptCodes;
    }

    public boolean isCLDRScriptCode(String code) {
        return this.CLDRScriptCodes.contains(code);
    }

    private synchronized void initCLDRLocaleBasedData() throws InternalError {
        if (this.defaultContentToBase == null) {
            TreeMap<CLDRLocale, CLDRLocale> p2c = new TreeMap<CLDRLocale, CLDRLocale>();
            TreeMap<CLDRLocale, CLDRLocale> c2p = new TreeMap<CLDRLocale, CLDRLocale>();
            TreeSet<CLDRLocale> tmpAllLocales = new TreeSet<CLDRLocale>();
            for (String l : this.defaultContentLocales) {
                CLDRLocale child = CLDRLocale.getInstance(l);
                tmpAllLocales.add(child);
            }
            for (CLDRLocale child : tmpAllLocales) {
                CLDRLocale childParent;
                CLDRLocale nextParent;
                for (nextParent = child.getParent(); nextParent != null && tmpAllLocales.contains(nextParent); nextParent = nextParent.getParent()) {
                }
                if (nextParent == null) {
                    throw new InternalError("SupplementalDataInfo.defaultContentToChild(): No valid parent for " + child);
                }
                if (nextParent == CLDRLocale.ROOT || nextParent == CLDRLocale.getInstance("root")) {
                    throw new InternalError("SupplementalDataInfo.defaultContentToChild(): Parent is root for default content locale " + child);
                }
                c2p.put(child, nextParent);
                CLDRLocale oldChild = (CLDRLocale)p2c.get(nextParent);
                if (oldChild != null && !(childParent = child.getParent()).equals(oldChild)) {
                    throw new InternalError("SupplementalData.defaultContentToChild(): defaultContent list in wrong order? Tried to map " + nextParent + " -> " + child + ", replacing " + oldChild + " (should have been " + childParent + ")");
                }
                p2c.put(nextParent, child);
            }
            this.baseToDefaultContent = Collections.unmodifiableMap(p2c);
            this.defaultContentToBase = Collections.unmodifiableMap(c2p);
        }
    }

    public Map<String, PreferredAndAllowedHour> getTimeData() {
        return this.timeData;
    }

    public String getDefaultScript(String baseLanguage) {
        String ls = this.likelySubtags.get(baseLanguage);
        if (ls == null) {
            return UNKNOWN_SCRIPT;
        }
        LocaleIDParser lp = new LocaleIDParser().set(ls);
        String defaultScript = lp.getScript();
        if (defaultScript.length() > 0) {
            return defaultScript;
        }
        return UNKNOWN_SCRIPT;
    }

    public Set<String> getEquivalentsForLocale(String localeId) {
        Map<String, String> likely;
        String newMax;
        if (this.equivalentLocales == null) {
            this.equivalentLocales = this.getEquivalentsForLocale();
        }
        TreeSet<String> result = new TreeSet<String>(LENGTH_FIRST);
        result.add(localeId);
        Set<String> equiv = this.equivalentLocales.getEquivalences(localeId);
        if (equiv != null) {
            result.addAll(this.equivalentLocales.getEquivalences(localeId));
        }
        if ((newMax = LikelySubtags.maximize(localeId, likely = this.getLikelySubtags())) != null) {
            result.add(newMax);
            newMax = LikelySubtags.minimize(localeId, likely, true);
            if (newMax != null) {
                result.add(newMax);
            }
            if ((newMax = LikelySubtags.minimize(localeId, likely, false)) != null) {
                result.add(newMax);
            }
        }
        return result;
    }

    private synchronized XEquivalenceClass<String, String> getEquivalentsForLocale() {
        SupplementalDataInfo sdi = this;
        Relation<String, String> localeToDefaultContents = Relation.of(new HashMap(), LinkedHashSet.class);
        Set<String> dcl = sdi.getDefaultContentLocales();
        Map<String, String> likely = sdi.getLikelySubtags();
        XEquivalenceClass<String, String> locales = new XEquivalenceClass<String, String>();
        LanguageTagParser ltp = new LanguageTagParser();
        HashSet<String> temp = new HashSet<String>();
        for (Map.Entry<String, String> entry : likely.entrySet()) {
            String source = entry.getKey();
            if (source.startsWith("und")) continue;
            for (String s2 : this.getCombinations(source, ltp, likely, temp)) {
                locales.add(source, s2);
            }
            for (String s2 : this.getCombinations(entry.getValue(), ltp, likely, temp)) {
                locales.add(source, s2);
            }
        }
        for (String defaultContentLocale : dcl) {
            String ds;
            String parent;
            Set<String> set;
            if (defaultContentLocale.startsWith("zh")) {
                boolean source = false;
            }
            if (!(set = locales.getEquivalences(defaultContentLocale)).contains(parent = LocaleIDParser.getSimpleParent(defaultContentLocale))) {
                localeToDefaultContents.put(parent, defaultContentLocale);
            }
            if (parent.contains("_") || (ds = sdi.getDefaultScript(parent)) == null) continue;
            ltp.set(parent);
            ltp.setScript(ds);
            String trial = ltp.toString();
            if (set.contains(trial)) continue;
            localeToDefaultContents.put(parent, trial);
        }
        return locales;
    }

    private Set<String> getCombinations(String source, LanguageTagParser ltp, Map<String, String> likely, Set<String> locales) {
        locales.clear();
        String max = LikelySubtags.maximize(source, likely);
        locales.add(max);
        ltp.set(source);
        ltp.setScript("");
        String trial = ltp.toString();
        String newMax = LikelySubtags.maximize(trial, likely);
        if (Objects.equals(newMax, max)) {
            locales.add(trial);
        }
        ltp.set(source);
        ltp.setRegion("");
        trial = ltp.toString();
        newMax = LikelySubtags.maximize(trial, likely);
        if (Objects.equals(newMax, max)) {
            locales.add(trial);
        }
        return locales;
    }

    public VersionInfo getCldrVersion() {
        return this.cldrVersion;
    }

    public String getUnicodeVersionString() {
        return this.unicodeVersion;
    }

    public VersionInfo getUnicodeVersion() {
        return VersionInfo.getInstance(this.getUnicodeVersionString());
    }

    public String getCldrVersionString() {
        return this.cldrVersionString;
    }

    public File getDirectory() {
        return this.directory;
    }

    public Map<AttributeValidityInfo, String> getAttributeValidity() {
        return this.attributeValidityInfo;
    }

    public Multimap<String, String> getLanguageGroups() {
        return this.languageGroups;
    }

    public UnitConverter getUnitConverter() {
        return this.unitConverter;
    }

    public Rational.RationalParser getRationalParser() {
        return this.rationalParser;
    }

    public UnitPreferences getUnitPreferences() {
        return this.unitPreferences;
    }

    public UnitIdComponentType getUnitIdComponentType(String component) {
        UnitIdComponentType result = this.unitIdComponentType.get(component);
        return result == null ? UnitIdComponentType.base : result;
    }

    public Set<String> hasGrammarInfo() {
        return this.grammarLocaleToTargetToFeatureToValues.keySet();
    }

    public Set<String> getLocalesWithFeatures(GrammarInfo.GrammaticalTarget target, GrammarInfo.GrammaticalScope scope, GrammarInfo.GrammaticalFeature ... features) {
        TreeSet<String> locales = new TreeSet<String>();
        for (Map.Entry<String, GrammarInfo> localeAndGrammar : this.grammarLocaleToTargetToFeatureToValues.entrySet()) {
            GrammarInfo grammarInfo = localeAndGrammar.getValue();
            for (GrammarInfo.GrammaticalFeature feature : features) {
                Collection<String> featureInfo = grammarInfo.get(target, feature, scope);
                if (featureInfo.isEmpty()) continue;
                locales.add(localeAndGrammar.getKey());
            }
        }
        return ImmutableSet.copyOf(locales);
    }

    public GrammarInfo getGrammarInfo(String locale) {
        return this.getGrammarInfo(locale, false);
    }

    @Deprecated
    public GrammarInfo getGrammarInfo(String locale, boolean seedOnly) {
        while (locale != null) {
            GrammarInfo result;
            if ((!seedOnly || GrammarInfo.getGrammarLocales().contains(locale)) && (result = this.grammarLocaleToTargetToFeatureToValues.get(locale)) != null) {
                return result;
            }
            locale = LocaleIDParser.getParent(locale);
        }
        return null;
    }

    public Set<String> hasGrammarDerivation() {
        return this.localeToGrammarDerivation.keySet();
    }

    public GrammarDerivation getGrammarDerivation(String locale) {
        while (locale != null) {
            GrammarDerivation result = this.localeToGrammarDerivation.get(locale);
            if (result != null) {
                return result;
            }
            locale = LocaleIDParser.getParent(locale);
        }
        return null;
    }

    public Multimap<PersonNameFormatter.Order, String> getPersonNameOrder() {
        return this.personNameOrder;
    }

    public UnitPrefixInfo getUnitPrefixInfo(String prefix) {
        return this.unitPrefixInfo.get(prefix);
    }

    public Set<String> getUnitPrefixes() {
        return this.unitPrefixInfo.keySet();
    }

    public Set<String> getCLDRTimezoneCodes() {
        return this.goodTimezones.get();
    }

    static {
        LENGTH_FIRST = new LengthFirstComparator();
        WHITESPACE_SPLITTER = Splitter.on(PatternCache.get("\\s+")).omitEmptyStrings();
    }

    public static final class AttributeValidityInfo {
        final String type;
        final Set<DtdType> dtds;
        final Set<String> elements;
        final Set<String> attributes;
        final String order;

        public String toString() {
            return "type:" + this.type + ", elements:" + this.elements + ", attributes:" + this.attributes + ", order:" + this.order;
        }

        static void add(Map<String, String> inputAttibutes, String inputValue, Map<AttributeValidityInfo, String> data) {
            AttributeValidityInfo key = new AttributeValidityInfo(inputAttibutes.get("dtds"), inputAttibutes.get("type"), inputAttibutes.get("attributes"), inputAttibutes.get("elements"), inputAttibutes.get("order"));
            if (data.containsKey(key)) {
                throw new IllegalArgumentException(key + " declared twice");
            }
            data.put(key, inputValue);
        }

        public AttributeValidityInfo(String dtds, String type, String attributes, String elements, String order) {
            if (dtds == null) {
                this.dtds = Collections.singleton(DtdType.ldml);
            } else {
                EnumSet<DtdType> temp = EnumSet.noneOf(DtdType.class);
                for (String s2 : WHITESPACE_SPLITTER.split(dtds)) {
                    temp.add(DtdType.fromElement(s2));
                }
                this.dtds = Collections.unmodifiableSet(temp);
            }
            this.type = type != null ? type : (order != null ? "choice" : null);
            this.elements = elements == null ? Collections.EMPTY_SET : (Set)With.in(WHITESPACE_SPLITTER.split(elements)).toUnmodifiableCollection(new HashSet());
            this.attributes = With.in(WHITESPACE_SPLITTER.split(attributes)).toUnmodifiableCollection(new HashSet());
            this.order = order;
        }

        public String getType() {
            return this.type;
        }

        public Set<DtdType> getDtds() {
            return this.dtds;
        }

        public Set<String> getElements() {
            return this.elements;
        }

        public Set<String> getAttributes() {
            return this.attributes;
        }

        public String getOrder() {
            return this.order;
        }

        public boolean equals(Object obj) {
            AttributeValidityInfo other = (AttributeValidityInfo)obj;
            return CldrUtility.deepEquals(this.type, other.type, this.dtds, other.dtds, this.elements, other.elements, this.attributes, other.attributes, this.order, other.order);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.dtds, this.elements, this.attributes, this.order);
        }
    }

    public static final class LengthFirstComparator<T>
    implements Comparator<T> {
        @Override
        public int compare(T a, T b) {
            String as = a.toString();
            String bs = b.toString();
            if (as.length() < bs.length()) {
                return -1;
            }
            if (as.length() > bs.length()) {
                return 1;
            }
            return as.compareTo(bs);
        }
    }

    public static class PluralInfo
    implements Comparable<PluralInfo> {
        static final Set<Double> explicits = new HashSet<Double>();
        static final Pattern pluralPaths;
        static final int fractDecrement = 13;
        static final int fractStart = 20;
        private final Map<Count, Set<Double>> countToExampleSet;
        private final Map<Count, String> countToStringExample;
        private final Map<Integer, Count> exampleToCount;
        private final PluralRules pluralRules;
        private final String pluralRulesString;
        private final Set<String> canonicalKeywords;
        private final Set<Count> keywords;
        private final Set<Count> integerKeywords;
        private final Set<Count> decimalKeywords;
        private final CountSampleList countSampleList;
        private final Map<Count, String> countToRule;
        private final Set<Count> adjustedCounts;
        private final Set<String> adjustedCountStrings;
        static final Pattern hasE;
        public static final DecimalQuantity NEGATIVE_INFINITY;
        public static final DecimalQuantity POSITIVE_INFINITY;

        private PluralInfo(Map<Count, String> countToRule, PluralType pluralType) {
            EnumMap<Count, String> tempCountToRule = new EnumMap<Count, String>(Count.class);
            tempCountToRule.putAll(countToRule);
            this.countToRule = Collections.unmodifiableMap(tempCountToRule);
            NumberFormat nf = NumberFormat.getNumberInstance(ULocale.ENGLISH);
            nf.setMaximumFractionDigits(2);
            StringBuilder pluralRuleBuilder = new StringBuilder();
            for (Count count : countToRule.keySet()) {
                if (pluralRuleBuilder.length() != 0) {
                    pluralRuleBuilder.append(';');
                }
                pluralRuleBuilder.append((Object)count).append(':').append(countToRule.get((Object)count));
            }
            this.pluralRulesString = pluralRuleBuilder.toString();
            try {
                this.pluralRules = PluralRules.parseDescription(this.pluralRulesString);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Can't create plurals from <" + this.pluralRulesString + ">", e);
            }
            EnumSet<Count> _keywords = EnumSet.noneOf(Count.class);
            EnumSet<Count> _integerKeywords = EnumSet.noneOf(Count.class);
            EnumSet<Count> _decimalKeywords = EnumSet.noneOf(Count.class);
            Matcher hasEMatcher = hasE.matcher("");
            TreeSet<Count> _adjustedCounts = null;
            TreeSet<String> _adjustedCountStrings = null;
            for (String s2 : this.pluralRules.getKeywords()) {
                String parsedRules;
                boolean bl;
                Count c = Count.valueOf(s2);
                _keywords.add(c);
                if (this.pluralRules.getDecimalSamples(s2, PluralRules.SampleType.DECIMAL) != null) {
                    _decimalKeywords.add(c);
                } else {
                    bl = true;
                }
                if (this.pluralRules.getDecimalSamples(s2, PluralRules.SampleType.INTEGER) != null) {
                    _integerKeywords.add(c);
                } else {
                    bl = true;
                }
                if (hasEMatcher.reset(parsedRules = this.pluralRules.getRules(s2)).find()) continue;
                if (_adjustedCounts == null) {
                    _adjustedCounts = new TreeSet<Count>();
                    _adjustedCountStrings = new TreeSet<String>();
                }
                _adjustedCounts.add(c);
                _adjustedCountStrings.add(s2);
            }
            this.adjustedCounts = _adjustedCounts == null ? Collections.emptySet() : ImmutableSet.copyOf(_adjustedCounts);
            this.adjustedCountStrings = _adjustedCounts == null ? Collections.emptySet() : ImmutableSet.copyOf(_adjustedCountStrings);
            this.keywords = Collections.unmodifiableSet(_keywords);
            this.decimalKeywords = Collections.unmodifiableSet(_decimalKeywords);
            this.integerKeywords = Collections.unmodifiableSet(_integerKeywords);
            this.countSampleList = new CountSampleList(this.pluralRules, this.keywords, pluralType);
            TreeMap countToExampleSetRaw = new TreeMap();
            TreeMap exampleToCountRaw = new TreeMap();
            Output output = new Output();
            String otherFractionalExamples = "";
            ArrayList otherFractions = new ArrayList(0);
            TreeMap<Count, Object> countToStringExampleRaw = new TreeMap<Count, Object>();
            for (Count type : this.keywords) {
                SampleList uset = this.countSampleList.get(type);
                countToStringExampleRaw.put(type, uset.toString(5, 5));
            }
            String baseOtherExamples = (String)countToStringExampleRaw.get((Object)Count.other);
            String otherExamples = (String)(baseOtherExamples == null ? "" : baseOtherExamples + "; ") + otherFractionalExamples + "...";
            countToStringExampleRaw.put(Count.other, otherExamples);
            for (Count type : countToStringExampleRaw.keySet()) {
                String[] exampleArray;
                Set<Double> doublesSet = new LinkedHashSet(0);
                String examples = (String)countToStringExampleRaw.get((Object)type);
                if (examples == null) {
                    examples = "";
                }
                String strippedExamples = examples.replaceAll("(, \u2026)|(; ...)", "");
                for (String example : exampleArray = strippedExamples.split("(, )|(-)")) {
                    if (example == null || example.length() == 0) continue;
                    Double doubleValue = Double.valueOf(example);
                    doublesSet.add(doubleValue);
                }
                doublesSet = Collections.unmodifiableSet(doublesSet);
                countToExampleSetRaw.put(type, doublesSet);
            }
            this.countToExampleSet = Collections.unmodifiableMap(countToExampleSetRaw);
            this.countToStringExample = Collections.unmodifiableMap(countToStringExampleRaw);
            this.exampleToCount = Collections.unmodifiableMap(exampleToCountRaw);
            LinkedHashSet<String> temp = new LinkedHashSet<String>();
            Set<String> keywords = this.pluralRules.getKeywords();
            for (Count count : Count.values()) {
                String keyword = count.toString();
                if (!keywords.contains(keyword)) continue;
                temp.add(keyword);
            }
            this.canonicalKeywords = Collections.unmodifiableSet(temp);
        }

        public String toString() {
            return this.countToExampleSet + "; " + this.exampleToCount + "; " + this.pluralRules;
        }

        public Map<Count, Set<Double>> getCountToExamplesMap() {
            return this.countToExampleSet;
        }

        public Map<Count, String> getCountToStringExamplesMap() {
            return this.countToStringExample;
        }

        public Count getCount(double exampleCount) {
            return Count.valueOf(this.pluralRules.select(exampleCount));
        }

        public Count getCount(DecimalQuantity exampleCount) {
            return Count.valueOf(this.pluralRules.select(exampleCount));
        }

        public PluralRules getPluralRules() {
            return this.pluralRules;
        }

        public String getRules() {
            return this.pluralRulesString;
        }

        public Count getDefault() {
            return null;
        }

        public Set<String> getCanonicalKeywords() {
            return this.canonicalKeywords;
        }

        public Set<Count> getCounts() {
            return this.keywords;
        }

        public Set<Count> getAdjustedCounts() {
            return this.adjustedCounts;
        }

        public Set<String> getAdjustedCountStrings() {
            return this.adjustedCountStrings;
        }

        public Set<Count> getCounts(PluralRules.SampleType sampleType) {
            return sampleType == PluralRules.SampleType.DECIMAL ? this.decimalKeywords : this.integerKeywords;
        }

        public SampleList getSamples9999(Count c) {
            return this.countSampleList.get(c);
        }

        public SampleList getSamples9999(Count c, int digit) {
            return this.countSampleList.get(c, digit);
        }

        public boolean hasSamples(Count c, int digits) {
            SampleList samples = this.countSampleList.get(c, digits);
            return samples != null && (samples.fractionSize() > 0 || samples.intSize() > 0);
        }

        public String getRule(Count keyword) {
            return this.countToRule.get((Object)keyword);
        }

        @Override
        public int compareTo(PluralInfo other) {
            int size2;
            int size1 = this.countToRule.size();
            int diff = size1 - (size2 = other.countToRule.size());
            if (diff != 0) {
                return diff;
            }
            Iterator<Count> it1 = this.countToRule.keySet().iterator();
            Iterator<Count> it2 = other.countToRule.keySet().iterator();
            while (it1.hasNext()) {
                Count a1 = it1.next();
                Count a2 = it2.next();
                diff = a1.ordinal() - a2.ordinal();
                if (diff == 0) continue;
                return diff;
            }
            return this.pluralRules.compareTo(other.pluralRules);
        }

        static double doubleValue(DecimalQuantity a) {
            return a.toDouble();
        }

        public boolean rangeExists(Count s2, Count e, Output<DecimalQuantity> minSample, Output<DecimalQuantity> maxSample) {
            if (!this.getCounts().contains((Object)s2) || !this.getCounts().contains((Object)e)) {
                return false;
            }
            minSample.value = this.getLeastIn(s2, PluralRules.SampleType.INTEGER, NEGATIVE_INFINITY, POSITIVE_INFINITY);
            DecimalQuantity temp = this.getLeastIn(s2, PluralRules.SampleType.DECIMAL, NEGATIVE_INFINITY, POSITIVE_INFINITY);
            if (this.lessOrFewerDecimals(temp, (DecimalQuantity)minSample.value)) {
                minSample.value = temp;
            }
            maxSample.value = this.getGreatestIn(e, PluralRules.SampleType.INTEGER, NEGATIVE_INFINITY, POSITIVE_INFINITY);
            temp = this.getGreatestIn(e, PluralRules.SampleType.DECIMAL, NEGATIVE_INFINITY, POSITIVE_INFINITY);
            if (this.greaterOrFewerDecimals(temp, (DecimalQuantity)maxSample.value)) {
                maxSample.value = temp;
            }
            if (PluralInfo.doubleValue((DecimalQuantity)minSample.value) >= PluralInfo.doubleValue((DecimalQuantity)maxSample.value)) {
                return false;
            }
            DecimalQuantity_DualStorageBCD lowestMax = new DecimalQuantity_DualStorageBCD(((DecimalQuantity)minSample.value).toBigDecimal().add(new BigDecimal("0.00001")));
            lowestMax.setMinFraction(5);
            PluralRules.SampleType bestType = this.getCounts(PluralRules.SampleType.INTEGER).contains((Object)e) ? PluralRules.SampleType.INTEGER : PluralRules.SampleType.DECIMAL;
            temp = this.getLeastIn(e, bestType, lowestMax, POSITIVE_INFINITY);
            if (this.lessOrFewerDecimals(temp, (DecimalQuantity)maxSample.value)) {
                maxSample.value = temp;
            }
            if (((DecimalQuantity)maxSample.value).toDouble() > 100000.0 && this.lessOrFewerDecimals(temp = this.getLeastIn(e, bestType, lowestMax, POSITIVE_INFINITY), (DecimalQuantity)maxSample.value)) {
                maxSample.value = temp;
            }
            return true;
        }

        public boolean greaterOrFewerDecimals(DecimalQuantity a, DecimalQuantity b) {
            return PluralInfo.doubleValue(a) > PluralInfo.doubleValue(b) || PluralInfo.doubleValue(b) == PluralInfo.doubleValue(a) && b.getPluralOperand(PluralRules.Operand.f) > a.getPluralOperand(PluralRules.Operand.f);
        }

        public boolean lessOrFewerDecimals(DecimalQuantity a, DecimalQuantity b) {
            return PluralInfo.doubleValue(a) < PluralInfo.doubleValue(b) || PluralInfo.doubleValue(b) == PluralInfo.doubleValue(a) && b.getPluralOperand(PluralRules.Operand.f) > a.getPluralOperand(PluralRules.Operand.f);
        }

        private DecimalQuantity getLeastIn(Count s2, PluralRules.SampleType sampleType, DecimalQuantity min2, DecimalQuantity max) {
            DecimalQuantity result = POSITIVE_INFINITY;
            PluralRules.DecimalQuantitySamples sSamples1 = this.pluralRules.getDecimalSamples(s2.toString(), sampleType);
            if (sSamples1 != null) {
                for (PluralRules.DecimalQuantitySamplesRange x : sSamples1.samples) {
                    DecimalQuantity minOverlap;
                    if (PluralInfo.doubleValue(x.start) > PluralInfo.doubleValue(max) || PluralInfo.doubleValue(x.end) < PluralInfo.doubleValue(min2) || !this.lessOrFewerDecimals(minOverlap = this.greaterOrFewerDecimals(min2, x.start) ? max : x.start, result)) continue;
                    result = minOverlap;
                }
            }
            return result;
        }

        private DecimalQuantity getGreatestIn(Count s2, PluralRules.SampleType sampleType, DecimalQuantity min2, DecimalQuantity max) {
            DecimalQuantity result = NEGATIVE_INFINITY;
            PluralRules.DecimalQuantitySamples sSamples1 = this.pluralRules.getDecimalSamples(s2.toString(), sampleType);
            if (sSamples1 != null) {
                for (PluralRules.DecimalQuantitySamplesRange x : sSamples1.getSamples()) {
                    DecimalQuantity maxOverlap;
                    if (PluralInfo.doubleValue(x.start) > PluralInfo.doubleValue(max) || PluralInfo.doubleValue(x.end) < PluralInfo.doubleValue(min2) || !this.greaterOrFewerDecimals(maxOverlap = this.lessOrFewerDecimals(max, x.end) ? max : x.end, result)) continue;
                    result = maxOverlap;
                }
            }
            return result;
        }

        public static DecimalQuantity getNonZeroSampleIfPossible(PluralRules.DecimalQuantitySamples exampleList) {
            Set<PluralRules.DecimalQuantitySamplesRange> sampleSet = exampleList.getSamples();
            DecimalQuantity sampleDecimal = null;
            for (PluralRules.DecimalQuantitySamplesRange range : sampleSet) {
                sampleDecimal = range.start;
                if (sampleDecimal.toDouble() == 0.0 && (sampleDecimal = range.end).toDouble() == 0.0) continue;
                break;
            }
            return sampleDecimal;
        }

        static {
            explicits.add(0.0);
            explicits.add(1.0);
            pluralPaths = PatternCache.get(".*pluralRule.*");
            hasE = Pattern.compile("e\\s*!?=");
            NEGATIVE_INFINITY = new DecimalQuantity_DualStorageBCD(Double.NEGATIVE_INFINITY);
            POSITIVE_INFINITY = new DecimalQuantity_DualStorageBCD(Double.POSITIVE_INFINITY);
        }

        static enum MinMax {
            MIN,
            MAX;

        }

        public static enum Count {
            zero,
            one,
            two,
            few,
            many,
            other;

            public static final int LENGTH;
            public static final List<Count> VALUES;

            static {
                LENGTH = Count.values().length;
                VALUES = Collections.unmodifiableList(Arrays.asList(Count.values()));
            }
        }
    }

    public static class CountSampleList {
        private final Map<PluralInfo.Count, SampleList> countToIntegerSamples9999 = new EnumMap<PluralInfo.Count, SampleList>(PluralInfo.Count.class);
        private final Map<PluralInfo.Count, SampleList[]> countToDigitToIntegerSamples9999 = new EnumMap<PluralInfo.Count, SampleList[]>(PluralInfo.Count.class);
        static final int MAX_COLLECTED_FRACTION = 5;

        CountSampleList(PluralRules pluralRules, Set<PluralInfo.Count> keywords, PluralType pluralType) {
            for (PluralInfo.Count c : keywords) {
                this.countToIntegerSamples9999.put(c, new SampleList());
                SampleList[] row = new SampleList[5];
                this.countToDigitToIntegerSamples9999.put(c, row);
                for (int i = 1; i < 5; ++i) {
                    row[i] = new SampleList();
                }
            }
            for (int ii = 0; ii < 10000; ++ii) {
                int i = ii;
                int digit = i > 999 ? 4 : (i > 99 ? 3 : (i > 9 ? 2 : 1));
                PluralInfo.Count count = PluralInfo.Count.valueOf(pluralRules.select(i));
                this.addSimple(this.countToIntegerSamples9999, i, count);
                this.addDigit(this.countToDigitToIntegerSamples9999, i, count, digit);
                if (this.haveFractions(keywords, digit) || pluralType != PluralType.cardinal) continue;
                for (int f = 0; f < 30; ++f) {
                    PluralRules.FixedDecimal ni = new PluralRules.FixedDecimal((double)i + (double)f / 10.0, f < 10 ? 1 : 2, f);
                    count = PluralInfo.Count.valueOf(pluralRules.select(ni));
                    this.addSimple(this.countToIntegerSamples9999, ni, count);
                    this.addDigit(this.countToDigitToIntegerSamples9999, ni, count, digit);
                }
            }
            this.addSimple(this.countToIntegerSamples9999, 1000000, PluralInfo.Count.valueOf(pluralRules.select(1000000.0)));
            for (PluralInfo.Count count : keywords) {
                SampleList uset = this.countToIntegerSamples9999.get((Object)count);
                uset.freeze();
                SampleList[] map = this.countToDigitToIntegerSamples9999.get((Object)count);
                for (int i = 1; i < map.length; ++i) {
                    map[i].freeze();
                }
            }
        }

        private boolean haveFractions(Set<PluralInfo.Count> keywords, int digit) {
            for (PluralInfo.Count c : keywords) {
                int size = this.countToDigitToIntegerSamples9999.get((Object)c)[digit].fractionSize();
                if (size >= 5) continue;
                return false;
            }
            return true;
        }

        private boolean addDigit(Map<PluralInfo.Count, SampleList[]> countToDigitToIntegerSamples9999, PluralRules.FixedDecimal i, PluralInfo.Count count, int digit) {
            return this.addFraction(i, countToDigitToIntegerSamples9999.get((Object)count)[digit]);
        }

        private boolean addFraction(PluralRules.FixedDecimal i, SampleList sampleList) {
            if (sampleList.fractionSize() < 5) {
                sampleList.add(i);
                return true;
            }
            return false;
        }

        private boolean addSimple(Map<PluralInfo.Count, SampleList> countToIntegerSamples9999, PluralRules.FixedDecimal i, PluralInfo.Count count) {
            return this.addFraction(i, countToIntegerSamples9999.get((Object)count));
        }

        private void addDigit(Map<PluralInfo.Count, SampleList[]> countToDigitToIntegerSamples9999, int i, PluralInfo.Count count, int digit) {
            countToDigitToIntegerSamples9999.get((Object)count)[digit].add(i);
        }

        private void addSimple(Map<PluralInfo.Count, SampleList> countToIntegerSamples9999, int i, PluralInfo.Count count) {
            countToIntegerSamples9999.get((Object)count).add(i);
        }

        public SampleList get(PluralInfo.Count type) {
            return this.countToIntegerSamples9999.get((Object)type);
        }

        public SampleList get(PluralInfo.Count c, int digit) {
            SampleList[] sampleLists = this.countToDigitToIntegerSamples9999.get((Object)c);
            return sampleLists == null ? null : sampleLists[digit];
        }
    }

    public static class SampleList {
        public static final SampleList EMPTY = new SampleList().freeze();
        private UnicodeSet uset = new UnicodeSet();
        private List<PluralRules.FixedDecimal> fractions = new ArrayList<PluralRules.FixedDecimal>(0);

        public String toString() {
            return this.toString(6, 3);
        }

        public String toString(int intLimit, int fractionLimit) {
            int i;
            StringBuilder b = new StringBuilder();
            int intCount = 0;
            int fractionCount = 0;
            int limit = this.uset.getRangeCount();
            for (i = 0; i < limit; ++i) {
                int end;
                int start;
                if (intCount >= intLimit) {
                    b.append(", \u2026");
                    break;
                }
                if (b.length() != 0) {
                    b.append(", ");
                }
                if ((start = this.uset.getRangeStart(i)) == (end = this.uset.getRangeEnd(i))) {
                    b.append(start);
                    ++intCount;
                    continue;
                }
                if (start + 1 == end) {
                    b.append(start).append(", ").append(end);
                    intCount += 2;
                    continue;
                }
                b.append(start).append('-').append(end);
                intCount += 2;
            }
            if (this.fractions.size() > 0) {
                for (i = 0; i < this.fractions.size() && fractionCount < fractionLimit; ++fractionCount, ++i) {
                    if (b.length() != 0) {
                        b.append(", ");
                    }
                    PluralRules.FixedDecimal fraction = this.fractions.get(i);
                    String formatted = String.format(Locale.ROOT, "%." + fraction.getVisibleDecimalDigitCount() + "f", fraction.getSource());
                    b.append(formatted);
                }
                b.append(", \u2026");
            }
            return b.toString();
        }

        public int getRangeCount() {
            return this.uset.getRangeCount();
        }

        public int getRangeStart(int index) {
            return this.uset.getRangeStart(index);
        }

        public int getRangeEnd(int index) {
            return this.uset.getRangeEnd(index);
        }

        public List<PluralRules.FixedDecimal> getFractions() {
            return this.fractions;
        }

        public int intSize() {
            return this.uset.size();
        }

        public SampleList remove(int i) {
            this.uset.remove(i);
            return this;
        }

        public SampleList add(int i) {
            this.uset.add(i);
            return this;
        }

        public SampleList freeze() {
            this.uset.freeze();
            if (this.fractions instanceof ArrayList) {
                this.fractions = Collections.unmodifiableList(this.fractions);
            }
            return this;
        }

        public void add(PluralRules.FixedDecimal i) {
            this.fractions.add(i);
        }

        public int fractionSize() {
            return this.fractions.size();
        }
    }

    public static enum PluralType {
        cardinal(PluralRules.PluralType.CARDINAL),
        ordinal(PluralRules.PluralType.ORDINAL);

        public final PluralRules.PluralType standardType;

        private PluralType(PluralRules.PluralType standardType) {
            this.standardType = standardType;
        }

        public static PluralType fromStandardType(PluralRules.PluralType standardType) {
            return standardType == null ? null : (standardType == PluralRules.PluralType.CARDINAL ? cardinal : ordinal);
        }
    }

    public static final class ApprovalRequirementMatcher {
        private final Set<CLDRLocale> locales;
        private final Pattern xpathMatcher;
        final int requiredVotes;

        public String toString() {
            return this.locales + " / " + this.xpathMatcher + " = " + this.requiredVotes;
        }

        ApprovalRequirementMatcher(String xpath) {
            XPathValue parts = SimpleXPathParts.getFrozenInstance(xpath);
            if (parts.containsElement("approvalRequirement")) {
                this.requiredVotes = ApprovalRequirementMatcher.getRequiredVotes(parts);
                String localeAttrib = parts.getAttributeValue(-1, "locales");
                if (localeAttrib == null || localeAttrib.equals(SupplementalDataInfo.STAR) || localeAttrib.isEmpty()) {
                    this.locales = null;
                } else {
                    HashSet<CLDRLocale> localeList = new HashSet<CLDRLocale>();
                    String[] el = localeAttrib.split(" ");
                    for (int i = 0; i < el.length; ++i) {
                        if (el[i].indexOf(":") == -1) {
                            localeList.add(CLDRLocale.getInstance(el[i]));
                            continue;
                        }
                        String[] coverageLocaleParts = el[i].split(":", 2);
                        String org = coverageLocaleParts[0];
                        String level = coverageLocaleParts[1].toUpperCase();
                        Set<String> coverageLocales = sc.getLocaleCoverageLocales(Organization.fromString(org), EnumSet.of(Level.fromString(level)));
                        for (String cl : coverageLocales) {
                            localeList.add(CLDRLocale.getInstance(cl));
                        }
                    }
                    this.locales = Collections.unmodifiableSet(localeList);
                }
                String xpathMatch = parts.getAttributeValue(-1, "paths");
                this.xpathMatcher = xpathMatch == null || xpathMatch.isEmpty() || xpathMatch.equals(SupplementalDataInfo.STAR) ? null : PatternCache.get(xpathMatch);
            } else {
                throw new RuntimeException("Unknown approval requirement: " + xpath);
            }
        }

        static int getRequiredVotes(XPathValue parts) {
            String votesStr = parts.getAttributeValue(-1, "votes");
            if (votesStr.charAt(0) == '=') {
                if ((votesStr = votesStr.substring(1)).equals("HIGH_BAR")) {
                    return VoteResolver.HIGH_BAR;
                }
                if (votesStr.equals("LOWER_BAR")) {
                    return VoteResolver.LOWER_BAR;
                }
                VoteResolver.Level l = VoteResolver.Level.valueOf(votesStr);
                return l.getVotes(Organization.unaffiliated);
            }
            return Integer.parseInt(votesStr);
        }

        public static List<ApprovalRequirementMatcher> buildAll(List<String> approvalRequirements) {
            LinkedList<ApprovalRequirementMatcher> newList = new LinkedList<ApprovalRequirementMatcher>();
            for (String xpath : approvalRequirements) {
                newList.add(new ApprovalRequirementMatcher(xpath));
            }
            return Collections.unmodifiableList(newList);
        }

        public boolean matches(CLDRLocale loc, PathHeader ph) {
            if (this.locales != null && !this.locales.contains(loc)) {
                return false;
            }
            if (this.xpathMatcher != null) {
                if (ph != null) {
                    return this.xpathMatcher.matcher(ph.getOriginalPath()).matches();
                }
                return false;
            }
            return true;
        }

        public int getRequiredVotes() {
            return this.requiredVotes;
        }
    }

    public static enum ParentLocaleComponent {
        main,
        collations,
        segmentations,
        grammaticalFeatures,
        plurals;


        public static ParentLocaleComponent fromString(String s2) {
            return s2 == null ? main : ParentLocaleComponent.valueOf(s2);
        }
    }

    private class CoverageCache {
        private final Deque<Node> localeList = new LinkedList<Node>();
        private final int MAX_LOCALES = 10;
        private final Object LOCALE_LIST_ITER_SYNC = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Level get(String xpath, String loc) {
            Object object = this.LOCALE_LIST_ITER_SYNC;
            synchronized (object) {
                Iterator<Node> it = this.localeList.iterator();
                Node reAddNode = null;
                while (it.hasNext()) {
                    Node node = it.next();
                    if (!node.loc.equals(loc)) continue;
                    reAddNode = node;
                    it.remove();
                    break;
                }
                if (reAddNode != null) {
                    this.localeList.addFirst(reAddNode);
                    return reAddNode.map.get(xpath);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(String xpath, String loc, Level covLevel) {
            Object object = this.LOCALE_LIST_ITER_SYNC;
            synchronized (object) {
                for (Node node : this.localeList) {
                    if (!node.loc.equals(loc)) continue;
                    node.map.put(xpath, covLevel);
                    return;
                }
                ConcurrentHashMap<String, Level> newMap = new ConcurrentHashMap<String, Level>();
                newMap.put(xpath, covLevel);
                this.localeList.addFirst(new Node(loc, newMap));
                if (this.localeList.size() > 10) {
                    this.localeList.removeLast();
                }
            }
        }

        private class Node {
            public String loc;
            public Map<String, Level> map;

            public Node(String _loc, Map<String, Level> _map) {
                this.loc = _loc;
                this.map = _map;
            }
        }
    }

    public static enum ContainmentStyle {
        all,
        core,
        grouping,
        deprecated;

    }

    public class CoverageVariableInfo {
        public Set<String> targetScripts;
        public Set<String> targetTerritories;
        public Set<String> calendars;
        public Set<String> targetCurrencies;
        public Set<String> targetTimeZones;
        public Set<String> targetPlurals;
    }

    class MyHandler
    extends XMLFileReader.SimpleHandler {
        private static final double MAX_POPULATION = 3.0E9;
        LanguageTagParser languageTagParser = null;
        public static final String NONLIKELYSCRIPT = "nonlikelyScript";

        MyHandler() {
        }

        public void cleanup() {
            if (SupplementalDataInfo.this.lastPluralMap.size() > 0) {
                SupplementalDataInfo.this.addPluralInfo(SupplementalDataInfo.this.lastPluralWasOrdinal);
            }
            SupplementalDataInfo.this.lastPluralLocales = "";
        }

        @Override
        public void handlePathValue(String path, String value) {
            try {
                String skipKey;
                String level3;
                XPathValue parts = SimpleXPathParts.getFrozenInstance(path);
                String level0 = parts.getElement(0);
                String level1 = parts.size() < 2 ? null : parts.getElement(1);
                String level2 = parts.size() < 3 ? null : parts.getElement(2);
                String string = level3 = parts.size() < 4 ? null : parts.getElement(3);
                if (level1.equals("generation")) {
                    return;
                }
                if (level1.equals("version")) {
                    if (SupplementalDataInfo.this.cldrVersion == null) {
                        String version = parts.getAttributeValue(1, "cldrVersion");
                        if (version == null) {
                            version = parts.getAttributeValue(0, "version");
                        }
                        SupplementalDataInfo.this.cldrVersionString = version;
                        SupplementalDataInfo.this.cldrVersion = VersionInfo.getInstance(version);
                        SupplementalDataInfo.this.unicodeVersion = parts.getAttributeValue(1, "unicodeVersion");
                    }
                    return;
                }
                if (level0.equals("ldmlBCP47")) {
                    if (this.handleBcp47(level1, parts)) {
                        return;
                    }
                } else if (level1.equals("territoryInfo")) {
                    if (this.handleTerritoryInfo(parts)) {
                        return;
                    }
                } else {
                    if (level1.equals("calendarPreferenceData")) {
                        this.handleCalendarPreferenceData(parts);
                        return;
                    }
                    if (level1.equals("languageData")) {
                        this.handleLanguageData(parts);
                        return;
                    }
                    if (level1.equals("territoryContainment")) {
                        this.handleTerritoryContainment(parts);
                        return;
                    }
                    if (level1.equals("subdivisionContainment")) {
                        this.handleSubdivisionContainment(parts);
                        return;
                    }
                    if (level1.equals("currencyData")) {
                        if (this.handleCurrencyData(level2, parts)) {
                            return;
                        }
                    } else if ("metazoneInfo".equals(level2)) {
                        if (this.handleMetazoneInfo(level3, parts)) {
                            return;
                        }
                    } else if ("mapTimezones".equals(level2)) {
                        if (this.handleMetazoneData(level3, parts)) {
                            return;
                        }
                    } else if (level1.equals("plurals")) {
                        if (SupplementalDataInfo.this.addPluralPath(parts, value)) {
                            return;
                        }
                    } else {
                        if (level1.equals("dayPeriodRuleSet")) {
                            SupplementalDataInfo.this.addDayPeriodPath(parts);
                            return;
                        }
                        if (level1.equals("telephoneCodeData")) {
                            this.handleTelephoneCodeData(parts);
                            return;
                        }
                        if (level1.equals("references")) {
                            String type = parts.getAttributeValue(-1, "type");
                            String uri = parts.getAttributeValue(-1, "uri");
                            SupplementalDataInfo.this.references.put(type, (Pair<String, String>)new Pair<String, String>(uri, value).freeze());
                            return;
                        }
                        if (level1.equals("likelySubtags")) {
                            this.handleLikelySubtags(parts);
                            return;
                        }
                        if (level1.equals("numberingSystems")) {
                            this.handleNumberingSystems(parts);
                            return;
                        }
                        if (level1.equals("coverageLevels")) {
                            this.handleCoverageLevels(parts);
                            return;
                        }
                        if (level1.equals("parentLocales")) {
                            this.handleParentLocales(parts);
                            return;
                        }
                        if (level1.equals("metadata") ? this.handleMetadata(level2, value, parts) : (level1.equals("codeMappings") ? this.handleCodeMappings(level2, parts) : (level1.equals("languageMatching") ? this.handleLanguageMatcher(parts) : (level1.equals("measurementData") ? this.handleMeasurementData(level2, parts) : (level1.equals("unitIdComponents") ? this.handleUnitUnitIdComponents(parts) : (level1.equals("unitPrefixes") ? this.handleUnitPrefix(parts) : (level1.equals("unitConstants") ? this.handleUnitConstants(parts) : (level1.equals("unitQuantities") ? this.handleUnitQuantities(parts) : (level1.equals("convertUnits") ? this.handleUnitConversion(parts) : (level1.equals("unitPreferenceData") ? this.handleUnitPreferences(parts, value) : (level1.equals("timeData") ? this.handleTimeData(parts) : (level1.equals("languageGroups") ? this.handleLanguageGroups(value, parts) : (level1.contentEquals("grammaticalData") ? this.handleGrammaticalData(value, parts) : level1.contentEquals("personNamesDefaults") && this.handlePersonNamesDefaults(value, parts)))))))))))))) {
                            return;
                        }
                    }
                }
                if (!SupplementalDataInfo.this.skippedElements.contains(skipKey = level1 + (String)(level2 == null ? "" : "/" + level2))) {
                    SupplementalDataInfo.this.skippedElements.add(skipKey);
                }
            }
            catch (Exception e) {
                throw (IllegalArgumentException)new IllegalArgumentException("Exception while processing path: " + path + ",\tvalue: " + value).initCause(e);
            }
        }

        private boolean handleUnitPrefix(XPathValue parts) {
            String power2;
            String power10 = parts.getAttributeValue(-1, "power10");
            if (power10 != null == ((power2 = parts.getAttributeValue(-1, "power2")) != null)) {
                throw new IllegalArgumentException("Must have exactly one @power2 or @power10");
            }
            SupplementalDataInfo.this.unitPrefixInfo.put(parts.getAttributeValue(-1, "type"), new UnitPrefixInfo(parts.getAttributeValue(-1, "symbol"), power10 != null ? 10 : 2, Integer.parseInt(power10 != null ? power10 : power2)));
            return true;
        }

        private boolean handlePersonNamesDefaults(String value, XPathValue parts) {
            SupplementalDataInfo.this.personNameOrder.putAll(PersonNameFormatter.Order.from(parts.getAttributeValue(-1, "order")), split_space.split(value));
            return true;
        }

        private boolean handleUnitUnitIdComponents(XPathValue parts) {
            UnitIdComponentType type = UnitIdComponentType.valueOf(parts.getAttributeValue(-1, "type"));
            for (String value : split_space.split(parts.getAttributeValue(-1, "values"))) {
                UnitIdComponentType old = SupplementalDataInfo.this.unitIdComponentType.put(value, type);
                if (old == null) continue;
                throw new IllegalArgumentException("Duplicate component: " + value);
            }
            return true;
        }

        private boolean handleGrammaticalData(String value, XPathValue parts) {
            for (String locale : split_space.split(parts.getAttributeValue(2, "locales"))) {
                block4 : switch (parts.getElement(2)) {
                    case "grammaticalFeatures": {
                        GrammarInfo targetToFeatureToValues = SupplementalDataInfo.this.grammarLocaleToTargetToFeatureToValues.get(locale);
                        if (targetToFeatureToValues == null) {
                            targetToFeatureToValues = new GrammarInfo();
                            SupplementalDataInfo.this.grammarLocaleToTargetToFeatureToValues.put(locale, targetToFeatureToValues);
                        }
                        String targets = parts.getAttributeValue(2, "targets");
                        if (parts.size() < 4) {
                            targetToFeatureToValues.add(targets, null, null, null);
                            break;
                        }
                        targetToFeatureToValues.add(targets, parts.getElement(3), parts.getAttributeValue(3, "scope"), parts.getAttributeValue(3, "values"));
                        break;
                    }
                    case "grammaticalDerivations": {
                        String feature = parts.getAttributeValue(3, "feature");
                        String structure = parts.getAttributeValue(3, "structure");
                        GrammarDerivation grammarCompoundDerivation = SupplementalDataInfo.this.localeToGrammarDerivation.get(locale);
                        if (grammarCompoundDerivation == null) {
                            grammarCompoundDerivation = new GrammarDerivation();
                            SupplementalDataInfo.this.localeToGrammarDerivation.put(locale, grammarCompoundDerivation);
                        }
                        switch (parts.getElement(3)) {
                            case "deriveCompound": {
                                grammarCompoundDerivation.add(feature, structure, parts.getAttributeValue(3, "value"));
                                break block4;
                            }
                            case "deriveComponent": {
                                grammarCompoundDerivation.add(feature, structure, parts.getAttributeValue(3, "value0"), parts.getAttributeValue(3, "value1"));
                                break block4;
                            }
                        }
                        throw new IllegalArgumentException("Structure not handled: " + parts);
                    }
                    default: {
                        throw new IllegalArgumentException("Structure not handled: " + parts);
                    }
                }
            }
            return true;
        }

        private boolean handleUnitPreferences(XPathValue parts, String value) {
            String geq = parts.getAttributeValue(-1, "geq");
            String small = parts.getAttributeValue(-2, "scope");
            if (small != null) {
                geq = "0.1234";
            }
            SupplementalDataInfo.this.unitPreferences.add(parts.getAttributeValue(-2, "category"), parts.getAttributeValue(-2, "usage"), parts.getAttributeValue(-1, "regions"), geq, parts.getAttributeValue(-1, "skeleton"), value);
            return true;
        }

        private boolean handleLanguageGroups(String value, XPathValue parts) {
            String parent = parts.getAttributeValue(-1, "parent");
            List<String> children = WHITESPACE_SPLITTER.splitToList(value);
            SupplementalDataInfo.this.languageGroups.putAll(parent, children);
            return true;
        }

        private boolean handleMeasurementData(String level2, XPathValue parts) {
            MeasurementType measurementType = MeasurementType.valueOf(level2);
            String type = parts.getAttributeValue(-1, "type");
            String territories = parts.getAttributeValue(-1, "territories");
            Map<String, String> data = SupplementalDataInfo.this.measurementData.get((Object)measurementType);
            if (data == null) {
                data = new HashMap<String, String>();
                SupplementalDataInfo.this.measurementData.put(measurementType, data);
            }
            for (String territory : territories.trim().split("\\s+")) {
                data.put(territory, type);
            }
            return true;
        }

        private boolean handleUnitConstants(XPathValue parts) {
            String constant = parts.getAttributeValue(-1, "constant");
            String value = parts.getAttributeValue(-1, "value");
            String status = parts.getAttributeValue(-1, "status");
            SupplementalDataInfo.this.rationalParser.addConstant(constant, value, status);
            return true;
        }

        private boolean handleUnitQuantities(XPathValue parts) {
            String baseUnit = parts.getAttributeValue(-1, "baseUnit");
            String quantity = parts.getAttributeValue(-1, "quantity");
            String status = parts.getAttributeValue(-1, "status");
            if (SupplementalDataInfo.this.unitConverter == null) {
                SupplementalDataInfo.this.unitConverter = new UnitConverter(SupplementalDataInfo.this.rationalParser, SupplementalDataInfo.this.validity, x -> SupplementalDataInfo.this.getUnitIdComponentType((String)x));
            }
            SupplementalDataInfo.this.unitConverter.addQuantityInfo(baseUnit, quantity, status);
            return true;
        }

        private boolean handleUnitConversion(XPathValue parts) {
            String source = parts.getAttributeValue(-1, "source");
            String target = parts.getAttributeValue(-1, "baseUnit");
            String factor = parts.getAttributeValue(-1, "factor");
            String offset = parts.getAttributeValue(-1, "offset");
            String special = parts.getAttributeValue(-1, "special");
            String systems = parts.getAttributeValue(-1, "systems");
            SupplementalDataInfo.this.unitConverter.addRaw(source, target, factor, offset, special, systems);
            return true;
        }

        private boolean handleTimeData(XPathValue parts) {
            String preferred = parts.getAttributeValue(-1, "preferred");
            PreferredAndAllowedHour preferredAndAllowedHour = new PreferredAndAllowedHour(preferred, parts.getAttributeValue(-1, "allowed"));
            for (String region : parts.getAttributeValue(-1, "regions").trim().split("\\s+")) {
                PreferredAndAllowedHour oldValue = SupplementalDataInfo.this.timeData.put(region, preferredAndAllowedHour);
                if (oldValue == null) continue;
                throw new IllegalArgumentException("timeData/hours must not have duplicate regions: " + region);
            }
            return true;
        }

        private boolean handleBcp47(String level1, XPathValue parts) {
            if (level1.equals("version") || level1.equals("generation") || level1.equals("cldrVersion")) {
                return true;
            }
            if (!level1.equals("keyword")) {
                throw new IllegalArgumentException("Unexpected level1 element: " + level1);
            }
            String finalElement = parts.getElement(-1);
            String key = parts.getAttributeValue(2, "name");
            String extension = parts.getAttributeValue(2, "extension");
            if (extension == null) {
                extension = "u";
            }
            SupplementalDataInfo.this.bcp47Extension2Keys.put(extension, key);
            String keyAlias = parts.getAttributeValue(2, "alias");
            String keyDescription = parts.getAttributeValue(2, "description");
            String deprecated = parts.getAttributeValue(2, "deprecated");
            Row.R2 key_empty = (Row.R2)Row.of(key, "").freeze();
            if (keyAlias != null) {
                SupplementalDataInfo.this.bcp47Aliases.putAll(key_empty, Arrays.asList(keyAlias.trim().split("\\s+")));
            }
            if (keyDescription != null) {
                SupplementalDataInfo.this.bcp47Descriptions.put(key_empty, keyDescription);
            }
            if (deprecated != null && deprecated.equals("true")) {
                SupplementalDataInfo.this.bcp47Deprecated.put(key_empty, deprecated);
            }
            switch (finalElement) {
                case "key": {
                    break;
                }
                case "type": {
                    String subtype = parts.getAttributeValue(3, "name");
                    String subtypeAlias = parts.getAttributeValue(3, "alias");
                    String desc = parts.getAttributeValue(3, "description");
                    String subtypeDescription = desc == null ? null : desc.replaceAll("\\s+", " ");
                    String subtypeSince = parts.getAttributeValue(3, "since");
                    String subtypePreferred = parts.getAttributeValue(3, "preferred");
                    String subtypeDeprecated = parts.getAttributeValue(3, "deprecated");
                    String valueType = parts.getAttributeValue(3, "deprecated");
                    Set<String> set = SupplementalDataInfo.this.bcp47Key2Subtypes.get(key);
                    if (set != null && set.contains(key)) {
                        throw new IllegalArgumentException("Collision with bcp47 key-value: " + key + "," + subtype);
                    }
                    SupplementalDataInfo.this.bcp47Key2Subtypes.put(key, subtype);
                    Row.R2 key_subtype = (Row.R2)Row.of(key, subtype).freeze();
                    if (subtypeAlias != null) {
                        SupplementalDataInfo.this.bcp47Aliases.putAll(key_subtype, Arrays.asList(subtypeAlias.trim().split("\\s+")));
                    }
                    if (subtypeDescription != null) {
                        SupplementalDataInfo.this.bcp47Descriptions.put(key_subtype, subtypeDescription.replaceAll("\\s+", " "));
                    }
                    if (subtypeSince != null) {
                        SupplementalDataInfo.this.bcp47Since.put(key_subtype, subtypeSince);
                    }
                    if (subtypePreferred != null) {
                        SupplementalDataInfo.this.bcp47Preferred.put(key_subtype, subtypePreferred);
                    }
                    if (subtypeDeprecated != null) {
                        SupplementalDataInfo.this.bcp47Deprecated.put(key_subtype, subtypeDeprecated);
                    }
                    if (valueType == null) break;
                    SupplementalDataInfo.this.bcp47ValueType.put(subtype, valueType);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected element: " + finalElement);
                }
            }
            return true;
        }

        private boolean handleLanguageMatcher(XPathValue parts) {
            Object type = parts.getAttributeValue(2, "type");
            String alt = parts.getAttributeValue(2, "alt");
            if (alt != null) {
                type = (String)type + "_" + alt;
            }
            switch (parts.getElement(3)) {
                case "paradigmLocales": {
                    List<String> locales = WHITESPACE_SPLITTER.splitToList(parts.getAttributeValue(3, "locales"));
                    break;
                }
                case "matchVariable": {
                    break;
                }
                case "languageMatch": {
                    List<Row.R4<String, String, Integer, Boolean>> matches = SupplementalDataInfo.this.languageMatch.get(type);
                    if (matches == null) {
                        matches = new ArrayList<Row.R4<String, String, Integer, Boolean>>();
                        SupplementalDataInfo.this.languageMatch.put((String)type, matches);
                    }
                    String percent = parts.getAttributeValue(3, "percent");
                    String distance = parts.getAttributeValue(3, "distance");
                    matches.add(Row.of(parts.getAttributeValue(3, "desired"), parts.getAttributeValue(3, "supported"), percent != null ? Integer.parseInt(percent) : 100 - Integer.parseInt(distance), "true".equals(parts.getAttributeValue(3, "oneway"))));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown element");
                }
            }
            return true;
        }

        private boolean handleCodeMappings(String level2, XPathValue parts) {
            if (level2.equals("territoryCodes")) {
                String alpha3;
                String type = parts.getAttributeValue(-1, "type");
                String numeric = parts.getAttributeValue(-1, "numeric");
                if (numeric != null) {
                    SupplementalDataInfo.this.numericTerritoryMapping.put(type, Integer.parseInt(numeric));
                }
                if ((alpha3 = parts.getAttributeValue(-1, "alpha3")) != null) {
                    SupplementalDataInfo.this.alpha3TerritoryMapping.put(type, alpha3);
                }
                return true;
            }
            if (level2.equals("currencyCodes")) {
                String type = parts.getAttributeValue(-1, "type");
                String numeric = parts.getAttributeValue(-1, "numeric");
                if (numeric != null) {
                    SupplementalDataInfo.this.numericCurrencyCodeMapping.put(type, Integer.parseInt(numeric));
                }
                return true;
            }
            return false;
        }

        private void handleNumberingSystems(XPathValue parts) {
            NumberingSystemInfo ns = new NumberingSystemInfo(parts);
            SupplementalDataInfo.this.numberingSystems.put(ns.name, ns);
            if (ns.type == NumberingSystemInfo.NumberingSystemType.numeric) {
                SupplementalDataInfo.this.numericSystems.add(ns.name);
            }
        }

        private void handleCoverageLevels(XPathValue parts) {
            if (parts.containsElement("approvalRequirement")) {
                SupplementalDataInfo.this.approvalRequirements.add(parts.toString());
            } else if (parts.containsElement("coverageLevel")) {
                Integer value;
                String match = parts.containsAttribute("match") ? SupplementalDataInfo.this.coverageVariables.replace(parts.getAttributeValue(-1, "match")) : null;
                String valueStr = parts.getAttributeValue(-1, "value");
                valueStr = Integer.toString(Level.get(valueStr).getLevel());
                String inLanguage = parts.containsAttribute("inLanguage") ? SupplementalDataInfo.this.coverageVariables.replace(parts.getAttributeValue(-1, "inLanguage")) : null;
                String inScript = parts.containsAttribute("inScript") ? SupplementalDataInfo.this.coverageVariables.replace(parts.getAttributeValue(-1, "inScript")) : null;
                String inTerritory = parts.containsAttribute("inTerritory") ? SupplementalDataInfo.this.coverageVariables.replace(parts.getAttributeValue(-1, "inTerritory")) : null;
                Integer n = value = valueStr != null ? Integer.valueOf(valueStr) : Integer.valueOf("101");
                if (SupplementalDataInfo.this.cldrVersion.getMajor() < 2) {
                    value = 40;
                }
                CoverageLevelInfo ci = new CoverageLevelInfo(match, value, inLanguage, inScript, inTerritory);
                SupplementalDataInfo.this.coverageLevels.add(ci);
            } else if (parts.containsElement("coverageVariable")) {
                String key = parts.getAttributeValue(-1, "key");
                String value = parts.getAttributeValue(-1, "value");
                SupplementalDataInfo.this.coverageVariables.add(key, value);
            }
        }

        private void handleParentLocales(XPathValue parts) {
            String componentsString = parts.getAttributeValue(1, "component");
            Set<ParentLocaleComponent> components = componentsString == null ? ImmutableSet.of(ParentLocaleComponent.main) : split_space.splitToStream(componentsString).map(x -> ParentLocaleComponent.fromString(x)).collect(Collectors.toSet());
            if (!parts.getElement(-1).equals("parentLocale")) {
                return;
            }
            String parent = parts.getAttributeValue(-1, "parent");
            String locales = parts.getAttributeValue(-1, "locales");
            String localeRules = parts.getAttributeValue(-1, "localeRules");
            Set localeRuleSet = localeRules == null ? Set.of() : Set.copyOf(split_space.splitToList(localeRules));
            for (ParentLocaleComponent component : components) {
                Map<String, String> componentParentLocales = SupplementalDataInfo.this.parentLocales.get((Object)component);
                if (localeRuleSet.contains(NONLIKELYSCRIPT)) {
                    SupplementalDataInfo.this.parentLocalesSkipNonLikely.add(component);
                    continue;
                }
                for (String childLocale : split_space.split(locales)) {
                    String old = componentParentLocales.put(childLocale, parent);
                    if (old == null) continue;
                    throw new IllegalArgumentException("Locale " + childLocale + " cannot have two parents: " + old + " and " + parent);
                }
            }
        }

        private void handleCalendarPreferenceData(XPathValue parts) {
            String territoryString = parts.getAttributeValue(-1, "territories");
            String orderingString = parts.getAttributeValue(-1, "ordering");
            String[] calendars = orderingString.split(" ");
            String[] territories = territoryString.split(" ");
            List<String> calendarList = Arrays.asList(calendars);
            for (int i = 0; i < territories.length; ++i) {
                SupplementalDataInfo.this.calendarPreferences.put(territories[i], calendarList);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void handleLikelySubtags(XPathValue parts) {
            String from = parts.getAttributeValue(-1, "from");
            String to = parts.getAttributeValue(-1, "to");
            String origin = parts.getAttributeValue(-1, "origin");
            String toOld = SupplementalDataInfo.this.likelySubtags.get(from);
            if (toOld != null) {
                if (!to.equals(toOld)) throw new IllegalArgumentException("Likely subtags duplicate from=" + from + ", overrides values: " + toOld + " with " + to);
                System.err.println("Likely subtags repeats from=" + from + " to= " + to);
                return;
            } else {
                SupplementalDataInfo.this.likelySubtags.put(from, to);
                if (origin == null) return;
                SupplementalDataInfo.this.likelyOrigins.put(from, origin);
            }
        }

        private boolean handleMetazoneData(String level3, XPathValue parts) {
            if (level3.equals("mapZone")) {
                Map<String, String> regionToZone;
                String maintype = parts.getAttributeValue(2, "type");
                if (maintype == null) {
                    maintype = "windows";
                }
                String mzone = parts.getAttributeValue(3, "other");
                String region = parts.getAttributeValue(3, "territory");
                String zone = parts.getAttributeValue(3, "type");
                Map<String, Map<String, String>> zoneToRegionToZone = SupplementalDataInfo.this.typeToZoneToRegionToZone.get(maintype);
                if (zoneToRegionToZone == null) {
                    zoneToRegionToZone = new TreeMap<String, Map<String, String>>();
                    SupplementalDataInfo.this.typeToZoneToRegionToZone.put(maintype, zoneToRegionToZone);
                }
                if ((regionToZone = zoneToRegionToZone.get(mzone)) == null) {
                    regionToZone = new TreeMap<String, String>();
                    zoneToRegionToZone.put(mzone, regionToZone);
                }
                if (region != null) {
                    regionToZone.put(region, zone);
                }
                if (maintype.equals("metazones")) {
                    if (mzone != null && region.equals("001")) {
                        SupplementalDataInfo.this.metazoneContinentMap.put(mzone, zone.substring(0, zone.indexOf("/")));
                    }
                    SupplementalDataInfo.this.allMetazones.add(mzone);
                }
                return true;
            }
            return false;
        }

        private Collection<String> getSpaceDelimited(int index, String attribute, Collection<String> defaultValue, XPathValue parts) {
            String temp = parts.getAttributeValue(index, attribute);
            Collection<String> elements = temp == null ? defaultValue : Arrays.asList(temp.split("\\s+"));
            return elements;
        }

        private boolean handleMetazoneInfo(String level3, XPathValue parts) {
            if (level3.equals("timezone")) {
                String zone = parts.getAttributeValue(3, "type");
                String mzone = parts.getAttributeValue(4, "mzone");
                String from = parts.getAttributeValue(4, "from");
                String to = parts.getAttributeValue(4, "to");
                MetaZoneRange mzoneRange = new MetaZoneRange(mzone, from, to);
                SupplementalDataInfo.this.zoneToMetaZoneRanges.put(zone, mzoneRange);
                return true;
            }
            return false;
        }

        private boolean handleMetadata(String level2, String value, XPathValue parts) {
            if (parts.containsElement("defaultContent")) {
                String defContent = parts.getAttributeValue(-1, "locales").trim();
                String[] defLocales = defContent.split("\\s+");
                SupplementalDataInfo.this.defaultContentLocales = Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList(defLocales)));
                return true;
            }
            if (level2.equals("alias")) {
                String level3 = parts.getElement(3);
                if (!level3.endsWith("Alias")) {
                    throw new IllegalArgumentException();
                }
                Map<String, Row.R2<List<String>, String>> tagToReplacement = SupplementalDataInfo.this.typeToTagToReplacement.get(level3 = level3.substring(0, level3.length() - "Alias".length()));
                if (tagToReplacement == null) {
                    tagToReplacement = new TreeMap<String, Row.R2<List<String>, String>>();
                    SupplementalDataInfo.this.typeToTagToReplacement.put(level3, tagToReplacement);
                }
                String replacement = parts.getAttributeValue(3, "replacement");
                ImmutableList replacementList = null;
                if (replacement != null) {
                    LinkedHashSet<String> builder = new LinkedHashSet<String>();
                    for (String item : replacement.split("\\s+")) {
                        String cleaned = SubdivisionNames.isOldSubdivisionCode(item) ? replacement.replace("-", "").toLowerCase(Locale.ROOT) : item;
                        builder.add(cleaned);
                    }
                    replacementList = ImmutableList.copyOf(builder);
                }
                String reason = parts.getAttributeValue(3, "reason");
                String cleanTag = parts.getAttributeValue(3, "type");
                tagToReplacement.put(cleanTag, (Row.R2)Row.of(replacementList, reason).freeze());
                return true;
            }
            if (level2.equals("validity")) {
                String level3 = parts.getElement(3);
                if (level3.equals("variable")) {
                    Map<String, String> attributes = parts.getAttributes(-1);
                    String idString = attributes.get("id");
                    String typeString = attributes.get("type");
                    SupplementalDataInfo.this.validityInfo.put(idString, Row.of(typeString, value));
                    if ("choice".equals(typeString)) {
                        String[] validCodeArray;
                        if ("$language".equals(idString) || "$languageNonTcGeqBasic".equals(idString)) {
                            validCodeArray = value.trim().split("\\s+");
                            SupplementalDataInfo.this.CLDRLanguageCodes.addAll(Arrays.asList(validCodeArray));
                        }
                        if ("$languageNonTcLtBasic".equals(idString)) {
                            validCodeArray = value.trim().split("\\s+");
                            List<String> asList = Arrays.asList(validCodeArray);
                            SupplementalDataInfo.this.languageNonTcLtBasic.addAll(asList);
                            SupplementalDataInfo.this.CLDRLanguageCodes.addAll(asList);
                        }
                    }
                    return true;
                }
                if (level3.equals("attributeValues")) {
                    String dtdsValue = parts.getAttributeValue(-1, "dtds");
                    if (!"keyboard".equals(dtdsValue) && !"platform".equals(dtdsValue)) {
                        AttributeValidityInfo.add(parts.getAttributes(-1), value, SupplementalDataInfo.this.attributeValidityInfo);
                    }
                    return true;
                }
            } else {
                String level3;
                if (level2.equals("serialElements")) {
                    SupplementalDataInfo.this.serialElements = Arrays.asList(value.trim().split("\\s+"));
                    return true;
                }
                if (level2.equals("distinguishing") && (level3 = parts.getElement(3)).equals("distinguishingItems")) {
                    Map<String, String> attributes = parts.getAttributes(-1);
                    if (attributes.containsKey("exclude") && "true".equals(attributes.get("exclude"))) {
                        return false;
                    }
                    SupplementalDataInfo.this.distinguishingAttributes = Collections.unmodifiableCollection(this.getSpaceDelimited(-1, "attributes", STAR_SET, parts));
                    return true;
                }
            }
            return false;
        }

        private boolean handleTerritoryInfo(XPathValue parts) {
            Map<String, String> territoryAttributes = parts.getAttributes(2);
            String territory = territoryAttributes.get("type");
            double territoryPopulation = this.parseDouble(territoryAttributes.get("population"));
            if (this.failsRangeCheck("population", territoryPopulation, 0.0, 3.0E9)) {
                return true;
            }
            double territoryLiteracyPercent = this.parseDouble(territoryAttributes.get("literacyPercent"));
            double territoryGdp = this.parseDouble(territoryAttributes.get("gdp"));
            if (SupplementalDataInfo.this.territoryToPopulationData.get(territory) == null) {
                SupplementalDataInfo.this.territoryToPopulationData.put(territory, new PopulationData().setPopulation(territoryPopulation).setLiteratePopulation(territoryLiteracyPercent * territoryPopulation / 100.0).setGdp(territoryGdp));
            }
            if (parts.size() > 3) {
                String baseLanguage;
                double writingPercent;
                Map<String, String> languageInTerritoryAttributes = parts.getAttributes(3);
                String language = languageInTerritoryAttributes.get("type");
                double languageLiteracyPercent = this.parseDouble(languageInTerritoryAttributes.get("literacyPercent"));
                if (Double.isNaN(languageLiteracyPercent)) {
                    languageLiteracyPercent = territoryLiteracyPercent;
                }
                if (Double.isNaN(writingPercent = this.parseDouble(languageInTerritoryAttributes.get("writingPercent")))) {
                    writingPercent = languageLiteracyPercent;
                }
                double languagePopulationPercent = this.parseDouble(languageInTerritoryAttributes.get("populationPercent"));
                double languagePopulation = languagePopulationPercent * territoryPopulation / 100.0;
                Map<String, PopulationData> territoryLanguageToPopulation = SupplementalDataInfo.this.territoryToLanguageToPopulationData.get(territory);
                if (territoryLanguageToPopulation == null) {
                    territoryLanguageToPopulation = new TreeMap<String, PopulationData>();
                    SupplementalDataInfo.this.territoryToLanguageToPopulationData.put(territory, territoryLanguageToPopulation);
                }
                OfficialStatus officialStatus = OfficialStatus.unknown;
                String officialStatusString = languageInTerritoryAttributes.get("officialStatus");
                if (officialStatusString != null) {
                    officialStatus = OfficialStatus.valueOf(officialStatusString);
                }
                PopulationData newData = new PopulationData().setPopulation(languagePopulation).setLiteratePopulation(languageLiteracyPercent * languagePopulation / 100.0).setWritingPopulation(writingPercent * languagePopulation / 100.0).setOfficialStatus(officialStatus);
                newData.freeze();
                if (territoryLanguageToPopulation.get(language) != null) {
                    System.out.println("Internal Problem in supplementalData: multiple data items for " + language + ", " + territory + "\tSkipping " + newData);
                    return true;
                }
                territoryLanguageToPopulation.put(language, newData);
                SupplementalDataInfo.this.languageToTerritories2.put(language, Pair.of(!newData.getOfficialStatus().isMajor(), Pair.of(-newData.getLiteratePopulation(), territory)));
                PopulationData data = SupplementalDataInfo.this.languageToPopulation.get(language);
                if (data == null) {
                    data = new PopulationData().set(newData);
                    SupplementalDataInfo.this.languageToPopulation.put(language, data);
                } else {
                    data.add(newData);
                }
                if (this.languageTagParser == null) {
                    this.languageTagParser = new LanguageTagParser();
                }
                if ((data = SupplementalDataInfo.this.baseLanguageToPopulation.get(baseLanguage = this.languageTagParser.set(language).getLanguage())) == null) {
                    data = new PopulationData().set(newData);
                    SupplementalDataInfo.this.baseLanguageToPopulation.put(baseLanguage, data);
                } else {
                    data.add(newData);
                }
                if (!baseLanguage.equals(language)) {
                    SupplementalDataInfo.this.languageToScriptVariants.put(baseLanguage, language);
                }
            }
            return true;
        }

        private boolean handleCurrencyData(String level2, XPathValue parts) {
            if (level2.equals("fractions")) {
                SupplementalDataInfo.this.currencyToCurrencyNumberInfo.put(parts.getAttributeValue(3, "iso4217"), new CurrencyNumberInfo(SupplementalDataInfo.this.parseIntegerOrNull(parts.getAttributeValue(3, "digits")), SupplementalDataInfo.this.parseIntegerOrNull(parts.getAttributeValue(3, "rounding")), SupplementalDataInfo.this.parseIntegerOrNull(parts.getAttributeValue(3, "cashDigits")), SupplementalDataInfo.this.parseIntegerOrNull(parts.getAttributeValue(3, "cashRounding"))));
                return true;
            }
            if (level2.equals("region")) {
                SupplementalDataInfo.this.territoryToCurrencyDateInfo.put(parts.getAttributeValue(2, "iso3166"), new CurrencyDateInfo(parts.getAttributeValue(3, "iso4217"), parts.getAttributeValue(3, "from"), parts.getAttributeValue(3, "to"), parts.getAttributeValue(3, "tender")));
                return true;
            }
            return false;
        }

        private void handleTelephoneCodeData(XPathValue parts) {
            String terr = parts.getAttributeValue(2, "territory");
            TelephoneCodeInfo tcInfo = new TelephoneCodeInfo(parts.getAttributeValue(3, "code"), parts.getAttributeValue(3, "from"), parts.getAttributeValue(3, "to"), parts.getAttributeValue(3, "alt"));
            Set<TelephoneCodeInfo> tcSet = SupplementalDataInfo.this.territoryToTelephoneCodeInfo.get(terr);
            if (tcSet == null) {
                tcSet = new LinkedHashSet<TelephoneCodeInfo>();
                SupplementalDataInfo.this.territoryToTelephoneCodeInfo.put(terr, tcSet);
            }
            tcSet.add(tcInfo);
        }

        private void handleTerritoryContainment(XPathValue parts) {
            String container = parts.getAttributeValue(-1, "type");
            List<String> contained = Arrays.asList(parts.getAttributeValue(-1, "contains").split("\\s+"));
            SupplementalDataInfo.this.containment.putAll(container, contained);
            String status = parts.getAttributeValue(-1, "status");
            String grouping = parts.getAttributeValue(-1, "grouping");
            if (status == null && grouping == null) {
                SupplementalDataInfo.this.containmentCore.putAll(container, contained);
            }
            if (status != null && status.equals("deprecated")) {
                SupplementalDataInfo.this.containmentDeprecated.putAll(container, contained);
            }
            if (grouping != null) {
                SupplementalDataInfo.this.containmentGrouping.putAll(container, contained);
            }
        }

        private void handleSubdivisionContainment(XPathValue parts) {
            String country = parts.getAttributeValue(-1, "type");
            String subtype = parts.getAttributeValue(-1, "subtype");
            String container = subtype == null ? country : (country + subtype).toLowerCase(Locale.ROOT);
            for (String contained : parts.getAttributeValue(-1, "contains").split("\\s+")) {
                String newContained = contained.charAt(0) >= 'a' ? contained : (country + contained).toLowerCase(Locale.ROOT);
                SupplementalDataInfo.this.containerToSubdivision.put(container, newContained);
            }
        }

        private void handleLanguageData(XPathValue parts) {
            String language = parts.getAttributeValue(2, "type");
            BasicLanguageData languageData = new BasicLanguageData();
            languageData.setType(parts.getAttributeValue(2, "alt") == null ? BasicLanguageData.Type.primary : BasicLanguageData.Type.secondary);
            languageData.setScriptsWithoutPopulation(parts.getAttributeValue(2, "scripts")).setTerritories(parts.getAttributeValue(2, "territories"));
            Map<BasicLanguageData.Type, BasicLanguageData> map = SupplementalDataInfo.this.languageToBasicLanguageData.get(language);
            if (map == null) {
                map = new EnumMap<BasicLanguageData.Type, BasicLanguageData>(BasicLanguageData.Type.class);
                SupplementalDataInfo.this.languageToBasicLanguageData.put(language, map);
            }
            if (map.containsKey((Object)languageData.type)) {
                throw new IllegalArgumentException("Duplicate value:\t" + parts);
            }
            map.put(languageData.type, languageData);
        }

        private boolean failsRangeCheck(String path, double input, double min2, double max) {
            if (input >= min2 && input <= max) {
                return false;
            }
            System.out.println("Internal Problem in supplementalData: range check fails for " + input + ", min: " + min2 + ", max:" + max + "\t" + path);
            return false;
        }

        private double parseDouble(String literacyString) {
            return literacyString == null ? Double.NaN : Double.parseDouble(literacyString);
        }
    }

    public static class Bcp47KeyInfo {
        final String description;
        final VersionInfo since;
        final String preferred;
        final boolean deprecated;
        final Set<String> aliases;

        public Bcp47KeyInfo(Set<String> aliases, String description, String since, String preferred, String deprecated) {
            this.description = description;
            this.deprecated = deprecated != null && !deprecated.equals("false");
            this.preferred = preferred;
            this.since = since == null ? null : VersionInfo.getInstance(since);
            this.aliases = aliases;
        }

        public String toString() {
            return String.format("{description=\u00ab%s\u00bb since=%s preferred=%s deprecated=%s aliases=%s}", this.description, this.since, this.preferred, this.deprecated, this.aliases);
        }
    }

    public static final class SupplementalDataInfoHelper {
        static SupplementalDataInfo SINGLETON = CLDRConfig.getInstance().getSupplementalDataInfo();
    }

    public static enum MeasurementType {
        measurementSystem,
        paperSize;

    }

    public static enum RBNFGroup {
        SpelloutRules,
        OrdinalRules,
        NumberingSystemRules;

    }

    public static class CoverageLevelInfo {
        public final String match;
        public final Level value;
        public final Pattern inLanguage;
        public final String inScript;
        public final Set<String> inScriptSet;
        public final String inTerritory;
        public final Set<String> inTerritorySet;
        private Set<String> inTerritorySetInternal;
        public static final Pattern NON_ASCII_LETTER = PatternCache.get("[^A-Za-z]+");

        public CoverageLevelInfo(String match, int value, String language, String script, String territory) {
            this.inLanguage = language != null ? PatternCache.get(language) : null;
            this.inScript = script;
            this.inTerritory = territory;
            this.inScriptSet = this.toSet(script);
            this.inTerritorySet = this.toSet(territory);
            this.match = match;
            this.value = Level.fromLevel(value);
        }

        private Set<String> toSet(String source) {
            if (source == null) {
                return null;
            }
            HashSet<String> result = new HashSet<String>(Arrays.asList(NON_ASCII_LETTER.split(source)));
            result.remove("");
            this.inTerritorySetInternal = result;
            return Collections.unmodifiableSet(result);
        }

        public static void fixEU(Collection<CoverageLevelInfo> targets, SupplementalDataInfo info) {
            Set<String> euCountries = info.getContained("EU");
            for (CoverageLevelInfo item : targets) {
                if (item.inTerritorySet == null || !item.inTerritorySet.contains("EU")) continue;
                item.inTerritorySetInternal.addAll(euCountries);
            }
        }
    }

    public static class TelephoneCodeInfo
    implements Comparable<TelephoneCodeInfo> {
        public static final Date END_OF_TIME = new Date(Long.MAX_VALUE);
        public static final Date START_OF_TIME = new Date(Long.MIN_VALUE);
        private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        private String code;
        private Date start;
        private Date end;
        private String alt;
        private String errors = "";
        static DateFormat[] simpleFormats = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyy-MM"), new SimpleDateFormat("yyyy")};

        public TelephoneCodeInfo(String code, String startDate, String endDate, String alt) {
            if (code == null) {
                throw new NullPointerException();
            }
            this.code = code;
            this.start = this.parseDate(startDate, START_OF_TIME);
            this.end = this.parseDate(endDate, END_OF_TIME);
            this.alt = alt == null ? "" : alt;
        }

        Date parseDate(String dateString, Date defaultDate) {
            if (dateString == null) {
                return defaultDate;
            }
            ParseException e2 = null;
            for (int i = 0; i < simpleFormats.length; ++i) {
                try {
                    Date result = simpleFormats[i].parse(dateString);
                    return result;
                }
                catch (ParseException e) {
                    if (i == 0) {
                        this.errors = this.errors + dateString + " ";
                    }
                    if (e2 != null) continue;
                    e2 = e;
                    continue;
                }
            }
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(e2);
        }

        public String getCode() {
            return this.code;
        }

        public Date getStart() {
            return this.start;
        }

        public Date getEnd() {
            return this.end;
        }

        public String getAlt() {
            return this.alt;
        }

        public String getErrors() {
            return this.errors;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TelephoneCodeInfo)) {
                return false;
            }
            TelephoneCodeInfo tc = (TelephoneCodeInfo)o;
            return tc.code.equals(this.code) && tc.start.equals(this.start) && tc.end.equals(this.end) && tc.alt.equals(this.alt);
        }

        public int hashCode() {
            return 31 * this.code.hashCode() + this.start.hashCode() + this.end.hashCode() + this.alt.hashCode();
        }

        @Override
        public int compareTo(TelephoneCodeInfo o) {
            int result = this.code.compareTo(o.code);
            if (result != 0) {
                return result;
            }
            result = this.start.compareTo(o.start);
            if (result != 0) {
                return result;
            }
            result = this.end.compareTo(o.end);
            if (result != 0) {
                return result;
            }
            return this.alt.compareTo(o.alt);
        }

        public String toString() {
            return "{" + this.code + ", " + TelephoneCodeInfo.formatDate(this.start) + ", " + TelephoneCodeInfo.formatDate(this.end) + ", " + this.alt + "}";
        }

        public static String formatDate(Date date) {
            if (date.equals(START_OF_TIME)) {
                return "-\u221e";
            }
            if (date.equals(END_OF_TIME)) {
                return "\u221e";
            }
            return dateFormat.format(date);
        }
    }

    public static final class MetaZoneRange
    implements Comparable<MetaZoneRange> {
        public final DateRange dateRange;
        public final String metazone;

        public MetaZoneRange(String metazone, String fromString, String toString) {
            this.metazone = metazone;
            this.dateRange = new DateRange(fromString, toString);
        }

        @Override
        public int compareTo(MetaZoneRange arg0) {
            int result = this.dateRange.compareTo(arg0.dateRange);
            if (0 != result) {
                return result;
            }
            return this.metazone.compareTo(arg0.metazone);
        }

        public String toString() {
            return "{" + this.dateRange + ", " + this.metazone + "}";
        }
    }

    public static class CurrencyDateInfo
    implements Comparable<CurrencyDateInfo> {
        public static final Date END_OF_TIME = new Date(Long.MAX_VALUE);
        public static final Date START_OF_TIME = new Date(Long.MIN_VALUE);
        private String currency;
        private DateRange dateRange;
        private boolean isLegalTender;
        private String errors = "";

        public CurrencyDateInfo(String currency, String startDate, String endDate, String tender) {
            this.currency = currency;
            this.dateRange = new DateRange(startDate, endDate);
            this.isLegalTender = tender == null || !tender.equals("false");
        }

        public String getCurrency() {
            return this.currency;
        }

        public Date getStart() {
            return new Date(this.dateRange.getFrom());
        }

        public Date getEnd() {
            return new Date(this.dateRange.getTo());
        }

        public String getErrors() {
            return this.errors;
        }

        public boolean isLegalTender() {
            return this.isLegalTender;
        }

        @Override
        public int compareTo(CurrencyDateInfo o) {
            if (this.isLegalTender && !o.isLegalTender) {
                return -1;
            }
            if (!this.isLegalTender && o.isLegalTender) {
                return 1;
            }
            int result = this.dateRange.compareTo(o.dateRange);
            if (result != 0) {
                return -result;
            }
            return this.currency.compareTo(o.currency);
        }

        public String toString() {
            return "{" + this.dateRange + ", " + this.currency + "}";
        }

        public static String formatDate(Date date) {
            return DateRange.formatDate(date.getTime());
        }
    }

    public static final class DateRange
    implements Comparable<DateRange> {
        public static final long START_OF_TIME = Long.MIN_VALUE;
        public static final long END_OF_TIME = Long.MAX_VALUE;
        public final long from;
        public final long to;
        static final DateFormat[] simpleFormats = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm"), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyy-MM"), new SimpleDateFormat("yyyy")};

        public DateRange(String fromString, String toString) {
            this.from = this.parseDate(fromString, Long.MIN_VALUE);
            this.to = this.parseDate(toString, Long.MAX_VALUE);
        }

        public long getFrom() {
            return this.from;
        }

        public long getTo() {
            return this.to;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long parseDate(String dateString, long defaultDate) {
            if (dateString == null) {
                return defaultDate;
            }
            ParseException e2 = null;
            for (int i = 0; i < simpleFormats.length; ++i) {
                try {
                    DateFormat dateFormat = simpleFormats[i];
                    synchronized (dateFormat) {
                        Date result = simpleFormats[i].parse(dateString);
                        return result.getTime();
                    }
                }
                catch (ParseException e) {
                    if (e2 != null) continue;
                    e2 = e;
                    continue;
                }
            }
            throw new IllegalArgumentException(e2);
        }

        public String toString() {
            return "{" + DateRange.formatDate(this.from) + ", " + DateRange.formatDate(this.to) + "}";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String formatDate(long date) {
            if (date == Long.MIN_VALUE) {
                return "-\u221e";
            }
            if (date == Long.MAX_VALUE) {
                return "\u221e";
            }
            DateFormat dateFormat = simpleFormats[0];
            synchronized (dateFormat) {
                return simpleFormats[0].format(date);
            }
        }

        @Override
        public int compareTo(DateRange arg0) {
            return this.to > arg0.to ? 1 : (this.to < arg0.to ? -1 : (this.from > arg0.from ? 1 : (this.from < arg0.from ? -1 : 0)));
        }

        static {
            TimeZone gmt = TimeZone.getTimeZone("GMT");
            for (DateFormat format : simpleFormats) {
                format.setTimeZone(gmt);
            }
        }
    }

    public static class NumberingSystemInfo {
        public final String name;
        public final NumberingSystemType type;
        public final String digits;
        public final String rules;

        public NumberingSystemInfo(XPathValue parts) {
            this.name = parts.getAttributeValue(-1, "id");
            this.digits = parts.getAttributeValue(-1, "digits");
            this.rules = parts.getAttributeValue(-1, "rules");
            this.type = NumberingSystemType.valueOf(parts.getAttributeValue(-1, "type"));
        }

        public static enum NumberingSystemType {
            algorithmic,
            numeric,
            unknown;

        }
    }

    public static class CurrencyNumberInfo {
        public final int digits;
        public final int rounding;
        public final double roundingIncrement;
        public final int cashDigits;
        public final int cashRounding;
        public final double cashRoundingIncrement;

        public int getDigits() {
            return this.digits;
        }

        public int getRounding() {
            return this.rounding;
        }

        public double getRoundingIncrement() {
            return this.roundingIncrement;
        }

        public CurrencyNumberInfo(int _digits, int _rounding, int _cashDigits, int _cashRounding) {
            this.digits = _digits;
            this.rounding = _rounding < 0 ? 0 : _rounding;
            this.roundingIncrement = (double)this.rounding * Math.pow(10.0, -this.digits);
            this.cashDigits = _cashDigits < 0 ? this.digits : _cashDigits;
            this.cashRounding = _cashRounding < 0 ? this.rounding : _cashRounding;
            this.cashRoundingIncrement = (double)this.cashRounding * Math.pow(10.0, -this.digits);
        }
    }

    public static class BasicLanguageData
    implements Comparable<BasicLanguageData>,
    Freezable<BasicLanguageData> {
        private Type type = Type.primary;
        private Set<String> scripts = Collections.emptySet();
        private Map<String, Integer> scriptsByPopulation = new TreeMap<String, Integer>();
        private Set<String> territories = Collections.emptySet();
        boolean frozen = false;

        public Type getType() {
            return this.type;
        }

        public BasicLanguageData setType(Type type) {
            this.type = type;
            return this;
        }

        public BasicLanguageData setScriptsWithoutPopulation(String scriptTokens) {
            return this.setScriptsWithoutPopulation(scriptTokens == null ? null : WHITESPACE_SPLITTER.splitToList(scriptTokens));
        }

        public BasicLanguageData setScriptsWithoutPopulation(Collection<String> scripts) {
            TreeMap<String, Integer> scriptsByPopulation = new TreeMap<String, Integer>();
            if (scripts != null) {
                for (String script : scripts) {
                    scriptsByPopulation.put(script, 0);
                }
            }
            return this.setScripts(scriptsByPopulation);
        }

        public BasicLanguageData setTerritories(String territoryTokens) {
            return this.setTerritories(territoryTokens == null ? null : WHITESPACE_SPLITTER.splitToList(territoryTokens));
        }

        public BasicLanguageData setScripts(Map<String, Integer> newScripts) {
            if (this.frozen) {
                throw new UnsupportedOperationException();
            }
            this.scripts = Collections.emptySet();
            this.scriptsByPopulation = new TreeMap<String, Integer>();
            if (newScripts != null) {
                this.addScripts(newScripts);
            }
            return this;
        }

        public BasicLanguageData setTerritories(Collection<String> territoryTokens) {
            if (this.frozen) {
                throw new UnsupportedOperationException();
            }
            this.territories = Collections.emptySet();
            if (territoryTokens != null) {
                for (String territory : territoryTokens) {
                    this.addTerritory(territory);
                }
            }
            return this;
        }

        public BasicLanguageData set(BasicLanguageData other) {
            this.scripts = other.scripts;
            this.territories = other.territories;
            return this;
        }

        public Set<String> getScripts() {
            return this.scripts;
        }

        public Set<String> getTerritories() {
            return this.territories;
        }

        public String toString(String languageSubtag) {
            if (this.scripts.size() == 0 && this.territories.size() == 0) {
                return "";
            }
            List sortedScripts = this.scriptsByPopulation.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).map(Map.Entry::getKey).collect(Collectors.toList());
            return "\t\t<language type=\"" + languageSubtag + "\"" + (String)(this.scripts.size() == 0 ? "" : " scripts=\"" + CldrUtility.join(sortedScripts, " ") + "\"") + (String)(this.territories.size() == 0 ? "" : " territories=\"" + CldrUtility.join(this.territories, " ") + "\"") + (String)(this.type == Type.primary ? "" : " alt=\"" + this.type + "\"") + "/>";
        }

        public String toString() {
            return "[" + this.type + (String)(this.scripts.isEmpty() ? "" : "; scripts=" + Joiner.on(" ").join(this.scripts)) + (String)(this.scripts.isEmpty() ? "" : "; territories=" + Joiner.on(" ").join(this.territories)) + "]";
        }

        @Override
        public int compareTo(BasicLanguageData o) {
            int result = this.type.compareTo(o.type);
            if (0 != result) {
                return result;
            }
            result = IterableComparator.compareIterables(this.scripts, o.scripts);
            if (0 != result) {
                return result;
            }
            result = IterableComparator.compareIterables(this.territories, o.territories);
            if (0 != result) {
                return result;
            }
            return 0;
        }

        public boolean equals(Object input) {
            return this.compareTo((BasicLanguageData)input) == 0;
        }

        public int hashCode() {
            return (this.type.ordinal() * 37 + this.scripts.hashCode()) * 37 + this.territories.hashCode();
        }

        public BasicLanguageData addScript(String script, Integer population) {
            if (script.length() != 4) {
                throw new IllegalArgumentException("Illegal Script: " + script);
            }
            if (this.scripts == Collections.EMPTY_SET) {
                this.scripts = new LinkedHashSet<String>();
                this.scriptsByPopulation = new TreeMap<String, Integer>();
            }
            this.scripts.add(script);
            Integer currentPopulation = this.scriptsByPopulation.get(script);
            if (currentPopulation == null) {
                this.scriptsByPopulation.put(script, population);
            } else if (population > 0) {
                this.scriptsByPopulation.put(script, population);
            }
            return this;
        }

        public BasicLanguageData addTerritory(String territory) {
            if (territory.length() != 2) {
                throw new IllegalArgumentException("Illegal Territory: " + territory);
            }
            if (this.territories == Collections.EMPTY_SET) {
                this.territories = new LinkedHashSet<String>();
            }
            this.territories.add(territory);
            return this;
        }

        @Override
        public boolean isFrozen() {
            return this.frozen;
        }

        @Override
        public BasicLanguageData freeze() {
            this.frozen = true;
            if (this.scripts != Collections.EMPTY_SET) {
                this.scripts = Collections.unmodifiableSet(this.scripts);
            }
            if (this.territories != Collections.EMPTY_SET) {
                this.territories = Collections.unmodifiableSet(this.territories);
            }
            return this;
        }

        @Override
        public BasicLanguageData cloneAsThawed() {
            BasicLanguageData result = new BasicLanguageData();
            result.scripts = new TreeSet<String>(this.scripts);
            result.territories = new TreeSet<String>(this.territories);
            return this;
        }

        private void addScripts(Map<String, Integer> newScripts) {
            for (Map.Entry<String, Integer> entry : newScripts.entrySet()) {
                this.addScript(entry.getKey(), entry.getValue());
            }
        }

        public static enum Type {
            primary,
            secondary;

        }
    }

    public static final class PopulationData
    implements Freezable<PopulationData> {
        private double population = Double.NaN;
        private double literatePopulation = Double.NaN;
        private double writingPopulation = Double.NaN;
        private double gdp = Double.NaN;
        private OfficialStatus officialStatus = OfficialStatus.unknown;
        private boolean frozen;

        public double getGdp() {
            return this.gdp;
        }

        public double getLiteratePopulation() {
            return this.literatePopulation;
        }

        public double getLiteratePopulationPercent() {
            return 100.0 * this.literatePopulation / this.population;
        }

        public double getWritingPopulation() {
            return this.writingPopulation;
        }

        public double getWritingPercent() {
            return 100.0 * this.writingPopulation / this.population;
        }

        public double getPopulation() {
            return this.population;
        }

        public PopulationData setGdp(double gdp) {
            if (this.frozen) {
                throw new UnsupportedOperationException("Attempt to modify frozen object");
            }
            this.gdp = gdp;
            return this;
        }

        public PopulationData setLiteratePopulation(double literatePopulation) {
            if (this.frozen) {
                throw new UnsupportedOperationException("Attempt to modify frozen object");
            }
            this.literatePopulation = literatePopulation;
            return this;
        }

        public PopulationData setPopulation(double population) {
            if (this.frozen) {
                throw new UnsupportedOperationException("Attempt to modify frozen object");
            }
            this.population = population;
            return this;
        }

        public PopulationData set(PopulationData other) {
            if (this.frozen) {
                throw new UnsupportedOperationException("Attempt to modify frozen object");
            }
            if (other == null) {
                this.gdp = Double.NaN;
                this.literatePopulation = Double.NaN;
                this.population = Double.NaN;
            } else {
                this.population = other.population;
                this.literatePopulation = other.literatePopulation;
                this.writingPopulation = other.writingPopulation;
                this.gdp = other.gdp;
            }
            return this;
        }

        public void add(PopulationData other) {
            if (this.frozen) {
                throw new UnsupportedOperationException("Attempt to modify frozen object");
            }
            this.population += other.population;
            this.literatePopulation += other.literatePopulation;
            this.writingPopulation += other.writingPopulation;
            this.gdp += other.gdp;
        }

        public String toString() {
            return MessageFormat.format("[pop: {0,number,#,##0},\t lit: {1,number,#,##0.00},\t gdp: {2,number,#,##0},\t status: {3}]", new Object[]{this.population, this.literatePopulation, this.gdp, this.officialStatus});
        }

        @Override
        public boolean isFrozen() {
            return this.frozen;
        }

        @Override
        public PopulationData freeze() {
            this.frozen = true;
            return this;
        }

        @Override
        public PopulationData cloneAsThawed() {
            throw new UnsupportedOperationException("not yet implemented");
        }

        public OfficialStatus getOfficialStatus() {
            return this.officialStatus;
        }

        public PopulationData setOfficialStatus(OfficialStatus officialStatus) {
            if (this.frozen) {
                throw new UnsupportedOperationException("Attempt to modify frozen object");
            }
            this.officialStatus = officialStatus;
            return this;
        }

        public PopulationData setWritingPopulation(double writingPopulation) {
            if (this.frozen) {
                throw new UnsupportedOperationException("Attempt to modify frozen object");
            }
            this.writingPopulation = writingPopulation;
            return this;
        }
    }

    public static enum OfficialStatus {
        unknown("U", 1),
        recognized("R", 1),
        official_minority("OM", 2),
        official_regional("OR", 3),
        de_facto_official("OD", 10),
        official("O", 10);

        private final String shortName;
        private final int weight;

        private OfficialStatus(String shortName, int weight) {
            this.shortName = shortName;
            this.weight = weight;
        }

        public String toShortString() {
            return this.shortName;
        }

        public int getWeight() {
            return this.weight;
        }

        public boolean isMajor() {
            return this.compareTo(de_facto_official) >= 0;
        }

        public boolean isOfficial() {
            return this.compareTo(official_regional) >= 0;
        }
    }

    public class UnitPrefixInfo {
        final String abbreviation;
        final int base;
        final int power;

        public UnitPrefixInfo(String abbreviation, int base, int power) {
            this.abbreviation = abbreviation;
            this.base = base;
            this.power = power;
        }

        public String toString() {
            return String.format("%s\t%s", this.abbreviation, String.valueOf(this.base) + "^" + String.valueOf(this.power));
        }
    }

    public static enum UnitIdComponentType {
        prefix,
        base,
        suffix,
        per,
        and,
        power;


        public String toShortId() {
            return this.name().substring(0, 1).toUpperCase();
        }
    }
}

