/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.BoilerplateUtilities;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.MapComparator;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.XEquivalenceClass;

public class ZoneParser {
    static final boolean DEBUG = false;
    private String version;
    private Map<String, String> zone_to_country;
    private Map<String, Set<String>> country_to_zoneSet;
    Map<String, List<String>> zoneData;
    Set<String> skippedAliases = new TreeSet<String>();
    static final String[] months = new String[]{"january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"};
    static final String[] weekdays = new String[]{"sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"};
    static Pattern dayPattern = PatternCache.get("([0-9]+)|(last)([a-z]+)|([a-z]+)([<=>]+)([0-9]+)");
    static final String[] relations = new String[]{"<=", ">="};
    Map<String, List<RuleLine>> ruleID_rules = new TreeMap<String, List<RuleLine>>();
    Map<String, List<ZoneLine>> zone_rules = new TreeMap<String, List<ZoneLine>>();
    Map<String, String> linkold_new = new TreeMap<String, String>();
    Map<String, Set<String>> linkNew_oldSet = new TreeMap<String, Set<String>>();
    private static List<String> errorData = Arrays.asList(String.valueOf(Double.MIN_VALUE), String.valueOf(Double.MIN_VALUE), "");
    private Comparator<String> TZIDComparator = new Comparator<String>(){
        Map<String, List<String>> data;
        {
            this.data = ZoneParser.this.getZoneData();
        }

        @Override
        public int compare(String s1, String s2) {
            Double d2;
            String country2;
            List<String> data1 = this.getData(s1);
            List<String> data2 = this.getData(s2);
            String country1 = data1.get(2);
            int result = country1.compareTo(country2 = data2.get(2));
            if (result != 0) {
                return result;
            }
            Double d1 = Double.valueOf(data1.get(1));
            result = d1.compareTo(d2 = Double.valueOf(data2.get(1)));
            if (result != 0) {
                return result;
            }
            d1 = Double.valueOf(data1.get(0));
            result = d1.compareTo(d2 = Double.valueOf(data2.get(0)));
            if (result != 0) {
                return result;
            }
            return s1.compareTo(s2);
        }

        private List<String> getData(String s2) {
            List<String> d = this.data.get(s2);
            if (d == null) {
                String sNew = ZoneParser.this.linkold_new.get(s2);
                if (sNew != null) {
                    d = this.data.get(sNew);
                }
                if (d == null) {
                    d = errorData;
                }
            }
            return d;
        }
    };
    public static MapComparator<String> regionalCompare = new MapComparator();
    private static String[] TZFiles;
    private static Map<String, String> FIX_UNSTABLE_TZIDS;
    private static Set<String> SKIP_LINKS;
    private static Set<String> PREFERRED_BASES;
    private static String[][] ADD_ZONE_ALIASES_DATA;
    static String[] FIX_DEPRECATED_ZONE_DATA;
    static final String[][] SUPPLEMENTAL_ZONE_ID_DATA;

    public Map<String, String> getZoneToCountry() {
        if (this.zone_to_country == null) {
            this.make_zone_to_country();
        }
        return this.zone_to_country;
    }

    public Map<String, Set<String>> getCountryToZoneSet() {
        if (this.country_to_zoneSet == null) {
            this.make_zone_to_country();
        }
        return this.country_to_zoneSet;
    }

    public Map<String, List<String>> getZoneData() {
        if (this.zoneData == null) {
            this.makeZoneData();
        }
        return this.zoneData;
    }

    public List<String> getDeprecatedZoneIDs() {
        return Arrays.asList(FIX_DEPRECATED_ZONE_DATA);
    }

    private void make_zone_to_country() {
        this.zone_to_country = new TreeMap<String, String>(this.TZIDComparator);
        this.country_to_zoneSet = new TreeMap<String, Set<String>>();
        Map<String, List<String>> zoneData = this.getZoneData();
        for (String zone : zoneData.keySet()) {
            String country = zoneData.get(zone).get(2);
            this.zone_to_country.put(zone, country);
            Set<String> s2 = this.country_to_zoneSet.get(country);
            if (s2 == null) {
                s2 = new TreeSet<String>();
                this.country_to_zoneSet.put(country, s2);
            }
            s2.add(zone);
        }
        this.zone_to_country = Collections.unmodifiableMap(this.zone_to_country);
        this.country_to_zoneSet = CldrUtility.protectCollection(this.country_to_zoneSet);
    }

    static int parseYear(String year, int defaultValue) {
        if ("only".startsWith(year)) {
            return defaultValue;
        }
        if ("minimum".startsWith(year)) {
            return Integer.MIN_VALUE;
        }
        if ("maximum".startsWith(year)) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(year);
    }

    static int findStartsWith(String value, String[] array, boolean exact) {
        value = value.toLowerCase(Locale.ENGLISH);
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].startsWith(value)) continue;
            return i;
        }
        throw new IllegalArgumentException("Can't find " + value + " in " + Arrays.asList(months));
    }

    public TransitionList getTransitions(String zoneID, int startYear, int endYear) {
        TransitionList results = new TransitionList();
        List<ZoneLine> rules = this.zone_rules.get(zoneID);
        ZoneLine lastZoneLine = null;
        for (ZoneLine zoneLine : rules) {
            results.addTransitions(lastZoneLine, zoneLine, startYear, endYear);
            lastZoneLine = zoneLine;
        }
        return results;
    }

    public Comparator<String> getTZIDComparator() {
        return this.TZIDComparator;
    }

    private void makeZoneData() {
        try {
            int i;
            String line;
            BufferedReader versionIn = CldrUtility.getUTF8Data("tzdb-version.txt");
            this.version = versionIn.readLine();
            if (!this.version.matches("[0-9]{4}[a-z]")) {
                throw new IllegalArgumentException(String.format("Bad Version number: %s, should be of the form 2007x", this.version));
            }
            versionIn.close();
            String deg = "([+-])([0-9][0-9][0-9]?)([0-9][0-9])([0-9][0-9])?";
            Matcher m4 = PatternCache.get(deg + deg).matcher("");
            this.zoneData = new TreeMap<String, List<String>>();
            BufferedReader in = CldrUtility.getUTF8Data("zone.tab");
            while ((line = in.readLine()) != null) {
                int pos = (line = line.trim()).indexOf(35);
                if (pos >= 0) {
                    this.skippedAliases.add(line);
                    line = line.substring(0, pos).trim();
                }
                if (line.length() == 0) continue;
                List<String> pieces = CldrUtility.splitList(line, '\t', true);
                String country = pieces.get(0);
                String latLong = pieces.get(1);
                String tzid = pieces.get(2);
                String ntzid = FIX_UNSTABLE_TZIDS.get(tzid);
                if (ntzid != null) {
                    tzid = ntzid;
                }
                String comment = pieces.size() < 4 ? null : pieces.get(3);
                pieces.clear();
                if (!m4.reset(latLong).matches()) {
                    throw new IllegalArgumentException("Bad zone.tab, lat/long format: " + line);
                }
                pieces.add(this.getDegrees(m4, true).toString());
                pieces.add(this.getDegrees(m4, false).toString());
                pieces.add(country);
                if (comment != null) {
                    pieces.add(comment);
                }
                if (this.zoneData.containsKey(tzid)) {
                    throw new IllegalArgumentException("Bad zone.tab, duplicate entry: " + line);
                }
                this.zoneData.put(tzid, pieces);
            }
            in.close();
            for (int i2 = -14; i2 <= 12; ++i2) {
                ArrayList<String> pieces = new ArrayList<String>();
                boolean latitude = false;
                int longitude = i2 * 15;
                if (longitude <= -180) {
                    longitude += 360;
                }
                pieces.add(Double.toString((double)latitude));
                pieces.add(Double.toString(-longitude));
                pieces.add("001");
                this.zoneData.put("Etc/GMT" + (String)(i2 == 0 ? "" : (i2 < 0 ? "" + i2 : "+" + i2)), pieces);
            }
            ArrayList<String> pieces = new ArrayList<String>();
            pieces.add(Double.toString(0.0));
            pieces.add(Double.toString(0.0));
            pieces.add("001");
            this.zoneData.put("Etc/Unknown", pieces);
            this.zoneData.put("Etc/UTC", pieces);
            for (String[] zoneEntry : SUPPLEMENTAL_ZONE_ID_DATA) {
                ArrayList<String> zarray = new ArrayList<String>();
                if (!m4.reset(zoneEntry[2]).matches()) {
                    throw new IllegalArgumentException("Bad zone.tab, lat/long format: " + zoneEntry[2]);
                }
                zarray.add(this.getDegrees(m4, true).toString());
                zarray.add(this.getDegrees(m4, false).toString());
                zarray.add(zoneEntry[1]);
                this.zoneData.put(zoneEntry[0], zarray);
            }
            this.zoneData = CldrUtility.protectCollection(this.zoneData);
            Pattern whitespace = PatternCache.get("\\s+");
            XEquivalenceClass<String, String> linkedItems = new XEquivalenceClass<String, String>("None");
            for (i = 0; i < TZFiles.length; ++i) {
                String line2;
                in = CldrUtility.getUTF8Data(TZFiles[i]);
                Object zoneID = null;
                while ((line2 = in.readLine()) != null) {
                    String originalLine = line2;
                    int commentPos = line2.indexOf("#");
                    String comment = null;
                    if (commentPos >= 0) {
                        comment = line2.substring(commentPos + 1).trim();
                        line2 = line2.substring(0, commentPos);
                    }
                    if ((line2 = line2.trim()).length() == 0) continue;
                    String[] items = whitespace.split(line2);
                    if (zoneID != null || items[0].equals("Zone")) {
                        List<ZoneLine> zoneRules;
                        ArrayList<String> l = new ArrayList<String>();
                        l.addAll(Arrays.asList(items));
                        if (zoneID == null) {
                            l.remove(0);
                            zoneID = (String)l.get(0);
                            String ntzid = FIX_UNSTABLE_TZIDS.get(zoneID);
                            if (ntzid != null) {
                                zoneID = ntzid;
                            }
                            l.remove(0);
                        }
                        if ((zoneRules = this.zone_rules.get(zoneID)) == null) {
                            zoneRules = new ArrayList<ZoneLine>();
                            this.zone_rules.put((String)zoneID, zoneRules);
                        }
                        if (l.size() < 3 || l.size() > 7) {
                            System.out.println("***Zone incorrect field count:");
                            System.out.println(l);
                            System.out.println(originalLine);
                        }
                        ZoneLine zoneLine = new ZoneLine(l);
                        zoneLine.comment = comment;
                        zoneRules.add(zoneLine);
                        if (l.size() != 3) continue;
                        zoneID = null;
                        continue;
                    }
                    if (items[0].equals("Rule")) {
                        String ruleID = items[1];
                        List<RuleLine> ruleList = this.ruleID_rules.get(ruleID);
                        if (ruleList == null) {
                            ruleList = new ArrayList<RuleLine>();
                            this.ruleID_rules.put(ruleID, ruleList);
                        }
                        ArrayList<String> l = new ArrayList<String>();
                        l.addAll(Arrays.asList(items));
                        l.remove(0);
                        l.remove(0);
                        if (l.size() != 8) {
                            System.out.println("***Rule incorrect field count:");
                            System.out.println(l);
                        }
                        if (comment != null) {
                            l.add(comment);
                        }
                        RuleLine ruleLine = new RuleLine(l);
                        ruleList.add(ruleLine);
                        continue;
                    }
                    if (!items[0].equals("Link")) continue;
                    String old = items[2];
                    String newOne = items[1];
                    if (SKIP_LINKS.contains(old) && SKIP_LINKS.contains(newOne)) continue;
                    linkedItems.add(old, newOne);
                }
                in.close();
            }
            for (i = 0; i < ADD_ZONE_ALIASES_DATA.length; ++i) {
                linkedItems.add(ADD_ZONE_ALIASES_DATA[i][0], ADD_ZONE_ALIASES_DATA[i][1]);
            }
            Set<String> isCanonical = this.zoneData.keySet();
            for (Set equivalents : linkedItems.getEquivalenceSets()) {
                TreeSet canonicals = new TreeSet(equivalents);
                canonicals.retainAll(isCanonical);
                if (canonicals.size() == 0) {
                    throw new IllegalArgumentException("No canonicals in: " + equivalents);
                }
                if (canonicals.size() > 1) {
                    TreeSet remainder = new TreeSet(equivalents);
                    remainder.removeAll(isCanonical);
                    if (remainder.size() != 0) {
                        // empty if block
                    }
                }
                HashSet<String> preferredItems = new HashSet<String>(PREFERRED_BASES);
                preferredItems.retainAll(canonicals);
                String newOne = preferredItems.size() > 0 ? (String)preferredItems.iterator().next() : (String)canonicals.iterator().next();
                for (String oldOne : equivalents) {
                    if (canonicals.contains(oldOne)) continue;
                    this.linkold_new.put(oldOne, newOne);
                }
            }
            for (String oldZone : this.linkold_new.keySet()) {
                String newZone = this.linkold_new.get(oldZone);
                Set<String> s2 = this.linkNew_oldSet.get(newZone);
                if (s2 == null) {
                    s2 = new HashSet<String>();
                    this.linkNew_oldSet.put(newZone, s2);
                }
                s2.add(oldZone);
            }
            this.linkNew_oldSet = CldrUtility.protectCollection(this.linkNew_oldSet);
            this.linkold_new = CldrUtility.protectCollection(this.linkold_new);
            this.ruleID_rules = CldrUtility.protectCollection(this.ruleID_rules);
            this.zone_rules = CldrUtility.protectCollection(this.zone_rules);
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException("Can't find timezone aliases: " + e.toString(), e);
        }
    }

    private Double getDegrees(Matcher m4, boolean lat) {
        int startIndex = lat ? 1 : 5;
        double amount = (double)Integer.parseInt(m4.group(startIndex + 1)) + (double)Integer.parseInt(m4.group(startIndex + 2)) / 60.0;
        if (m4.group(startIndex + 3) != null) {
            amount += (double)Integer.parseInt(m4.group(startIndex + 3)) / 3600.0;
        }
        if (m4.group(startIndex).equals("-")) {
            amount = -amount;
        }
        return amount;
    }

    public Map<String, String> getZoneLinkold_new() {
        this.getZoneData();
        return this.linkold_new;
    }

    public Map<String, Set<String>> getZoneLinkNew_OldSet() {
        this.getZoneData();
        return this.linkNew_oldSet;
    }

    public Map<String, List<RuleLine>> getZoneRuleID_rules() {
        this.getZoneData();
        return this.ruleID_rules;
    }

    public Map<String, List<ZoneLine>> getZone_rules() {
        this.getZoneData();
        return this.zone_rules;
    }

    public String getVersion() {
        return this.version;
    }

    static {
        regionalCompare.add("America");
        regionalCompare.add("Atlantic");
        regionalCompare.add("Europe");
        regionalCompare.add("Africa");
        regionalCompare.add("Asia");
        regionalCompare.add("Indian");
        regionalCompare.add("Australia");
        regionalCompare.add("Pacific");
        regionalCompare.add("Arctic");
        regionalCompare.add("Antarctica");
        regionalCompare.add("Etc");
        TZFiles = new String[]{"africa", "antarctica", "asia", "australasia", "backward", "etcetera", "europe", "northamerica", "southamerica"};
        SKIP_LINKS = new HashSet<String>(Arrays.asList("America/Montreal", "America/Toronto", "America/Santa_Isabel", "America/Tijuana"));
        PREFERRED_BASES = new HashSet<String>(Arrays.asList("Europe/London"));
        ADD_ZONE_ALIASES_DATA = new String[][]{{"Etc/UCT", "Etc/UTC"}, {"EST", "Etc/GMT+5"}, {"MST", "Etc/GMT+7"}, {"HST", "Etc/GMT+10"}, {"SystemV/AST4", "Etc/GMT+4"}, {"SystemV/EST5", "Etc/GMT+5"}, {"SystemV/CST6", "Etc/GMT+6"}, {"SystemV/MST7", "Etc/GMT+7"}, {"SystemV/PST8", "Etc/GMT+8"}, {"SystemV/YST9", "Etc/GMT+9"}, {"SystemV/HST10", "Etc/GMT+10"}};
        FIX_DEPRECATED_ZONE_DATA = new String[]{"Africa/Timbuktu", "America/Argentina/ComodRivadavia", "America/Santa_Isabel", "Europe/Belfast", "Pacific/Yap", "Antarctica/South_Pole", "America/Shiprock", "America/Montreal", "Asia/Chongqing", "Asia/Harbin", "Asia/Kashgar"};
        Object[][] FIX_UNSTABLE_TZID_DATA = new String[][]{{"America/Atikokan", "America/Coral_Harbour"}, {"America/Argentina/Buenos_Aires", "America/Buenos_Aires"}, {"America/Argentina/Catamarca", "America/Catamarca"}, {"America/Argentina/Cordoba", "America/Cordoba"}, {"America/Argentina/Jujuy", "America/Jujuy"}, {"America/Argentina/Mendoza", "America/Mendoza"}, {"America/Nuuk", "America/Godthab"}, {"America/Kentucky/Louisville", "America/Louisville"}, {"America/Indiana/Indianapolis", "America/Indianapolis"}, {"Africa/Asmara", "Africa/Asmera"}, {"Atlantic/Faroe", "Atlantic/Faeroe"}, {"Asia/Kolkata", "Asia/Calcutta"}, {"Asia/Ho_Chi_Minh", "Asia/Saigon"}, {"Asia/Yangon", "Asia/Rangoon"}, {"Asia/Kathmandu", "Asia/Katmandu"}, {"Europe/Kyiv", "Europe/Kiev"}, {"Pacific/Pohnpei", "Pacific/Ponape"}, {"Pacific/Chuuk", "Pacific/Truk"}, {"Pacific/Honolulu", "Pacific/Johnston"}};
        FIX_UNSTABLE_TZIDS = CldrUtility.asMap(FIX_UNSTABLE_TZID_DATA);
        SUPPLEMENTAL_ZONE_ID_DATA = new String[][]{{"Europe/Uzhgorod", "UA", "+4837+02218"}, {"Europe/Zaporozhye", "UA", "+4750+03510"}, {"America/Nipigon", "CA", "+4901-08816"}, {"America/Rainy_River", "CA", "+4843-09434"}, {"America/Thunder_Bay", "CA", "+4823-08915"}, {"America/Pangnirtung", "CA", "+6608-06544"}};
    }

    public class TransitionList {
        void addTransitions(ZoneLine lastZoneLine, ZoneLine zoneLine, int startYear, int endYear) {
            if (lastZoneLine == null) {
                return;
            }
            startYear = Math.max(startYear, lastZoneLine.untilYear);
            endYear = Math.min(endYear, zoneLine.untilYear);
            int gmtOffset = lastZoneLine.gmtOff;
            for (int year = startYear; year <= endYear; ++year) {
                this.resolveTime(gmtOffset, lastZoneLine.untilYear, lastZoneLine.untilMonth, lastZoneLine.untilDay, lastZoneLine.untilTime);
            }
        }

        private long resolveTime(int gmtOffset, int untilYear, int untilMonth, Day untilDay, Time untilTime) {
            return 0L;
        }
    }

    public class Transition {
        public long date;
        public long offset;
        public String abbreviation;
    }

    public static class ZoneLine {
        public static Set<Day> untilDays = new TreeSet<Day>();
        public static Set<String> rulesSaves = new TreeSet<String>();
        public int gmtOff;
        public String rulesSave;
        public String format;
        public int untilYear = Integer.MAX_VALUE;
        public int untilMonth;
        public Day untilDay;
        public Time untilTime;
        public String comment;
        public static final int FIELD_COUNT = 3;
        public static final int FIELD_COUNT_UNTIL = 7;

        ZoneLine(List<String> l) {
            this.gmtOff = Time.parseSeconds(l.get(0), true);
            this.rulesSave = l.get(1);
            if (this.rulesSave.equals("-")) {
                this.rulesSave = "0";
            } else if (this.rulesSave.charAt(0) < 'A') {
                this.rulesSave = "" + Time.parseSeconds(this.rulesSave, false);
            }
            this.format = l.get(2);
            switch (l.size()) {
                case 7: {
                    this.untilTime = new Time(l.get(6));
                }
                case 6: {
                    this.untilDay = new Day(l.get(5));
                    untilDays.add(this.untilDay);
                }
                case 5: {
                    this.untilMonth = 1 + ZoneParser.findStartsWith(l.get(4), months, false);
                }
                case 4: {
                    this.untilYear = ZoneParser.parseYear(l.get(3), Integer.MAX_VALUE);
                }
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong field count: " + l);
                }
            }
            rulesSaves.add(this.rulesSave);
        }

        public String toString() {
            return BoilerplateUtilities.toStringHelper(this);
        }
    }

    public static class RuleLine {
        public static Set<String> types = new TreeSet<String>();
        public static Set<Day> days = new TreeSet<Day>();
        static Set<Integer> saves = new TreeSet<Integer>();
        public int fromYear;
        public int toYear;
        public String type;
        public int month;
        public Day day;
        public Time time;
        public int save;
        public String letter;
        public static final int FIELD_COUNT = 8;

        RuleLine(List<String> l) {
            this.fromYear = ZoneParser.parseYear(l.get(0), 0);
            this.toYear = ZoneParser.parseYear(l.get(1), this.fromYear);
            this.type = l.get(2);
            if (this.type.equals("-")) {
                this.type = null;
            }
            this.month = 1 + ZoneParser.findStartsWith(l.get(3), months, false);
            this.day = new Day(l.get(4));
            this.time = new Time(l.get(5));
            this.save = Time.parseSeconds(l.get(6), true);
            this.letter = l.get(7);
            if (this.letter.equals("-")) {
                this.letter = null;
            }
            if (this.type != null) {
                types.add(this.type);
            }
            days.add(this.day);
        }

        public String toString() {
            return BoilerplateUtilities.toStringHelper(this);
        }
    }

    public static class Day
    implements Comparable<Object> {
        public int number;
        public byte relation;
        public int weekDay;
        static final byte NONE = 0;
        static final byte LEQ = 2;
        static final byte GEQ = 4;

        Day(String value) {
            value = value.toLowerCase();
            Matcher matcher = dayPattern.matcher(value);
            if (!matcher.matches()) {
                throw new IllegalArgumentException();
            }
            if (matcher.group(1) != null) {
                this.number = Integer.parseInt(matcher.group(1));
                return;
            }
            if (matcher.group(2) != null) {
                this.weekDay = ZoneParser.findStartsWith(matcher.group(3), weekdays, false);
                this.number = 31;
                this.relation = (byte)2;
                return;
            }
            if (matcher.group(4) != null) {
                this.weekDay = ZoneParser.findStartsWith(matcher.group(4), weekdays, false);
                this.relation = (byte)ZoneParser.findStartsWith(matcher.group(5), relations, false);
                this.number = Integer.parseInt(matcher.group(6));
                return;
            }
            throw new IllegalArgumentException();
        }

        public String toString() {
            return BoilerplateUtilities.toStringHelper(this);
        }

        @Override
        public int compareTo(Object other) {
            return this.toString().compareTo(other.toString());
        }
    }

    public static class Time {
        public int seconds;
        public byte type;
        static final byte WALL = 0;
        static final byte STANDARD = 1;
        static final byte UNIVERSAL = 2;

        Time(String in) {
            if (in.equals("-")) {
                return;
            }
            char suffix = in.charAt(in.length() - 1);
            switch (suffix) {
                case 'w': {
                    in = in.substring(0, in.length() - 1);
                    break;
                }
                case 's': {
                    in = in.substring(0, in.length() - 1);
                    this.type = 1;
                    break;
                }
                case 'g': 
                case 'u': 
                case 'z': {
                    in = in.substring(0, in.length() - 1);
                    this.type = (byte)2;
                }
            }
            this.seconds = Time.parseSeconds(in, false);
        }

        public static int parseSeconds(String in, boolean allowNegative) {
            boolean negative = false;
            if (in.startsWith("-")) {
                assert (allowNegative);
                negative = true;
                in = in.substring(1);
            }
            String[] pieces = in.split(":");
            int multiplier = 3600;
            int result = 0;
            for (int i = 0; i < pieces.length; ++i) {
                result += multiplier * Integer.parseInt(pieces[i]);
                assert ((multiplier /= 60) >= 0);
            }
            if (negative) {
                result = -result;
            }
            return result;
        }

        public String toString() {
            return BoilerplateUtilities.toStringHelper(this);
        }
    }
}

