/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.impl.UnicodeMap;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.Parser;
import org.unicode.cldr.util.PatternCache;

public class UnicodeMapBuilder<T> {
    UnicodeMap<T> result;
    Parser<T, String> parser;
    Leniency leniency;
    Pattern semi = PatternCache.get("\\s+;\\s+");

    public UnicodeMapBuilder<T> setParser(Parser<T, String> parser) {
        this.parser = parser;
        return this;
    }

    public Parser<T, String> getParser() {
        return this.parser;
    }

    public Leniency getLeniency() {
        return this.leniency;
    }

    public UnicodeMapBuilder<T> setLeniency(Leniency leniency) {
        this.leniency = leniency;
        return this;
    }

    public UnicodeMap<T> get() {
        return this.result;
    }

    public UnicodeMap<T> getFrozen() {
        Object myResult = this.result.freeze();
        this.result = null;
        return myResult;
    }

    public UnicodeMapBuilder<T> putFromLines(BufferedReader br) {
        if (this.result == null) {
            this.result = new UnicodeMap();
        }
        UnicodeSet sources = new UnicodeSet();
        String line = null;
        try {
            while ((line = UnicodeMapBuilder.readDataLine(br, null)) != null) {
                if (line.length() == 0) continue;
                sources.clear();
                String[] pieces = this.semi.split(line);
                if (pieces.length < 2) {
                    throw new IllegalArgumentException("Line must be of form code ; value");
                }
                String codelist = pieces[0].trim();
                String valueString = pieces[1].trim();
                if (UnicodeSet.resemblesPattern(pieces[0], 0)) {
                    sources = new UnicodeSet(codelist);
                } else if (codelist.length() < 4) {
                    sources.add(codelist);
                } else {
                    String[] codes = codelist.split("\\s+");
                    for (int i = 0; i < codes.length; ++i) {
                        int start;
                        String[] range = codes[i].split("\\.\\.");
                        int end = start = this.getCodePoint(range[0]);
                        if (range.length > 1) {
                            if (range.length > 2) {
                                throw new IllegalArgumentException("Too many ..");
                            }
                            end = this.getCodePoint(range[1]);
                            if (start >= end) {
                                throw new IllegalArgumentException("Range out of order");
                            }
                        }
                        sources.add(start, end);
                    }
                }
                String value = this.parser == null ? valueString : this.parser.parseObject(valueString);
                this.result.putAll(sources, value);
            }
            br.close();
        }
        catch (Exception e) {
            throw (RuntimeException)new RuntimeException("Failure on line " + line).initCause(e);
        }
        return this;
    }

    private int getCodePoint(String source) {
        if (source.startsWith("U+") || source.startsWith("\\u") || source.startsWith("\\U")) {
            source = source.substring(2);
        }
        return Integer.parseInt(source, 16);
    }

    public static String readDataLine(BufferedReader br, int[] count) throws IOException {
        String originalLine = "";
        String line = "";
        try {
            int commentPos;
            line = originalLine = br.readLine();
            if (line == null) {
                return null;
            }
            if (count != null) {
                count[0] = count[0] + 1;
            }
            if (line.length() > 0 && line.charAt(0) == '\ufeff') {
                line = line.substring(1);
            }
            if ((commentPos = line.indexOf(35)) >= 0) {
                line = line.substring(0, commentPos);
            }
            line = line.trim();
        }
        catch (Exception e) {
            throw new ICUUncheckedIOException("Line \"{" + originalLine + "}\",  \"{" + line + "}\"", e);
        }
        return line;
    }

    public static enum Leniency {
        allowChars,
        allowUnicodeSet;

    }
}

