/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CollatorHelper;
import org.unicode.cldr.util.Emoji;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.XPathParts;

public class CompareEmoji {
    private static final Splitter BAR_SPLITTER = Splitter.on("|").trimResults().omitEmptyStrings();
    static final CLDRConfig CONFIG = CLDRConfig.getInstance();
    static final Factory FACTORY = CONFIG.getAnnotationsFactory();
    private static final File[] paths = new File[]{new File(CLDRPaths.ANNOTATIONS_DERIVED_DIRECTORY)};
    static final Factory FACTORY_DERIVED = SimpleFactory.make(paths, ".*");
    private static final Joiner BAR_JOINER = Joiner.on(" | ");
    private static final String base = "/Users/markdavis/github/private/DATA/cldr-private/emoji_diff/";
    private static final Set<String> sorted = ImmutableSet.copyOf(Emoji.getAllRgi().addAllTo(new TreeSet<Object>(CollatorHelper.EMOJI_COLLATOR)));

    public static void main(String[] args) throws IOException {
        String locale = "zh_Hant";
        Map<String, EmojiData> annotations = CompareEmoji.getDataFor("zh_Hant");
        Map<String, Set<String>> removed = CompareEmoji.loadItems("zh_Hant", "_removed.csv", new HashMap<String, Set<String>>());
        Map<String, Set<String>> added = CompareEmoji.loadItems("zh_Hant", "_added.csv", new HashMap<String, Set<String>>());
        int count = 0;
        System.out.println("No.\tEmoji\tType\tName\tCommon\tRemoved\tAdded");
        for (String key : sorted) {
            Status status;
            String shortName;
            Set<Object> commonSet;
            String minimal = key.replace("\ufe0f", "");
            EmojiData v = annotations.get(minimal);
            if (v == null) {
                commonSet = Set.of();
                shortName = "<constructed>";
                status = Status.missing;
            } else {
                commonSet = v.searchKeywords;
                shortName = v.shortName;
                status = v.status;
            }
            Set<String> removedSet = removed.get(key);
            Set<String> addedSet = added.get(key);
            if (removedSet == null && addedSet == null) continue;
            if (removedSet != null) {
                commonSet = Sets.difference(commonSet, removedSet);
            }
            System.out.println(++count + "\t" + key + "\t" + status.abbreviation() + "\t" + shortName + "\t" + BAR_JOINER.join(commonSet) + "\t" + (removedSet == null ? "" : BAR_JOINER.join(removedSet)) + "\t" + (addedSet == null ? "" : BAR_JOINER.join(addedSet)));
        }
    }

    private static Map<String, EmojiData> getDataFor(String locale) {
        HashMap<String, EmojiData> result = new HashMap<String, EmojiData>();
        CLDRFile cldrfile = FACTORY.make(locale, true);
        CompareEmoji.getDataIn(cldrfile, result, Status.regular);
        CLDRFile cldrfileDerived = FACTORY_DERIVED.make(locale, true);
        CompareEmoji.getDataIn(cldrfileDerived, result, Status.constructed);
        return result;
    }

    public static void getDataIn(CLDRFile cldrfile, Map<String, EmojiData> result, Status status) {
        for (String path : cldrfile) {
            XPathParts parts = XPathParts.getFrozenInstance(path);
            String cp = parts.getAttributeValue(-1, "cp");
            if (cp == null) continue;
            EmojiData record = result.get(cp);
            if (record == null) {
                record = new EmojiData();
                result.put(cp, record);
                record.status = status;
            }
            boolean istts = parts.getAttributeValue(-1, "type") != null;
            String value = cldrfile.getStringValue(path);
            if (istts) {
                record.shortName = value;
                continue;
            }
            record.searchKeywords = ImmutableSet.copyOf(BAR_SPLITTER.splitToList(value));
        }
    }

    public static Map<String, Set<String>> loadItems(String locale, String suffix, Map<String, Set<String>> result) throws IOException {
        try (BufferedReader reader = FileUtilities.openUTF8Reader(base, locale + suffix);){
            while (true) {
                String[] split;
                String line;
                if ((line = reader.readLine()) == null) {
                    Map<String, Set<String>> map = result;
                    return map;
                }
                if (line.startsWith("Emoji,") || (split = FileUtilities.splitCommaSeparated(line)).length < 2) continue;
                String key = split[0];
                AbstractCollection values = new TreeSet<Object>(CollatorHelper.EMOJI_COLLATOR);
                for (int i = 1; i < split.length; ++i) {
                    values.add(split[i]);
                }
                values = ImmutableSet.copyOf(values);
                result.put(key, (Set<String>)((Object)values));
            }
        }
    }

    private static class EmojiData {
        String shortName;
        Set<String> searchKeywords;
        Status status;

        private EmojiData() {
        }

        public String toString() {
            return this.shortName + "; " + this.searchKeywords + "; " + this.status;
        }
    }

    static enum Status {
        regular,
        constructed,
        missing;


        char abbreviation() {
            return Character.toUpperCase(this.name().charAt(0));
        }
    }
}

