/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Comparators;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;

public class LSRSource
implements Comparable<LSRSource> {
    private static final Joiner JOIN_SPACE = Joiner.on(' ');
    private static final Splitter SPLIT_SPACE = Splitter.on(' ').omitEmptyStrings();
    private final CLDRLocale cldrLocale;
    private final Set<String> sources;

    LSRSource(String lang, String script, String region, String sources) {
        this.cldrLocale = CLDRLocale.getInstance(lang, script, region);
        this.sources = ImmutableSortedSet.copyOf(SPLIT_SPACE.splitToList(sources));
    }

    public String getLanguage() {
        return this.cldrLocale.getLanguage();
    }

    public String getScript() {
        return this.cldrLocale.getScript();
    }

    public String getRegion() {
        return this.cldrLocale.getRegion();
    }

    public Set<String> getSources() {
        return this.sources;
    }

    public String getLsrString() {
        return this.cldrLocale.toString();
    }

    @Override
    public int compareTo(LSRSource other) {
        return ComparisonChain.start().compare(this.cldrLocale, other.cldrLocale).compare(this.sources, other.sources, Comparators.lexicographical(Comparator.naturalOrder())).result();
    }

    public int hashCode() {
        return Objects.hash(this.cldrLocale, this.sources);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LSRSource)) {
            return false;
        }
        LSRSource other = (LSRSource)obj;
        return Objects.equals(this.cldrLocale, other.cldrLocale) && Objects.equals(this.sources, other.sources);
    }

    public String toString() {
        return this.cldrLocale.toString() + " // " + this.getSources();
    }

    public String line(String source) {
        CLDRFile english = CLDRConfig.getInstance().getEnglish();
        String target = this.cldrLocale.toString();
        String result = "<likelySubtag from=\"" + source + "\" to=\"" + target + (String)(this.getSources().isEmpty() ? "" : "\" origin=\"" + this.getSourceString()) + "\"/>\t<!-- " + english.nameGetter().getNameFromIdentifier(source) + " \u27a1\ufe0e " + english.nameGetter().getNameFromIdentifier(target) + " -->";
        return result;
    }

    public String getSourceString() {
        return JOIN_SPACE.join(this.getSources());
    }

    public CLDRLocale getCldrLocale() {
        return this.cldrLocale;
    }
}

