/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ibm.icu.impl.number.DecimalQuantity;
import com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import com.ibm.icu.text.PluralRules;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.tool.PluralMinimalPairs;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PluralRanges;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

public class WritePluralRulesSpreadsheets {
    public static String[] tests = new String[]{"or", "tk", "ps", "as", "sd"};
    static final SupplementalDataInfo supplemental = SupplementalDataInfo.getInstance();
    static final Factory factory = ToolConfig.getToolInstance().getFullCldrFactory();
    static final StandardCodes STD = StandardCodes.make();

    public static void main(String[] args) {
        WritePluralRulesSpreadsheets.ranges();
    }

    private static void ranges() {
        HashMultimap<Set<String>, String> missingMinimalPairs = HashMultimap.create();
        System.out.println("Type\tCode\tName\tRange\tResult\tResult Example\tStart-Range Example\tEnd-Range Example");
        TreeSet<String> cldrLocales = new TreeSet<String>(STD.getLocaleCoverageLocales(Organization.cldr));
        cldrLocales.addAll(STD.getLocaleCoverageLocales(Organization.google));
        cldrLocales.remove("*");
        WritePluralRulesSpreadsheets.writeRanges("Core", cldrLocales, missingMinimalPairs);
        for (Map.Entry missing : missingMinimalPairs.entries()) {
            Set keywords = (Set)missing.getKey();
            String locale = (String)missing.getValue();
            System.out.println("Missing Core\t" + WritePluralRulesSpreadsheets.getName(locale) + "\t" + keywords);
        }
        System.out.println();
        missingMinimalPairs.clear();
        TreeSet<String> localesWithPlurals = new TreeSet<String>(supplemental.getPluralLocales(SupplementalDataInfo.PluralType.cardinal));
        localesWithPlurals.removeAll(cldrLocales);
        WritePluralRulesSpreadsheets.writeRanges("Other", localesWithPlurals, missingMinimalPairs);
        for (Map.Entry missing : missingMinimalPairs.entries()) {
            Set keywords = (Set)missing.getKey();
            String locale = (String)missing.getValue();
            System.out.println("Missing Other\t" + WritePluralRulesSpreadsheets.getName(locale) + "\t" + keywords);
        }
    }

    private static void writePluralChecklist(String ... locales) {
        List<String> sampleStrings = Arrays.asList("0", "0.1", "0.2", "0.9", "1.9", "1", "1.0", "1.2", "2.0", "2.1", "0.00", "0.01", "0.10", "0.11", "0.02", "1.00", "1.10", "1.11", "1.02", "2.00", "2.01", "2.9");
        for (String locale : locales) {
            if ("root".equals(locale) || locale.contains("_")) continue;
            PluralRules rules = supplemental.getPlurals(locale).getPluralRules();
            PluralMinimalPairs samplePatterns = PluralMinimalPairs.getInstance(locale);
            if (samplePatterns.isEmpty(PluralRules.PluralType.CARDINAL)) continue;
            TreeSet<DecimalQuantity> samples = new TreeSet<DecimalQuantity>();
            Set<String> keywords = rules.getKeywords();
            System.out.print(locale + "\tNumber\tCat.\tSample\tReplacement for Sample");
            for (String keyword : keywords) {
                System.out.print("\t" + SupplementalDataInfo.PluralInfo.Count.valueOf(keyword));
                HashSet<Double> items = new HashSet<Double>(rules.getSamples(keyword, PluralRules.SampleType.INTEGER));
                for (int i = 0; i < 5; ++i) {
                    items.add((double)i + 0.0);
                    items.add((double)i + 10.0);
                    items.add((double)i + 20.0);
                    items.add((double)i + 100.0);
                    items.add((double)i + 110.0);
                }
                for (Double d : items) {
                    DecimalQuantity_DualStorageBCD fd = new DecimalQuantity_DualStorageBCD(d);
                    samples.add(fd);
                }
                for (String string : sampleStrings) {
                    DecimalQuantity dq = DecimalQuantity_DualStorageBCD.fromExponentString(string);
                    samples.add(dq);
                }
            }
            System.out.println();
            for (DecimalQuantity number : samples) {
                String cat = rules.select(number);
                String sample = samplePatterns.get(PluralRules.PluralType.CARDINAL, SupplementalDataInfo.PluralInfo.Count.valueOf(cat));
                System.out.print(locale + "\t\u00a0" + number + "\t" + cat + "\t" + sample.replace("{0}", number.toString()) + "\t\u00abreplace if Sample wrong\u00bb");
                for (String keyword : keywords) {
                    String sample2 = samplePatterns.get(PluralRules.PluralType.CARDINAL, SupplementalDataInfo.PluralInfo.Count.valueOf(keyword));
                    System.out.print("\t" + sample2.replace("{0}", number.toString()));
                }
                System.out.println();
            }
            System.out.println();
        }
    }

    private static void writeRanges(String title, Set<String> locales, Multimap<Set<String>, String> missingMinimalPairs) {
        for (String locale : locales) {
            String rangePattern;
            if ("root".equals(locale) || locale.contains("_")) continue;
            PluralRules rules = supplemental.getPlurals(locale).getPluralRules();
            try {
                rangePattern = factory.make(locale, true).getStringValue("//ldml/numbers/miscPatterns[@numberSystem=\"latn\"]/pattern[@type=\"range\"]");
            }
            catch (Exception e) {
                missingMinimalPairs.put(rules.getKeywords(), locale);
                continue;
            }
            PluralMinimalPairs samplePatterns = PluralMinimalPairs.getInstance(locale);
            if (samplePatterns.isEmpty(PluralRules.PluralType.CARDINAL)) {
                missingMinimalPairs.put(rules.getKeywords(), locale);
                continue;
            }
            Set<String> keywords = rules.getKeywords();
            PluralRanges pluralRanges = supplemental.getPluralRanges(locale);
            for (String start : keywords) {
                DecimalQuantity small = WritePluralRulesSpreadsheets.getSample(rules, start, null);
                String startPattern = WritePluralRulesSpreadsheets.getSamplePattern(samplePatterns, start);
                if (startPattern == null) {
                    throw new NullPointerException("no startPattern: get[Cardinal]SamplePattern([" + locale + "]," + start + ") returned null- samplePatterns: " + samplePatterns.toString());
                }
                for (String end : keywords) {
                    DecimalQuantity large = WritePluralRulesSpreadsheets.getSample(rules, end, small);
                    if (large == null) continue;
                    String endPattern = WritePluralRulesSpreadsheets.getSamplePattern(samplePatterns, end);
                    if (endPattern == null) {
                        throw new NullPointerException("no endPattern: get[Cardinal]SamplePattern([" + locale + "]," + end + ") returned null- samplePatterns: " + samplePatterns.toString());
                    }
                    String range = MessageFormat.format(rangePattern, small.toString(), large.toString());
                    SupplementalDataInfo.PluralInfo.Count rangeCount = pluralRanges == null ? null : pluralRanges.get(SupplementalDataInfo.PluralInfo.Count.valueOf(start), SupplementalDataInfo.PluralInfo.Count.valueOf(end));
                    String rangeCountPattern = rangeCount == null ? "<copy correct pattern>" : WritePluralRulesSpreadsheets.getSamplePattern(samplePatterns, rangeCount.toString());
                    System.out.println(title + "\t" + WritePluralRulesSpreadsheets.getName(locale) + "\t" + start + "\u2014" + end + "\t" + (rangeCount == null ? "?" : rangeCount.toString()) + "\t" + (rangeCountPattern.contains("{0}") ? rangeCountPattern.replace("{0}", range) : rangeCountPattern) + "\t" + (startPattern.contains("{0}") ? startPattern.replace("{0}", range) : "?") + "\t" + (endPattern.contains("{0}") ? endPattern.replace("{0}", range) : "?"));
                }
            }
            System.out.println();
        }
    }

    private static String getName(String missing) {
        return missing + "\t" + CLDRConfig.getInstance().getEnglish().nameGetter().getNameFromIdentifier(missing);
    }

    private static String getSamplePattern(PluralMinimalPairs samplePatterns, String start) {
        return samplePatterns.get(PluralRules.PluralType.CARDINAL, SupplementalDataInfo.PluralInfo.Count.valueOf(start));
    }

    private static DecimalQuantity getSample(PluralRules rules, String start, DecimalQuantity minimum) {
        DecimalQuantity result = WritePluralRulesSpreadsheets.getSample(rules, start, PluralRules.SampleType.INTEGER, minimum);
        DecimalQuantity result2 = WritePluralRulesSpreadsheets.getSample(rules, start, PluralRules.SampleType.DECIMAL, minimum);
        if (result == null) {
            return result2;
        }
        return result;
    }

    private static DecimalQuantity getSample(PluralRules rules, String start, PluralRules.SampleType sampleType, DecimalQuantity minimum) {
        PluralRules.DecimalQuantitySamples samples = rules.getDecimalSamples(start, sampleType);
        if (samples == null) {
            return null;
        }
        Set<PluralRules.DecimalQuantitySamplesRange> samples2 = samples.getSamples();
        if (samples2 == null) {
            return null;
        }
        for (PluralRules.DecimalQuantitySamplesRange sample : samples2) {
            if (minimum == null) {
                return sample.start;
            }
            if (minimum.toDouble() < sample.start.toDouble()) {
                return sample.start;
            }
            if (!(minimum.toDouble() < sample.end.toDouble())) continue;
            return sample.end;
        }
        return null;
    }
}

