/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.google.common.collect.AbstractMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.unicode.cldr.icu.dev.util.ElapsedTimer;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.tool.ShowLocaleCoverage;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CalculatedCoverageLevels;
import org.unicode.cldr.util.CoreCoverageInfo;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.CoverageInfo;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagCanonicalizer;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.RegexLookup;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.VettingViewer;

public class CalculateLocaleCoverage {
    Map<CLDRLocale, CoverageResult> data = new TreeMap<CLDRLocale, CoverageResult>();
    static final Logger logger = Logger.getLogger(CalculateLocaleCoverage.class.getName());
    private static final double BASIC_THRESHOLD = 1.0;
    private static final double MODERATE_THRESHOLD = 0.995;
    private static final double MODERN_THRESHOLD = 0.995;
    private final StandardCodes SC = StandardCodes.make();
    private final Factory factory;
    private final CLDRFile ENGLISH = CLDRConfig.getInstance().getEnglish();
    private static final RegexLookup<Boolean> SUPPRESS_PATHS_CAN_BE_EMPTY = new RegexLookup<Boolean>().add("\\[@alt=\"accounting\"]", Boolean.valueOf(true)).add("\\[@alt=\"variant\"]", (Boolean)true).add("^//ldml/localeDisplayNames/territories/territory.*@alt=\"short", (Boolean)true).add("^//ldml/localeDisplayNames/languages/language.*_", (Boolean)true).add("^//ldml/numbers/currencies/currency.*/symbol", (Boolean)true).add("^//ldml/characters/exemplarCharacters", (Boolean)true);
    private static CLDRFile.DraftStatus minimumDraftStatus = CLDRFile.DraftStatus.unconfirmed;
    private PathHeader.Factory pathHeaderFactory = PathHeader.getFactory(this.ENGLISH);
    final Set<String> COMMON_LOCALES;
    final StandardCodes STANDARD_CODES = StandardCodes.make();
    private final SupplementalDataInfo SUPPLEMENTAL_DATA_INFO = CLDRConfig.getInstance().getSupplementalDataInfo();
    private final CoverageInfo coverageInfo = new CoverageInfo(this.SUPPLEMENTAL_DATA_INFO);
    private static final Set<ULocale> ICU_Locales = ImmutableSet.copyOf(ULocale.getAvailableLocales());

    public CalculateLocaleCoverage(Factory f) {
        this.factory = f;
        this.COMMON_LOCALES = this.factory.getAvailableLanguages();
    }

    public static Collection<CoverageResult> getCoverage(Factory f) {
        return CalculateLocaleCoverage.getCoverage(f, null);
    }

    public static Collection<CoverageResult> getCoverage(Factory f, String only) {
        CalculateLocaleCoverage c = new CalculateLocaleCoverage(f);
        c.calculateCoverage(only);
        return c.data.values();
    }

    private void calculateCoverage(String only) {
        Set<String> locales = this.COMMON_LOCALES;
        Set<String> checkModernLocales = this.STANDARD_CODES.getLocaleCoverageLocales(Organization.cldr, EnumSet.of(Level.MODERN));
        TreeSet<String> availableLanguages = new TreeSet<String>(this.factory.getAvailableLanguages());
        availableLanguages.addAll(checkModernLocales);
        AbstractMultimap languageToRegion = TreeMultimap.create();
        LanguageTagParser ltp = new LanguageTagParser();
        LanguageTagCanonicalizer ltc = new LanguageTagCanonicalizer(true);
        for (String locale : this.factory.getAvailable()) {
            String country = ltp.set(locale).getRegion();
            if (country.isEmpty()) continue;
            languageToRegion.put(ltc.transform(ltp.getLanguageScript()), country);
        }
        languageToRegion = ImmutableMultimap.copyOf(languageToRegion);
        logger.info(Joiner.on("\n").join(languageToRegion.asMap().entrySet()));
        logger.info("# Calculating locale coverage: " + availableLanguages);
        NumberFormat percentFormat = NumberFormat.getPercentInstance(Locale.ENGLISH);
        percentFormat.setMaximumFractionDigits(1);
        Relation<VettingViewer.MissingStatus, String> missingPaths = Relation.of(new EnumMap(VettingViewer.MissingStatus.class), TreeSet.class, CLDRFile.getComparator(DtdType.ldml));
        TreeSet<String> unconfirmed = new TreeSet<String>(CLDRFile.getComparator(DtdType.ldml));
        Set<String> defaultContents = this.SUPPLEMENTAL_DATA_INFO.getDefaultContentLocales();
        Counter<Level> foundCounter = new Counter<Level>();
        Counter<Level> unconfirmedCounter = new Counter<Level>();
        Counter<Level> missingCounter = new Counter<Level>();
        AbstractCollection levelsToShow = new ArrayList<Level>(EnumSet.allOf(Level.class));
        levelsToShow.remove((Object)Level.COMPREHENSIVE);
        levelsToShow.remove((Object)Level.UNDETERMINED);
        levelsToShow = ImmutableList.copyOf(levelsToShow);
        AbstractCollection reversedLevels = new ArrayList<Level>(levelsToShow);
        Collections.reverse(reversedLevels);
        reversedLevels = ImmutableList.copyOf(reversedLevels);
        int localeCount = 0;
        NumberFormat tsvPercent = NumberFormat.getPercentInstance(Locale.ENGLISH);
        tsvPercent.setMaximumFractionDigits(2);
        long start = System.currentTimeMillis();
        LikelySubtags likelySubtags = new LikelySubtags();
        EnumMap<Level, Double> targetLevel = new EnumMap<Level, Double>(Level.class);
        targetLevel.put(Level.CORE, 0.02);
        targetLevel.put(Level.BASIC, 0.16);
        targetLevel.put(Level.MODERATE, 0.33);
        targetLevel.put(Level.MODERN, 1.0);
        TreeMultimap pathToLocale = TreeMultimap.create();
        Counter<Level> computedLevels = new Counter<Level>();
        Counter<Level> computedSublocaleLevels = new Counter<Level>();
        for (String locale : availableLanguages) {
            if (only != null && !locale.equals(only)) continue;
            logger.info("Begin Calc Cov: " + locale);
            ElapsedTimer et = new ElapsedTimer("  End Calc Cov: " + locale + " in {0}");
            try {
                String region;
                String base;
                if (locale.contains("supplemental") || locales != null && !locales.contains(locale) && !locales.contains(base = CLDRLocale.getInstance(locale).getLanguage()) || defaultContents.contains(locale) || "root".equals(locale) || "und".equals(locale) || !(region = ltp.set(locale).getRegion()).isEmpty()) continue;
                Level cldrLocaleLevelGoal = this.SC.getLocaleCoverageLevel(Organization.cldr, locale);
                String specialFlag = CalculateLocaleCoverage.getSpecialFlag(locale);
                boolean cldrLevelGoalBasicToModern = Level.CORE_TO_MODERN.contains((Object)cldrLocaleLevelGoal);
                String language = likelySubtags.minimize(locale);
                if (language == null) {
                    logger.info("skipping unminimizable " + locale);
                    continue;
                }
                missingPaths.clear();
                unconfirmed.clear();
                CLDRFile file = this.factory.make(locale, true, minimumDraftStatus);
                IterableFilter pathSource = new IterableFilter(file.fullIterable());
                VettingViewer.getStatus(pathSource, file, this.pathHeaderFactory, foundCounter, unconfirmedCounter, missingCounter, missingPaths, unconfirmed);
                long found = 0L;
                long unconfirmedc = 0L;
                long missing = 0L;
                Level adjustedGoal = cldrLocaleLevelGoal.compareTo(Level.BASIC) < 0 ? Level.BASIC : cldrLocaleLevelGoal;
                for (Level level : Level.values()) {
                    if (level.compareTo(adjustedGoal) > 0) continue;
                    found += foundCounter.get(level);
                    unconfirmedc += unconfirmedCounter.get(level);
                    missing += missingCounter.get(level);
                }
                CoverageResult cr = new CoverageResult(CLDRLocale.getInstance(locale), adjustedGoal, found, unconfirmedc, missing, cldrLocaleLevelGoal);
                this.data.put(CLDRLocale.getInstance(locale), cr);
                Collection sublocales = languageToRegion.asMap().get(language);
                if (sublocales == null) {
                    sublocales = Collections.emptySet();
                }
                sublocales = ImmutableSet.copyOf(sublocales);
                EnumMap<Level, Integer> totals = new EnumMap<Level, Integer>(Level.class);
                EnumMap<Level, Integer> confirmed = new EnumMap<Level, Integer>(Level.class);
                EnumSet<CoreCoverageInfo.CoreItems> specialMissingPaths = EnumSet.noneOf(CoreCoverageInfo.CoreItems.class);
                ShowLocaleCoverage.StatusCounter starredCounter = new ShowLocaleCoverage.StatusCounter();
                TreeMultimap<CoreCoverageInfo.CoreItems, String> detailedErrors = TreeMultimap.create();
                Set<CoreCoverageInfo.CoreItems> coverage = CoreCoverageInfo.getCoreCoverageInfo(file, detailedErrors);
                for (CoreCoverageInfo.CoreItems coreItems : coverage) {
                    foundCounter.add(coreItems.desiredLevel, 1L);
                }
                for (Map.Entry entry : detailedErrors.entries()) {
                    CoreCoverageInfo.CoreItems coreItem = (CoreCoverageInfo.CoreItems)((Object)entry.getKey());
                    String path = (String)entry.getValue();
                    specialMissingPaths.add(coreItem);
                    if (coreItem.desiredLevel == Level.BASIC) {
                        starredCounter.gatherStarred(path, null);
                    }
                    missingCounter.add(coreItem.desiredLevel, 1L);
                }
                int sumFound = 0;
                int sumMissing = 0;
                int sumUnconfirmed = 0;
                for (Level level : levelsToShow) {
                    long foundCount = foundCounter.get(level);
                    long unconfirmedCount = unconfirmedCounter.get(level);
                    long missingCount = missingCounter.get(level);
                    sumFound = (int)((long)sumFound + foundCount);
                    sumUnconfirmed = (int)((long)sumUnconfirmed + unconfirmedCount);
                    sumMissing = (int)((long)sumMissing + missingCount);
                    confirmed.put(level, sumFound);
                    totals.put(level, sumFound + sumUnconfirmed + sumMissing);
                }
                EnumMap<Level, Integer> enumMap = new EnumMap<Level, Integer>(Level.class);
                EnumMap<Level, Integer> accumConfirmed = new EnumMap<Level, Integer>(Level.class);
                int currTotals = 0;
                int currConfirmed = 0;
                for (Level level : levelsToShow) {
                    accumConfirmed.put(level, currConfirmed += ((Integer)confirmed.get((Object)level)).intValue());
                    enumMap.put(level, currTotals += ((Integer)totals.get((Object)level)).intValue());
                }
                Level computed = Level.UNDETERMINED;
                EnumMap<Level, Double> levelToProportion = new EnumMap<Level, Double>(Level.class);
                for (Level level : reversedLevels) {
                    int confirmedCoverage = (Integer)accumConfirmed.get((Object)level);
                    double total = ((Integer)enumMap.get((Object)level)).intValue();
                    double proportion = (double)confirmedCoverage / total;
                    levelToProportion.put(level, proportion);
                    if (computed != Level.UNDETERMINED) continue;
                    switch (level) {
                        case MODERN: {
                            if (!(proportion >= 0.995)) break;
                            computed = level;
                            break;
                        }
                        case MODERATE: {
                            if (!(proportion >= 0.995)) break;
                            computed = level;
                            break;
                        }
                        case BASIC: {
                            if (!(proportion >= 1.0)) break;
                            computed = level;
                            break;
                        }
                    }
                }
                EnumSet<CoreCoverageInfo.CoreItems> shownMissingPaths = EnumSet.noneOf(CoreCoverageInfo.CoreItems.class);
                Level computedWithCore = computed == Level.UNDETERMINED ? Level.BASIC : computed;
                for (CoreCoverageInfo.CoreItems item : specialMissingPaths) {
                    if (item.desiredLevel.compareTo(computedWithCore) <= 0) {
                        shownMissingPaths.add(item);
                        continue;
                    }
                    boolean bl = false;
                }
                computedLevels.add(computed, 1L);
                computedSublocaleLevels.add(computed, sublocales.size());
                String visibleLevelComputed = computed.toString();
                cr.setVisibleLevelComputed(visibleLevelComputed);
                try {
                    cr.setICU(!CalculateLocaleCoverage.getIcuValue(language).isEmpty());
                }
                catch (Throwable t2) {
                    logger.log(java.util.logging.Level.SEVERE, "getting icu value for " + language, t2);
                }
                cr.setSumFound(sumFound);
                cr.setSumUnconfirmed(sumUnconfirmed);
                for (Level level : reversedLevels) {
                    cr.setProportion(level, (Double)levelToProportion.get((Object)level));
                }
                cr.setMissingPaths(shownMissingPaths);
                ++localeCount;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            logger.info(et.toString());
        }
        long end = System.currentTimeMillis();
        logger.info(end - start + " millis = " + (end - start) / (long)localeCount + " millis/locale");
    }

    private static String getSpecialFlag(String locale) {
        return StandardCodes.make().getLocaleCoverageLevel(Organization.special, locale) == Level.UNDETERMINED ? "" : "\u2021";
    }

    private static String getIcuValue(String locale) {
        return ICU_Locales.contains(new ULocale(locale)) ? "ICU" : "";
    }

    private static class IterableFilter
    implements Iterable<String> {
        private Iterable<String> source;
        private static final Set<String> SUPPRESS_PATHS_AFTER_SUBMISSION = ImmutableSet.of();

        IterableFilter(Iterable<String> source) {
            this.source = source;
        }

        @Override
        public Iterator<String> iterator() {
            return new IteratorFilter(this.source.iterator());
        }

        private static class IteratorFilter
        implements Iterator<String> {
            Iterator<String> source;
            String peek;

            public IteratorFilter(Iterator<String> source) {
                this.source = source;
                this.fillPeek();
            }

            @Override
            public boolean hasNext() {
                return this.peek != null;
            }

            @Override
            public String next() {
                String result = this.peek;
                this.fillPeek();
                return result;
            }

            private void fillPeek() {
                this.peek = null;
                while (this.source.hasNext()) {
                    this.peek = this.source.next();
                    if (!SUPPRESS_PATHS_AFTER_SUBMISSION.contains(this.peek) && SUPPRESS_PATHS_CAN_BE_EMPTY.get(this.peek) != Boolean.TRUE) break;
                    this.peek = null;
                }
            }
        }
    }

    public static final class CoverageResult {
        public final Level staticLevel;
        public final String locale;
        public final String adjustedGoal;
        public final long found;
        public final long unconfirmedc;
        public final long missing;
        public final Level cldrLocaleLevelGoal;
        public String visibleLevelComputed;
        public boolean icu = false;
        public int sumFound;
        public int sumUnconfirmed;
        public double[] proportions = new double[Level.values().length];
        public String[] shownMissingPaths;

        public CoverageResult(CLDRLocale locale, Level adjustedGoal, long found, long unconfirmedc, long missing, Level cldrLocaleLevelGoal) {
            this.locale = locale.getBaseName();
            this.adjustedGoal = adjustedGoal.name();
            this.found = found;
            this.unconfirmedc = unconfirmedc;
            this.missing = missing;
            this.cldrLocaleLevelGoal = cldrLocaleLevelGoal;
            this.staticLevel = CalculatedCoverageLevels.getInstance().getEffectiveCoverageLevel(locale);
        }

        public void setVisibleLevelComputed(String visibleLevelComputed) {
            this.visibleLevelComputed = visibleLevelComputed;
        }

        public void setICU(boolean b) {
            this.icu = b;
        }

        public void setSumFound(int sumFound) {
            this.sumFound = sumFound;
        }

        public void setSumUnconfirmed(int sumUnconfirmed) {
            this.sumUnconfirmed = sumUnconfirmed;
        }

        public void setProportion(Level level, Double double1) {
            this.proportions[level.ordinal()] = double1;
        }

        public void setMissingPaths(Set<CoreCoverageInfo.CoreItems> shownMissingPaths) {
            this.shownMissingPaths = (String[])shownMissingPaths.stream().map(m4 -> m4.name()).toArray(String[]::new);
        }
    }
}

