/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Splitter;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.impl.UnicodeMap;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.Transform;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ICUException;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.ULocale;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.ScriptMetadata;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.util.Builder;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRURLS;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Containment;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.Emoji;
import org.unicode.cldr.util.EnumNames;
import org.unicode.cldr.util.GrammarInfo;
import org.unicode.cldr.util.InternalCldrException;
import org.unicode.cldr.util.MapComparator;
import org.unicode.cldr.util.NameGetter;
import org.unicode.cldr.util.NameType;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.RegexLookup;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.StringId;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.UnitConverter;
import org.unicode.cldr.util.With;
import org.unicode.cldr.util.XPathParts;
import org.unicode.cldr.util.personname.PersonNameFormatter;

public class PathHeader
implements Comparable<PathHeader> {
    public static final String SECTION_LINK = "<a href='";
    static boolean UNIFORM_CONTINENTS = true;
    static Factory factorySingleton = null;
    static final boolean SKIP_ORIGINAL_PATH = true;
    private static final Logger logger = Logger.getLogger(PathHeader.class.getName());
    static final Splitter HYPHEN_SPLITTER = Splitter.on('-');
    private static final EnumNames<SectionId> SectionIdNames = new EnumNames();
    private static final EnumNames<PageId> PageIdNames = new EnumNames();
    private static final Relation<SectionId, PageId> SectionIdToPageIds = Relation.of(new TreeMap(), TreeSet.class);
    private final SectionId sectionId;
    private final PageId pageId;
    private final String header;
    private final String code;
    private final String originalPath;
    private final SurveyToolStatus status;
    private final int headerOrder;
    private final long codeOrder;
    private final SubstringOrder codeSuborder;
    static final Pattern SEMI = PatternCache.get("\\s*;\\s*");
    static final Matcher ALT_MATCHER = PatternCache.get("\\[@alt=\"([^\"]*+)\"]").matcher("");
    static final SupplementalDataInfo supplementalDataInfo = SupplementalDataInfo.getInstance();
    static final Map<String, String> metazoneToContinent = supplementalDataInfo.getMetazoneToContinentMap();
    static final Map<String, String> metazoneToPageTerritory = new HashMap<String, String>();
    private static final List<String> COUNTS;
    private static Collator alphabetic;
    private static final String SURVEY_URL;
    private static UnicodeMap<PageId> nonEmojiMap;

    private PathHeader(SectionId sectionId, PageId pageId, String header, int headerOrder, String code, long codeOrder, SubstringOrder suborder, SurveyToolStatus status, String originalPath) {
        this.sectionId = sectionId;
        this.pageId = pageId;
        this.header = header;
        this.headerOrder = headerOrder;
        this.code = code;
        this.codeOrder = codeOrder;
        this.codeSuborder = suborder;
        this.originalPath = originalPath;
        this.status = status;
    }

    public static Factory getFactory(CLDRFile englishFile) {
        if (factorySingleton == null) {
            if (englishFile == null) {
                englishFile = CLDRConfig.getInstance().getEnglish();
            }
            if (!englishFile.getLocaleID().equals(ULocale.ENGLISH.getBaseName())) {
                throw new IllegalArgumentException("PathHeader's CLDRFile must be '" + ULocale.ENGLISH.getBaseName() + "', but found '" + englishFile.getLocaleID() + "'");
            }
            factorySingleton = new Factory(englishFile);
        }
        return factorySingleton;
    }

    public static Factory getFactory() {
        return PathHeader.getFactory(null);
    }

    @Deprecated
    public String getSection() {
        return this.sectionId.toString();
    }

    public SectionId getSectionId() {
        return this.sectionId;
    }

    @Deprecated
    public String getPage() {
        return this.pageId.toString();
    }

    public PageId getPageId() {
        return this.pageId;
    }

    public String getHeader() {
        return this.header == null ? "" : this.header;
    }

    public String getCode() {
        return this.code;
    }

    public String getHeaderCode() {
        return this.getHeader() + ": " + this.getCode();
    }

    public String getOriginalPath() {
        return this.originalPath;
    }

    public SurveyToolStatus getSurveyToolStatus() {
        return this.status;
    }

    public String toString() {
        return this.sectionId + "\t" + this.pageId + "\t" + this.header + "\t" + this.code;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(PathHeader other) {
        try {
            int result = this.sectionId.compareTo(other.sectionId);
            if (0 != result) {
                return result;
            }
            result = this.pageId.compareTo(other.pageId);
            if (0 != result) {
                return result;
            }
            result = this.headerOrder - other.headerOrder;
            if (0 != result) {
                return result;
            }
            result = PathHeader.alphabeticCompare(this.header, other.header);
            if (0 != result) {
                return result;
            }
            long longResult = this.codeOrder - other.codeOrder;
            if (0L != longResult) {
                if (longResult >= 0L) return 1;
                return -1;
            }
            if (this.codeSuborder != null) {
                if (other.codeSuborder == null) return 1;
                result = this.codeSuborder.compareTo(other.codeSuborder);
                if (0 != result) {
                    return result;
                }
            } else if (other.codeSuborder != null) {
                return -1;
            }
            if (0 == (result = PathHeader.alphabeticCompare(this.code, other.code))) return 0;
            return result;
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Internal problem comparing " + this + " and " + other, e);
        }
    }

    public boolean equals(Object obj) {
        PathHeader other;
        try {
            other = (PathHeader)obj;
        }
        catch (Exception e) {
            return false;
        }
        return this.sectionId == other.sectionId && this.pageId == other.pageId && this.header.equals(other.header) && this.code.equals(other.code);
    }

    public int hashCode() {
        return this.sectionId.hashCode() ^ this.pageId.hashCode() ^ this.header.hashCode() ^ this.code.hashCode();
    }

    public static String getMetazonePageTerritory(String source) {
        String result = metazoneToPageTerritory.get(source);
        return result == null ? "ZZ" : result;
    }

    private static int alphabeticCompare(String aa, String bb) {
        if (alphabetic == null) {
            PathHeader.initializeAlphabetic();
        }
        return alphabetic.compare(aa, bb);
    }

    private static synchronized void initializeAlphabetic() {
        if (alphabetic == null) {
            alphabetic = CLDRConfig.getInstance().getCollatorRoot();
        }
    }

    public String getUrl(BaseUrl baseUrl, String locale) {
        return this.getUrl(baseUrl.base, locale);
    }

    public String getUrl(String baseUrl, String locale) {
        return PathHeader.getUrl(baseUrl, locale, this.getOriginalPath());
    }

    public static String trimLast(String str) {
        int n = str.lastIndexOf(47);
        if (n == -1) {
            return "";
        }
        return str.substring(0, n + 1);
    }

    public static String getUrlForLocalePath(String locale, String path) {
        return PathHeader.getUrl(SURVEY_URL, locale, path);
    }

    public static String getUrl(String baseUrl, String locale, String path) {
        return PathHeader.trimLast(baseUrl) + "v#/" + locale + "//" + StringId.getHexId(path);
    }

    @Deprecated
    public static String getLinkedView(String baseUrl, CLDRFile file, String path) {
        return SECTION_LINK + PathHeader.getUrl(baseUrl, file.getLocaleID(), path) + "'><em>view</em></a>";
    }

    public static String getLinkedView(CLDRURLS urls, CLDRFile file, String path) {
        return SECTION_LINK + urls.forXpath(file.getLocaleID(), path) + "'><em>view</em></a>";
    }

    private static String getSubdivisionsTerritory(String input, Output<String> suffix) {
        String theTerritory;
        if (StandardCodes.LstrType.subdivision.isWellFormed(input)) {
            int territoryEnd = input.charAt(0) < 'A' ? 3 : 2;
            theTerritory = input.substring(0, territoryEnd).toUpperCase(Locale.ROOT);
            if (suffix != null) {
                suffix.value = input.substring(territoryEnd);
            }
        } else {
            theTerritory = input;
            if (suffix != null) {
                suffix.value = "";
            }
        }
        return theTerritory;
    }

    public boolean shouldHide() {
        switch (this.status) {
            case HIDE: 
            case DEPRECATED: {
                return true;
            }
            case READ_ONLY: 
            case READ_WRITE: 
            case LTR_ALWAYS: {
                return false;
            }
        }
        logger.log(Level.SEVERE, "Missing case for " + this.status);
        return false;
    }

    public boolean canReadAndWrite() {
        switch (this.status) {
            case READ_WRITE: 
            case LTR_ALWAYS: {
                return true;
            }
            case HIDE: 
            case DEPRECATED: 
            case READ_ONLY: {
                return false;
            }
        }
        logger.log(Level.SEVERE, "Missing case for " + this.status);
        return false;
    }

    private static PageId getCharacterPageId(String cp) {
        PageId pageId;
        if (Emoji.getAllRgiNoES().contains(cp)) {
            return Emoji.getPageId(cp);
        }
        if (nonEmojiMap == null) {
            nonEmojiMap = PathHeader.createNonEmojiMap();
        }
        if ((pageId = nonEmojiMap.get(cp)) == null) {
            throw new InternalCldrException("Failure getting character page id");
        }
        return pageId;
    }

    private static UnicodeMap<PageId> createNonEmojiMap() {
        return new UnicodeMap<PageId>().putAll(new UnicodeSet("[:P:]"), PageId.Punctuation).putAll(new UnicodeSet("[:Sm:]"), PageId.MathSymbols).putAll(new UnicodeSet("[^[:Sm:][:P:]]"), PageId.OtherSymbols).freeze();
    }

    static {
        Map<String, Map<String, String>> metazoneToRegionToZone = supplementalDataInfo.getMetazoneToRegionToZone();
        for (Map.Entry<String, Map<String, String>> metazoneEntry : metazoneToRegionToZone.entrySet()) {
            String metazone = metazoneEntry.getKey();
            String worldZone = metazoneEntry.getValue().get("001");
            String territory = Containment.getRegionFromZone(worldZone);
            if (territory == null) {
                territory = "ZZ";
            }
            if (territory.equals("RU") || territory.equals("AQ")) {
                metazoneToPageTerritory.put(metazone, territory);
                continue;
            }
            String continent = Containment.getContinent(territory);
            String subcontinent = Containment.getSubcontinent(territory);
            if (continent.equals("142")) {
                metazoneToPageTerritory.put(metazone, subcontinent);
                continue;
            }
            if (continent.equals("019")) {
                metazoneToPageTerritory.put(metazone, subcontinent.equals("005") ? subcontinent : "003");
                continue;
            }
            if (subcontinent.equals("053")) {
                metazoneToPageTerritory.put(metazone, subcontinent);
                continue;
            }
            metazoneToPageTerritory.put(metazone, continent);
        }
        COUNTS = Arrays.asList("displayName", "zero", "one", "two", "few", "many", "other", "per");
        SURVEY_URL = CLDRConfig.getInstance().urls().base();
        nonEmojiMap = null;
    }

    @Deprecated
    public static enum BaseUrl {
        SMOKE("https://st.unicode.org/smoketest/survey"),
        PRODUCTION("https://st.unicode.org/cldr-apps/survey");

        final String base;

        private BaseUrl(String url) {
            this.base = url;
        }
    }

    public static class Factory
    implements Transform<String, PathHeader> {
        static final RegexLookup<RawData> lookup = RegexLookup.of(new PathHeaderTransform()).setPatternTransform(RegexLookup.RegexFinderTransformPath).loadFromFile(PathHeader.class, "data/PathHeader.txt");
        static final Output<String[]> args = new Output();
        static final Counter<RawData> counter = new Counter();
        static final Map<RawData, String> samples = new HashMap<RawData, String>();
        static long order;
        static SubstringOrder suborder;
        static final Map<String, PathHeader> cache;
        static final Map<SectionId, Map<PageId, SectionPage>> sectionToPageToSectionPage;
        static final Relation<SectionPage, String> sectionPageToPaths;
        private static CLDRFile englishFile;
        private static NameGetter englishNameGetter;
        private final Set<String> matchersFound = new HashSet<String>();
        static Map<String, Transform<String, String>> functionMap;
        static String[] months;
        static List<String> days;
        static List<String> unitOrder;
        static final MapComparator<String> dayPeriods;
        static LikelySubtags likelySubtags;
        static HyphenSplitter hyphenSplitter;
        static Transform<String, String> catFromTerritory;
        static Transform<String, String> catFromTimezone;
        private static Set<UnitConverter.UnitSystem> METRIC_UNITS;
        private static Set<UnitConverter.UnitSystem> US_UNITS;

        private Factory(CLDRFile englishFile) {
            Factory.setEnglishCLDRFileIfNotSet(englishFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void setEnglishCLDRFileIfNotSet(CLDRFile englishFile2) {
            Class<Factory> clazz = Factory.class;
            synchronized (Factory.class) {
                if (englishFile == null) {
                    englishFile = englishFile2;
                    englishNameGetter = englishFile.nameGetter();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearCache() {
            Map<String, PathHeader> map = cache;
            synchronized (map) {
                cache.clear();
            }
        }

        public PathHeader fromPath(String path) {
            return this.fromPath(path, null);
        }

        @Override
        public PathHeader transform(String path) {
            return this.fromPath(path, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PathHeader fromPath(String path, List<String> failures) {
            if (path == null) {
                throw new NullPointerException("Path cannot be null");
            }
            Object object = cache;
            synchronized (object) {
                PathHeader old = cache.get(path);
                if (old != null) {
                    return old;
                }
            }
            object = lookup;
            synchronized (object) {
                Output<RegexLookup.Finder> matcherFound;
                RawData data;
                Object cleanPath = path;
                String alt = null;
                int altPos = ((String)cleanPath).indexOf("[@alt=");
                if (altPos >= 0 && !((String)cleanPath).endsWith("/symbol[@alt=\"narrow\"]")) {
                    if (ALT_MATCHER.reset((CharSequence)cleanPath).find()) {
                        alt = ALT_MATCHER.group(1);
                        cleanPath = ((String)cleanPath).substring(0, ALT_MATCHER.start()) + ((String)cleanPath).substring(ALT_MATCHER.end());
                        int pos = alt.indexOf("proposed");
                        if (pos >= 0 && !path.startsWith("//ldml/collations")) {
                            alt = pos == 0 ? null : alt.substring(0, pos - 1);
                        }
                    } else {
                        throw new IllegalArgumentException();
                    }
                }
                if ((data = lookup.get((String)cleanPath, null, args, matcherFound = new Output<RegexLookup.Finder>(), failures)) == null) {
                    return null;
                }
                this.matchersFound.add(((RegexLookup.Finder)matcherFound.value).toString());
                counter.add(data, 1L);
                if (!samples.containsKey(data)) {
                    samples.put(data, (String)cleanPath);
                }
                try {
                    PathHeader result = this.makePathHeader(data, path, alt);
                    Map<String, PathHeader> map = cache;
                    synchronized (map) {
                        SectionPage sectionPage;
                        PathHeader old = cache.get(path);
                        if (old == null) {
                            cache.put(path, result);
                        } else {
                            result = old;
                        }
                        Map<PageId, SectionPage> pageToPathHeaders = sectionToPageToSectionPage.get((Object)result.sectionId);
                        if (pageToPathHeaders == null) {
                            pageToPathHeaders = new EnumMap<PageId, SectionPage>(PageId.class);
                            sectionToPageToSectionPage.put(result.sectionId, pageToPathHeaders);
                        }
                        if ((sectionPage = pageToPathHeaders.get((Object)result.pageId)) == null) {
                            sectionPage = new SectionPage(result.sectionId, result.pageId);
                            pageToPathHeaders.put(result.pageId, sectionPage);
                        }
                        sectionPageToPaths.put(sectionPage, path);
                    }
                    return result;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Probably mismatch in Page/Section enum, or too few capturing groups in regex for " + path, e);
                }
            }
        }

        private PathHeader makePathHeader(RawData data, String path, String alt) {
            SectionId newSectionId = SectionId.forString(Factory.fix(data.section, 0));
            PageId newPageId = PageId.forString(Factory.fix(data.page, 0));
            String newHeader = Factory.fix(data.header, data.headerOrder);
            int newHeaderOrder = (int)order;
            String codeDashAlt = data.code + (String)(alt == null ? "" : "-" + alt);
            String newCode = Factory.fix(codeDashAlt, data.codeOrder);
            long newCodeOrder = order;
            return new PathHeader(newSectionId, newPageId, newHeader, newHeaderOrder, newCode, newCodeOrder, suborder, data.status, path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Set<String> getCachedPaths(SectionId sectionId, PageId page) {
            HashSet<String> target = new HashSet<String>();
            Map<String, PathHeader> map = cache;
            synchronized (map) {
                Map<PageId, SectionPage> pageToSectionPage = sectionToPageToSectionPage.get((Object)sectionId);
                if (pageToSectionPage == null) {
                    return target;
                }
                SectionPage sectionPage = pageToSectionPage.get((Object)page);
                if (sectionPage == null) {
                    return target;
                }
                Set<String> set = sectionPageToPaths.getAll(sectionPage);
                target.addAll(set);
            }
            return target;
        }

        public static Relation<SectionId, PageId> getSectionIdsToPageIds() {
            SectionIdToPageIds.freeze();
            return SectionIdToPageIds;
        }

        public Iterable<String> filterCldr(SectionId section, PageId page, CLDRFile file) {
            return new FilteredIterable(section, page, file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public Counter<CounterData> getInternalCounter() {
            RegexLookup<RawData> regexLookup = lookup;
            synchronized (regexLookup) {
                Counter<CounterData> result = new Counter<CounterData>();
                for (Map.Entry<RegexLookup.Finder, RawData> entry : lookup) {
                    RegexLookup.Finder finder = entry.getKey();
                    RawData data = entry.getValue();
                    long count = counter.get(data);
                    result.add(new CounterData(finder.toString(), data, samples.get(data)), count);
                }
                return result;
            }
        }

        private static int getIndex(String item, String[] array) {
            for (int i = 0; i < array.length; ++i) {
                if (!item.equals(array[i])) continue;
                return i;
            }
            return -1;
        }

        private static String getEnglishFirstLetter(String s2) {
            int underscorePos = s2.indexOf("_");
            String languageOnlyPart = underscorePos > 0 ? s2.substring(0, underscorePos) : s2;
            String name = englishNameGetter.getNameFromTypeEnumCode(NameType.LANGUAGE, languageOnlyPart);
            return name == null ? "?" : name.substring(0, 1).toUpperCase();
        }

        private static String fix(String input, int orderIn) {
            input = RegexLookup.replace((String)input, (String[])Factory.args.value);
            order = orderIn;
            suborder = null;
            int pos = 0;
            int functionStart;
            while ((functionStart = ((String)input).indexOf(38, pos)) >= 0) {
                String arg;
                int functionEnd = ((String)input).indexOf(40, functionStart);
                int argEnd = ((String)input).indexOf(41, functionEnd + 2);
                Transform<String, String> func = functionMap.get(((String)input).substring(functionStart + 1, functionEnd));
                String temp = func.transform(arg = ((String)input).substring(functionEnd + 1, argEnd));
                if (temp == null) {
                    func.transform(arg);
                    throw new IllegalArgumentException("Function returns invalid results for \u00ab" + arg + "\u00bb.");
                }
                input = ((String)input).substring(0, functionStart) + temp + ((String)input).substring(argEnd + 1);
                pos = functionStart + temp.length();
            }
            return Factory.adjustPageForPath((String)input, ((String[])Factory.args.value)[0]).toString();
        }

        private static String adjustPageForPath(String input, String path) {
            if ("Fields".equals(input)) {
                return Factory.getFieldsPageId(path).toString();
            }
            if ("Length".equals(input)) {
                return Factory.getLengthPageId(path).toString();
            }
            if ("Other Units".equals(input)) {
                return Factory.getOtherUnitsPageId(path).toString();
            }
            if ("Volume".equals(input)) {
                return Factory.getVolumePageId(path).toString();
            }
            return input;
        }

        private static PageId getFieldsPageId(String path) {
            XPathParts parts = XPathParts.getFrozenInstance(path);
            return parts.containsElement("relative") || parts.containsElement("relativeTime") || parts.containsElement("relativePeriod") ? PageId.Relative : PageId.Fields;
        }

        private static PageId getLengthPageId(String path) {
            String shortUnitId = Factory.getShortUnitId(path);
            if (Factory.isSystemUnit(shortUnitId, METRIC_UNITS)) {
                return PageId.Length_Metric;
            }
            return PageId.Length_Other;
        }

        private static PageId getVolumePageId(String path) {
            String shortUnitId = Factory.getShortUnitId(path);
            if (Factory.isSystemUnit(shortUnitId, METRIC_UNITS)) {
                return PageId.Volume_Metric;
            }
            return Factory.isSystemUnit(shortUnitId, US_UNITS) ? PageId.Volume_US : PageId.Volume_Other;
        }

        private static PageId getOtherUnitsPageId(String path) {
            String shortUnitId = Factory.getShortUnitId(path);
            if (Factory.isSystemUnit(shortUnitId, METRIC_UNITS)) {
                return shortUnitId.contains("per") ? PageId.OtherUnitsMetricPer : PageId.OtherUnitsMetric;
            }
            return Factory.isSystemUnit(shortUnitId, US_UNITS) ? PageId.OtherUnitsUS : PageId.OtherUnits;
        }

        private static boolean isSystemUnit(String shortUnitId, Set<UnitConverter.UnitSystem> system) {
            UnitConverter uc = supplementalDataInfo.getUnitConverter();
            Set<UnitConverter.UnitSystem> systems = uc.getSystemsEnum(shortUnitId);
            return !Collections.disjoint(system, systems);
        }

        private static String getShortUnitId(String path) {
            String longUnitId = XPathParts.getFrozenInstance(path).findAttributeValue("unit", "type");
            if (longUnitId == null) {
                throw new InternalCldrException("Missing unit in path " + path);
            }
            UnitConverter uc = supplementalDataInfo.getUnitConverter();
            return uc.getShortId(longUnitId);
        }

        public Set<String> pathsForFile(CLDRFile file) {
            HashSet filePaths = new HashSet();
            file.fullIterable().forEach(filePaths::add);
            for (String path : filePaths) {
                try {
                    this.fromPath(path);
                }
                catch (Throwable throwable) {}
            }
            return Collections.unmodifiableSet(filePaths);
        }

        public Set<String> getUnmatchedRegexes() {
            LinkedHashMap outputUnmatched = new LinkedHashMap();
            lookup.getUnmatchedPatterns(this.matchersFound, outputUnmatched);
            return outputUnmatched.keySet();
        }

        static {
            cache = new HashMap<String, PathHeader>();
            sectionToPageToSectionPage = new EnumMap<SectionId, Map<PageId, SectionPage>>(SectionId.class);
            sectionPageToPaths = Relation.of(new TreeMap(), HashSet.class);
            functionMap = new HashMap<String, Transform<String, String>>();
            months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "Und"};
            days = Arrays.asList("sun", "mon", "tue", "wed", "thu", "fri", "sat");
            unitOrder = DtdData.getUnitOrder().getOrder();
            dayPeriods = new MapComparator<String>().add("am", "pm", "midnight", "noon", "morning1", "morning2", "afternoon1", "afternoon2", "evening1", "evening2", "night1", "night2").freeze();
            likelySubtags = new LikelySubtags();
            hyphenSplitter = new HyphenSplitter();
            functionMap.put("month", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    int m4 = Integer.parseInt(source);
                    order = m4;
                    return months[m4 - 1];
                }
            });
            functionMap.put("count", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    suborder = new SubstringOrder(source);
                    return source;
                }
            });
            functionMap.put("count2", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    int pos = ((String)source).indexOf(45);
                    source = pos + ((String)source).substring(pos);
                    suborder = new SubstringOrder((String)source);
                    return source;
                }
            });
            functionMap.put("currencySymbol", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    order = 901L;
                    if (source.endsWith("narrow")) {
                        order = 902L;
                    }
                    if (source.endsWith("variant")) {
                        order = 903L;
                    }
                    return source;
                }
            });
            functionMap.put("unitCount", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    List<String> parts = HYPHEN_SPLITTER.splitToList(source);
                    if (parts.size() == 1) {
                        return source;
                    }
                    int lengthNumber = Width.getValue(parts.get(0)).ordinal();
                    int type = 0;
                    int rest = 0;
                    switch (parts.get(1)) {
                        case "gender": {
                            type = 0;
                            break;
                        }
                        case "displayName": {
                            type = 1;
                            break;
                        }
                        case "per": {
                            type = 2;
                            break;
                        }
                        default: {
                            type = 3;
                            int countNumber = (parts.size() > 1 ? SupplementalDataInfo.PluralInfo.Count.valueOf(parts.get(1)) : SupplementalDataInfo.PluralInfo.Count.other).ordinal();
                            int caseNumber = (parts.size() > 2 ? GrammarInfo.CaseValues.valueOf(parts.get(2)) : GrammarInfo.CaseValues.nominative).ordinal();
                            int genderNumber = GrammarInfo.GenderValues.neuter.ordinal();
                            if (parts.size() > 3) {
                                String genderPart = parts.get(3);
                                if (!genderPart.equals("dgender")) {
                                    genderNumber = GrammarInfo.GenderValues.valueOf(genderPart).ordinal();
                                }
                                type = 4;
                            }
                            rest = countNumber << 16 | caseNumber << 8 | genderNumber;
                        }
                    }
                    order = type << 28 | lengthNumber << 24 | rest;
                    return source;
                }
            });
            functionMap.put("pluralNumber", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    order = GrammarInfo.PluralValues.valueOf(source).ordinal();
                    return source;
                }
            });
            functionMap.put("caseNumber", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    order = GrammarInfo.CaseValues.valueOf(source).ordinal();
                    return source;
                }
            });
            functionMap.put("genderNumber", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    order = GrammarInfo.GenderValues.valueOf(source).ordinal();
                    return source;
                }
            });
            functionMap.put("day", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    int m4 = days.indexOf(source);
                    order = m4;
                    return source;
                }
            });
            functionMap.put("dayPeriod", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    try {
                        order = dayPeriods.getNumericOrder(source).intValue();
                    }
                    catch (Exception e) {
                        order = Math.abs(source.hashCode() << 16);
                    }
                    return source;
                }
            });
            functionMap.put("calendar", new Transform<String, String>(){
                final Map<String, String> fixNames = Builder.with(new HashMap()).put("islamicc", "Islamic Civil").put("roc", "Minguo").put("Ethioaa", "Ethiopic Amete Alem").put("Gregory", "Gregorian").put("iso8601", "ISO 8601").freeze();

                @Override
                public String transform(String source) {
                    String result = this.fixNames.get(source);
                    return result != null ? result : UCharacter.toTitleCase(source, null);
                }
            });
            functionMap.put("calField", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    String[] fields = source.split(":", 3);
                    order = 0L;
                    List<String> widthValues = Arrays.asList("wide", "abbreviated", "short", "narrow");
                    List<String> calendarFieldValues = Arrays.asList("Eras", "Quarters", "Months", "Days", "DayPeriods", "Formats");
                    List<String> calendarFormatTypes = Arrays.asList("Standard", "Flexible", "Intervals");
                    List<String> calendarContextTypes = Arrays.asList("none", "format", "stand-alone");
                    List<String> calendarFormatSubtypes = Arrays.asList("date", "time", "time12", "time24", "dateTime", "fallback");
                    HashMap fixNames = Builder.with(new HashMap()).put("DayPeriods", "Day Periods").put("format", "Formatting").put("stand-alone", "Standalone").put("none", "").put("date", "Date Formats").put("time", "Time Formats").put("time12", "12 Hour Time Formats").put("time24", "24 Hour Time Formats").put("dateTime", "Date & Time Combination Formats").freeze();
                    order = calendarFieldValues.contains(fields[0]) ? (long)(calendarFieldValues.indexOf(fields[0]) * 100) : (long)(calendarFieldValues.size() * 100);
                    if (fields[0].equals("Formats")) {
                        order = calendarFormatTypes.contains(fields[1]) ? (order += (long)(calendarFormatTypes.indexOf(fields[1]) * 10)) : (order += (long)(calendarFormatTypes.size() * 10));
                        order = calendarFormatSubtypes.contains(fields[2]) ? (order += (long)calendarFormatSubtypes.indexOf(fields[2])) : (order += (long)calendarFormatSubtypes.size());
                    } else {
                        order = widthValues.contains(fields[1]) ? (order += (long)(widthValues.indexOf(fields[1]) * 10)) : (order += (long)(widthValues.size() * 10));
                        order = calendarContextTypes.contains(fields[2]) ? (order += (long)calendarContextTypes.indexOf(fields[2])) : (order += (long)calendarContextTypes.size());
                    }
                    String[] fixedFields = new String[fields.length];
                    for (int i = 0; i < fields.length; ++i) {
                        String s2 = (String)fixNames.get(fields[i]);
                        fixedFields[i] = s2 != null ? s2 : fields[i];
                    }
                    return fixedFields[0] + " - " + fixedFields[1] + (String)(fixedFields[2].length() > 0 ? " - " + fixedFields[2] : "");
                }
            });
            functionMap.put("titlecase", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    return UCharacter.toTitleCase(source, null);
                }
            });
            functionMap.put("categoryFromScript", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    String script = hyphenSplitter.split(source);
                    ScriptMetadata.Info info = ScriptMetadata.getInfo(script);
                    if (info == null) {
                        info = ScriptMetadata.getInfo("Zzzz");
                    }
                    order = 100 - info.idUsage.ordinal();
                    return info.idUsage.name;
                }
            });
            functionMap.put("categoryFromKey", new Transform<String, String>(){
                final Map<String, String> fixNames = Builder.with(new HashMap()).put("cf", "Currency Format").put("em", "Emoji Presentation").put("fw", "First Day of Week").put("lb", "Line Break").put("hc", "Hour Cycle").put("ms", "Measurement System").put("ss", "Sentence Break Suppressions").freeze();

                @Override
                public String transform(String source) {
                    String fixedName = this.fixNames.get(source);
                    return fixedName != null ? fixedName : source;
                }
            });
            functionMap.put("languageSection", new Transform<String, String>(){
                final char[] languageRangeStartPoints = new char[]{'A', 'E', 'K', 'O', 'T'};
                final char[] languageRangeEndPoints = new char[]{'D', 'J', 'N', 'S', 'Z'};

                @Override
                public String transform(String source0) {
                    char firstLetter = Factory.getEnglishFirstLetter(source0).charAt(0);
                    for (int i = 0; i < this.languageRangeStartPoints.length; ++i) {
                        if (firstLetter < this.languageRangeStartPoints[i] || firstLetter > this.languageRangeEndPoints[i]) continue;
                        return "Languages (" + Character.toUpperCase(this.languageRangeStartPoints[i]) + "-" + Character.toUpperCase(this.languageRangeEndPoints[i]) + ")";
                    }
                    return "Languages";
                }
            });
            functionMap.put("firstLetter", new Transform<String, String>(){

                @Override
                public String transform(String source0) {
                    return Factory.getEnglishFirstLetter(source0);
                }
            });
            functionMap.put("languageSort", new Transform<String, String>(){

                @Override
                public String transform(String source0) {
                    int underscorePos = source0.indexOf("_");
                    String languageOnlyPart = underscorePos > 0 ? source0.substring(0, underscorePos) : source0;
                    return englishNameGetter.getNameFromTypeEnumCode(NameType.LANGUAGE, languageOnlyPart) + " \u25ba " + source0;
                }
            });
            functionMap.put("scriptFromLanguage", new Transform<String, String>(){

                @Override
                public String transform(String source0) {
                    String language = hyphenSplitter.split(source0);
                    String script = likelySubtags.getLikelyScript(language);
                    if (script == null) {
                        script = likelySubtags.getLikelyScript(language);
                    }
                    String scriptName = englishNameGetter.getNameFromTypeEnumCode(NameType.SCRIPT, script);
                    return "Languages in " + (String)(script.equals("Hans") || script.equals("Hant") ? "Han Script" : (scriptName.endsWith(" Script") ? scriptName : scriptName + " Script"));
                }
            });
            catFromTerritory = new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    String territory = PathHeader.getSubdivisionsTerritory(source, null);
                    String container = Containment.getContainer(territory);
                    order = Containment.getOrder(territory);
                    return englishNameGetter.getNameFromTypeEnumCode(NameType.TERRITORY, container);
                }
            };
            functionMap.put("categoryFromTerritory", catFromTerritory);
            functionMap.put("territorySection", new Transform<String, String>(){
                final Set<String> specialRegions = new HashSet<String>(Arrays.asList("EZ", "EU", "QO", "UN", "ZZ"));

                @Override
                public String transform(String source0) {
                    String theContinent;
                    String theTerritory = PathHeader.getSubdivisionsTerritory(source0, null);
                    try {
                        if (this.specialRegions.contains(theTerritory) || theTerritory.charAt(0) < 'A' && Integer.parseInt(theTerritory) > 0) {
                            return "Geographic Regions";
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    switch (theContinent = Containment.getContinent(theTerritory)) {
                        case "019": {
                            String subcontinent = Containment.getSubcontinent(theTerritory);
                            String theSubContinent = subcontinent.equals("005") ? "005" : "003";
                            return "Territories (" + englishNameGetter.getNameFromTypeEnumCode(NameType.TERRITORY, theSubContinent) + ")";
                        }
                        case "001": 
                        case "ZZ": {
                            return "Geographic Regions";
                        }
                    }
                    return "Territories (" + englishNameGetter.getNameFromTypeEnumCode(NameType.TERRITORY, theContinent) + ")";
                }
            });
            catFromTimezone = new Transform<String, String>(){

                @Override
                public String transform(String source0) {
                    String territory = Containment.getRegionFromZone(source0);
                    if (territory == null) {
                        territory = "ZZ";
                    }
                    return catFromTerritory.transform(territory);
                }
            };
            functionMap.put("categoryFromTimezone", catFromTimezone);
            functionMap.put("timeZonePage", new Transform<String, String>(){
                Set<String> singlePageTerritories = new HashSet<String>(Arrays.asList("AQ", "RU", "ZZ"));

                @Override
                public String transform(String source0) {
                    String theTerritory = Containment.getRegionFromZone(source0);
                    if (theTerritory == null || "001".equals(theTerritory) || "ZZ".equals(theTerritory)) {
                        if ("Etc/Unknown".equals(source0)) {
                            theTerritory = "ZZ";
                        } else {
                            throw new IllegalArgumentException("ICU needs zone update? Source: " + source0 + "; Territory: " + theTerritory);
                        }
                    }
                    if (this.singlePageTerritories.contains(theTerritory)) {
                        return englishNameGetter.getNameFromTypeEnumCode(NameType.TERRITORY, theTerritory);
                    }
                    String theContinent = Containment.getContinent(theTerritory);
                    String subcontinent = Containment.getSubcontinent(theTerritory);
                    switch (Integer.parseInt(theContinent)) {
                        case 9: {
                            String theSubContinent;
                            try {
                                theSubContinent = subcontinent.equals("053") ? "053" : "009";
                            }
                            catch (NumberFormatException ex) {
                                theSubContinent = "009";
                            }
                            return englishNameGetter.getNameFromTypeEnumCode(NameType.TERRITORY, theSubContinent);
                        }
                        case 19: {
                            String theSubContinent = Integer.parseInt(subcontinent) == 5 ? "005" : "003";
                            return englishNameGetter.getNameFromTypeEnumCode(NameType.TERRITORY, theSubContinent);
                        }
                        case 142: {
                            return englishNameGetter.getNameFromTypeEnumCode(NameType.TERRITORY, subcontinent);
                        }
                    }
                    return englishNameGetter.getNameFromTypeEnumCode(NameType.TERRITORY, theContinent);
                }
            });
            functionMap.put("timezoneSorting", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    List<String> codeValues = Arrays.asList("generic-long", "generic-short", "standard-long", "standard-short", "daylight-long", "daylight-short");
                    order = codeValues.contains(source) ? (long)codeValues.indexOf(source) : (long)codeValues.size();
                    return source;
                }
            });
            functionMap.put("tzdpField", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    HashMap fieldNames = Builder.with(new HashMap()).put("regionFormat", "Region Format - Generic").put("regionFormat-standard", "Region Format - Standard").put("regionFormat-daylight", "Region Format - Daylight").put("gmtFormat", "GMT Format").put("hourFormat", "GMT Hours/Minutes Format").put("gmtZeroFormat", "GMT Zero Format").put("fallbackFormat", "Location Fallback Format").freeze();
                    List<String> fieldOrder = Arrays.asList("regionFormat", "regionFormat-standard", "regionFormat-daylight", "gmtFormat", "hourFormat", "gmtZeroFormat", "fallbackFormat");
                    order = fieldOrder.contains(source) ? (long)fieldOrder.indexOf(source) : (long)fieldOrder.size();
                    String result = (String)fieldNames.get(source);
                    return result == null ? source : result;
                }
            });
            functionMap.put("unit", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    int m4 = unitOrder.indexOf(source);
                    order = m4;
                    return source.substring(source.indexOf(45) + 1);
                }
            });
            functionMap.put("numericSort", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    Integer pos = Integer.parseInt(source) + 5;
                    suborder = new SubstringOrder(pos.toString());
                    return source;
                }
            });
            functionMap.put("metazone", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    if (UNIFORM_CONTINENTS) {
                        String container = PathHeader.getMetazonePageTerritory(source);
                        order = Containment.getOrder(container);
                        return englishNameGetter.getNameFromTypeEnumCode(NameType.TERRITORY, container);
                    }
                    String continent = metazoneToContinent.get(source);
                    if (continent == null) {
                        continent = "UnknownT";
                    }
                    return continent;
                }
            });
            Object[][] ctto = new Object[][]{{"BUK", "MM"}, {"CSD", "RS"}, {"CSK", "CZ"}, {"DDM", "DE"}, {"EUR", "ZZ"}, {"RHD", "ZW"}, {"SUR", "RU"}, {"TPE", "TL"}, {"XAG", "ZZ"}, {"XAU", "ZZ"}, {"XBA", "ZZ"}, {"XBB", "ZZ"}, {"XBC", "ZZ"}, {"XBD", "ZZ"}, {"XDR", "ZZ"}, {"XEU", "ZZ"}, {"XFO", "ZZ"}, {"XFU", "ZZ"}, {"XPD", "ZZ"}, {"XPT", "ZZ"}, {"XRE", "ZZ"}, {"XSU", "ZZ"}, {"XTS", "ZZ"}, {"XUA", "ZZ"}, {"XXX", "ZZ"}, {"YDD", "YE"}, {"YUD", "RS"}, {"YUM", "RS"}, {"YUN", "RS"}, {"YUR", "RS"}, {"ZRN", "CD"}, {"ZRZ", "CD"}};
            Object[][] sctc = new Object[][]{{"Northern America", "North America (C)"}, {"Central America", "North America (C)"}, {"Caribbean", "North America (C)"}, {"South America", "South America (C)"}, {"Northern Africa", "Northern Africa"}, {"Western Africa", "Western Africa"}, {"Middle Africa", "Middle Africa"}, {"Eastern Africa", "Eastern Africa"}, {"Southern Africa", "Southern Africa"}, {"Europe", "Northern/Western Europe"}, {"Northern Europe", "Northern/Western Europe"}, {"Western Europe", "Northern/Western Europe"}, {"Eastern Europe", "Southern/Eastern Europe"}, {"Southern Europe", "Southern/Eastern Europe"}, {"Western Asia", "Western Asia (C)"}, {"Central Asia", "Central Asia (C)"}, {"Eastern Asia", "Eastern Asia (C)"}, {"Southern Asia", "Southern Asia (C)"}, {"Southeast Asia", "Southeast Asia (C)"}, {"Australasia", "Oceania (C)"}, {"Melanesia", "Oceania (C)"}, {"Micronesian Region", "Oceania (C)"}, {"Polynesia", "Oceania (C)"}, {"Unknown Region", "Unknown Region (C)"}};
            final Map currencyToTerritoryOverrides = CldrUtility.asMap(ctto);
            final Map subContinentToContinent = CldrUtility.asMap(sctc);
            final HashSet<String> fundCurrencies = new HashSet<String>(Arrays.asList("CHE", "CHW", "CLF", "COU", "ECV", "MXV", "USN", "USS", "UYI", "XEU", "ZAL"));
            final HashSet<String> offshoreCurrencies = new HashSet<String>(Arrays.asList("CNH"));
            functionMap.put("categoryFromCurrency", new Transform<String, String>(){

                @Override
                public String transform(String source0) {
                    Object tenderOrNot = "";
                    String territory = likelySubtags.getLikelyTerritoryFromCurrency(source0);
                    if (territory == null) {
                        String tag = fundCurrencies.contains(source0) ? " (fund)" : (offshoreCurrencies.contains(source0) ? " (offshore)" : " (old)");
                        tenderOrNot = ": " + source0 + tag;
                    }
                    if (currencyToTerritoryOverrides.keySet().contains(source0)) {
                        territory = (String)currencyToTerritoryOverrides.get(source0);
                    } else if (territory == null) {
                        territory = source0.substring(0, 2);
                    }
                    if (territory.equals("ZZ")) {
                        order = 999L;
                        return englishNameGetter.getNameFromTypeEnumCode(NameType.TERRITORY, territory) + ": " + source0;
                    }
                    return catFromTerritory.transform(territory) + ": " + englishNameGetter.getNameFromTypeEnumCode(NameType.TERRITORY, territory) + (String)tenderOrNot;
                }
            });
            functionMap.put("continentFromCurrency", new Transform<String, String>(){

                @Override
                public String transform(String source0) {
                    String subContinent;
                    String territory = likelySubtags.getLikelyTerritoryFromCurrency(source0);
                    if (currencyToTerritoryOverrides.keySet().contains(source0)) {
                        territory = (String)currencyToTerritoryOverrides.get(source0);
                    } else if (territory == null) {
                        territory = source0.substring(0, 2);
                    }
                    if (territory.equals("ZZ")) {
                        order = 999L;
                        subContinent = englishNameGetter.getNameFromTypeEnumCode(NameType.TERRITORY, territory);
                    } else {
                        subContinent = catFromTerritory.transform(territory);
                    }
                    String result = (String)subContinentToContinent.get(subContinent);
                    return result;
                }
            });
            functionMap.put("numberingSystem", new Transform<String, String>(){

                @Override
                public String transform(String source0) {
                    if ("latn".equals(source0)) {
                        return "";
                    }
                    String displayName = englishFile.getStringValue("//ldml/localeDisplayNames/types/type[@key=\"numbers\"][@type=\"" + source0 + "\"]");
                    return "using " + (String)(displayName == null ? source0 : displayName + " (" + source0 + ")");
                }
            });
            functionMap.put("datefield", new Transform<String, String>(){
                private final String[] datefield = new String[]{"era", "era-short", "era-narrow", "century", "century-short", "century-narrow", "year", "year-short", "year-narrow", "quarter", "quarter-short", "quarter-narrow", "month", "month-short", "month-narrow", "week", "week-short", "week-narrow", "weekOfMonth", "weekOfMonth-short", "weekOfMonth-narrow", "day", "day-short", "day-narrow", "dayOfYear", "dayOfYear-short", "dayOfYear-narrow", "weekday", "weekday-short", "weekday-narrow", "weekdayOfMonth", "weekdayOfMonth-short", "weekdayOfMonth-narrow", "dayperiod", "dayperiod-short", "dayperiod-narrow", "zone", "zone-short", "zone-narrow", "hour", "hour-short", "hour-narrow", "minute", "minute-short", "minute-narrow", "second", "second-short", "second-narrow", "millisecond", "millisecond-short", "millisecond-narrow", "microsecond", "microsecond-short", "microsecond-narrow", "nanosecond", "nanosecond-short", "nanosecond-narrow"};

                @Override
                public String transform(String source) {
                    order = Factory.getIndex(source, this.datefield);
                    return source;
                }
            });
            functionMap.put("relativeDate", new Transform<String, String>(){
                private final String[] relativeDateField = new String[]{"year", "year-short", "year-narrow", "quarter", "quarter-short", "quarter-narrow", "month", "month-short", "month-narrow", "week", "week-short", "week-narrow", "day", "day-short", "day-narrow", "hour", "hour-short", "hour-narrow", "minute", "minute-short", "minute-narrow", "second", "second-short", "second-narrow", "sun", "sun-short", "sun-narrow", "mon", "mon-short", "mon-narrow", "tue", "tue-short", "tue-narrow", "wed", "wed-short", "wed-narrow", "thu", "thu-short", "thu-narrow", "fri", "fri-short", "fri-narrow", "sat", "sat-short", "sat-narrow"};
                private final String[] longNames = new String[]{"Year", "Year Short", "Year Narrow", "Quarter", "Quarter Short", "Quarter Narrow", "Month", "Month Short", "Month Narrow", "Week", "Week Short", "Week Narrow", "Day", "Day Short", "Day Narrow", "Hour", "Hour Short", "Hour Narrow", "Minute", "Minute Short", "Minute Narrow", "Second", "Second Short", "Second Narrow", "Sunday", "Sunday Short", "Sunday Narrow", "Monday", "Monday Short", "Monday Narrow", "Tuesday", "Tuesday Short", "Tuesday Narrow", "Wednesday", "Wednesday Short", "Wednesday Narrow", "Thursday", "Thursday Short", "Thursday Narrow", "Friday", "Friday Short", "Friday Narrow", "Saturday", "Saturday Short", "Saturday Narrow"};

                @Override
                public String transform(String source) {
                    order = Factory.getIndex(source, this.relativeDateField) + 100;
                    return "Relative " + this.longNames[Factory.getIndex(source, this.relativeDateField)];
                }
            });
            functionMap.put("number", new Transform<String, String>(){
                private final String[] symbols = new String[]{"decimal", "group", "plusSign", "minusSign", "approximatelySign", "percentSign", "perMille", "exponential", "superscriptingExponent", "infinity", "nan", "list", "currencies"};

                @Override
                public String transform(String source) {
                    String[] parts = source.split("-");
                    order = Factory.getIndex(parts[0], this.symbols);
                    if (parts.length > 1) {
                        suborder = new SubstringOrder(parts[1]);
                    }
                    return source;
                }
            });
            functionMap.put("numberFormat", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    List<String> fieldOrder = Arrays.asList("standard-decimal", "standard-currency", "standard-currency-accounting", "standard-percent", "standard-scientific");
                    order = fieldOrder.contains(source) ? (long)fieldOrder.indexOf(source) : (long)fieldOrder.size();
                    return source;
                }
            });
            functionMap.put("localePattern", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    if (source.equals("localeKeyTypePattern")) {
                        order = 10L;
                    }
                    return source;
                }
            });
            functionMap.put("listOrder", new Transform<String, String>(){
                private String[] listParts = new String[]{"2", "start", "middle", "end"};

                @Override
                public String transform(String source) {
                    order = Factory.getIndex(source, this.listParts);
                    return source;
                }
            });
            functionMap.put("personNameSection", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    List<String> itemValues = PersonNameFormatter.SampleType.ALL_STRINGS;
                    if (source.equals("NameOrder")) {
                        order = 0L;
                        return "NameOrder for Locales";
                    }
                    if (source.equals("Parameters")) {
                        order = 4L;
                        return "Default Parameters";
                    }
                    if (source.equals("AuxiliaryItems")) {
                        order = 10L;
                        return source;
                    }
                    String itemPrefix = "SampleName:";
                    if (source.startsWith(itemPrefix)) {
                        String itemValue = source.substring(itemPrefix.length());
                        order = 20 + itemValues.indexOf(itemValue);
                        return "SampleName Fields for Item: " + itemValue;
                    }
                    String pnPrefix = "PersonName:";
                    if (source.startsWith(pnPrefix)) {
                        String nameUsage;
                        String attrValues = source.substring(pnPrefix.length());
                        List<String> parts = HYPHEN_SPLITTER.splitToList(attrValues);
                        String nameOrder = parts.get(0);
                        if (nameOrder.contentEquals("sorting")) {
                            order = 40L;
                            return "PersonName Sorting Patterns (Usage: referring)";
                        }
                        order = 30L;
                        if (nameOrder.contentEquals("surnameFirst")) {
                            ++order;
                        }
                        if ((nameUsage = parts.get(1)).contentEquals("monogram")) {
                            order += 20L;
                            return "PersonName Monogram Patterns for Order: " + nameOrder;
                        }
                        return "PersonName Main Patterns for Order: " + nameOrder;
                    }
                    order = 60L;
                    return source;
                }
            });
            functionMap.put("personNameOrder", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    List<String> attrValues = Arrays.asList("referring", "addressing", "formal", "informal", "long", "medium", "short");
                    List<String> parts = HYPHEN_SPLITTER.splitToList(source);
                    order = 0L;
                    Object attributes = "";
                    boolean skipReferring = false;
                    for (String part : parts) {
                        if (attrValues.contains(part)) {
                            order += (long)(1 << attrValues.indexOf(part));
                            if (skipReferring && part.contentEquals("referring")) continue;
                            if (((String)attributes).length() == 0) {
                                attributes = part;
                                continue;
                            }
                            attributes = (String)attributes + "-" + part;
                            continue;
                        }
                        if (!part.contentEquals("sorting")) continue;
                        skipReferring = true;
                    }
                    return attributes;
                }
            });
            functionMap.put("sampleNameOrder", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    List<String> attrValues = Arrays.asList("informal", "prefix", "core", "prefix", "given", "given2", "surname", "surname2", "suffix");
                    List<String> parts = HYPHEN_SPLITTER.splitToList(source);
                    order = 0L;
                    for (String part : parts) {
                        if (!attrValues.contains(part)) continue;
                        order += (long)(1 << attrValues.indexOf(part));
                    }
                    return source;
                }
            });
            functionMap.put("alphaOrder", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    order = 0L;
                    return source;
                }
            });
            functionMap.put("transform", new Transform<String, String>(){
                Splitter commas = Splitter.on(',').trimResults();

                @Override
                public String transform(String source) {
                    List<String> parts;
                    return parts.get(1) + ((parts = this.commas.splitToList(source)).get(0).equals("both") ? "\u2194\ufe0e" : "\u2192") + parts.get(2) + (String)(parts.size() > 3 ? "/" + parts.get(3) : "");
                }
            });
            functionMap.put("major", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    return PathHeader.getCharacterPageId(source).toString();
                }
            });
            functionMap.put("minor", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    String minorCat = Emoji.getMinorCategory(source);
                    order = Emoji.getEmojiMinorOrder(minorCat);
                    return minorCat;
                }
            });
            functionMap.put("emoji", new Transform<String, String>(){

                @Override
                public String transform(String source) {
                    int dashPos = source.indexOf(32);
                    String emoji = source.substring(0, dashPos);
                    order = (Emoji.getEmojiToOrder(emoji) << 1) + (long)(source.endsWith("name") ? 0 : 1);
                    return source;
                }
            });
            METRIC_UNITS = Set.of(UnitConverter.UnitSystem.metric, UnitConverter.UnitSystem.metric_adjacent);
            US_UNITS = Set.of(UnitConverter.UnitSystem.ussystem);
        }

        static class HyphenSplitter {
            String main;
            String extras;

            HyphenSplitter() {
            }

            String split(String source) {
                int hyphenPos = source.indexOf(45);
                if (hyphenPos < 0) {
                    this.main = source;
                    this.extras = "";
                } else {
                    this.main = source.substring(0, hyphenPos);
                    this.extras = source.substring(hyphenPos);
                }
                return this.main;
            }
        }

        @Deprecated
        public class CounterData
        extends Row.R4<String, RawData, String, String> {
            public CounterData(String a, RawData b, String c) {
                super(a, b, c == null ? "no sample" : c, c == null ? "no sample" : Factory.this.fromPath(c).toString());
            }
        }

        static class PathHeaderTransform
        implements Transform<String, RawData> {
            PathHeaderTransform() {
            }

            @Override
            public RawData transform(String source) {
                return new RawData(source);
            }
        }

        static class RawData {
            static ChronologicalOrder codeOrdering = new ChronologicalOrder(null);
            static ChronologicalOrder headerOrdering = new ChronologicalOrder(codeOrdering);
            public final String section;
            public final String page;
            public final String header;
            public final int headerOrder;
            public final String code;
            public final int codeOrder;
            public final SurveyToolStatus status;

            public RawData(String source) {
                String[] split = SEMI.split(source);
                this.section = split[0];
                this.page = this.section.equals("Timezones") && split[1].equals("Indian") ? "Indian2" : split[1];
                this.header = headerOrdering.set(split[2]);
                this.headerOrder = headerOrdering.getOrder();
                this.code = codeOrdering.set(split[3]);
                this.codeOrder = codeOrdering.getOrder();
                this.status = split.length < 5 ? SurveyToolStatus.READ_WRITE : SurveyToolStatus.valueOf(split[4]);
            }

            public String toString() {
                return this.section + "\t" + this.page + "\t" + this.header + "\t" + this.headerOrder + "\t" + this.code + "\t" + this.codeOrder + "\t" + this.status;
            }
        }

        private static class ChronologicalOrder {
            private final Map<String, Integer> map = new HashMap<String, Integer>();
            private String item;
            private int order;
            private final ChronologicalOrder toClear;

            ChronologicalOrder(ChronologicalOrder toClear) {
                this.toClear = toClear;
            }

            int getOrder() {
                return this.order;
            }

            public String set(String itemToOrder) {
                if (itemToOrder.startsWith("*")) {
                    this.item = itemToOrder.substring(1, itemToOrder.length());
                    return this.item;
                }
                this.item = itemToOrder;
                Integer old = this.map.get(this.item);
                if (old != null) {
                    this.order = old;
                } else {
                    this.order = this.map.size();
                    this.map.put(this.item, this.order);
                    this.clearLower();
                }
                return this.item;
            }

            private void clearLower() {
                if (this.toClear != null) {
                    this.toClear.map.clear();
                    this.toClear.order = 0;
                    this.toClear.clearLower();
                }
            }
        }

        private class FilteredIterable
        implements Iterable<String>,
        With.SimpleIterator<String> {
            private final SectionId sectionId;
            private final PageId pageId;
            private final Iterator<String> fileIterator;

            FilteredIterable(SectionId sectionId, PageId pageId, CLDRFile file) {
                this.sectionId = sectionId;
                this.pageId = pageId;
                this.fileIterator = file.fullIterable().iterator();
            }

            public FilteredIterable(String section, String page, CLDRFile file) {
                this(SectionId.forString(section), PageId.forString(page), file);
            }

            @Override
            public Iterator<String> iterator() {
                return With.toIterator(this);
            }

            @Override
            public String next() {
                while (this.fileIterator.hasNext()) {
                    String path = this.fileIterator.next();
                    PathHeader pathHeader = Factory.this.fromPath(path);
                    if (this.sectionId != pathHeader.sectionId || this.pageId != pathHeader.pageId) continue;
                    return path;
                }
                return null;
            }
        }

        private static class SectionPage
        implements Comparable<SectionPage> {
            private final SectionId sectionId;
            private final PageId pageId;

            public SectionPage(SectionId sectionId, PageId pageId) {
                this.sectionId = sectionId;
                this.pageId = pageId;
            }

            @Override
            public int compareTo(SectionPage other) {
                int result = this.sectionId.compareTo(other.sectionId);
                if (0 != result) {
                    return result;
                }
                result = this.pageId.compareTo(other.pageId);
                if (0 != result) {
                    return result;
                }
                return 0;
            }

            public boolean equals(Object obj) {
                PathHeader other;
                try {
                    other = (PathHeader)obj;
                }
                catch (Exception e) {
                    return false;
                }
                return this.sectionId == other.sectionId && this.pageId == other.pageId;
            }

            public int hashCode() {
                return this.sectionId.hashCode() ^ this.pageId.hashCode();
            }

            public String toString() {
                return this.sectionId + " > " + this.pageId;
            }
        }
    }

    public static enum PageId {
        Alphabetic_Information(SectionId.Core_Data, "Alphabetic Information"),
        Numbering_Systems(SectionId.Core_Data, "Numbering Systems"),
        LinguisticElements(SectionId.Core_Data, "Linguistic Elements"),
        Locale_Name_Patterns(SectionId.Locale_Display_Names, "Locale Name Patterns"),
        Languages_A_D(SectionId.Locale_Display_Names, "Languages (A-D)"),
        Languages_E_J(SectionId.Locale_Display_Names, "Languages (E-J)"),
        Languages_K_N(SectionId.Locale_Display_Names, "Languages (K-N)"),
        Languages_O_S(SectionId.Locale_Display_Names, "Languages (O-S)"),
        Languages_T_Z(SectionId.Locale_Display_Names, "Languages (T-Z)"),
        Scripts(SectionId.Locale_Display_Names, new String[0]),
        Territories(SectionId.Locale_Display_Names, "Geographic Regions"),
        T_NAmerica(SectionId.Locale_Display_Names, "Territories (North America)"),
        T_SAmerica(SectionId.Locale_Display_Names, "Territories (South America)"),
        T_Africa(SectionId.Locale_Display_Names, "Territories (Africa)"),
        T_Europe(SectionId.Locale_Display_Names, "Territories (Europe)"),
        T_Asia(SectionId.Locale_Display_Names, "Territories (Asia)"),
        T_Oceania(SectionId.Locale_Display_Names, "Territories (Oceania)"),
        Locale_Variants(SectionId.Locale_Display_Names, "Locale Variants"),
        Keys(SectionId.Locale_Display_Names, new String[0]),
        Fields(SectionId.DateTime, new String[0]),
        Relative(SectionId.DateTime, new String[0]),
        Gregorian(SectionId.DateTime, new String[0]),
        ISO8601(SectionId.DateTime, "ISO 8601"),
        Generic(SectionId.DateTime, new String[0]),
        Buddhist(SectionId.DateTime, new String[0]),
        Chinese(SectionId.DateTime, new String[0]),
        Coptic(SectionId.DateTime, new String[0]),
        Dangi(SectionId.DateTime, new String[0]),
        Ethiopic(SectionId.DateTime, new String[0]),
        Ethiopic_Amete_Alem(SectionId.DateTime, "Ethiopic-Amete-Alem"),
        Hebrew(SectionId.DateTime, new String[0]),
        Indian(SectionId.DateTime, new String[0]),
        Islamic(SectionId.DateTime, new String[0]),
        Japanese(SectionId.DateTime, new String[0]),
        Persian(SectionId.DateTime, new String[0]),
        Minguo(SectionId.DateTime, new String[0]),
        Timezone_Display_Patterns(SectionId.Timezones, "Timezone Display Patterns"),
        NAmerica(SectionId.Timezones, "North America"),
        SAmerica(SectionId.Timezones, "South America"),
        Africa(SectionId.Timezones, new String[0]),
        Europe(SectionId.Timezones, new String[0]),
        Russia(SectionId.Timezones, new String[0]),
        WAsia(SectionId.Timezones, "Western Asia"),
        CAsia(SectionId.Timezones, "Central Asia"),
        EAsia(SectionId.Timezones, "Eastern Asia"),
        SAsia(SectionId.Timezones, "Southern Asia"),
        SEAsia(SectionId.Timezones, "Southeast Asia"),
        Australasia(SectionId.Timezones, new String[0]),
        Antarctica(SectionId.Timezones, new String[0]),
        Oceania(SectionId.Timezones, new String[0]),
        UnknownT(SectionId.Timezones, "Unknown Region"),
        Overrides(SectionId.Timezones, new String[0]),
        Symbols(SectionId.Numbers, new String[0]),
        Number_Formatting_Patterns(SectionId.Numbers, "Number Formatting Patterns"),
        Compact_Decimal_Formatting(SectionId.Numbers, "Compact Decimal Formatting"),
        Compact_Decimal_Formatting_Other(SectionId.Numbers, "Compact Decimal Formatting (Other Numbering Systems)"),
        Measurement_Systems(SectionId.Units, "Measurement Systems"),
        Duration(SectionId.Units, new String[0]),
        Graphics(SectionId.Units, new String[0]),
        Length_Metric(SectionId.Units, "Length Metric"),
        Length_Other(SectionId.Units, "Length Other"),
        Area(SectionId.Units, new String[0]),
        Volume_Metric(SectionId.Units, "Volume Metric"),
        Volume_US(SectionId.Units, "Volume US"),
        Volume_Other(SectionId.Units, "Volume Other"),
        SpeedAcceleration(SectionId.Units, "Speed and Acceleration"),
        MassWeight(SectionId.Units, "Mass and Weight"),
        EnergyPower(SectionId.Units, "Energy and Power"),
        ElectricalFrequency(SectionId.Units, "Electrical and Frequency"),
        Weather(SectionId.Units, new String[0]),
        Digital(SectionId.Units, new String[0]),
        Coordinates(SectionId.Units, new String[0]),
        OtherUnitsMetric(SectionId.Units, "Other Units Metric"),
        OtherUnitsMetricPer(SectionId.Units, "Other Units Metric Per"),
        OtherUnitsUS(SectionId.Units, "Other Units US"),
        OtherUnits(SectionId.Units, "Other Units"),
        CompoundUnits(SectionId.Units, "Compound Units"),
        Displaying_Lists(SectionId.Misc, "Displaying Lists"),
        MinimalPairs(SectionId.Misc, "Minimal Pairs"),
        PersonNameFormats(SectionId.Misc, "Person Name Formats"),
        Transforms(SectionId.Misc, new String[0]),
        Identity(SectionId.Special, new String[0]),
        Version(SectionId.Special, new String[0]),
        Suppress(SectionId.Special, new String[0]),
        Deprecated(SectionId.Special, new String[0]),
        Unknown(SectionId.Special, new String[0]),
        C_NAmerica(SectionId.Currencies, "North America (C)"),
        C_SAmerica(SectionId.Currencies, "South America (C)"),
        C_NWEurope(SectionId.Currencies, "Northern/Western Europe"),
        C_SEEurope(SectionId.Currencies, "Southern/Eastern Europe"),
        C_NAfrica(SectionId.Currencies, "Northern Africa"),
        C_WAfrica(SectionId.Currencies, "Western Africa"),
        C_MAfrica(SectionId.Currencies, "Middle Africa"),
        C_EAfrica(SectionId.Currencies, "Eastern Africa"),
        C_SAfrica(SectionId.Currencies, "Southern Africa"),
        C_WAsia(SectionId.Currencies, "Western Asia (C)"),
        C_CAsia(SectionId.Currencies, "Central Asia (C)"),
        C_EAsia(SectionId.Currencies, "Eastern Asia (C)"),
        C_SAsia(SectionId.Currencies, "Southern Asia (C)"),
        C_SEAsia(SectionId.Currencies, "Southeast Asia (C)"),
        C_Oceania(SectionId.Currencies, "Oceania (C)"),
        C_Unknown(SectionId.Currencies, "Unknown Region (C)"),
        u_Extension(SectionId.BCP47, new String[0]),
        t_Extension(SectionId.BCP47, new String[0]),
        Alias(SectionId.Supplemental, new String[0]),
        IdValidity(SectionId.Supplemental, new String[0]),
        Locale(SectionId.Supplemental, new String[0]),
        RegionMapping(SectionId.Supplemental, new String[0]),
        WZoneMapping(SectionId.Supplemental, new String[0]),
        Transform(SectionId.Supplemental, new String[0]),
        Units(SectionId.Supplemental, new String[0]),
        Likely(SectionId.Supplemental, new String[0]),
        LanguageMatch(SectionId.Supplemental, new String[0]),
        TerritoryInfo(SectionId.Supplemental, new String[0]),
        LanguageInfo(SectionId.Supplemental, new String[0]),
        LanguageGroup(SectionId.Supplemental, new String[0]),
        Fallback(SectionId.Supplemental, new String[0]),
        Gender(SectionId.Supplemental, new String[0]),
        Grammar(SectionId.Supplemental, new String[0]),
        Metazone(SectionId.Supplemental, new String[0]),
        NumberSystem(SectionId.Supplemental, new String[0]),
        Plural(SectionId.Supplemental, new String[0]),
        PluralRange(SectionId.Supplemental, new String[0]),
        Containment(SectionId.Supplemental, new String[0]),
        Currency(SectionId.Supplemental, new String[0]),
        Calendar(SectionId.Supplemental, new String[0]),
        WeekData(SectionId.Supplemental, new String[0]),
        Measurement(SectionId.Supplemental, new String[0]),
        Language(SectionId.Supplemental, new String[0]),
        Script(SectionId.Supplemental, new String[0]),
        RBNF(SectionId.Supplemental, new String[0]),
        Segmentation(SectionId.Supplemental, new String[0]),
        DayPeriod(SectionId.Supplemental, new String[0]),
        Category(SectionId.Characters, new String[0]),
        Smileys(SectionId.Characters, "Smileys & Emotion"),
        People(SectionId.Characters, "People & Body"),
        People2(SectionId.Characters, "People & Body 2"),
        Animals_Nature(SectionId.Characters, "Animals & Nature"),
        Food_Drink(SectionId.Characters, "Food & Drink"),
        Travel_Places(SectionId.Characters, "Travel & Places"),
        Travel_Places2(SectionId.Characters, "Travel & Places 2"),
        Activities(SectionId.Characters, new String[0]),
        Objects(SectionId.Characters, new String[0]),
        Objects2(SectionId.Characters, new String[0]),
        EmojiSymbols(SectionId.Characters, "Emoji Symbols"),
        Punctuation(SectionId.Characters, new String[0]),
        MathSymbols(SectionId.Characters, "Math Symbols"),
        OtherSymbols(SectionId.Characters, "Other Symbols"),
        Flags(SectionId.Characters, new String[0]),
        Component(SectionId.Characters, new String[0]),
        Typography(SectionId.Characters, new String[0]);

        private final SectionId sectionId;

        private PageId(SectionId sectionId, String ... alternateNames) {
            this.sectionId = sectionId;
            SectionIdToPageIds.put(sectionId, this);
            PageIdNames.add(this, alternateNames);
        }

        public static PageId forString(String name) {
            try {
                return PageIdNames.forString(name);
            }
            catch (Exception e) {
                throw new ICUException("No PageId for " + name, e);
            }
        }

        public String toString() {
            return PageIdNames.toString(this);
        }

        public SectionId getSectionId() {
            return this.sectionId;
        }
    }

    private static class SubstringOrder
    implements Comparable<SubstringOrder> {
        final String mainOrder;
        final int order;

        public SubstringOrder(String source) {
            int pos = source.lastIndexOf(45) + 1;
            int ordering = COUNTS.indexOf(source.substring(pos));
            this.order = ordering < 0 ? source.charAt(pos) : 65536 + ordering;
            this.mainOrder = source.substring(0, pos);
        }

        public String toString() {
            return "{" + this.mainOrder + ", " + this.order + "}";
        }

        @Override
        public int compareTo(SubstringOrder other) {
            int diff = PathHeader.alphabeticCompare(this.mainOrder, other.mainOrder);
            if (diff != 0) {
                return diff;
            }
            return this.order - other.order;
        }
    }

    public static enum SectionId {
        Core_Data("Core Data"),
        Locale_Display_Names("Locale Display Names"),
        DateTime("Date & Time"),
        Timezones(new String[0]),
        Numbers(new String[0]),
        Currencies(new String[0]),
        Units(new String[0]),
        Characters(new String[0]),
        Misc("Miscellaneous"),
        BCP47(new String[0]),
        Supplemental(new String[0]),
        Special(new String[0]);


        private SectionId(String ... alternateNames) {
            SectionIdNames.add(this, alternateNames);
        }

        public static SectionId forString(String name) {
            return SectionIdNames.forString(name);
        }

        public String toString() {
            return SectionIdNames.toString(this);
        }
    }

    public static enum SurveyToolStatus {
        DEPRECATED,
        HIDE,
        READ_ONLY,
        READ_WRITE,
        LTR_ALWAYS;

    }

    public static enum Width {
        FULL,
        LONG,
        WIDE,
        SHORT,
        NARROW;


        public static Width getValue(String input) {
            try {
                return Width.valueOf(input.toUpperCase(Locale.ENGLISH));
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                throw e;
            }
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

