/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Random;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.ShowLocaleCoverage;

public class TempPrintWriter
extends Writer {
    final PrintWriter tempPrintWriter;
    final String tempName;
    final String filename;
    boolean noReplace = false;
    boolean skipCopyright = false;
    boolean noDiff = false;

    public TempPrintWriter skipCopyright(boolean newSkipCopyright) {
        this.skipCopyright = newSkipCopyright;
        return this;
    }

    public PrintWriter asPrintWriter() {
        return this.tempPrintWriter;
    }

    public TempPrintWriter noDiff() {
        this.noDiff = true;
        return this;
    }

    public static TempPrintWriter openUTF8Writer(String filename) {
        return new TempPrintWriter(new File(filename));
    }

    public static TempPrintWriter openUTF8Writer(String dir, String filename) {
        return new TempPrintWriter(new File(dir, filename));
    }

    public TempPrintWriter(String dir, String filename) {
        this(new File(dir, filename));
    }

    public TempPrintWriter(File file) {
        String parentFile = file.getParent();
        this.filename = file.toString();
        Random rand = new Random();
        try {
            File tempFile;
            while ((tempFile = new File(parentFile, (0xFFFF & rand.nextInt()) + "-" + file.getName())).exists()) {
            }
            this.tempName = tempFile.toString();
            this.tempPrintWriter = FileUtilities.openUTF8Writer(parentFile, tempFile.getName());
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    public void dontReplaceFile() {
        this.noReplace = true;
    }

    @Override
    public void close() {
        this.tempPrintWriter.close();
        try {
            if (this.noReplace) {
                new File(this.tempName).delete();
            } else {
                this.replaceDifferentOrDelete(this.filename, this.tempName);
            }
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        this.tempPrintWriter.write(cbuf, off, len);
    }

    @Override
    public void flush() {
        this.tempPrintWriter.flush();
    }

    public void println(Object line) {
        this.tempPrintWriter.println(line);
    }

    public void print(Object line) {
        this.tempPrintWriter.print(line);
    }

    public void println() {
        this.tempPrintWriter.println();
    }

    public void printlnWithTabs(int desiredCount, String textToPrint) {
        StringBuilder result = new StringBuilder();
        for (String line : ShowLocaleCoverage.LF_SPLITTER.split(textToPrint)) {
            long count = (long)desiredCount - line.chars().filter(ch -> ch == 9).count();
            if (count < 0L) {
                throw new IllegalArgumentException("Too many tabs in line.");
            }
            result.append(line);
            if (count != 0L) {
                int i = 0;
                while ((long)i < count) {
                    result.append('\t');
                    ++i;
                }
            }
            result.append('\n');
        }
        this.print(result);
    }

    private boolean replaceDifferentOrDelete(String oldFile, String newFile) throws IOException {
        File oldFile2 = new File(oldFile);
        if (oldFile2.exists()) {
            String[] lines = new String[2];
            boolean identical = TempPrintWriter.filesAreIdentical(oldFile, newFile, this.skipCopyright, lines);
            if (identical) {
                new File(newFile).delete();
                return false;
            }
            if (this.noDiff) {
                System.out.println("Writing: " + oldFile);
            } else {
                System.out.println("Found difference in : " + oldFile + ", " + newFile);
                int diff = TempPrintWriter.compare(lines[0], lines[1]);
                System.out.println(" File1: '" + lines[0].substring(0, diff) + "', '" + lines[0].substring(diff) + "'");
                System.out.println(" File2: '" + lines[1].substring(0, diff) + "', '" + lines[1].substring(diff) + "'");
            }
        }
        Files.move(Path.of(newFile, new String[0]), oldFile2.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean filesAreIdentical(String file1, String file2, boolean skipCopyright, String[] lines) throws IOException {
        if (file1 == null) {
            lines[0] = null;
            lines[1] = null;
            return false;
        }
        BufferedReader br1 = new BufferedReader(new FileReader(file1), 32768);
        BufferedReader br2 = new BufferedReader(new FileReader(file2), 32768);
        String line1 = "";
        String line2 = "";
        try {
            int lineCount = 0;
            while (true) {
                line1 = TempPrintWriter.getLineWithoutFluff(br1, lineCount == 0, skipCopyright);
                line2 = TempPrintWriter.getLineWithoutFluff(br2, lineCount == 0, skipCopyright);
                if (line1 == null) {
                    if (line2 != null) break;
                    boolean bl = true;
                    return bl;
                }
                if (!line1.equals(line2)) break;
                ++lineCount;
            }
            lines[0] = line1;
            lines[1] = line2;
            if (lines[0] == null) {
                lines[0] = "<end of file>";
            }
            if (lines[1] == null) {
                lines[1] = "<end of file>";
            }
            boolean bl = false;
            return bl;
        }
        finally {
            br1.close();
            br2.close();
        }
    }

    private static String getLineWithoutFluff(BufferedReader br1, boolean first, boolean skipCopyright) throws IOException {
        String line1;
        while (true) {
            if ((line1 = br1.readLine()) == null) {
                return line1;
            }
            if ((line1 = line1.trim()).length() == 0 || line1.equals("#") || line1.startsWith("# Generated") || line1.startsWith("# Date") || skipCopyright && (line1.startsWith("# Copyright") || line1.contains("Copyright \u00a9")) || line1.startsWith("<p><b>Date:</b>") || line1.startsWith("<td valign=\"top\">20") && line1.endsWith("GMT</td>") || line1.equals("# ================================================")) continue;
            if (!first || !line1.startsWith("#")) break;
            first = false;
        }
        return line1;
    }

    public static int compare(String a, String b) {
        int len = a.length();
        if (len > b.length()) {
            len = b.length();
        }
        for (int i = 0; i < len; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return i;
        }
        if (a.length() != b.length()) {
            return len;
        }
        return -1;
    }
}

