/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.text.UTF16;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.unicode.cldr.draft.CharacterListCompressor;
import org.unicode.cldr.util.CldrUtility;

public class Compacter {
    public static double totalOld;
    public static double totalNew;
    static boolean useCibus;

    public static String encodeString(Collection<String> set2) {
        int size = 2;
        for (String s2 : set2) {
            char cp;
            for (int i = 0; i < s2.length(); i += Character.charCount(cp)) {
                cp = s2.charAt(i);
                if (cp < '\u0080') {
                    ++size;
                    continue;
                }
                if (cp < '\u0800') {
                    size += 2;
                    continue;
                }
                if (cp < '\u10000') {
                    size += 3;
                    continue;
                }
                size += 4;
            }
            ++size;
        }
        List<CharacterListCompressor.Interval> intermediate = Compacter.codePointsToIntervals(set2);
        String result = CharacterListCompressor.base88EncodeList(intermediate);
        totalOld += (double)size;
        totalNew += (double)(result.length() + 2);
        return result;
    }

    public static List<String> decodeString(String encodedString) {
        List<CharacterListCompressor.Interval> intermediate = CharacterListCompressor.base88DecodeList(encodedString);
        ArrayList<String> result = new ArrayList<String>();
        for (CharacterListCompressor.Interval interval : intermediate) {
            for (int i = interval.first; i <= interval.last; ++i) {
                result.add(UTF16.valueOf(i));
            }
        }
        return result;
    }

    private static List<CharacterListCompressor.Interval> codePointsToIntervals(Collection<String> set2) {
        ArrayList<CharacterListCompressor.Interval> result = new ArrayList<CharacterListCompressor.Interval>();
        int first = -1;
        int last = -1;
        for (String item : set2) {
            int cp = UTF16.charAt(item, 0);
            if (first == -1) {
                first = last = cp;
                continue;
            }
            if (cp == last + 1) {
                last = cp;
                continue;
            }
            result.add(new CharacterListCompressor.Interval(first, last));
            first = last = cp;
        }
        if (first != -1) {
            result.add(new CharacterListCompressor.Interval(first, last));
        }
        return result;
    }

    public static String appendCompacted(Collection<String> set2) {
        if (useCibus) {
            return Compacter.encodeString(set2);
        }
        String resultStr = Compacter.getInternalRangeString(set2);
        return resultStr;
    }

    public static String getInternalRangeString(Collection<String> set2) {
        StringBuilder result = new StringBuilder();
        int first = -1;
        int last = -1;
        for (String item : set2) {
            int cp = UTF16.charAt(item, 0);
            if (first == -1) {
                first = last = cp;
                continue;
            }
            if (cp == last + 1) {
                last = cp;
                continue;
            }
            Compacter.appendRange(result, first, last);
            first = last = cp;
        }
        if (first != -1) {
            Compacter.appendRange(result, first, last);
        }
        String resultStr = result.toString();
        return resultStr;
    }

    private static void appendRange(StringBuilder result, int first, int last) {
        result.append(UTF16.valueOf(first));
        if (first != last) {
            int delta = 57344 + last - first;
            if (delta >= 63488) {
                throw new IllegalArgumentException("Range too large: " + CldrUtility.toHex(first, true) + "-" + CldrUtility.toHex(last, true));
            }
            result.appendCodePoint(delta);
        }
    }

    public static List<String> getFromCompacted(String in) {
        int cp;
        if (useCibus) {
            return Compacter.decodeString(in);
        }
        ArrayList<String> result = new ArrayList<String>();
        int first = 0;
        for (int i = 0; i < in.length(); i += Character.charCount(cp)) {
            cp = in.codePointAt(i);
            if (57344 <= cp && cp < 63488) {
                for (int j = first + 1; j <= first + cp - 57344; ++j) {
                    result.add(UTF16.valueOf(j));
                }
            } else {
                result.add(UTF16.valueOf(cp));
            }
            first = cp;
        }
        return result;
    }

    public static double getTotalOld() {
        return totalOld;
    }

    public static double getTotalNew() {
        return totalNew;
    }

    static {
        useCibus = true;
    }
}

