/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.Comparators;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.common.collect.TreeMultimap;
import com.google.common.collect.TreeMultiset;
import com.ibm.icu.util.Output;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import org.unicode.cldr.test.CoverageLevel2;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PathStarrer;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.UnitConverter;
import org.unicode.cldr.util.Validity;
import org.unicode.cldr.util.XPathParts;

public class ListCoverageLevels {
    static final Joiner JOIN_TAB = Joiner.on('\t').useForNull("null");
    private static final Set<String> VALID_REGULAR_UNITS = Validity.getInstance().getStatusToCodes(StandardCodes.LstrType.unit).get((Object)Validity.Status.regular);
    static final StandardCodes stdCodes = StandardCodes.make();
    static final Set<String> cldrCoverage = Sets.difference(stdCodes.getLocaleCoverageLocales(Organization.cldr), stdCodes.getLocaleCoverageLocales(Organization.special));

    private static String levelName(Level level) {
        return level == Level.COMPREHENSIVE ? "\ua78f" + String.valueOf((Object)level) : level.toString();
    }

    public static void main(String[] args) {
        Set<String> toTest;
        CLDRConfig config = CLDRConfig.getInstance();
        StandardCodes sc = StandardCodes.make();
        SupplementalDataInfo sdi = config.getSupplementalDataInfo();
        Factory mainAndAnnotationsFactory = config.getMainAndAnnotationsFactory();
        Locales localesToTest = Locales.all;
        switch (localesToTest) {
            default: {
                toTest = mainAndAnnotationsFactory.getAvailable();
                break;
            }
            case modern_cldr: {
                toTest = sc.getLocaleCoverageLocales(Organization.cldr, EnumSet.of(Level.MODERN));
                break;
            }
            case specific: {
                toTest = ImmutableSortedSet.of("it", "en", "ja", "root");
            }
        }
        UnitConverter unitConverter = sdi.getUnitConverter();
        Map<String, UnitConverter.TargetInfo> conversionData = unitConverter.getInternalConversionData();
        TreeSet<String> shortUnits = new TreeSet<String>(conversionData.keySet());
        LinkedHashSet _ALL = new LinkedHashSet();
        toTest.forEach(locale -> _ALL.add(CLDRLocale.getInstance(locale)));
        ImmutableSet ALL = ImmutableSet.copyOf(_ALL);
        TreeMap TcToLevelToCounter = new TreeMap();
        for (Target target : Target.values()) {
            TreeMap levelToCounter = new TreeMap();
            for (Level level : Level.values()) {
                levelToCounter.put(level, TreeMultiset.create());
            }
            TcToLevelToCounter.put(target, levelToCounter);
        }
        TreeMap unitLevelToCounter = new TreeMap();
        TreeMultimap<String, String> unitToLocales = TreeMultimap.create();
        for (Level level : Level.values()) {
            unitLevelToCounter.put(level, TreeMultiset.create());
        }
        for (String string : toTest) {
            Optional<CLDRLocale> contained = ListCoverageLevels.localeOrAncestorMatches(string, itOrParent -> cldrCoverage.contains(itOrParent.toString()));
            Target target = contained.isPresent() ? Target.TC : Target.DDL;
            CLDRFile cLDRFile = mainAndAnnotationsFactory.make(string, false);
            CoverageLevel2 coverageLeveler = null;
            try {
                coverageLeveler = CoverageLevel2.getInstance(string);
            }
            catch (Exception level) {
                // empty catch block
            }
            System.out.println(string + "\t" + String.valueOf((Object)target) + "\t" + String.valueOf(target == Target.TC ? (Comparable)contained.get() : ""));
            for (String path : cLDRFile) {
                Level level = coverageLeveler == null ? Level.COMPREHENSIVE : coverageLeveler.getLevel(path);
                String skeleton = PathStarrer.get(path);
                ((Multiset)((Map)TcToLevelToCounter.get((Object)target)).get((Object)level)).add(skeleton);
                if (!path.startsWith("//ldml/units/unitLength") || path.contains("coordinateUnit") || path.endsWith("/alias")) continue;
                XPathParts parts = XPathParts.getFrozenInstance(path);
                String longUnitId = parts.getAttributeValue(3, "type");
                unitToLocales.put(longUnitId, string);
            }
        }
        System.out.println("\nSkeletons\n");
        for (Map.Entry entry : TcToLevelToCounter.entrySet()) {
            Target target = (Target)((Object)entry.getKey());
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                Level level = (Level)((Object)entry2.getKey());
                Multiset counter = (Multiset)entry2.getValue();
                for (Multiset.Entry skeleton : counter.entrySet()) {
                    System.out.println(String.valueOf((Object)target) + "\t" + ListCoverageLevels.levelName(level) + "\t" + skeleton.getCount() + "\t" + (String)skeleton.getElement());
                }
            }
        }
    }

    private static Optional<CLDRLocale> localeOrAncestorMatches(String locale, Predicate<? super CLDRLocale> condition) {
        return Streams.stream(CLDRLocale.getInstance(locale).getParentIterator()).filter(condition).findFirst();
    }

    private static void showUnit(UnitConverter unitConverter, Collection<String> locales, String longUnitId) {
        double factor;
        String unit = unitConverter.getShortId(longUnitId);
        String systems = "?";
        try {
            systems = unitConverter.getSystems(unit).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Output<String> baseUnitOut = new Output<String>();
        UnitConverter.ConversionInfo conversionInfo = null;
        try {
            conversionInfo = unitConverter.parseUnitId(unit, baseUnitOut, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        double d = factor = conversionInfo == null ? Double.NaN : conversionInfo.factor.doubleValue();
        if (locales == null) {
            locales = Set.of();
        }
        System.out.println(JOIN_TAB.join(locales, longUnitId, unit, unitConverter.getQuantityFromUnit(unit, false), baseUnitOut, factor, systems.toString()));
    }

    private static String getLocaleName(Set<CLDRLocale> all, Set<CLDRLocale> locales) {
        Function<Set, String> remainderName = x -> {
            LinkedHashSet y = new LinkedHashSet(all);
            y.removeAll((Collection<?>)x);
            return "AllLcs-(" + Joiner.on("|").join(y) + ")";
        };
        return all == null ? Joiner.on("|").join(locales) : (locales.equals(all) ? "AllLcs" : (locales.size() * 2 > all.size() ? remainderName.apply(locales) : Joiner.on("|").join(locales)));
    }

    static class Attributes
    implements Comparable<Attributes> {
        private static final Comparator<Iterable<String>> COLLECTION_COMPARATOR = Comparators.lexicographical(Comparator.naturalOrder());
        private final CLDRLocale cLoc;
        private final List<String> attributes;

        public Attributes(CLDRLocale cLoc, List<String> attributes2) {
            this.cLoc = cLoc;
            this.attributes = ImmutableList.copyOf(attributes2);
        }

        public static StringBuilder compact(Collection<List<String>> attrList, StringBuilder result) {
            Map<String, Map> map = Attributes.getMap(attrList);
            Attributes.getName(map, result);
            return result;
        }

        public static Multimap<String, List<String>> getLocaleNameToAttributeList(Set<CLDRLocale> all, Set<Attributes> attributeSet) {
            TreeMultimap localeNameToAttributeList = TreeMultimap.create(Comparator.naturalOrder(), COLLECTION_COMPARATOR);
            TreeMultimap attributesToLocales = TreeMultimap.create(COLLECTION_COMPARATOR, Comparator.naturalOrder());
            int count = 0;
            for (Attributes attributes : attributeSet) {
                count = attributes.attributes.size();
                attributesToLocales.put(attributes.attributes, attributes.cLoc);
            }
            if (count > 1) {
                boolean bl = false;
            }
            for (Map.Entry entry : attributesToLocales.asMap().entrySet()) {
                List attributeList = (List)entry.getKey();
                Set locales = (Set)entry.getValue();
                String localeName = ListCoverageLevels.getLocaleName(all, locales);
                localeNameToAttributeList.put(localeName, attributeList);
            }
            return localeNameToAttributeList;
        }

        private static void getName(Map<String, Map> map, StringBuilder result) {
            if (map.isEmpty()) {
                return;
            }
            result.append("(");
            boolean first = true;
            for (Map.Entry<String, Map> entry : map.entrySet()) {
                if (!first) {
                    result.append('|');
                } else {
                    first = false;
                }
                result.append(entry.getKey());
                Attributes.getName(entry.getValue(), result);
            }
            result.append(")");
        }

        private static <T, U extends Iterable<T>, V extends Iterable<U>> Map<T, Map> getMap(V source) {
            if (!source.iterator().hasNext()) {
                return Collections.emptyMap();
            }
            LinkedHashMap items = new LinkedHashMap();
            for (Iterable list : source) {
                LinkedHashMap top = items;
                for (Object item : list) {
                    LinkedHashMap value = (LinkedHashMap)top.get(item);
                    if (value == null) {
                        value = new LinkedHashMap();
                        top.put(item, value);
                    }
                    top = value;
                }
            }
            return items;
        }

        @Override
        public int compareTo(Attributes o) {
            return ComparisonChain.start().compare(this.cLoc, o.cLoc).compare(this.attributes, o.attributes, COLLECTION_COMPARATOR).result();
        }

        public String toString() {
            return this.attributes.isEmpty() ? this.cLoc.toString() : String.valueOf(this.cLoc) + "|" + Joiner.on("|").join(this.attributes);
        }
    }

    static enum Target {
        TC,
        DDL;

    }

    static enum Locales {
        all,
        modern_cldr,
        specific;

    }
}

