/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.File;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.SimpleFactory;

public class RemoveEmptyCldrFiles {
    public static void main(String[] args) {
        File[] paths = new File[]{new File(CLDRPaths.ANNOTATIONS_DIRECTORY)};
        Factory factory = SimpleFactory.make(paths, ".*");
        for (String localeId : factory.getAvailable()) {
            CLDRFile cldrFile = factory.make(localeId, false);
            File file = new File(CLDRPaths.ANNOTATIONS_DIRECTORY, localeId + ".xml");
            if (RemoveEmptyCldrFiles.isEmpty(cldrFile)) {
                if (!file.exists()) {
                    throw new IllegalArgumentException("Missing file: " + String.valueOf(file));
                }
                System.out.println("Deleting: " + String.valueOf(file));
                file.delete();
                continue;
            }
            System.out.println("Retaining: " + String.valueOf(file));
        }
    }

    private static boolean isEmpty(CLDRFile cldrFile) {
        for (String path : cldrFile) {
            if (path.contains("/identity")) continue;
            return false;
        }
        return true;
    }
}

